/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.evtformat.GeoDevEvent;
import cn.org.gddsn.seis.evtformat.NotImplementException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;

public class InteractEvent
extends GeoDevEvent
implements DataFrameInput,
Runnable {
    boolean bOrginalTime = true;
    long evtStartTime = new Date().getTime() / 1000L;
    int evtHeadInfoSize;
    int dataFrameSize;
    int currentReadingSec = 0;
    LittleEndianInputStream interactDatIn = null;
    private int nLoop = 0;
    private static int updateMs = 2000;

    public InteractEvent() {
        new Thread(this).start();
    }

    public void setUpdatePeriod(int ms) {
        updateMs = ms;
    }

    public void setLogLost(boolean bLogLost) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long ms = 0L;
        long csec = System.currentTimeMillis() / 1000L;
        while (true) {
            if (csec + 1L == System.currentTimeMillis() / 1000L) {
                ++csec;
                InteractEvent interactEvent = this;
                synchronized (interactEvent) {
                    this.notify();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void increaseLoop() {
        ++this.nLoop;
    }

    public int getTRL() {
        return this.evt_head.rec_length;
    }

    public boolean readEvtFile(String fileName) {
        try {
            throw new NotImplementException("Reading GeoDev Format from a File Not Implement");
        }
        catch (NotImplementException ex) {
            logger.warn(ex.getMessage(), ex);
            return false;
        }
    }

    public boolean writeEvtFile(String fileName) {
        try {
            throw new NotImplementException("Writing Old GeoDev Format to a File Not Implement");
        }
        catch (NotImplementException ex) {
            logger.warn(ex.getMessage(), ex);
            return false;
        }
    }

    public void userOrginalTime(boolean bOrginalTime) {
        this.bOrginalTime = bOrginalTime;
    }

    public void setInteractEventFile(String newEvtFile) {
        try {
            if (this.interactDatIn != null) {
                this.interactDatIn.close();
                this.interactDatIn = null;
            }
            FileInputStream FileIn = new FileInputStream(newEvtFile);
            BufferedInputStream BufferedIn = new BufferedInputStream(FileIn, 4096);
            this.interactDatIn = new LittleEndianInputStream(BufferedIn);
            this.getEvtHeadInfo(this.interactDatIn);
            this.convertToTimeSeries();
            this.evtHeadInfoSize = 276;
            int i = 0;
            while (i < this.TSN) {
                this.evtHeadInfoSize += 120 + this.SI[i].stn_par.comp * 12312;
                ++i;
            }
            this.dataFrameSize = 0;
            i = 0;
            while (i < this.TSN) {
                this.dataFrameSize += (1 + this.SI[i].stn_par.samp * this.SI[i].stn_par.comp) * 4;
                ++i;
            }
            this.currentReadingSec = 0;
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public int getDataFrameSize() {
        return this.dataFrameSize;
    }

    public int getAvailableSecs() {
        int AvailableSecs = 0;
        try {
            AvailableSecs = this.interactDatIn.available() / this.dataFrameSize;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return AvailableSecs;
    }

    public void skipAvailableSecs() {
        long availableBytes = 0L;
        try {
            availableBytes = this.interactDatIn.available();
            this.currentReadingSec = (int)((long)this.currentReadingSec + availableBytes / (long)this.dataFrameSize);
            this.interactDatIn.skip(availableBytes / (long)this.dataFrameSize * (long)this.dataFrameSize);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getCurrentReadingSec() {
        return this.currentReadingSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFrame[] readDataFrame() throws EOFException, IOException {
        DataFrame[] dataFrame = new DataFrame[this.TCN];
        int i = 0;
        while (i < this.TCN) {
            dataFrame[i] = new DataFrame();
            dataFrame[i].data = new int[this.SI[this.toStn((int)i)].stn_par.samp];
            dataFrame[i].time = this.bOrginalTime ? (long)(this.evt_head.data_begin + this.nLoop * this.getTRL() + this.currentReadingSec) : this.evtStartTime + (long)(this.nLoop * this.getTRL()) + (long)this.currentReadingSec;
            ChannelLocator cl = new ChannelLocator();
            cl.setChannelLocator("GD", this.getStationCode(i), "00", this.getChannelCode(i));
            dataFrame[i].setChannelLocator(cl);
            ++i;
        }
        int k = 0;
        while (k < this.TSN) {
            int flag = this.interactDatIn.readInt();
            int j = 0;
            while (j < this.SI[k].stn_par.comp) {
                dataFrame[this.getCN((int)k) + j].flag = flag;
                int i2 = 0;
                while (i2 < this.SI[k].stn_par.samp) {
                    int dat;
                    if (this.SI[k].stn_par.wlen != 16) {
                        dat = this.interactDatIn.readInt();
                        dataFrame[this.getCN((int)k) + j].data[i2] = flag != 1 ? dat : 0;
                    } else {
                        dat = this.interactDatIn.readShort();
                        dataFrame[this.getCN((int)k) + j].data[i2] = flag != 1 ? dat : 0;
                    }
                    ++i2;
                }
                ++j;
            }
            ++k;
        }
        ++this.currentReadingSec;
        InteractEvent interactEvent = this;
        synchronized (interactEvent) {
            try {
                this.wait(updateMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.info(new Date(dataFrame[0].time * 1000L));
        return dataFrame;
    }

    public LittleEndianOutputStream InteractiveWriteEvtFile(String fileName) throws IOException {
        LittleEndianOutputStream leOut = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(fileName), 4096));
        return leOut;
    }

    public static boolean WriteTotalRecordLength(String fname, int trl) {
        try {
            RandomAccessFile raFile = new RandomAccessFile(fname, "rw");
            raFile.seek(272L);
            raFile.writeByte(trl & 0xFF);
            raFile.writeByte(trl >>> 8 & 0xFF);
            raFile.writeByte(trl >>> 16 & 0xFF);
            raFile.writeByte(trl >>> 24 & 0xFF);
            raFile.close();
            return true;
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            return false;
        }
    }

    public void writeOneDataFrame(LittleEndianOutputStream leOut, DataFrame[] dataFrame) throws IOException {
        int k = 0;
        while (k < this.TSN) {
            leOut.writeInt(dataFrame[this.getCN((int)k)].flag);
            int j = 0;
            while (j < this.SI[k].stn_par.comp) {
                int i = 0;
                while (i < this.SI[k].stn_par.samp) {
                    if (this.SI[k].stn_par.wlen != 16) {
                        leOut.writeInt(dataFrame[this.getCN((int)k) + j].data[i]);
                    } else {
                        leOut.writeShort(dataFrame[this.getCN((int)k) + j].data[i]);
                    }
                    ++i;
                }
                ++j;
            }
            ++k;
        }
    }

    public int getEvtHeadInfoSize() {
        return this.evtHeadInfoSize;
    }

    public LittleEndianInputStream readEvtSimulateRT(String FileName) {
        LittleEndianInputStream DatIn = null;
        try {
            FileInputStream FileIn = new FileInputStream(FileName);
            BufferedInputStream BufferedIn = new BufferedInputStream(FileIn, 4096);
            DatIn = new LittleEndianInputStream(BufferedIn);
            this.evtHeadInfoSize = DatIn.available();
            this.getEvtHeadInfo(DatIn);
            this.evtHeadInfoSize -= DatIn.available();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return DatIn;
    }

    public int get_origenal_site_id() {
        return -1;
    }

    public void close() {
        try {
            this.interactDatIn.close();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public static void main(String[] args) {
        InteractEvent interactEvent = new InteractEvent();
    }
}

