/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.GeoDevConstant;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.RTResponse;
import cn.org.gddsn.seis.evtformat.RTStationInfo;
import cn.org.gddsn.seis.evtformat.Response;
import cn.org.gddsn.seis.evtformat.StationInfo;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public abstract class GeoDevEvtData
extends EvtData
implements GeoDevConstant,
Serializable {
    static Logger logger = Logger.getLogger(GeoDevEvtData.class);
    static final long serialVersionUID = 9003863699413221824L;
    protected int TRL;
    protected Date[] aEventDate;
    protected int[] aTRL;
    protected StationInfo[] SI;
    protected Response[] Rspns;
    protected int[][] Flag;
    protected double[][] WDat;

    protected void convertToTimeSeries() {
        TimeSeries[] chanData = new RTOneChannelData[this.TCN];
        RTStationInfo[] rtSI = new RTStationInfo[this.TCN];
        RTResponse[] rtRsp = new RTResponse[this.TCN];
        int i = 0;
        while (i < this.TCN) {
            chanData[i] = new RTOneChannelData();
            rtSI[i] = new RTStationInfo();
            rtRsp[i] = new RTResponse();
            ++i;
        }
        int chanOrder = 0;
        String chan2 = null;
        StringTokenizer st = null;
        int stn = 0;
        while (stn < this.TSN) {
            int comp = 0;
            while (comp < this.SI[stn].stn_par.comp) {
                chanOrder = this.getCN(stn) + comp;
                String key = new String(this.SI[stn].stn_par.name).trim();
                st = new StringTokenizer(key, "/");
                chan2 = null;
                if (st.countTokens() == 4) {
                    rtSI[chanOrder].setNetworkCode(st.nextToken());
                    rtSI[chanOrder].setStationCode(st.nextToken());
                    rtSI[chanOrder].setAuxId(st.nextToken());
                    chan2 = st.nextToken();
                } else {
                    rtSI[chanOrder].setNetworkCode("XX");
                    rtSI[chanOrder].setStationCode(key);
                    rtSI[chanOrder].setAuxId("00");
                }
                rtSI[chanOrder].setChannelComp(this.SI[stn].stn_par.comp);
                rtSI[chanOrder].setStationType(rtSI[chanOrder].getChannelComp() + "C");
                rtSI[chanOrder].setInstrumentType(new String(this.SI[stn].stn_par.seismometer).trim());
                rtSI[chanOrder].setSampleRate(this.SI[stn].stn_par.samp);
                rtSI[chanOrder].setCoordSys("WGS-84");
                rtSI[chanOrder].setStationLocation(new Location(this.SI[stn].stn_par.latitude, this.SI[stn].stn_par.longitude));
                if (comp == 0) {
                    if (this.SI[stn].stn_par.SMMode == 0) {
                        rtSI[chanOrder].setChannelCode("SHZ");
                    } else {
                        rtSI[chanOrder].setChannelCode("BHZ");
                    }
                    if (chan2 != null) {
                        rtSI[chanOrder].setChannelCode(String.valueOf(chan2) + "Z");
                    }
                    rtSI[chanOrder].setHAng(-1.0);
                    rtSI[chanOrder].setVAng(0.0);
                } else if (comp == 1) {
                    if (this.SI[stn].stn_par.SMMode == 0) {
                        rtSI[chanOrder].setChannelCode("SHE");
                    } else {
                        rtSI[chanOrder].setChannelCode("BHE");
                    }
                    if (chan2 != null) {
                        rtSI[chanOrder].setChannelCode(String.valueOf(chan2) + "E");
                    }
                    rtSI[chanOrder].setHAng(90.0);
                    rtSI[chanOrder].setVAng(90.0);
                } else {
                    if (this.SI[stn].stn_par.SMMode == 0) {
                        rtSI[chanOrder].setChannelCode("SHN");
                    } else {
                        rtSI[chanOrder].setChannelCode("BHN");
                    }
                    if (chan2 != null) {
                        rtSI[chanOrder].setChannelCode(String.valueOf(chan2) + "N");
                    }
                    rtSI[chanOrder].setHAng(0.0);
                    rtSI[chanOrder].setVAng(90.0);
                }
                rtRsp[chanOrder].setCalibFactor(this.Rspns[chanOrder].getFactor());
                rtRsp[chanOrder].setCalper(this.Rspns[chanOrder].getF0());
                rtRsp[chanOrder].setScaleFactor(this.Rspns[chanOrder].getTfGain());
                rtRsp[chanOrder].setZero(this.Rspns[chanOrder].getZero());
                rtRsp[chanOrder].setPole(this.Rspns[chanOrder].getPole());
                rtRsp[chanOrder].setOriginalType(this.SI[stn].stn_par.oritype);
                if (this.WDat == null) {
                    ((RTOneChannelData)chanData[chanOrder]).setData(rtSI[chanOrder], rtRsp[chanOrder], (Date)this.aEventDate[stn].clone(), null);
                } else {
                    ((RTOneChannelData)chanData[chanOrder]).setData(rtSI[chanOrder], rtRsp[chanOrder], (Date)this.aEventDate[stn].clone(), this.WDat[chanOrder]);
                }
                ++comp;
            }
            ++stn;
        }
        this.setTimeSeries(chanData);
    }

    public void setEvtData(GeoDevEvtData evtData) {
        this.TCN = evtData.TCN;
        this.TSN = evtData.TSN;
        this.TRL = evtData.TRL;
        this.aEventDate = evtData.aEventDate;
        this.aTRL = evtData.aTRL;
        this.SI = evtData.SI;
        this.Rspns = evtData.Rspns;
        this.Flag = evtData.Flag;
        this.WDat = evtData.WDat;
    }

    public StationInfo getStationInfo(int stnCode) {
        int i = 0;
        while (this.SI[i].stn_par.no != stnCode) {
            ++i;
        }
        if (i >= this.TSN) {
            return null;
        }
        return (StationInfo)this.SI[i].clone();
    }

    public StationInfo getStationInfo(String stnName) {
        int i = 0;
        while (!stnName.equalsIgnoreCase(new String(this.SI[i].stn_par.name))) {
            ++i;
        }
        if (i >= this.TSN) {
            return null;
        }
        return (StationInfo)this.SI[i].clone();
    }

    protected int toStn(int Chn) {
        ++Chn;
        int ret = 0;
        int i = 0;
        while (i < this.TSN) {
            if ((Chn -= this.SI[i].stn_par.comp) <= 0) {
                ret = i;
                break;
            }
            ++i;
        }
        if (Chn > 0) {
            logger.fatal("Error in toStn: the param Chn is too BIG!");
            System.exit(-1);
        }
        return ret;
    }

    protected int getCN(int Stn) {
        if (Stn > this.TSN) {
            logger.fatal("Error in getCN: the param Stn is too BIG!");
            System.exit(-1);
        }
        int sum = 0;
        int i = 0;
        while (i < Stn) {
            sum += this.SI[i].stn_par.comp;
            ++i;
        }
        return sum;
    }

    public double getResponse(int chn, double freq) {
        int min = 0;
        int max = this.Rspns[chn].ntrip;
        if (freq <= this.Rspns[chn].Freq[0]) {
            return this.Rspns[chn].Amp[0] * this.Rspns[chn].Factor;
        }
        if (freq >= this.Rspns[chn].Freq[max - 1]) {
            return this.Rspns[chn].Amp[max - 1] * this.Rspns[chn].Factor;
        }
        do {
            if (freq < this.Rspns[chn].Freq[min + (max - min) / 2]) {
                max = min + (max - min) / 2;
                continue;
            }
            min += (max - min) / 2;
        } while (min + 1 < max);
        double rate = Math.abs(this.Rspns[chn].Freq[min] - freq) / Math.abs(this.Rspns[chn].Freq[max] - this.Rspns[chn].Freq[min]);
        return (this.Rspns[chn].Amp[min] + rate * (this.Rspns[chn].Amp[max] - this.Rspns[chn].Amp[min])) * this.Rspns[chn].Factor;
    }

    public Response[] getResponse() {
        return this.Rspns;
    }

    public void clipEvtData(int begCutTime, int cutLength) {
        int i = 0;
        while (i < this.TSN) {
            this.aEventDate[i] = new Date(this.aEventDate[i].getTime() + (long)(begCutTime * 1000));
            this.aTRL[i] = cutLength;
            this.TRL = cutLength;
            int k = 0;
            while (k < cutLength) {
                this.Flag[i][k] = this.Flag[i][begCutTime + k];
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < this.TCN) {
            int counts = cutLength * this.SI[this.toStn((int)i)].stn_par.samp;
            int beg = begCutTime * this.SI[this.toStn((int)i)].stn_par.samp;
            int k = 0;
            while (k < counts) {
                this.WDat[i][k] = this.WDat[i][beg + k];
                ++k;
            }
            ++i;
        }
    }

    public boolean writeEventHeadInfoConfigurationFile(String fname) {
        try {
            ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(fname), 4096));
            zipOut.setLevel(1);
            ZipEntry head = new ZipEntry("Head");
            zipOut.putNextEntry(head);
            ObjectOutputStream oos = new ObjectOutputStream(zipOut);
            oos.writeInt(this.TSN);
            oos.writeInt(this.TCN);
            oos.writeObject(this.SI);
            oos.writeObject(this.Rspns);
            oos.flush();
            zipOut.closeEntry();
            zipOut.close();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            return false;
        }
        return true;
    }

    public boolean readEventHeadInfoConfigurationFile(String fname) {
        try {
            ZipFile zf = new ZipFile(fname);
            ZipEntry head = zf.getEntry("Head");
            ObjectInputStream ois = new ObjectInputStream(zf.getInputStream(head));
            this.TSN = ois.readInt();
            this.TCN = ois.readInt();
            this.SI = (StationInfo[])ois.readObject();
            this.Rspns = (Response[])ois.readObject();
            ois.close();
            zf.close();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            return false;
        }
        return true;
    }
}

