/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import JSci.maths.Complex;
import cn.org.gddsn.convert.CStringToJava;
import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EdasZipEvent;
import cn.org.gddsn.seis.evtformat.GeoDevEvent;
import cn.org.gddsn.seis.evtformat.GeoDevOldEvent;
import cn.org.gddsn.seis.evtformat.JZipEvent;
import cn.org.gddsn.seis.evtformat.JZipEvtHead;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.MultiGeoDevEvent;
import cn.org.gddsn.seis.evtformat.MultiTimeSeries;
import cn.org.gddsn.seis.evtformat.RTEvtData;
import cn.org.gddsn.seis.evtformat.RTMiniSeedData;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.evtformat.UnsupportedEventFormat;
import cn.org.gddsn.seis.evtformat.WaveFormType;
import cn.org.gddsn.seis.evtformat.seed.SeedVolume;
import cn.org.gddsn.seis.evtformat.seed.SeedVolumeNativePlugin;
import cn.org.gddsn.seis.location.LocationMath;
import cn.org.gddsn.seis.location.PeriodBound;
import cn.org.gddsn.seis.location.TauPToolkit;
import cn.org.gddsn.signal.FFTFilter;
import edu.iris.miniseedutils.steim.MiniSeedRecordDouble;
import edu.sc.seis.TauP.Arrival;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EvtData
implements Serializable,
WaveFormType,
MultiTimeSeries {
    static Logger logger = Logger.getLogger(EvtData.class);
    static final long serialVersionUID = -1364303022956719099L;
    protected int evtFormat;
    protected double clat;
    protected double clon;
    protected double calt;
    protected int TCN;
    protected int TSN;
    protected int maxTRL = -1;
    protected boolean cleanNodataChannel = true;
    protected List<TimeSeries> list = new LinkedList<TimeSeries>();
    private Hashtable<ChannelLocator, TimeSeries> tbl = new Hashtable();
    protected Vector<ChannelLocator> noDataChannel = new Vector();
    public static final int SORT_DELTA = 0;
    public static final int SORT_P_ARRIVAL = 1;
    public static final int SORT_STATION_NAME = 2;
    public static final int SORT_STATION_NUM = 3;
    public static final int SORT_AZIMUTH = 4;
    public static final int SORT_RES = 5;
    public static final int SORT_LAT_LON = 6;
    public static final int SORT_LON_LAT = 7;
    public static final int ALIGN_P = 8;
    public static final int ALIGN_S = 9;
    public static int WaveFormSortType = -1;
    public static SourceParam source = null;
    public static EvtData thisEvtData = null;
    TauPToolkit ttk = new TauPToolkit();

    public abstract boolean readEvtFile(String var1);

    public abstract boolean writeEvtFile(String var1);

    public abstract boolean readEvtFile(URL var1);

    public abstract boolean writeEvtFile(URL var1);

    public void sort() {
        Collections.sort(this.list);
    }

    public void checkGain(int chan) {
        Complex[] zero = this.getZero(chan);
        Complex[] pole = this.getPole(chan);
        double A0 = this.getScaleFactor(chan);
        double freq = this.getCalper(chan);
        double norm = FFTFilter.normalf(zero, pole, A0, freq);
        logger.info(this.getChannelLocator(chan) + " norm factor:" + norm);
        if (norm < 0.9 || norm > 1.1) {
            norm = 1.0;
            logger.warn(this.getChannelLocator(chan) + " check pole & zero");
        }
    }

    public static final EvtData readEvtData(String fileName) {
        EvtData evtData = null;
        boolean success = true;
        int format = EvtData.getEvtFormat(fileName);
        switch (format) {
            case 7: {
                SeedVolume seed = new SeedVolume(true);
                SeedVolumeNativePlugin plugin = new SeedVolumeNativePlugin();
                plugin.setFile(new File(fileName));
                seed.setSeedVolumePlugin(plugin);
                evtData = seed;
                success = evtData.readEvtFile(fileName);
                if (!success) break;
                int i = 0;
                while (i < evtData.getTCN()) {
                    evtData.checkGain(i);
                    ++i;
                }
                break;
            }
            case 0: {
                evtData = new GeoDevEvent();
                success = evtData.readEvtFile(fileName);
                break;
            }
            case 1: {
                evtData = new GeoDevOldEvent();
                success = evtData.readEvtFile(fileName);
                break;
            }
            case 9: {
                evtData = new EdasZipEvent();
                success = evtData.readEvtFile(fileName);
                break;
            }
            case 2: {
                evtData = new JZipEvent();
                success = evtData.readEvtFile(fileName);
                break;
            }
            case 3: {
                evtData = new MultiGeoDevEvent();
                success = evtData.readEvtFile(fileName);
                break;
            }
            case 5: {
                evtData = new RTEvtData();
                success = evtData.readEvtFile(fileName);
                break;
            }
            case 6: {
                evtData = new RTMiniSeedData();
                success = evtData.readEvtFile(fileName);
                break;
            }
            default: {
                throw new UnsupportedEventFormat("Unknown Data Format: " + new File(fileName).getPath());
            }
        }
        if (!success) {
            evtData = null;
        }
        return evtData;
    }

    public static int getEvtFormat(String FileName) {
        int ret = -1;
        try {
            FileInputStream FileIn = new FileInputStream(FileName);
            DataInputStream DatIn = new DataInputStream(FileIn);
            byte[] evtFlag = new byte[16];
            DatIn.readFully(evtFlag, 0, 16);
            DatIn.close();
            FileIn.close();
            CStringToJava.tailToZero(evtFlag, 16);
            String gettingID = new String(evtFlag);
            String newID = "digital event";
            String oldID1 = "PROCESSED";
            String oldID2 = "EVT-PC";
            String edasZip = "SEISMIC EVENT";
            File file = new File(FileName);
            if (gettingID.startsWith(newID)) {
                ret = 0;
            } else if (EvtData.isSeedVolume(FileName)) {
                ret = 7;
            } else if (gettingID.startsWith(oldID1) || gettingID.startsWith(oldID2)) {
                ret = 1;
            } else if (gettingID.startsWith(edasZip)) {
                ret = 9;
            } else if (file.isDirectory()) {
                ret = 3;
            } else if (EvtData.isJZipEvt(FileName)) {
                ret = 2;
            } else if (EvtData.isRTEvtData(FileName)) {
                ret = 5;
            } else if (EvtData.isRTMiniSeedData(FileName)) {
                ret = 6;
            }
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), e);
        }
        return ret;
    }

    static boolean isJZipEvt(String openedFileFullName) {
        boolean ret = false;
        try {
            ZipFile zf = new ZipFile(openedFileFullName);
            ZipEntry head = zf.getEntry("head");
            ObjectInputStream ois = new ObjectInputStream(zf.getInputStream(head));
            JZipEvtHead evtHead = (JZipEvtHead)ois.readObject();
            String ID = null;
            ID = evtHead.EvtFlag;
            ois.close();
            zf.close();
            if (ID.startsWith("JZipEvt")) {
                ret = true;
            }
        }
        catch (Exception Ex) {
            ret = false;
        }
        return ret;
    }

    static boolean isRTEvtData(String openedFileFullName) {
        boolean ret = false;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(openedFileFullName));
            String lineStr = reader.readLine();
            StringTokenizer st = new StringTokenizer(lineStr);
            if (st.nextToken().equals("FORMAT_RTStreamData")) {
                return true;
            }
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            ret = false;
        }
        return ret;
    }

    static boolean isRTMiniSeedData(String openedFileFullName) {
        boolean ret = false;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(openedFileFullName));
            String lineStr = reader.readLine();
            StringTokenizer st = new StringTokenizer(lineStr);
            if (st.nextToken().equals("FORMAT_RTMiniSeedData")) {
                ret = true;
            }
            reader.close();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            ret = false;
        }
        return ret;
    }

    static boolean isSeedVolume(String openedFileFullName) {
        boolean ret = false;
        try {
            FileReader reader = new FileReader(openedFileFullName);
            char[] lineStr = new char[8];
            reader.read(lineStr);
            if ("000001V ".equals(new String(lineStr))) {
                ret = true;
            }
            reader.close();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            ret = false;
        }
        return ret;
    }

    public int getTCN() {
        return this.TCN;
    }

    public int getTSN() {
        return this.TSN;
    }

    public int getMaxTRL() {
        return this.maxTRL;
    }

    public String[] getAllNetStation() {
        Vector<String> stnCodes = new Vector<String>();
        int chan = 0;
        while (chan < this.TCN) {
            String code = String.valueOf(this.getNetworkCode(chan)) + "/" + this.getStationCode(chan);
            if (!stnCodes.contains(code)) {
                stnCodes.add(code);
            }
            ++chan;
        }
        Object[] objs = stnCodes.toArray();
        String[] rets = new String[objs.length];
        int i = 0;
        while (i < objs.length) {
            rets[i] = (String)objs[i];
            ++i;
        }
        return rets;
    }

    public double getClat() {
        return this.clat;
    }

    public double getClon() {
        return this.clon;
    }

    public double getCalt() {
        return this.calt;
    }

    public int getEvtFormat() {
        return this.evtFormat;
    }

    public double getTRL(int chanOrder) {
        return (double)this.getSamples(chanOrder) / this.getSampleRate(chanOrder);
    }

    public synchronized void setEvtData(EvtData evtData) {
        this.clat = evtData.clat;
        this.clon = evtData.clon;
        this.calt = evtData.calt;
        this.TCN = evtData.TCN;
        this.TSN = evtData.TSN;
        this.maxTRL = evtData.maxTRL;
        this.list = evtData.list;
    }

    public synchronized void addTimeSeries(TimeSeries[] timeSeries) {
        int i = 0;
        while (i < timeSeries.length) {
            this.list.add(timeSeries[i]);
            ++i;
        }
        this.TCN = this.list.size();
        this.TSN = this.getAllNetStation().length;
        try {
            i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        this.tbl.clear();
        i = 0;
        while (i < timeSeries.length) {
            this.tbl.put(this.getChannelLocator(i), timeSeries[i]);
            ++i;
        }
    }

    public synchronized void removeTimeSeries(ChannelLocator cl) {
        int i = 0;
        while (i < this.TCN) {
            if (this.getChannelLocator(i).equals(cl)) {
                this.list.remove(i);
                break;
            }
            ++i;
        }
        this.TCN = this.list.size();
        this.TSN = this.getAllNetStation().length;
        try {
            i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        this.tbl.clear();
        i = 0;
        while (i < this.list.size()) {
            this.tbl.put(this.getChannelLocator(i), this.list.get(i));
            ++i;
        }
    }

    public synchronized void setTimeSeries(TimeSeries[] timeSeries) {
        this.list = new LinkedList<TimeSeries>();
        int i = 0;
        while (i < timeSeries.length) {
            this.list.add(timeSeries[i]);
            ++i;
        }
        this.TCN = this.list.size();
        this.TSN = this.getAllNetStation().length;
        try {
            i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        this.tbl.clear();
        i = 0;
        while (i < timeSeries.length) {
            this.tbl.put(this.getChannelLocator(i), timeSeries[i]);
            ++i;
        }
    }

    public synchronized void setTimeSeries(List<TimeSeries> aList) {
        int i = 0;
        while (i < aList.size()) {
            if (!(aList.get(i) instanceof TimeSeries)) {
                throw new IllegalArgumentException("List contain an element is not TimeSeries");
            }
            ++i;
        }
        this.list = aList;
        this.TCN = this.list.size();
        this.TSN = this.getAllNetStation().length;
        try {
            i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        this.tbl.clear();
        i = 0;
        while (i < aList.size()) {
            this.tbl.put(this.getChannelLocator(i), aList.get(i));
            ++i;
        }
    }

    public synchronized void setTimeSeries() {
        this.TCN = this.list.size();
        this.TSN = this.getAllNetStation().length;
        this.maxTRL = -1;
        try {
            int i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        this.tbl.clear();
        int i = 0;
        while (i < this.list.size()) {
            this.tbl.put(this.getChannelLocator(i), this.list.get(i));
            ++i;
        }
        logger.info("Total Station / Total Channel : " + this.TSN + " / " + this.TCN);
    }

    public synchronized int[] getChanOrder(int chanOrder) {
        return this.getChanOrder(this.getNetworkCode(chanOrder), this.getStationCode(chanOrder));
    }

    public synchronized int[] getChanOrder(String network, String stationCode, String locId, String chan2) {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.TCN) {
            TimeSeries chanData = this.list.get(i);
            if (chanData.getNetworkCode().equals(network) && chanData.getStationCode().equals(stationCode) && chanData.getAuxId().equals(locId) && chanData.getChannelCode().substring(0, 2).equals(chan2)) {
                aList.add(i);
            }
            ++i;
        }
        if (aList.size() == 0) {
            return null;
        }
        Collections.sort(aList);
        Object[] integer = aList.toArray();
        int[] cOrder = new int[integer.length];
        int i2 = 0;
        while (i2 < cOrder.length) {
            cOrder[i2] = (Integer)integer[i2];
            ++i2;
        }
        return cOrder;
    }

    public synchronized int[] getChanOrder(String networkId, String stationCode) {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.TCN) {
            TimeSeries chanData = this.list.get(i);
            if (chanData.getNetworkCode().equals(networkId) && chanData.getStationCode().equals(stationCode)) {
                aList.add(i);
            }
            ++i;
        }
        if (aList.size() == 0) {
            return null;
        }
        Object[] integer = aList.toArray();
        int[] cOrder = new int[integer.length];
        int i2 = 0;
        while (i2 < cOrder.length) {
            cOrder[i2] = (Integer)integer[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < cOrder.length) {
            int j = i3 + 1;
            while (j < cOrder.length) {
                if (cOrder[i3] > cOrder[j]) {
                    int temp = cOrder[i3];
                    cOrder[i3] = cOrder[j];
                    cOrder[j] = temp;
                }
                ++j;
            }
            ++i3;
        }
        return cOrder;
    }

    public synchronized int getChanOrder(String networkId, String stationCode, String channelCode) {
        int retVal = -1;
        int i = 0;
        while (i < this.TCN) {
            TimeSeries chanData = this.list.get(i);
            if (chanData.getNetworkCode().equals(networkId) && chanData.getStationCode().equals(stationCode) && chanData.getChannelCode().equals(channelCode)) {
                retVal = i;
                break;
            }
            ++i;
        }
        if (retVal == -1) {
            // empty if block
        }
        return retVal;
    }

    public int getChanOrder(String cl) {
        StringTokenizer st = new StringTokenizer(cl, "/");
        if (st.countTokens() != 4) {
            return -1;
        }
        return this.getChanOrder(new ChannelLocator(st.nextToken(), st.nextToken(), st.nextToken(), st.nextToken()));
    }

    public synchronized int getChanOrder(ChannelLocator cl) {
        int retVal = -1;
        int i = 0;
        while (i < this.TCN) {
            TimeSeries chanData = this.list.get(i);
            if (chanData.getChannelLocator().equals(cl)) {
                retVal = i;
                break;
            }
            ++i;
        }
        if (retVal == -1) {
            // empty if block
        }
        return retVal;
    }

    public synchronized int[] getChanOrder0(String stationCode, String locId) {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.TCN) {
            TimeSeries chanData = this.list.get(i);
            if (chanData.getStationCode().equals(stationCode) && chanData.getAuxId().equals(locId)) {
                aList.add(i);
            }
            ++i;
        }
        if (aList.size() == 0) {
            return null;
        }
        Object[] integer = aList.toArray();
        int[] cOrder = new int[integer.length];
        int i2 = 0;
        while (i2 < cOrder.length) {
            cOrder[i2] = (Integer)integer[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < cOrder.length) {
            int j = i3 + 1;
            while (j < cOrder.length) {
                if (cOrder[i3] > cOrder[j]) {
                    int temp = cOrder[i3];
                    cOrder[i3] = cOrder[j];
                    cOrder[j] = temp;
                }
                ++j;
            }
            ++i3;
        }
        return cOrder;
    }

    public synchronized boolean isThreeComp(int chanOrder) {
        this.checkChannelOrder(chanOrder);
        int[] chans = this.getChanOrder(chanOrder);
        return chans != null && chans.length >= 3;
    }

    public synchronized boolean isThreeComp(String networkCode, String stationCode, String auxId, String channelCode) {
        return this.isThreeComp(this.chanOrder(networkCode, stationCode, auxId, channelCode));
    }

    public synchronized TimeSeries getTimeSeries(int chanOrder) {
        this.checkChannelOrder(chanOrder);
        return this.list.get(chanOrder);
    }

    public synchronized TimeSeries getTimeSeries(ChannelLocator cl) {
        return this.tbl.get(cl);
    }

    public double[] getSampData(int chanOrder, Date date, int samples) {
        return this.getSampData(chanOrder);
    }

    public int toComp(int chanOrder) {
        int ret = -1;
        if (this.getChannelCode(chanOrder).endsWith("Z")) {
            ret = 1;
        } else if (this.getChannelCode(chanOrder).endsWith("E")) {
            ret = 2;
        } else if (this.getChannelCode(chanOrder).endsWith("N")) {
            ret = 3;
        }
        return ret;
    }

    public void clipEvtData(int begCutTime, int cutLength) {
    }

    private void checkChannelOrder(int chanOrder) {
        if (chanOrder >= this.TCN || chanOrder < 0) {
            throw new IllegalArgumentException("channal order exceed: " + chanOrder);
        }
    }

    private int chanOrder(String networkCode, String stationCode, String auxId, String channelCode) {
        ListIterator<TimeSeries> itr = this.list.listIterator();
        while (itr.hasNext()) {
            TimeSeries chanData = itr.next();
            if (!chanData.getNetworkCode().equals(networkCode) || !chanData.getStationCode().equals(stationCode) || !chanData.getAuxId().equals(auxId) || !chanData.getChannelCode().equals(channelCode)) continue;
            return itr.previousIndex();
        }
        return -1;
    }

    @Override
    public Date getArrivalTime(int chanOrder) {
        return this.getTimeSeries(chanOrder).getArrivalTime();
    }

    @Override
    public double[] getSampData(int chanOrder) {
        return this.getTimeSeries(chanOrder).getSampData();
    }

    @Override
    public int getSamples(int chanOrder) {
        return this.getTimeSeries(chanOrder).getSamples();
    }

    @Override
    public void setArrivalTime(int chanOrder, Date newArrivalTime) {
        this.getTimeSeries(chanOrder).setArrivalTime(newArrivalTime);
    }

    @Override
    public void setSampData(int chanOrder, double[] newSampData) {
        this.getTimeSeries(chanOrder).setSampData(newSampData);
    }

    @Override
    public String getNetworkCode(int chanOrder) {
        return this.getTimeSeries(chanOrder).getNetworkCode();
    }

    @Override
    public String getStationCode(int chanOrder) {
        return this.getTimeSeries(chanOrder).getStationCode();
    }

    @Override
    public String getAuxId(int chanOrder) {
        return this.getTimeSeries(chanOrder).getAuxId();
    }

    @Override
    public ChannelLocator getChannelLocator(int chanOrder) {
        return this.getTimeSeries(chanOrder).getChannelLocator();
    }

    @Override
    public String getStationType(int chanOrder) {
        return this.getTimeSeries(chanOrder).getStationType();
    }

    @Override
    public int getChannelComp(int chanOrder) {
        return this.getTimeSeries(chanOrder).getChannelComp();
    }

    @Override
    public String getChannelCode(int chanOrder) {
        return this.getTimeSeries(chanOrder).getChannelCode();
    }

    @Override
    public Location getStationLocation(int chanOrder) {
        return this.getTimeSeries(chanOrder).getStationLocation();
    }

    @Override
    public String getCoordSys(int chanOrder) {
        return this.getTimeSeries(chanOrder).getCoordSys();
    }

    @Override
    public String getInstrumentType(int chanOrder) {
        return this.getTimeSeries(chanOrder).getInstrumentType();
    }

    @Override
    public double getHAng(int chanOrder) {
        return this.getTimeSeries(chanOrder).getHAng();
    }

    @Override
    public double getVAng(int chanOrder) {
        return this.getTimeSeries(chanOrder).getVAng();
    }

    @Override
    public double getSampleRate(int chanOrder) {
        return this.getTimeSeries(chanOrder).getSampleRate();
    }

    @Override
    public void setNetworkCode(int chanOrder, String newNetworkCode) {
        this.getTimeSeries(chanOrder).setNetworkCode(newNetworkCode);
    }

    @Override
    public void setStationCode(int chanOrder, String newStationCode) {
        this.getTimeSeries(chanOrder).setStationCode(newStationCode);
    }

    @Override
    public void setStationType(int chanOrder, String newStationType) {
        this.getTimeSeries(chanOrder).setStationType(newStationType);
    }

    @Override
    public void setAuxId(int chanOrder, String newAuxId) {
        this.getTimeSeries(chanOrder).setAuxId(newAuxId);
    }

    @Override
    public void setChannelComp(int chanOrder, int newChannelComp) {
        this.getTimeSeries(chanOrder).setChannelComp(newChannelComp);
    }

    @Override
    public void setChannelCode(int chanOrder, String newChannelCode) {
        this.getTimeSeries(chanOrder).setChannelCode(newChannelCode);
    }

    @Override
    public void setInstrumentType(int chanOrder, String newInstrumentType) {
        this.getTimeSeries(chanOrder).setInstrumentType(newInstrumentType);
    }

    @Override
    public void setStationLocation(int chanOrder, Location newStationlocation) {
        this.getTimeSeries(chanOrder).setStationLocation(newStationlocation);
    }

    @Override
    public void setCoordSys(int chanOrder, String newCoordSys) {
        this.getTimeSeries(chanOrder).setCoordSys(newCoordSys);
    }

    @Override
    public void setHAng(int chanOrder, double newHAng) {
        this.getTimeSeries(chanOrder).setHAng(newHAng);
    }

    @Override
    public void setVAng(int chanOrder, double newVAng) {
        this.getTimeSeries(chanOrder).setVAng(newVAng);
    }

    @Override
    public void setSampleRate(int chanOrder, double newSampleRate) {
        this.getTimeSeries(chanOrder).setSampleRate(newSampleRate);
    }

    @Override
    public double getCalibFactor(int chanOrder) {
        return this.getTimeSeries(chanOrder).getCalibFactor();
    }

    @Override
    public double getCalper(int chanOrder) {
        return this.getTimeSeries(chanOrder).getCalper();
    }

    @Override
    public double getScaleFactor(int chanOrder) {
        return this.getTimeSeries(chanOrder).getScaleFactor();
    }

    @Override
    public Complex[] getZero(int chanOrder) {
        return this.getTimeSeries(chanOrder).getZero();
    }

    @Override
    public Complex[] getPole(int chanOrder) {
        return this.getTimeSeries(chanOrder).getPole();
    }

    @Override
    public int getZeroNum(int chanOrder) {
        return this.getTimeSeries(chanOrder).getZeroNum();
    }

    @Override
    public int getPoleNum(int chanOrder) {
        return this.getTimeSeries(chanOrder).getPoleNum();
    }

    @Override
    public void setCalibFactor(int chanOrder, double newCalibFactor) {
        this.getTimeSeries(chanOrder).setCalibFactor(newCalibFactor);
    }

    @Override
    public void setCalper(int chanOrder, double newCalper) {
        this.getTimeSeries(chanOrder).setCalper(newCalper);
    }

    @Override
    public void setScaleFactor(int chanOrder, double newScaleFactor) {
        this.getTimeSeries(chanOrder).setScaleFactor(newScaleFactor);
    }

    @Override
    public void setZero(int chanOrder, Complex[] newZero) {
        this.getTimeSeries(chanOrder).setZero(newZero);
    }

    @Override
    public void setPole(int chanOrder, Complex[] newPole) {
        this.getTimeSeries(chanOrder).setPole(newPole);
    }

    @Override
    public void setOriginalType(int chanOrder, int newOriginalType) {
        this.getTimeSeries(chanOrder).setOriginalType(newOriginalType);
    }

    @Override
    public int getOriginalType(int chanOrder) {
        return this.getTimeSeries(chanOrder).getOriginalType();
    }

    public Vector<Phase> getTheoreticPhases(int chanOrder) {
        return this.getTimeSeries(chanOrder).getTheoreticPhases();
    }

    public void setTheoreticPhases(int chanOrder, Vector<Phase> theoreticPhase) {
        this.getTimeSeries(chanOrder).setTheoreticPhases(theoreticPhase);
    }

    public Vector<Phase> getAutoPhases(int chanOrder) {
        return this.getTimeSeries(chanOrder).getAutoPhases();
    }

    public void setAutoPhases(int chanOrder, Vector<Phase> autoPhases) {
        this.getTimeSeries(chanOrder).setAutoPhases(autoPhases);
    }

    public Vector<Phase> getPhases(int chanOrder) {
        return this.getTimeSeries(chanOrder).getPhases();
    }

    public void setPhases(int chanOrder, Vector<Phase> thePhases) {
        this.getTimeSeries(chanOrder).setPhases(thePhases);
    }

    public boolean hasPhase(int chanOrder) {
        return !this.getTimeSeries(chanOrder).getPhases().isEmpty();
    }

    public boolean hasPhase(String networkId, String stationCode) {
        int[] chn = this.getChanOrder(networkId, stationCode);
        boolean has = false;
        int i = 0;
        while (i < chn.length) {
            boolean bl = has = !this.getTimeSeries(chn[i]).getPhases().isEmpty();
            if (has) {
                return has;
            }
            ++i;
        }
        return has;
    }

    public boolean hasPhase(String networkId, String stationCode, String phaseName) {
        int[] chn = this.getChanOrder(networkId, stationCode);
        int i = 0;
        while (i < chn.length) {
            Vector<Phase> vec = this.getTimeSeries(chn[i]).getPhases();
            for (Phase p : vec) {
                if (!p.getPhaseName().equals(phaseName)) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public Phase getPhase(String networkId, String stationCode, String phaseName) {
        int[] chn = this.getChanOrder(networkId, stationCode);
        int i = 0;
        while (i < chn.length) {
            Vector<Phase> vec = this.getTimeSeries(chn[i]).getPhases();
            for (Phase p : vec) {
                if (!p.getPhaseName().equals(phaseName)) continue;
                return p;
            }
            ++i;
        }
        return null;
    }

    public int getMaxPPCountWithPeriod(int chn, int start, int end, double mean, PeriodBound pb) {
        int maxIdx = start;
        double maxAmp = -1.0;
        int maxPer = 0;
        double[] WDat = this.getSampData(chn);
        double sr = this.getSampleRate(chn);
        if (end > WDat.length) {
            end = WDat.length;
        }
        int i = start;
        while (i < end) {
            double[] par = LocationMath.measurePeriod(WDat, i, start, end, sr, mean);
            int per = (int)(sr * par[0]);
            double amp = this.getMaxPPCount(chn, i - per / 2, i + per / 2) / 2.0;
            if (pb.accept(par) && maxAmp < amp) {
                maxIdx = i;
                maxAmp = amp;
                maxPer = per;
            }
            i += per / 2;
            ++i;
        }
        return this.getMaxCountIndex(chn, maxIdx - maxPer / 2, maxIdx + maxPer / 2, mean);
    }

    public int getMaxCountIndex(int chn, int start, int end, double mean) {
        double[] WDat = this.getSampData(chn);
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (end >= WDat.length) {
            end = WDat.length - 1;
        }
        if (start >= WDat.length) {
            start = WDat.length - 1;
        }
        double max = Math.abs(WDat[start] - mean);
        int imax = start;
        int i = start + 1;
        while (i < end) {
            if (max < Math.abs(WDat[i] - mean)) {
                max = Math.abs(WDat[i] - mean);
                imax = i;
            }
            ++i;
        }
        return imax;
    }

    public double getMaxPPCount(int chn, int start, int end) {
        double[] WDat = this.getSampData(chn);
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (end >= WDat.length) {
            end = WDat.length - 1;
        }
        if (start >= WDat.length) {
            start = WDat.length - 1;
        }
        int minIndex = start;
        int maxIndex = start;
        int i = start;
        while (i < end) {
            if (WDat[minIndex] <= WDat[i]) {
                if (WDat[maxIndex] <= WDat[i]) {
                    maxIndex = i;
                }
            } else {
                minIndex = i;
            }
            ++i;
        }
        return WDat[maxIndex] - WDat[minIndex];
    }

    public double getMean(int chn, int start, int end) {
        double sum = 0.0;
        double[] WDat = this.getSampData(chn);
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (end >= WDat.length) {
            end = WDat.length;
        }
        if (start >= WDat.length) {
            start = WDat.length - 1;
        }
        double srate = this.getSampleRate(chn);
        int Count = (int)(srate * this.getTRL(chn));
        int min = Math.min(end, Count);
        int i = start;
        while (i < min) {
            sum += WDat[i];
            ++i;
        }
        return sum / (double)(min - start);
    }

    public Phase getPhase(int chn, String phaseName) {
        Vector<Phase> vec = this.getTimeSeries(chn).getPhases();
        for (Phase p : vec) {
            if (!p.getPhaseName().equals(phaseName)) continue;
            return p;
        }
        return null;
    }

    public Phase getTheoreticPhase(int chn, String phaseName) {
        Vector<Phase> vec = this.getTimeSeries(chn).getTheoreticPhases();
        for (Phase p : vec) {
            if (!p.getPhaseName().equals(phaseName)) continue;
            return p;
        }
        return null;
    }

    public void removePhase(String phaseName) {
        int chn = 0;
        while (chn < this.TCN) {
            Vector<Phase> phs = this.getPhases(chn);
            Iterator<Phase> it = phs.iterator();
            while (it.hasNext()) {
                Phase ph = it.next();
                if (!ph.getPhaseName().equals(phaseName)) continue;
                it.remove();
            }
            ++chn;
        }
    }

    public float getMaxRes(String networkId, String stationCode) {
        int[] chn = this.getChanOrder(networkId, stationCode);
        float max = 0.0f;
        int i = 0;
        while (i < chn.length) {
            Vector<Phase> phs = this.getPhases(chn[i]);
            for (Phase p : phs) {
                if (p.getPhaType() != 0 || !(max < Math.abs(p.getResi()))) continue;
                max = Math.abs(p.getResi());
            }
            ++i;
        }
        return max;
    }

    public double getTheoreticTravelTime(String pha, double delta, double depth) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(pha);
        Arrival[] arrs = this.ttk.getArrivals(strBuf.substring(0), depth, delta);
        if (arrs == null || arrs.length == 0) {
            return Double.NaN;
        }
        return arrs[0].getTime();
    }

    public double getTheoreticTravelTime(String pha, double delta, double depth, String model) {
        this.ttk.setTauModel(model);
        return this.getTheoreticTravelTime(pha, delta, depth);
    }

    public double getTheoreticTravelTime(String netSta, String pha, double s_lat, double s_lon, double s_depth, Date otime, String model) {
        String stn;
        int idx = netSta.indexOf(47);
        String net = netSta.substring(0, idx);
        int[] chn = this.getChanOrder(net, stn = netSta.substring(idx + 1));
        if (chn == null || chn.length == 0) {
            return Double.NaN;
        }
        int c = chn[0];
        double staLat = this.getStationLocation(c).getLatitude();
        double staLon = this.getStationLocation(c).getLongtitude();
        double delta = SphereUtil.distOnSphere(s_lat, s_lon, staLat, staLon);
        return this.getTheoreticTravelTime(pha, delta, s_depth, model);
    }

    public void generateTheoreticPhase(String[] netSta, String[] phaList, double s_lat, double s_lon, double s_depth, Date otime, String model) {
        this.ttk.setTauModel(model);
        StringBuffer strBuf = new StringBuffer();
        int i = 0;
        while (i < phaList.length) {
            strBuf.append(phaList[i]);
            strBuf.append(",");
            ++i;
        }
        int s = 0;
        while (s < netSta.length) {
            int[] chn;
            int idx = netSta[s].indexOf(47);
            String net = netSta[s].substring(0, idx);
            String stn = netSta[s].substring(idx + 1);
            int[] nArray = chn = this.getChanOrder(net, stn);
            int n = chn.length;
            int n2 = 0;
            while (n2 < n) {
                int c = nArray[n2];
                double staLat = this.getStationLocation(c).getLatitude();
                double staLon = this.getStationLocation(c).getLongtitude();
                double delta = SphereUtil.distOnSphere(s_lat, s_lon, staLat, staLon);
                Arrival[] arrivals = this.ttk.getArrivals(strBuf.substring(0), s_depth, delta);
                Vector<Phase> vec = this.getTheoreticPhases(c);
                vec.clear();
                Phase phase = null;
                int i2 = 0;
                while (i2 < arrivals.length) {
                    phase = new Phase();
                    phase.setPhaseName(arrivals[i2].getName());
                    if (phase.getPhaseName().equals("p")) {
                        phase.setPhaseName("P");
                    }
                    if (phase.getPhaseName().equals("s")) {
                        phase.setPhaseName("S");
                    }
                    phase.setNetCode(this.getNetworkCode(c));
                    phase.setBelongedChannelID(0);
                    phase.setStationCode(stn);
                    phase.setChanCode(this.getChannelCode(c));
                    phase.setInstrumentName(this.getInstrumentType(c));
                    long date = otime.getTime() + (long)(arrivals[i2].getTime() * 1000.0);
                    phase.setPhaseTime(new Date(date));
                    phase.offset = (int)((double)(phase.getPhaseTime().getTime() - this.getArrivalTime(c).getTime()) / 1000.0 * this.getSampleRate(c));
                    phase.setWeight(0);
                    phase.setProcessType('T');
                    boolean found = false;
                    Enumeration<Phase> enu = vec.elements();
                    while (enu.hasMoreElements()) {
                        Phase phs = enu.nextElement();
                        if (!phs.getPhaseName().equals(phase.getPhaseName()) || phs.getProcessType() != 'T') continue;
                        found = true;
                    }
                    if (!found) {
                        vec.add(phase);
                    }
                    ++i2;
                }
                ++n2;
            }
            ++s;
        }
    }

    public Vector<ChannelLocator> getNoDataChannel() {
        return this.noDataChannel;
    }

    public boolean isCleanNodataChannel() {
        return this.cleanNodataChannel;
    }

    public void setCleanNodataChannel(boolean cleanNodataChannel) {
        this.cleanNodataChannel = cleanNodataChannel;
    }

    @Override
    public synchronized boolean add(int chanOrder, Date newArrival, MiniSeedRecordDouble mrd) {
        return this.getTimeSeries(chanOrder).add(newArrival, mrd);
    }

    public synchronized void prepareStationDelta(double lat, double lon, Date otime) {
        source = new SourceParam();
        source.setLat(lat);
        source.setLon(lon);
        source.setOriginTime(otime);
        int i = 0;
        while (i < this.TCN) {
            Location loc = this.getStationLocation(i);
            SphereUtil.DELTAI deltai = SphereUtil.deltai(source.getLat(), source.getLon(), loc.getLatitude(), loc.getLongtitude());
            loc.setDelta(deltai.delta);
            loc.setAzimuth(deltai.az1);
            ++i;
        }
        WaveFormSortType = 0;
    }

    public synchronized void prepareStationDelta(int chn) {
        source = new SourceParam();
        Location theLoc = this.getStationLocation(chn);
        source.setLat(theLoc.getLatitude());
        source.setLon(theLoc.getLongtitude());
        int i = 0;
        while (i < this.TCN) {
            Location loc = this.getStationLocation(i);
            SphereUtil.DELTAI deltai = SphereUtil.deltai(source.getLat(), source.getLon(), loc.getLatitude(), loc.getLongtitude());
            loc.setDelta(deltai.delta);
            loc.setAzimuth(deltai.az1);
            ++i;
        }
        WaveFormSortType = 0;
    }

    public synchronized void cleanAllPhases() {
        int i = 0;
        while (i < this.TCN) {
            this.getPhases(i).removeAllElements();
            ++i;
        }
    }

    public synchronized void cleanAllPhases(char type) {
        int i = 0;
        while (i < this.TCN) {
            Iterator<Phase> it = this.getPhases(i).iterator();
            while (it.hasNext()) {
                Phase p = it.next();
                if (p.getProcessType() != type) continue;
                it.remove();
            }
            ++i;
        }
    }

    public synchronized void prepareTheoreticPhases(String model) {
        String[] phaList = new String[]{"P", "S", "p", "s"};
        this.prepareTheoreticPhases(model, phaList);
    }

    public synchronized void prepareTheoreticPhases(String model, String[] phaList) {
        if (source == null) {
            return;
        }
        int i = 0;
        while (i < this.TCN) {
            Location loc = this.getStationLocation(i);
            SphereUtil.DELTAI deltai = SphereUtil.deltai(source.getLat(), source.getLon(), loc.getLatitude(), loc.getLongtitude());
            loc.setDelta(deltai.delta);
            loc.setAzimuth(deltai.az1);
            loc.setMaxResi(this.getMaxRes(this.getNetworkCode(i), this.getStationCode(i)));
            ++i;
        }
        SourceParam s = source;
        double depth = s.getDepth();
        if (depth < 0.0 || depth > 1000.0) {
            depth = 0.0;
        }
        this.generateTheoreticPhase(this.getAllNetStation(), phaList, s.getLat(), s.getLon(), depth, s.getOriginTime(), model);
    }
}

