/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.RTResponse;
import cn.org.gddsn.seis.evtformat.RTStationInfo;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.util.EdasSteim2;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javolution.io.Struct;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdasZipEvent
extends EvtData {
    static Logger logger = Logger.getLogger(EdasZipEvent.class);
    Layout layout = new Layout();

    public EdasZipEvent() {
        this.evtFormat = 9;
    }

    @Override
    public boolean readEvtFile(String fileName) {
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(fileName));
            this.read(in);
            in.close();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            return false;
        }
        catch (EdasZipEventException ex) {
            logger.warn(ex.getMessage(), ex);
            return false;
        }
        this.convertToTimeSeries();
        return true;
    }

    @Override
    public boolean writeEvtFile(String fileName) {
        return false;
    }

    @Override
    public boolean readEvtFile(URL urlFile) {
        throw new UnsupportedOperationException("Method readEvtFile() not yet implemented.");
    }

    @Override
    public boolean writeEvtFile(URL urlFile) {
        throw new UnsupportedOperationException("Method writeEvtFile() not yet implemented.");
    }

    private void convertToTimeSeries() {
        this.clat = this.layout.network.centerLat.get();
        this.clon = this.layout.network.centerLon.get();
        this.calt = this.layout.network.centerAlt.get();
        TimeSeries[] chanData = new RTOneChannelData[this.TCN];
        RTStationInfo[] rtSI = new RTStationInfo[this.TCN];
        RTResponse[] rtRsp = new RTResponse[this.TCN];
        int i = 0;
        while (i < this.TCN) {
            chanData[i] = new RTOneChannelData();
            rtSI[i] = new RTStationInfo();
            rtRsp[i] = new RTResponse();
            ++i;
        }
        int chanOrder = 0;
        int stn = 0;
        while (stn < this.TSN) {
            Station sta = this.layout.staBlk[stn].sta;
            int chns = sta.comp.get();
            int comp = 0;
            while (comp < chns) {
                rtSI[chanOrder].setNetworkCode("XX");
                String stnCode = new String(sta.name.get()).trim();
                rtSI[chanOrder].setStationCode(stnCode);
                rtSI[chanOrder].setAuxId("00");
                rtSI[chanOrder].setChannelComp(chns);
                rtSI[chanOrder].setStationType(chns + "C");
                rtSI[chanOrder].setInstrumentType(sta.seismometer.get().trim());
                rtSI[chanOrder].setSampleRate(sta.samp.get());
                rtSI[chanOrder].setCoordSys("WGS-84");
                rtSI[chanOrder].setStationLocation(new Location(sta.lat.get(), sta.lon.get()));
                if (comp == 0) {
                    if (sta.smmode.get() == Station.SMMODE.SHORT) {
                        rtSI[chanOrder].setChannelCode("SHZ");
                    } else {
                        rtSI[chanOrder].setChannelCode("BHZ");
                    }
                    rtSI[chanOrder].setHAng(-1.0);
                    rtSI[chanOrder].setVAng(0.0);
                } else if (comp == 1) {
                    if (sta.smmode.get() == Station.SMMODE.SHORT) {
                        rtSI[chanOrder].setChannelCode("SHE");
                    } else {
                        rtSI[chanOrder].setChannelCode("BHE");
                    }
                    rtSI[chanOrder].setHAng(90.0);
                    rtSI[chanOrder].setVAng(90.0);
                } else {
                    if (sta.smmode.get() == Station.SMMODE.SHORT) {
                        rtSI[chanOrder].setChannelCode("SHN");
                    } else {
                        rtSI[chanOrder].setChannelCode("BHN");
                    }
                    rtSI[chanOrder].setHAng(0.0);
                    rtSI[chanOrder].setVAng(90.0);
                }
                ZeroPoleResp zap = this.layout.staBlk[stn].chan[comp].zap;
                rtRsp[chanOrder].setCalibFactor(zap.sg_value.get());
                rtRsp[chanOrder].setCalper(zap.sg_fre.get());
                rtRsp[chanOrder].setScaleFactor(zap.ao_value.get());
                rtRsp[chanOrder].setZero(zap.zero);
                rtRsp[chanOrder].setPole(zap.pole);
                if (this.layout.header.recordType.get() == RECORD_TYPE.DISPLACEMENT) {
                    rtRsp[chanOrder].setOriginalType(0);
                } else if (this.layout.header.recordType.get() == RECORD_TYPE.VELOCITY) {
                    rtRsp[chanOrder].setOriginalType(1);
                } else {
                    rtRsp[chanOrder].setOriginalType(2);
                }
                ((RTOneChannelData)chanData[chanOrder]).setData(rtSI[chanOrder], rtRsp[chanOrder], new Date(this.layout.startSecond.get() * 1000L), this.getWaveform(stn, comp));
                ++chanOrder;
                ++comp;
            }
            ++stn;
        }
        this.setTimeSeries(chanData);
    }

    public void read(DataInputStream in) throws IOException, EdasZipEventException {
        int sec;
        this.layout.readFully(in);
        if (logger.isDebugEnabled()) {
            logger.debug("Event layout header\n" + (Object)((Object)this.layout));
        }
        if ((sec = this.layout.length.get()) == 0) {
            logger.warn("Event length is 0 second");
            sec = 3600;
        }
        this.TSN = this.layout.network.numSta.get();
        this.layout.staBlk = new StationBlock[this.TSN];
        this.TCN = 0;
        int i = 0;
        while (i < this.layout.staBlk.length) {
            this.layout.staBlk[i] = new StationBlock();
            this.layout.staBlk[i].readFully(in);
            if (logger.isDebugEnabled()) {
                logger.debug("Station " + this.layout.staBlk[i].sta.name.get() + " info: " + (Object)((Object)this.layout.staBlk[i].sta));
            }
            int comp = this.layout.staBlk[i].sta.comp.get();
            this.TCN += comp;
            this.layout.staBlk[i].chan = new Channel[comp];
            int j = 0;
            while (j < comp) {
                this.layout.staBlk[i].chan[j] = new Channel();
                this.layout.staBlk[i].chan[j].readFully(in);
                this.layout.staBlk[i].chan[j].zap.parse(in);
                this.layout.staBlk[i].chan[j].data = new int[this.layout.staBlk[i].sta.samp.get() * sec];
                if (logger.isDebugEnabled()) {
                    logger.debug("Channel " + this.layout.staBlk[i].chan[j].name.get() + " info: " + (Object)((Object)this.layout.staBlk[i].chan[j]));
                    logger.debug("Pole and zero: " + (Object)((Object)this.layout.staBlk[i].chan[j].zap));
                }
                ++j;
            }
            ++i;
        }
        this.layout.indexBlk = new IndexBlock();
        this.layout.indexBlk.readFully(in);
        int[] data = null;
        byte[] bdata = null;
        this.layout.secBlk = new SecondBlock[sec];
        int nsec = 0;
        int s = 0;
        while (s < sec) {
            this.layout.secBlk[s] = new SecondBlock();
            this.layout.secBlk[s].dataBlk = new DataBlock[this.TSN];
            try {
                int j = 0;
                while (j < this.TSN) {
                    this.layout.secBlk[s].dataBlk[j] = new DataBlock();
                    this.layout.secBlk[s].dataBlk[j].readFully(in);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Data info: " + (Object)((Object)this.layout.secBlk[s].dataBlk[j]));
                    }
                    short len = this.layout.secBlk[s].dataBlk[j].length.get();
                    bdata = new byte[len];
                    in.readFully(bdata);
                    int srate = this.layout.staBlk[j].sta.samp.get();
                    int comp = this.layout.staBlk[j].sta.comp.get();
                    data = new int[srate * comp];
                    EdasSteim2.decodeSteim2(bdata, 0, bdata.length, data);
                    int i2 = 0;
                    while (i2 < comp) {
                        System.arraycopy(data, i2 * srate, this.layout.staBlk[j].chan[i2].data, s * srate, srate);
                        ++i2;
                    }
                    ++j;
                }
            }
            catch (EOFException eofEx) {
                break;
            }
            ++s;
            ++nsec;
        }
        if (nsec < sec) {
            int j = 0;
            while (j < this.TSN) {
                int srate = this.layout.staBlk[j].sta.samp.get();
                int comp = this.layout.staBlk[j].sta.comp.get();
                int i3 = 0;
                while (i3 < comp) {
                    int[] dat = new int[nsec * srate];
                    System.arraycopy(this.layout.staBlk[j].chan[i3].data, 0, dat, 0, dat.length);
                    this.layout.staBlk[j].chan[i3].data = dat;
                    ++i3;
                }
                ++j;
            }
        }
    }

    public double[] getWaveform(int sta, int ch) {
        int c = this.layout.staBlk[sta].chan[ch].data.length;
        double[] r = new double[c];
        int i = 0;
        while (i < c) {
            r[i] = this.layout.staBlk[sta].chan[ch].data[i];
            ++i;
        }
        return r;
    }

    public int getSampRate(int sta) {
        return this.layout.staBlk[sta].sta.samp.get();
    }

    private static <T> Vector<T> toVector(T[] a) {
        Vector<T> vec = new Vector<T>();
        int i = 0;
        while (i < a.length) {
            vec.add(a[i]);
            ++i;
        }
        return vec;
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configureAndWatch("log4j.properties");
        EdasZipEvent evt = new EdasZipEvent();
        String file = "/home/samba/data/edas_zip/2006121623000000.dat";
        if (args.length == 1) {
            file = args[0];
        }
        evt.readEvtFile(file);
    }

    static /* synthetic */ Vector access$0(Object[] objectArray) {
        return EdasZipEvent.toVector(objectArray);
    }

    public static class Channel
    extends Struct {
        public final Struct.Utf8String name = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Utf8String inputUnit = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Utf8String outputUnit = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Float32 A = new Struct.Float32((Struct)this);
        public final Struct.Signed32 numOrder = new Struct.Signed32((Struct)this);
        public final ZeroPoleResp zap = (ZeroPoleResp)this.inner(new ZeroPoleResp());
        public int[] data;

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("/name=");
            buf.append(this.name.get().trim());
            buf.append("/inputUnit=");
            buf.append(this.inputUnit.get());
            buf.append("/outputUnit=");
            buf.append(this.outputUnit.get());
            buf.append("/A=");
            buf.append(this.A.get());
            buf.append("/numOrder=");
            buf.append(this.numOrder.get());
            buf.append("/");
            return buf.toString();
        }
    }

    public static class Complex
    extends Struct {
        public final Struct.Float32 re = new Struct.Float32((Struct)this);
        public final Struct.Float32 im = new Struct.Float32((Struct)this);
    }

    public static class DataBlock
    extends Struct {
        public final Struct.Unsigned32 sec = new Struct.Unsigned32((Struct)this);
        public final Struct.Signed16 length = new Struct.Signed16((Struct)this);
        public final Struct.Unsigned8 transFlag = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 dataFlag = new Struct.Unsigned8((Struct)this);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("/sec=");
            buf.append(new Date(this.sec.get() * 1000L));
            buf.append("/length=");
            buf.append(this.length.get());
            buf.append("/transFlag=");
            buf.append(this.transFlag.get());
            buf.append("/dataFlag=");
            buf.append(this.dataFlag.get());
            buf.append("/");
            return buf.toString();
        }
    }

    public static class EdasZipEventException
    extends Exception {
        public EdasZipEventException() {
        }

        public EdasZipEventException(String s) {
            super(s);
        }
    }

    public static class Header
    extends Struct {
        public final Struct.Utf8String flag = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Enum32 format = new Struct.Enum32((Struct)this, (List)EdasZipEvent.access$0((Object[])FORMAT.values()));
        public final Struct.Enum32 zipMethod = new Struct.Enum32((Struct)this, (List)EdasZipEvent.access$0((Object[])ZIP_METHOD.values()));
        public final Struct.Unsigned32 edian = new Struct.Unsigned32((Struct)this);
        public final Struct.Enum32 recordType = new Struct.Enum32((Struct)this, (List)EdasZipEvent.access$0((Object[])RECORD_TYPE.values()));
        public final Struct.Signed32 process = new Struct.Signed32((Struct)this);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("/flag=");
            buf.append(this.flag.get());
            buf.append("/format=");
            buf.append(this.format.get());
            buf.append("/zipMethod=");
            buf.append(this.zipMethod.get());
            buf.append("/edian=");
            buf.append(Long.toHexString(this.edian.get()));
            buf.append("/recordType=");
            buf.append(this.recordType.get());
            buf.append("/process=");
            buf.append(this.process.get());
            buf.append("/");
            return buf.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum FORMAT {
            UNKNOW1,
            UNKNOW2,
            UNKNOW3;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ZIP_METHOD {
            UNKNOW1,
            UNKNOW2,
            UNKNOW3;

        }
    }

    public static class IndexBlock
    extends Struct {
        public final Struct.Utf8String blk = new Struct.Utf8String((Struct)this, 2048);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }

    public static class Layout
    extends Struct {
        public final Header header = (Header)this.inner(new Header());
        public final Network network = (Network)this.inner(new Network());
        public final Struct.Unsigned32 startSecond = new Struct.Unsigned32((Struct)this);
        public final Struct.Signed32 length = new Struct.Signed32((Struct)this);
        public StationBlock[] staBlk;
        public IndexBlock indexBlk;
        public SecondBlock[] secBlk;

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("header: ");
            buf.append(String.valueOf(this.header.toString()) + "\t");
            buf.append("network: ");
            buf.append(String.valueOf(this.network.toString()) + "\t");
            buf.append("/startSecond=");
            buf.append(new Date(this.startSecond.get() * 1000L));
            buf.append("/length=");
            buf.append(this.length.get());
            buf.append("/");
            return buf.toString();
        }
    }

    public static class Network
    extends Struct {
        public final Struct.Utf8String name = new Struct.Utf8String((Struct)this, 80);
        public final Struct.Signed32 numSta = new Struct.Signed32((Struct)this);
        public final Struct.Float32 centerLat = new Struct.Float32((Struct)this);
        public final Struct.Float32 centerLon = new Struct.Float32((Struct)this);
        public final Struct.Float32 centerAlt = new Struct.Float32((Struct)this);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("/name=");
            buf.append(this.name.get());
            buf.append("/numSta=");
            buf.append(this.numSta.get());
            buf.append("/centerLat=");
            buf.append(this.centerLat.get());
            buf.append("/centerLon=");
            buf.append(this.centerLon.get());
            buf.append("/centerAlt=");
            buf.append(this.centerAlt.get());
            buf.append("/");
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RECORD_TYPE {
        DISPLACEMENT,
        VELOCITY,
        ACCELERATION;

    }

    public static class SecondBlock {
        public DataBlock[] dataBlk;
    }

    public static class Station
    extends Struct {
        public final Struct.Signed32 order = new Struct.Signed32((Struct)this);
        public final Struct.Utf8String name = new Struct.Utf8String((Struct)this, 16);
        public final Struct.Utf8String shortName = new Struct.Utf8String((Struct)this, 4);
        public final Struct.Utf8String dasType = new Struct.Utf8String((Struct)this, 10);
        public final Struct.Signed16 wlen = new Struct.Signed16((Struct)this);
        public final Struct.Float32 maxVolt = new Struct.Float32((Struct)this);
        public final Struct.Signed32 samp = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 comp = new Struct.Signed32((Struct)this);
        public final Struct.Signed16 transType = new Struct.Signed16((Struct)this);
        public final Struct.Utf8String transDevice = new Struct.Utf8String((Struct)this, 12);
        public final Struct.Signed16 clockType = new Struct.Signed16((Struct)this);
        public final Struct.Utf8String clockDevice = new Struct.Utf8String((Struct)this, 12);
        public final Struct.Float32 clockErr = new Struct.Float32((Struct)this);
        public final Struct.Float32 lat = new Struct.Float32((Struct)this);
        public final Struct.Float32 lon = new Struct.Float32((Struct)this);
        public final Struct.Float32 alt = new Struct.Float32((Struct)this);
        public final Struct.Float32 azimuth = new Struct.Float32((Struct)this);
        public final Struct.Float32 incident = new Struct.Float32((Struct)this);
        public final Struct.Signed16 weight = new Struct.Signed16((Struct)this);
        public final Struct.Signed16 veloc = new Struct.Signed16((Struct)this);
        public final Struct.Enum32 sourceType = new Struct.Enum32((Struct)this, (List)EdasZipEvent.access$0((Object[])RECORD_TYPE.values()));
        public final Struct.Utf8String seismometer = new Struct.Utf8String((Struct)this, 8);
        public final Struct.Enum32 smmode = new Struct.Enum32((Struct)this, (List)EdasZipEvent.access$0((Object[])SMMODE.values()));

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("/order=");
            buf.append(this.order.get());
            buf.append("/name=");
            buf.append(this.name.get());
            buf.append("/shortName=");
            buf.append(this.shortName.get());
            buf.append("/dasType=");
            buf.append(this.dasType.get());
            buf.append("/wlen=");
            buf.append(this.wlen.get());
            buf.append("/maxVlot=");
            buf.append(this.maxVolt.get());
            buf.append("/samp=");
            buf.append(this.samp.get());
            buf.append("/comp=");
            buf.append(this.comp.get());
            buf.append("/transType=");
            buf.append(this.transType.get());
            buf.append("/transDevice=");
            buf.append(this.transDevice.get());
            buf.append("/clockType=");
            buf.append(this.clockType.get());
            buf.append("/clockDevice=");
            buf.append(this.clockDevice.get());
            buf.append("/clockErr=");
            buf.append(this.clockErr.get());
            buf.append("/lat=");
            buf.append(this.lat.get());
            buf.append("/lon=");
            buf.append(this.lon.get());
            buf.append("/lat=");
            buf.append(this.lat.get());
            buf.append("/azimuth=");
            buf.append(this.azimuth.get());
            buf.append("/incident=");
            buf.append(this.incident.get());
            buf.append("/weight=");
            buf.append(this.weight.get());
            buf.append("/veloc=");
            buf.append(this.veloc.get());
            buf.append("/sourceType=");
            buf.append(this.sourceType.get());
            buf.append("/seismometer=");
            buf.append(this.seismometer.get());
            buf.append("/smmode=");
            buf.append(this.smmode.get());
            buf.append("/");
            return buf.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SMMODE {
            SHORT,
            BROAD,
            VERY_BROAD;

        }
    }

    public static class StationBlock
    extends Struct {
        public final Station sta = (Station)this.inner(new Station());
        public Channel[] chan = null;

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }

    public static class ZeroPoleResp
    extends Struct {
        public final Struct.Signed32 order = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 type = new Struct.Signed32((Struct)this);
        public final Struct.Utf8String name = new Struct.Utf8String((Struct)this, 4);
        public final Struct.Utf8String inputUnit = new Struct.Utf8String((Struct)this, 12);
        public final Struct.Utf8String outputUnit = new Struct.Utf8String((Struct)this, 12);
        public final Struct.Float32 ao_value = new Struct.Float32((Struct)this);
        public final Struct.Signed32 is_sen = new Struct.Signed32((Struct)this);
        public final Struct.Float32 sg_value = new Struct.Float32((Struct)this);
        public final Struct.Float32 sg_fre = new Struct.Float32((Struct)this);
        public final Struct.Utf8String sg_unit = new Struct.Utf8String((Struct)this, 12);
        public final Struct.Signed32 poleNum = new Struct.Signed32((Struct)this);
        public final Struct.Signed32 zeroNum = new Struct.Signed32((Struct)this);
        public JSci.maths.Complex[] pole;
        public JSci.maths.Complex[] zero;

        public void parse(DataInputStream in) throws IOException {
            Complex c = new Complex();
            this.pole = new JSci.maths.Complex[this.poleNum.get()];
            int i = 0;
            while (i < this.pole.length) {
                c.readFully(in);
                this.pole[i] = new JSci.maths.Complex(c.re.get(), c.im.get());
                ++i;
            }
            this.zero = new JSci.maths.Complex[this.zeroNum.get()];
            i = 0;
            while (i < this.zero.length) {
                c.readFully(in);
                this.zero[i] = new JSci.maths.Complex(c.re.get(), c.im.get());
                ++i;
            }
            int nskip = 512 - (this.size() + (this.pole.length + this.zero.length) * 8);
            in.skip(nskip);
        }

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("/order=");
            buf.append(this.order.get());
            buf.append("/type=");
            buf.append(this.type.get());
            buf.append("/name=");
            buf.append(this.name.get().trim());
            buf.append("/inputUnit=");
            buf.append(this.inputUnit.get().trim());
            buf.append("/outputUnit=");
            buf.append(this.outputUnit.get().trim());
            buf.append("/ao_value=");
            buf.append(this.ao_value.get());
            buf.append("/is_sen=");
            buf.append(this.is_sen.get());
            buf.append("/sg_value=");
            buf.append(this.sg_value.get());
            buf.append("/sg_fre=");
            buf.append(this.sg_fre.get());
            buf.append("/sg_unit=");
            buf.append(this.sg_unit.get());
            buf.append("/zeroNum=");
            buf.append(this.zeroNum.get());
            buf.append("/poleNum=");
            buf.append(this.poleNum.get());
            buf.append("/");
            return buf.toString();
        }
    }
}

