/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import JSci.maths.Complex;
import cn.org.gddsn.convert.DateToString;
import cn.org.gddsn.seis.evtformat.EvtData;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class AsciiZipEvent
extends EvtData {
    static Logger logger = Logger.getLogger(AsciiZipEvent.class);

    public boolean writeAsciiFile(String FileName, int[] chanOrders, float[] begCutTime, float[] cutLength) {
        String[] name = new String[chanOrders.length];
        return this.writeAsciiFile(FileName, chanOrders, begCutTime, cutLength, name);
    }

    public boolean writeAsciiFile(String FileName, int[] chanOrders, float[] begCutTime, float[] cutLength, String[] name) {
        boolean retVal = true;
        try {
            FileOutputStream Out = new FileOutputStream(FileName);
            BufferedOutputStream BufferedOut = new BufferedOutputStream(Out, 4096);
            ZipOutputStream zipOut = new ZipOutputStream(BufferedOut);
            zipOut.setLevel(1);
            PrintWriter p = new PrintWriter(zipOut);
            int i = 0;
            while (i < chanOrders.length) {
                ZipEntry head = new ZipEntry(String.valueOf(this.getNetworkCode(chanOrders[i])) + "_" + this.getStationCode(chanOrders[i]) + "_" + this.getChannelCode(chanOrders[i]) + "_" + i + ".par");
                zipOut.putNextEntry(head);
                p.println("Network Code: " + this.getNetworkCode(chanOrders[i]));
                p.println("Station Code: " + this.getStationCode(chanOrders[i]));
                p.println("AuxId: " + this.getAuxId(chanOrders[i]));
                p.println("Station Type: " + this.getStationType(chanOrders[i]));
                p.println("Channel Comp: " + this.getChannelComp(chanOrders[i]));
                p.println("Channel Code: " + this.getChannelCode(chanOrders[i]));
                p.println("Station Lat : " + this.getStationLocation(chanOrders[i]).getLatitude());
                p.println("Station Lon : " + this.getStationLocation(chanOrders[i]).getLongtitude());
                p.println("Coordinate Sys: " + this.getCoordSys(chanOrders[i]));
                p.println("Instrument Type: " + this.getInstrumentType(chanOrders[i]));
                p.println("H Ang: " + this.getHAng(chanOrders[i]));
                p.println("V Ang: " + this.getVAng(chanOrders[i]));
                p.println("Sample Rate: " + this.getSampleRate(chanOrders[i]));
                p.println("Calib Factor: " + this.getCalibFactor(chanOrders[i]));
                p.println("Calper: " + this.getCalper(chanOrders[i]));
                p.println("Scale Factor: " + this.getScaleFactor(chanOrders[i]));
                p.println("Zero : ");
                Complex[] zeros = this.getZero(chanOrders[i]);
                int j = 0;
                while (j < this.getZeroNum(chanOrders[i])) {
                    p.println(" " + zeros[j].real() + "+j" + zeros[j].imag());
                    ++j;
                }
                p.println("Pole : ");
                Complex[] poles = this.getPole(chanOrders[i]);
                int j2 = 0;
                while (j2 < this.getPoleNum(chanOrders[i])) {
                    p.println(" " + poles[j2].real() + "+j" + poles[j2].imag());
                    ++j2;
                }
                p.println("START_TIME :");
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(new Date(this.getArrivalTime(chanOrders[i]).getTime() + (long)Math.round(begCutTime[i] * 1000.0f)));
                p.println(DateToString.getFullTime(c.getTime()));
                p.print("Length of Event: ");
                p.print(cutLength[i]);
                p.println(" <sec>");
                p.flush();
                zipOut.closeEntry();
                ++i;
            }
            int k = 0;
            while (k < chanOrders.length) {
                ZipEntry stnEntry = new ZipEntry(String.valueOf(this.getNetworkCode(chanOrders[k])) + "_" + this.getStationCode(chanOrders[k]) + "_" + this.getChannelCode(chanOrders[k]) + "_" + k + (name[k] == null ? ".txt" : "_" + name[k] + ".txt"));
                zipOut.putNextEntry(stnEntry);
                double rate = this.getSampleRate(chanOrders[k]);
                int beginP = (int)Math.round((double)begCutTime[k] * rate);
                int endP = (int)Math.round((double)cutLength[k] * rate) + beginP;
                int i2 = beginP;
                while (i2 < endP) {
                    p.println(this.getSampData(chanOrders[k])[i2]);
                    ++i2;
                }
                p.flush();
                zipOut.closeEntry();
                ++k;
            }
            zipOut.close();
            BufferedOut.close();
            Out.close();
        }
        catch (ZipException zipEx) {
            retVal = false;
            logger.warn(" Throw ZipException in Writing ASCII FILE !");
        }
        catch (IOException e) {
            retVal = false;
            logger.warn(" Write ASCII FILE Error!");
        }
        return retVal;
    }

    public boolean readEvtFile(String fileName) {
        return false;
    }

    public boolean writeEvtFile(String fileName) {
        int[] chanOrders = new int[this.getTCN()];
        float[] cutLength = new float[this.getTCN()];
        float[] begCutTime = new float[this.getTCN()];
        int i = 0;
        while (i < this.getTCN()) {
            chanOrders[i] = i;
            cutLength[i] = (float)((double)this.getSamples(chanOrders[i]) / this.getSampleRate(chanOrders[i]));
            ++i;
        }
        return this.writeAsciiFile(fileName, chanOrders, begCutTime, cutLength);
    }

    public boolean readEvtFile(URL urlFile) {
        return false;
    }

    public boolean writeEvtFile(URL urlFile) {
        return false;
    }

    public boolean writeAsciiFile(String FileName, int[] chanOrders, int begCutTime, int cutLength) {
        float[] fBeg = new float[chanOrders.length];
        float[] fLength = new float[chanOrders.length];
        int i = 0;
        while (i < chanOrders.length) {
            fBeg[i] = begCutTime;
            fLength[i] = cutLength;
            ++i;
        }
        return this.writeAsciiFile(FileName, chanOrders, fBeg, fLength);
    }

    public static void main(String[] args) {
        new AsciiZipEvent();
    }
}

