/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlLocation {
    static Logger logger;
    Vector stnList = new Vector();
    int nStation = 0;
    int nChannel = 0;
    int nPhases = 0;
    Network network = new Network();
    VelModel VelModel = new VelModel();
    Vector stations = new Vector(10);
    Vector chans = new Vector(50);
    SourceParam source;
    Vector phases = new Vector(5);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.seis.config.XmlLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public Network getNetwork() {
        return this.network;
    }

    public VelModel getVelModel() {
        return this.VelModel;
    }

    public SourceParam getSource() {
        return this.source;
    }

    public Vector getStations() {
        return this.stations;
    }

    public Vector getPhases() {
        return this.phases;
    }

    public boolean parseLocation(InputStream in) {
        boolean bret = false;
        ParseHandler handler = new ParseHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)handler);
            bret = true;
        }
        catch (SAXParseException spe) {
            logger.warn("\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            logger.warn("   " + spe.getMessage());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            logger.warn(((Throwable)x).getMessage(), x);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            logger.warn(((Throwable)x).getMessage(), x);
        }
        catch (ParserConfigurationException pce) {
            logger.warn(pce.getMessage(), pce);
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return bret;
    }

    private static Date getTime(String dstr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        Date date = null;
        try {
            date = sdf.parse(dstr);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return date;
    }

    private static Date getDate(String dstr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Date date = null;
        try {
            date = sdf.parse(dstr);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return date;
    }

    public static void main(String[] args) {
        try {
            XmlLocation xl = new XmlLocation();
            xl.parseLocation(new FileInputStream("/home/samba/hwh.xml"));
            logger.info("OK.");
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public static class Network {
        public String Code;
        public String Cname;
        public String Sname;
        Vector stations = new Vector(10);

        public String toString() {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(this.Code);
            strBuf.append('\t');
            strBuf.append(this.Cname);
            strBuf.append('\t');
            strBuf.append(this.Sname);
            return strBuf.toString();
        }
    }

    class ParseHandler
    extends DefaultHandler {
        private String sta;
        private String locID;
        private String chan;
        private Station station;
        private VelModel velModel;
        private Phase phase;
        private int nLayer = 0;

        ParseHandler() {
        }

        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            if (qName.equals("NETWORK")) {
                XmlLocation.this.network.Code = attrs.getValue("Code");
                XmlLocation.this.network.Cname = attrs.getValue("Cname");
                XmlLocation.this.network.Sname = attrs.getValue("Sname");
            }
            if (qName.equals("STATION")) {
                this.station = new Station();
                this.station.Code = attrs.getValue("Code");
                this.station.Cname = attrs.getValue("Cname");
                this.station.Comment = attrs.getValue("Comment");
                this.station.Coordsys = attrs.getValue("Coordsys");
                this.station.Elev = Double.parseDouble(attrs.getValue("Elev"));
                this.station.Lat = Double.parseDouble(attrs.getValue("Lat"));
                this.station.Lon = Double.parseDouble(attrs.getValue("Lon"));
                this.station.MType = attrs.getValue("MType");
                this.station.Net = attrs.getValue("Net");
                if (!attrs.getValue("Ondate").equals("")) {
                    this.station.Ondate = XmlLocation.getDate(attrs.getValue("Ondate"));
                }
                if (!attrs.getValue("Offdate").equals("")) {
                    this.station.Offdate = XmlLocation.getDate(attrs.getValue("Offdate"));
                }
                this.station.Sname = attrs.getValue("Sname");
                this.station.P_travtime_corr = Double.parseDouble(attrs.getValue("P_travtime_corr"));
                this.station.S_travtime_corr = Double.parseDouble(attrs.getValue("S_travtime_corr"));
                this.station.Mag_corr = Double.parseDouble(attrs.getValue("Mag_corr"));
                this.station.Sta_type = attrs.getValue("Sta_type");
                this.station.TransmitType = attrs.getValue("TransmitType");
                this.sta = this.station.Code;
                XmlLocation.this.stnList.add(this.sta);
                ++XmlLocation.this.nStation;
            }
            if (qName.equals("VEL_MODEL")) {
                this.velModel = new VelModel();
                this.velModel.Vp_vs = Double.parseDouble(attrs.getValue("Vp_vs"));
                this.velModel.Layer_num = Integer.parseInt(attrs.getValue("Layer_num"));
                this.velModel.Thinckness = new double[this.velModel.Layer_num];
                this.velModel.Vel_p = new double[this.velModel.Layer_num];
                this.nLayer = 0;
            }
            if (qName.equals("LAYER")) {
                this.velModel.Thinckness[this.nLayer] = Double.parseDouble(attrs.getValue("Thickness"));
                this.velModel.Vel_p[this.nLayer++] = Double.parseDouble(attrs.getValue("Vel_p"));
            }
            if (qName.equals("CATLOG")) {
                XmlLocation.this.source = new SourceParam();
                XmlLocation.this.source.Cata_id = attrs.getValue("Cata_id");
                XmlLocation.this.source.Event_id = attrs.getValue("Event_id");
                XmlLocation.this.source.Operator = attrs.getValue("Operator");
                XmlLocation.this.source.Program = attrs.getValue("Program");
                XmlLocation.this.source.Save_time = XmlLocation.getTime(attrs.getValue("Save_time"));
                XmlLocation.this.source.Eq_type = attrs.getValue("Eq_type");
                XmlLocation.this.source.O_Time = XmlLocation.getTime(attrs.getValue("O_time"));
                XmlLocation.this.source.Lat = Double.parseDouble(attrs.getValue("Lat"));
                XmlLocation.this.source.Lon = Double.parseDouble(attrs.getValue("Lon"));
                XmlLocation.this.source.Depth = Double.parseDouble(attrs.getValue("Depth"));
                try {
                    XmlLocation.this.source.Ml = Double.parseDouble(attrs.getValue("Ml"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.Ms = Double.parseDouble(attrs.getValue("Ms"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.Md = Double.parseDouble(attrs.getValue("Md"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.Mb = Double.parseDouble(attrs.getValue("mb"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.mmB = Double.parseDouble(attrs.getValue("mBB"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.Mw = Double.parseDouble(attrs.getValue("Mw"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.M = Double.parseDouble(attrs.getValue("M"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.Dmin = Double.parseDouble(attrs.getValue("Dmin"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.Gap_azi = Double.parseDouble(attrs.getValue("Gap_azi"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.Rms = Double.parseDouble(attrs.getValue("Rms"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.Erh = Double.parseDouble(attrs.getValue("Erh"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.Erz = Double.parseDouble(attrs.getValue("Erz"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                XmlLocation.this.source.Qloc = attrs.getValue("Qloc");
                XmlLocation.this.source.Qnet = attrs.getValue("Qnet");
                XmlLocation.this.source.Qcom = attrs.getValue("Qcom");
                try {
                    XmlLocation.this.source.Sum_stn = Integer.parseInt(attrs.getValue("Sum_stn"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.Used_stn = Integer.parseInt(attrs.getValue("Used_stn"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.Sum_pha = Integer.parseInt(attrs.getValue("Sum_pha"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    XmlLocation.this.source.Used_pha = Integer.parseInt(attrs.getValue("Used_pha"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                XmlLocation.this.source.bExplosion = attrs.getValue("Explosion_flag").equals("Y");
                XmlLocation.this.source.Epic_id = attrs.getValue("Epic_id");
                XmlLocation.this.source.Rgin_id = attrs.getValue("Rgin_id");
                XmlLocation.this.source.Location_cname = attrs.getValue("Location_cname");
                XmlLocation.this.source.Comment = attrs.getValue("Comment");
            }
            if (qName.equals("PHASE")) {
                this.phase = new Phase();
                this.phase.Cata_id = attrs.getValue("Cata_id");
                this.phase.Net = attrs.getValue("Net");
                this.phase.Loc_id = attrs.getValue("Loc_id");
                this.phase.Sta_code = attrs.getValue("Sta_code");
                this.phase.Chan_code = attrs.getValue("Chan_code");
                this.phase.Rec_type = attrs.getValue("Rec_type");
                this.phase.Phase_name = attrs.getValue("Phase_name");
                this.phase.Phase_time = XmlLocation.getTime(attrs.getValue("Phase_time"));
                this.phase.Amp_type = attrs.getValue("Amp_type");
                try {
                    this.phase.Amp = Double.parseDouble(attrs.getValue("Amp"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.phase.Amp_unit = attrs.getValue("Amp_unit");
                try {
                    this.phase.Period = Double.parseDouble(attrs.getValue("Period"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    this.phase.Weight = Integer.parseInt(attrs.getValue("Weight"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.phase.Source_id = attrs.getValue("Source_id");
                this.phase.Clarity = attrs.getValue("Clarity");
                this.phase.Wsign = attrs.getValue("Wsign");
                try {
                    this.phase.Resi = Double.parseDouble(attrs.getValue("Resi"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.phase.Ml = Double.parseDouble(attrs.getValue("Ml"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.phase.Ms = Double.parseDouble(attrs.getValue("Ms"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.phase.Md = Double.parseDouble(attrs.getValue("Md"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.phase.Mb = Double.parseDouble(attrs.getValue("Mb"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.phase.mmB = Double.parseDouble(attrs.getValue("mmB"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.phase.Mw = Double.parseDouble(attrs.getValue("Mw"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            if (qName.equals("STATION")) {
                XmlLocation.this.stations.add(this.station);
                this.station = null;
            }
            if (qName.equals("PHASE")) {
                XmlLocation.this.phases.add(this.phase);
                this.phase = null;
            }
            if (qName.equals("VEL_MODEL")) {
                this.nLayer = 0;
                XmlLocation.this.VelModel = this.velModel;
            }
        }

        public void characters(char[] buf, int offset, int len) throws SAXException {
        }

        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }

        public void warning(SAXParseException err) throws SAXParseException {
            logger.warn("** Warning, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            logger.warn("   " + err.getMessage());
        }
    }

    public static class Phase {
        public static final String HALF_AMP = "HALF";
        public static final String FULL_AMP = "FULL";
        public static final String ArtiNone = "";
        public static final String I = "I";
        public static final String E = "E";
        public static final String Bracket = "(";
        public static final String SignNone = "";
        public static final String C = "C";
        public static final String D = "D";
        public static final String U = "U";
        public static final String R = "R";
        public static final int AT = 0;
        public static final int MA = 1;
        public static final int FM = 2;
        public String Cata_id = "";
        public String Net = "";
        public String Sta_code = "";
        public String Loc_id;
        public String Chan_code = "";
        public String Rec_type = "V";
        public String Phase_name = "";
        public Date Phase_time;
        public String Amp_type;
        public double Amp = 0.0;
        public double Period = 0.0;
        public String Amp_unit = "um/s";
        public int Weight = 1;
        public String Source_id = "";
        public String Clarity = "";
        public String Wsign = "";
        public double Resi;
        public double Ml = -99999.0;
        public double Ms = -99999.0;
        public double Md = -99999.0;
        public double Mb = -99999.0;
        public double mmB = -99999.0;
        public double Mw = -99999.0;
    }

    public static class SourceParam
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        public double Lat;
        public double Lon;
        public double Depth;
        public Date O_Time = new Date(0L);
        public double Ml = -99999.0;
        public double Ms = -99999.0;
        public double Md = -99999.0;
        public double Mb = -99999.0;
        public double Mw = -99999.0;
        public double M = -99999.0;
        public double mmB = -99999.0;
        public double Rms = -1.0;
        public String Cata_id = "";
        public String Event_id = "";
        public String Operator = "";
        public String Program = "";
        public Date Save_time = new Date();
        public String Eq_type = "L";
        public boolean bExplosion = false;
        public String Epic_id = "";
        public String Rgin_id = "";
        public String Location_cname = "";
        public String Comment = "";
        public double accuracy = -99999.0;
        public int Used_stn;
        public int Used_pha;
        public int Sum_stn;
        public int Sum_pha;
        public double Erh = -99999.0;
        public double Erz = -99999.0;
        public double Dmin = -99999.0;
        public double Gap_azi = -99999.0;
        public String Qloc = "1";
        public String Qnet = "2";
        public String Qcom = "2";

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static class Station {
        public String Net = null;
        public String Code = null;
        public String Cname = null;
        public String Sname = null;
        public String Sta_type = null;
        public double Lat;
        public double Lon;
        public String Coordsys = "WGS-84";
        public double Elev;
        public String MType = null;
        public String TransmitType = null;
        public double P_travtime_corr = 0.0;
        public double S_travtime_corr = 0.0;
        public double Mag_corr = 0.0;
        public Date Ondate;
        public Date Offdate = null;
        public String Comment = "";
        Vector chans = new Vector(3);

        public String toString() {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(this.Net);
            strBuf.append('\t');
            strBuf.append(this.Code);
            strBuf.append('\t');
            strBuf.append(this.Cname);
            strBuf.append('\t');
            strBuf.append(this.Sname);
            strBuf.append('\t');
            strBuf.append(this.Sta_type);
            strBuf.append('\t');
            strBuf.append(this.Lat);
            strBuf.append('\t');
            strBuf.append(this.Lon);
            strBuf.append('\t');
            strBuf.append(this.Coordsys);
            strBuf.append('\t');
            strBuf.append(this.Elev);
            strBuf.append('\t');
            strBuf.append(this.MType);
            strBuf.append('\t');
            strBuf.append(this.TransmitType);
            strBuf.append('\t');
            strBuf.append(this.P_travtime_corr);
            strBuf.append('\t');
            strBuf.append(this.S_travtime_corr);
            strBuf.append('\t');
            strBuf.append(this.Mag_corr);
            strBuf.append('\t');
            strBuf.append(this.Ondate);
            strBuf.append('\t');
            strBuf.append(this.Offdate);
            strBuf.append('\t');
            strBuf.append(this.Comment);
            return strBuf.toString();
        }
    }

    public static class VelModel {
        public double Vp_vs;
        public double Vel_mantle;
        public int Layer_num;
        public double[] Thinckness;
        public double[] Vel_p;

        public String toString() {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("Vp/Vs: " + this.Vp_vs);
            strBuf.append('\t');
            strBuf.append("Vel_mantle: " + this.Vel_mantle);
            strBuf.append('\t');
            strBuf.append("Layer_num: " + this.Layer_num);
            strBuf.append('\t');
            int i = 0;
            while (i < this.Layer_num) {
                strBuf.append("\tThickness: " + this.Thinckness[i]);
                strBuf.append('\t');
                strBuf.append("Vel_p: " + this.Vel_p[i]);
                strBuf.append('\n');
                ++i;
            }
            return strBuf.toString();
        }
    }
}

