/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.config;

import cn.org.gddsn.db.ConnectionPool;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.config.StationProfile;
import cn.org.gddsn.util.Log4jConfig;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class Xml2Mysql {
    static Logger logger;
    ConnectionPool pool = null;
    private boolean delete = false;
    private StationProfile profile;
    private File network;
    private String config;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.seis.config.Xml2Mysql");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public void setConfig(String config) {
        this.config = config;
        this.initPool();
    }

    public void setNetwork(File network) {
        this.network = network;
        this.parse();
    }

    private void parse() {
        try {
            this.profile = new StationProfile();
            this.profile.parseNetwork(new FileInputStream(this.network));
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    private void initPool() {
        try {
            this.pool = new ConnectionPool();
            this.pool.initialize(this.config);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public void destory() {
        if (this.pool != null) {
            this.pool.destroy();
        }
    }

    public void listStation(String net, String sta) {
        block18: {
            Connection conn = this.pool.getConnection();
            if (conn == null) {
                logger.warn("ConnectionPool return null!");
                System.exit(-1);
            }
            Statement stmt = null;
            try {
                try {
                    stmt = conn.createStatement();
                    ResultSet res = stmt.executeQuery("SELECT * FROM station WHERE net LIKE '" + net + "' AND sta LIKE '" + sta + "'");
                    boolean bdata = false;
                    while (res.next()) {
                        bdata = true;
                        logger.info("net:\t" + res.getString("net"));
                        logger.info("sta:\t" + res.getString("sta"));
                        logger.info("ordr:\t" + res.getInt("ordr"));
                        logger.info("lat:\t" + res.getDouble("lat"));
                        logger.info("lon:\t" + res.getDouble("lon"));
                        logger.info("elev:\t" + res.getDouble("elev"));
                        logger.info("coordsys:\t" + res.getString("coordsys"));
                        logger.info("type:\t" + res.getString("type"));
                        logger.info("num_chan:\t" + res.getInt("num_chan"));
                        logger.info("sta_name:\t" + res.getString("sta_name"));
                        logger.info("start_time:\t" + res.getDate("start_time"));
                        logger.info("end_time:\t" + res.getDate("end_time"));
                        logger.info("description:\t" + res.getString("description"));
                        logger.info("----------------------------------------------");
                    }
                    if (bdata) {
                        logger.info("List station operation success");
                        break block18;
                    }
                    logger.info("No data to list");
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (conn == null) {
                            conn.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn == null) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void deleteStation(String net, String sta) {
        Connection conn = this.pool.getConnection();
        if (conn == null) {
            logger.warn("ConnectionPool return null!");
            System.exit(-1);
        }
        Statement deleteStmt = null;
        try {
            try {
                conn.setAutoCommit(false);
                deleteStmt = conn.createStatement();
                deleteStmt.execute("DELETE FROM station WHERE net LIKE '" + net + "' AND sta LIKE '" + sta + "'");
                conn.commit();
                deleteStmt.execute("DELETE FROM channel WHERE net LIKE '" + net + "' AND sta LIKE '" + sta + "'");
                conn.commit();
                logger.info("Delete Operation success");
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                try {
                    if (deleteStmt != null) {
                        deleteStmt.close();
                    }
                    if (conn == null) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (deleteStmt != null) {
                    deleteStmt.close();
                }
                if (conn == null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void modifyStation(String net, String sta, String key, String value) {
        Connection conn = this.pool.getConnection();
        if (conn == null) {
            System.out.println("ConnectionPool return null!");
            System.exit(-1);
        }
        Statement stmt = null;
        try {
            try {
                conn.setAutoCommit(false);
                String update = "UPDATE station set " + key + "=? where net=? and sta=?";
                stmt = conn.prepareStatement(update);
                stmt.setString(1, value);
                stmt.setString(2, net);
                stmt.setString(3, sta);
                stmt.execute();
                conn.commit();
                logger.info("Update station data success");
            }
            catch (SQLException ex) {
                logger.warn(ex.getMessage(), ex);
                ex.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (SQLException ex1) {
                    logger.warn(ex.getMessage(), ex1);
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn == null) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void listChannel(ChannelLocator cl) {
        block18: {
            Connection conn = this.pool.getConnection();
            if (conn == null) {
                logger.warn("ConnectionPool return null!");
                System.exit(-1);
            }
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = conn.prepareStatement("SELECT * FROM channel WHERE net=? and sta=? and loc_id like ? and chan like ?");
                    stmt.setString(1, cl.getNetCode());
                    stmt.setString(2, cl.getStationCode());
                    stmt.setString(3, cl.getLocID());
                    stmt.setString(4, cl.getChanCode());
                    ResultSet res = stmt.executeQuery();
                    boolean bdata = false;
                    while (res.next()) {
                        bdata = true;
                        logger.info("net:\t" + res.getString("net"));
                        logger.info("sta:\t" + res.getString("sta"));
                        logger.info("loc_id:\t" + res.getString("loc_id"));
                        logger.info("chan:\t" + res.getString("chan"));
                        logger.info("data_type:\t" + res.getString("data_type"));
                        logger.info("serial:\t" + res.getString("serial"));
                        logger.info("value1:\t" + res.getString("value1"));
                        logger.info("value2:\t" + res.getString("value2"));
                        logger.info("start_time:\t" + res.getString("start_time"));
                        logger.info("end_time:\t" + res.getString("end_time"));
                        logger.info("----------------------------------------------");
                    }
                    if (bdata) {
                        logger.info("List Channel Operation success");
                        break block18;
                    }
                    logger.info("No data to list");
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (conn == null) {
                            conn.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn == null) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void modifyChannel(ChannelLocator cl, String type, int serial, String key, String value) {
        Connection conn = this.pool.getConnection();
        if (conn == null) {
            System.out.println("ConnectionPool return null!");
            System.exit(-1);
        }
        Statement stmt = null;
        try {
            try {
                conn.setAutoCommit(false);
                String update = "UPDATE channel set " + key + "=? where net=? and sta=? and loc_id=? and chan=? and data_type=? and serial=?";
                stmt = conn.prepareStatement(update);
                stmt.setString(1, value);
                stmt.setString(2, cl.getNetCode());
                stmt.setString(3, cl.getStationCode());
                stmt.setString(4, cl.getLocID());
                stmt.setString(5, cl.getChanCode());
                stmt.setString(6, type);
                stmt.setInt(7, serial);
                stmt.execute();
                conn.commit();
                logger.info("Update channel data success");
            }
            catch (SQLException ex) {
                logger.warn(ex.getMessage(), ex);
                ex.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (SQLException ex1) {
                    logger.warn(ex.getMessage(), ex1);
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn == null) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void convert() throws Exception {
        block18: {
            Connection conn = this.pool.getConnection();
            if (conn == null) {
                System.out.println("ConnectionPool return null!");
                System.exit(-1);
            }
            conn.setAutoCommit(false);
            Statement stmt = null;
            Statement deleteStmt = null;
            try {
                try {
                    String stnInsert = "INSERT INTO station (net, sta, ordr, lat, lon, elev, coordsys, type, num_chan, sta_name, start_time, end_time,description) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    stmt = conn.prepareStatement(stnInsert);
                    Vector stnVec = this.profile.getStationList();
                    Enumeration enu = stnVec.elements();
                    int n = 0;
                    while (enu.hasMoreElements()) {
                        String sta = (String)enu.nextElement();
                        StationProfile.Station station = this.profile.getStation(sta);
                        logger.info("process station: " + station);
                        if (station == null) {
                            System.out.println("network.xml Error");
                        }
                        if (this.delete) {
                            deleteStmt = conn.createStatement();
                            deleteStmt.execute("DELETE FROM station where sta='" + sta + "'");
                            deleteStmt.execute("DELETE FROM channel  where sta='" + sta + "'");
                            deleteStmt.close();
                        }
                        StationProfile.Channel[] chans = this.profile.getAllChannel(sta);
                        stmt.setString(1, station.getNet());
                        stmt.setString(2, station.getSta());
                        stmt.setInt(3, n++);
                        stmt.setDouble(4, station.getLat());
                        stmt.setDouble(5, station.getLon());
                        stmt.setDouble(6, station.getElev());
                        stmt.setString(7, station.getCoordsys());
                        stmt.setString(8, station.getStaType());
                        stmt.setInt(9, chans.length);
                        stmt.setString(10, station.getCname());
                        stmt.setString(11, station.getOndate());
                        stmt.setString(12, station.getOffdate());
                        stmt.setString(13, station.getComment());
                        stmt.executeUpdate();
                    }
                    String chanInsert = "INSERT INTO channel (net, sta, loc_id, chan, data_type, serial, value1, value2, start_time, end_time) VALUES (?,?,?,?,?,?,?,?,?,?)";
                    stmt = conn.prepareStatement(chanInsert);
                    StationProfile.Channel[] chans = this.profile.getAllChannel();
                    logger.info("Total Station: " + this.profile.getNStation());
                    logger.info("Total Channel: " + chans.length);
                    int i = 0;
                    while (i < chans.length) {
                        logger.info(chans[i].getSta());
                        StationProfile.Station station = this.profile.getStation(chans[i].getSta());
                        stmt.setString(1, chans[i].getNet());
                        stmt.setString(2, chans[i].getSta());
                        stmt.setString(3, chans[i].getLocID());
                        stmt.setString(4, chans[i].getCha());
                        stmt.setString(5, "caliper");
                        stmt.setInt(6, 0);
                        stmt.setString(7, "" + chans[i].getTranFun().getCalper());
                        stmt.setNull(8, 12);
                        stmt.setString(9, station.getOndate());
                        stmt.setString(10, station.getOffdate());
                        stmt.executeUpdate();
                        stmt.setString(1, chans[i].getNet());
                        stmt.setString(2, chans[i].getSta());
                        stmt.setString(3, chans[i].getLocID());
                        stmt.setString(4, chans[i].getCha());
                        stmt.setString(5, "caliFactor");
                        stmt.setInt(6, 0);
                        stmt.setString(7, "" + chans[i].getTranFun().getSensitivity());
                        stmt.setNull(8, 12);
                        stmt.setString(9, station.getOndate());
                        stmt.setString(10, station.getOffdate());
                        stmt.executeUpdate();
                        stmt.setString(1, chans[i].getNet());
                        stmt.setString(2, chans[i].getSta());
                        stmt.setString(3, chans[i].getLocID());
                        stmt.setString(4, chans[i].getCha());
                        stmt.setString(5, "hAng");
                        stmt.setInt(6, 0);
                        stmt.setString(7, "" + chans[i].getHang());
                        stmt.setNull(8, 12);
                        stmt.setString(9, station.getOndate());
                        stmt.setString(10, station.getOffdate());
                        stmt.executeUpdate();
                        stmt.setString(1, chans[i].getNet());
                        stmt.setString(2, chans[i].getSta());
                        stmt.setString(3, chans[i].getLocID());
                        stmt.setString(4, chans[i].getCha());
                        stmt.setString(5, "vAng");
                        stmt.setInt(6, 0);
                        stmt.setString(7, "" + chans[i].getHang());
                        stmt.setNull(8, 12);
                        stmt.setString(9, station.getOndate());
                        stmt.setString(10, station.getOffdate());
                        stmt.executeUpdate();
                        stmt.setString(1, chans[i].getNet());
                        stmt.setString(2, chans[i].getSta());
                        stmt.setString(3, chans[i].getLocID());
                        stmt.setString(4, chans[i].getCha());
                        stmt.setString(5, "instrumentType");
                        stmt.setInt(6, 0);
                        stmt.setString(7, station.getMtype());
                        stmt.setNull(8, 12);
                        stmt.setString(9, station.getOndate());
                        stmt.setString(10, station.getOffdate());
                        stmt.executeUpdate();
                        stmt.setString(1, chans[i].getNet());
                        stmt.setString(2, chans[i].getSta());
                        stmt.setString(3, chans[i].getLocID());
                        stmt.setString(4, chans[i].getCha());
                        stmt.setString(5, "originalType");
                        stmt.setInt(6, 0);
                        stmt.setString(7, "V");
                        stmt.setNull(8, 12);
                        stmt.setString(9, station.getOndate());
                        stmt.setString(10, station.getOffdate());
                        stmt.executeUpdate();
                        stmt.setString(1, chans[i].getNet());
                        stmt.setString(2, chans[i].getSta());
                        stmt.setString(3, chans[i].getLocID());
                        stmt.setString(4, chans[i].getCha());
                        stmt.setString(5, "sampleRate");
                        stmt.setInt(6, 0);
                        stmt.setString(7, "" + chans[i].getSampleRate());
                        stmt.setNull(8, 12);
                        stmt.setString(9, station.getOndate());
                        stmt.setString(10, station.getOffdate());
                        stmt.executeUpdate();
                        stmt.setString(1, chans[i].getNet());
                        stmt.setString(2, chans[i].getSta());
                        stmt.setString(3, chans[i].getLocID());
                        stmt.setString(4, chans[i].getCha());
                        stmt.setString(5, "ScaleFactor");
                        stmt.setInt(6, 0);
                        stmt.setString(7, "" + chans[i].getTranFun().getSfactor());
                        stmt.setNull(8, 12);
                        stmt.setString(9, station.getOndate());
                        stmt.setString(10, station.getOffdate());
                        stmt.executeUpdate();
                        StringTokenizer st = new StringTokenizer(chans[i].getTranFun().getPole());
                        int j = 0;
                        while (j < chans[i].getTranFun().getNpole()) {
                            stmt.setString(1, chans[i].getNet());
                            stmt.setString(2, chans[i].getSta());
                            stmt.setString(3, chans[i].getLocID());
                            stmt.setString(4, chans[i].getCha());
                            stmt.setString(5, "pole");
                            stmt.setInt(6, j);
                            stmt.setString(7, st.nextToken());
                            stmt.setString(8, st.nextToken());
                            stmt.setString(9, station.getOndate());
                            stmt.setString(10, station.getOffdate());
                            stmt.executeUpdate();
                            ++j;
                        }
                        st = new StringTokenizer(chans[i].getTranFun().getZero());
                        j = 0;
                        while (j < chans[i].getTranFun().getNzero()) {
                            stmt.setString(1, chans[i].getNet());
                            stmt.setString(2, chans[i].getSta());
                            stmt.setString(3, chans[i].getLocID());
                            stmt.setString(4, chans[i].getCha());
                            stmt.setString(5, "zero");
                            stmt.setInt(6, j);
                            stmt.setString(7, st.nextToken());
                            stmt.setString(8, st.nextToken());
                            stmt.setString(9, station.getOndate());
                            stmt.setString(10, station.getOffdate());
                            stmt.executeUpdate();
                            ++j;
                        }
                        ++i;
                    }
                    conn.commit();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    conn.rollback();
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                throw throwable;
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        logger.info("Add Operation success");
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public static void ui(String[] args) throws Exception {
        String[] net_stn;
        Options options = new Options();
        Option help = new Option("help", "print this message");
        OptionBuilder.withArgName((String)"config");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"ConectionPool configuration");
        Option config = OptionBuilder.create((String)"config");
        OptionBuilder.withArgName((String)"network.xml");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"add network.xml file to db");
        Option add = OptionBuilder.create((String)"add");
        Option remove = new Option("remove", "remove station before adding network.xml to db");
        OptionBuilder.withArgName((String)"net sta");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"delete station from db");
        Option delete = OptionBuilder.create((String)"delete");
        delete.setArgs(2);
        OptionBuilder.withArgName((String)"net sta");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"list station nfo  from db");
        Option lsta = OptionBuilder.create((String)"lsta");
        lsta.setArgs(2);
        OptionBuilder.withArgName((String)"net/sta/loc/chan");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"list channel nfo  from db");
        Option lchan = OptionBuilder.create((String)"lchan");
        OptionBuilder.withArgName((String)"net sta key value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"update station info  from db");
        Option usta = OptionBuilder.create((String)"usta");
        usta.setArgs(4);
        OptionBuilder.withArgName((String)"net/sta/loc/chan  data_type serial key value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"update channel info  from db");
        Option uchan = OptionBuilder.create((String)"uchan");
        uchan.setArgs(5);
        options.addOption(help).addOption(config).addOption(add).addOption(remove).addOption(delete).addOption(lsta).addOption(lchan).addOption(usta).addOption(uchan);
        BasicParser parser = new BasicParser();
        CommandLine cmd = parser.parse(options, args);
        Xml2Mysql xml2Mysql = new Xml2Mysql();
        if (args.length == 0 || cmd.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Xml2Mysql", options);
            System.exit(-1);
        }
        if (cmd.hasOption("config")) {
            xml2Mysql.setConfig(cmd.getOptionValue("config"));
        }
        if (cmd.hasOption("add")) {
            xml2Mysql.setNetwork(new File(cmd.getOptionValue("add")));
            if (cmd.hasOption("remove")) {
                xml2Mysql.setDelete(true);
            }
            xml2Mysql.convert();
        } else if (cmd.hasOption("delete")) {
            net_stn = cmd.getOptionValues("delete");
            xml2Mysql.deleteStation(net_stn[0], net_stn[1]);
        } else if (cmd.hasOption("lsta")) {
            net_stn = cmd.getOptionValues("lsta");
            xml2Mysql.listStation(net_stn[0], net_stn[1]);
        } else if (cmd.hasOption("lchan")) {
            xml2Mysql.listChannel(ChannelLocator.parse(cmd.getOptionValue("lchan")));
        }
        if (cmd.hasOption("usta")) {
            String[] usta_arg = cmd.getOptionValues("usta");
            logger.info("" + usta_arg.length);
            xml2Mysql.modifyStation(usta_arg[0], usta_arg[1], usta_arg[2], usta_arg[3]);
        }
        if (cmd.hasOption("uchan")) {
            String[] uchan_arg = cmd.getOptionValues("uchan");
            xml2Mysql.modifyChannel(ChannelLocator.parse(uchan_arg[0]), uchan_arg[1], Integer.parseInt(uchan_arg[2]), uchan_arg[3], uchan_arg[4]);
        }
        xml2Mysql.destory();
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("Xml2Mysql.properties");
        Xml2Mysql.ui(args);
    }
}

