/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.calibration;

public class PulseAmpPeriodFinder {
    private double[] data;
    private int minPeriod = 50;
    private int avgPeriod = 200;
    private double amp;
    private int period;
    private int indexOfPulse;
    private boolean findMin = true;

    public void find() {
        if (this.data == null) {
            return;
        }
        int mi = this.findMinIndex();
        this.amp = Math.abs(this.data[mi]);
        this.indexOfPulse = mi;
        int Ti = 0;
        while (!(mi - ++Ti + 1 - 2 < 1 || (this.data[mi - Ti + 1] - this.data[mi - Ti + 1 - 1]) * (this.data[mi - Ti + 1 - 1] - this.data[mi - Ti + 1 - 2]) <= 0.0 && Ti > this.minPeriod)) {
        }
        if (mi - Ti + 1 - this.avgPeriod < 0 || mi - Ti + 1 - this.avgPeriod > this.data.length) {
            this.period = 0;
            return;
        }
        if (mi - Ti + 1 - 1 < 0 || mi - Ti + 1 - 1 > this.data.length) {
            this.period = 0;
            return;
        }
        if (!(this.mean(this.data, mi - Ti + 1 - this.avgPeriod, mi - Ti + 1 - 1) > this.data[mi - Ti + 1]) && this.mean(this.data, mi - Ti + 1 - this.avgPeriod, mi - Ti + 1 - 1) < this.data[mi - Ti + 1]) {
            while (this.mean(this.data, mi - Ti + 1 - this.avgPeriod, mi - Ti + 1 - 1) < this.data[mi - Ti + 1]) {
                --Ti;
            }
        }
        this.period = Ti;
    }

    public double getAmp() {
        return this.amp;
    }

    public int getIndexOfPulse() {
        return this.indexOfPulse;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setAvgPeriod(int avgPeriod) {
        this.avgPeriod = avgPeriod;
    }

    public void setFindMin(boolean findMin) {
        this.findMin = findMin;
        if (!this.findMin) {
            int i = 0;
            while (i < this.data.length) {
                this.data[i] = -this.data[i];
                ++i;
            }
        }
    }

    public void setMinPeriod(int minPeriod) {
        this.minPeriod = minPeriod;
    }

    public void setData(double[] data) {
        this.data = data;
    }

    private double mean(double[] x, int start, int end) {
        double sum = 0.0;
        int i = start;
        while (i < end) {
            sum += x[i];
            ++i;
        }
        return sum / (double)(end - start);
    }

    private int findMinIndex() {
        double mv = this.data[0];
        int mi = 0;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] < mv) {
                mi = i;
                mv = this.data[i];
            }
            ++i;
        }
        return mi;
    }
}

