/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.CatalogI;
import cn.org.gddsn.jopens.entity.PhaseI;
import cn.org.gddsn.jopens.service.ReportService;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.seis.CatalogExporterInf;
import cn.org.gddsn.seis.EventInfoUtils;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdCatalogExporter
implements CatalogExporterInf {
    private boolean exportArrival = true;
    private boolean exportAmp = true;

    @Override
    public void write(File cataFile, ReportService rs, String where) throws IOException {
        List<Catalog> cataList = rs.findCatalog(where);
        this.write(cataFile, cataList);
    }

    @Override
    public void write(File cataFile, List<Catalog> cataList) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(cataFile));
        for (Catalog c : cataList) {
            this.write(pw, c);
        }
        pw.close();
    }

    @Override
    public void write(EvtData evt, SeedVolumeService svs, File cataFile) throws IOException {
        CatalogI c = new CatalogI();
        if (EvtData.source == null) {
            EvtData.source = new SourceParam();
            EvtData.source.setOriginTime(evt.getArrivalTime(0));
            EvtData.source.setLat(-99999.0);
            EvtData.source.setLon(-99999.0);
            EvtData.source.setDepth(-99999.0);
            EvtData.source.setRms(-99999.0);
        }
        if (EvtData.source.getOriginTime() == null) {
            EvtData.source.setOriginTime(evt.getArrivalTime(0));
            EvtData.source.setLat(-99999.0);
            EvtData.source.setLon(-99999.0);
            EvtData.source.setDepth(-99999.0);
            EvtData.source.setRms(-99999.0);
        }
        EventInfoUtils.sourceParam2Catalog(EvtData.source, c, svs);
        c.setId(cataFile.getName());
        c.setPhases(new LinkedList<cn.org.gddsn.jopens.entity.Phase>());
        int TCH = evt.getTCN();
        int i = 0;
        while (i < TCH) {
            for (Phase p : evt.getPhases(i)) {
                PhaseI dbPh = new PhaseI();
                EventInfoUtils.phase2EntityPhase(p, dbPh, svs);
                dbPh.setCatalog(c);
                c.getPhases().add(dbPh);
            }
            ++i;
        }
        Collections.sort(c.getPhases());
        this.write(cataFile.getParentFile(), (Catalog)c);
    }

    @Override
    public void write(File path, Catalog c) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(new File(path, String.valueOf(c.getId()) + ".phase")));
        this.write(pw, c);
        pw.close();
    }

    @Override
    public void write(PrintWriter wr, Catalog c) throws IOException {
        this.exportCatalog(wr, c);
        if (this.exportArrival) {
            this.exportArrival(wr, c);
        }
        if (this.exportAmp) {
            this.exportAmp(wr, c);
        }
        wr.println();
    }

    @Override
    public void exportCatalog(PrintWriter wr, Catalog c) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("#  yyyy MM dd HH  mm ");
        wr.print(df.format(c.getOriginTime()));
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date(c.getOriginTime().getTime() + (long)(c.getOriginTimeFrac() / 10)));
        double sec = (double)gc.get(13) + (double)(gc.getTimeInMillis() % 1000L) / 1000.0;
        wr.print(sec);
        wr.printf(" %.4f %.4f %5.1f %3.1f %.2f %.2f %6.3f %s", Float.valueOf(c.getLat()), Float.valueOf(c.getLon()), Float.valueOf(c.getDepth()), Float.valueOf(c.getM()), Float.valueOf(c.getErh()), Float.valueOf(c.getErz()), Float.valueOf(c.getRms()), c.getId());
        wr.println();
    }

    @Override
    public void exportArrival(PrintWriter wr, Catalog c) throws IOException {
        wr.println("##Arrival info");
        wr.println("##CL  TT  RES  PHASE  DELTA");
        for (cn.org.gddsn.jopens.entity.Phase p : c.getPhases()) {
            if (!p.getPhaseType().equals("time")) continue;
            wr.print(p.getChannelLocator());
            double tt = ((double)(p.getPhaseTime().getTime() - c.getOriginTime().getTime()) - (double)c.getOriginTimeFrac() / 10.0) / 1000.0;
            wr.printf(" %6.2f %4.2f %s,%s,%s %.2f", tt, Float.valueOf(p.getResi()), p.getClarity(), p.getPhaseName(), p.getWsign(), p.getDistance() > -9999.0f ? (double)p.getDistance() / 111.19 : (double)p.getDistance());
            wr.println();
        }
    }

    @Override
    public void exportAmp(PrintWriter wr, Catalog c) throws IOException {
        wr.println("##Amp info");
        wr.println("##CL  AMP PERIOD AmpT MagT  MAG");
        for (cn.org.gddsn.jopens.entity.Phase p : c.getPhases()) {
            if (p.getPhaseType().equals("time")) continue;
            wr.printf("%s %.2f %.2f %s %s %.2f", p.getChannelLocator(), Float.valueOf(p.getAmp()), Float.valueOf(p.getPeriod()), p.getRecType(), p.getMagType().getId(), Float.valueOf(p.getMagVal()));
            wr.println();
        }
    }

    public void setExportAmp(boolean exportAmp) {
        this.exportAmp = exportAmp;
    }

    public void setExportArrival(boolean exportArrival) {
        this.exportArrival = exportArrival;
    }

    public static void main(String[] args) {
    }
}

