/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class ChannelLocator
implements Comparable,
Serializable {
    private static final long serialVersionUID = 8259495511302267108L;
    private String netCode = "";
    private String stationCode = "";
    private String locID = "00";
    private String chanCode = "";
    private int comp;

    public ChannelLocator() {
    }

    private int toComp() {
        int ret = -1;
        if (this.chanCode.endsWith("Z")) {
            ret = 2;
        } else if (this.chanCode.endsWith("E")) {
            ret = 1;
        } else if (this.chanCode.endsWith("N")) {
            ret = 0;
        }
        return ret;
    }

    public ChannelLocator(String netCode, String StationCode, String locID, String chanCode) {
        this.setChannelLocator(netCode, StationCode, locID, chanCode);
    }

    public static ChannelLocator parse(String chanDiscription) throws NoSuchElementException {
        StringTokenizer sToken = new StringTokenizer(chanDiscription, "/");
        ChannelLocator cl = new ChannelLocator();
        cl.setChannelLocator(sToken.nextToken(), sToken.nextToken(), sToken.nextToken(), sToken.nextToken());
        return cl;
    }

    public static ChannelLocator[] parse(String[] chanDiscription) throws NoSuchElementException {
        ChannelLocator[] cls = new ChannelLocator[chanDiscription.length];
        int i = 0;
        while (i < cls.length) {
            cls[i] = ChannelLocator.parse(chanDiscription[i]);
            ++i;
        }
        return cls;
    }

    public ChannelLocator copy() {
        ChannelLocator cl = new ChannelLocator();
        cl.netCode = new String(this.netCode);
        cl.stationCode = new String(this.stationCode);
        cl.locID = new String(this.locID);
        cl.chanCode = new String(this.chanCode);
        return cl;
    }

    public void setChannelLocator(String netCode, String StationCode, String locID, String chanCode) {
        this.netCode = netCode;
        this.stationCode = StationCode;
        this.locID = locID;
        this.chanCode = chanCode;
        if (chanCode.length() != 3) {
            throw new IllegalArgumentException("netcode=" + netCode + " or ChanCode=" + chanCode + " is invalid,StationCode=" + StationCode);
        }
        this.comp = this.toComp();
    }

    public String getNetCode() {
        return this.netCode;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public String getLocID() {
        return this.locID;
    }

    public String getChanCode() {
        return this.chanCode;
    }

    public int compareTo(Object o) {
        return this.compareTo((ChannelLocator)o);
    }

    public int compareTo(ChannelLocator cl) {
        String key = this.toUnderLineString();
        int keyLen = key.length();
        String akey = cl.toUnderLineString();
        int akeyLen = akey.length();
        int c = key.substring(0, keyLen - 1).compareTo(akey.substring(0, akeyLen - 1));
        if (c != 0) {
            return c;
        }
        return this.comp - cl.comp;
    }

    public String toString() {
        return String.valueOf(this.netCode) + "/" + this.stationCode + "/" + this.locID + "/" + this.chanCode;
    }

    public String toUnderLineString() {
        return String.valueOf(this.netCode) + "_" + this.stationCode + "_" + this.locID + "_" + this.chanCode;
    }

    public int hashCode() {
        return (String.valueOf(this.netCode) + this.stationCode + this.locID + this.chanCode).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChannelLocator) {
            ChannelLocator obj1 = (ChannelLocator)obj;
            return this.netCode.equals(obj1.netCode) && this.stationCode.equals(obj1.stationCode) && this.locID.equals(obj1.locID) && this.chanCode.equals(obj1.chanCode);
        }
        return false;
    }

    public void setNetCode(String netCode) {
        this.netCode = netCode;
    }

    public static void main(String[] args) {
        ChannelLocator cl = new ChannelLocator("HE", "WAT", "00", "BHN");
        System.out.println(cl.hashCode());
        cl = new ChannelLocator("HE", "ZAQ", "00", "BHN");
        System.out.println(cl.hashCode());
    }
}

