/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.security;

import cn.org.gddsn.security.Bytes;
import cn.org.gddsn.security.MessageDigest;

public final class MD5
extends MessageDigest {
    private long counter;
    private int reminder;
    private byte[] buffer;
    private int[] state;
    private int[] x;
    static byte[] padding;
    private static String[] messages;
    private static String[] digests;

    static {
        byte[] byArray = new byte[64];
        byArray[0] = -128;
        padding = byArray;
        messages = new String[]{"", "a", "abc", "message digest", "abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "12345678901234567890123456789012345678901234567890123456789012345678901234567890"};
        digests = new String[]{"d41d8cd98f00b204e9800998ecf8427e", "0cc175b9c0f1b6a831c399e269772661", "900150983cd24fb0d6963f7d28e17f72", "f96b697d7cb7938d525a2f31aaf161d0", "c3fcd3d76192e4007dfb496cca67e13b", "d174ab98d277d9f5a5611c2c9f419d9f", "57edf4a22be3c955ac49da2e2107b67a"};
    }

    public void reset() {
        this.buffer = new byte[64];
        this.state = new int[4];
        this.x = new int[16];
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.counter = 0L;
        this.reminder = 64;
    }

    public void append(byte[] block, int offset, int length) {
        while (length >= this.reminder) {
            System.arraycopy(block, offset, this.buffer, (int)(this.counter & 0x3FL), this.reminder);
            this.transform(this.buffer);
            this.counter += (long)this.reminder;
            offset += this.reminder;
            length -= this.reminder;
            this.reminder = 64;
        }
        System.arraycopy(block, offset, this.buffer, (int)(this.counter & 0x3FL), length);
        this.counter += (long)length;
        this.reminder -= length;
    }

    public byte[] digest(byte[] block, int offset, int length) {
        this.append(block, offset, length);
        byte[] bits = MD5.toBytes(this.counter << 3);
        byte[] digest = new byte[16];
        if (this.reminder > 8) {
            this.append(padding, 0, this.reminder - 8);
        } else {
            this.append(padding, 0, 64 + (this.reminder - 8));
        }
        this.append(bits, 0, 8);
        MD5.int2byte(this.state, digest);
        this.reset();
        return digest;
    }

    private static void byte2int(byte[] in, int[] out) {
        int inpos = 0;
        int outpos = 0;
        while (outpos < 16) {
            out[outpos] = in[inpos++] & 0xFF | (in[inpos++] & 0xFF) << 8 | (in[inpos++] & 0xFF) << 16 | (in[inpos++] & 0xFF) << 24;
            ++outpos;
        }
    }

    private static void int2byte(int[] in, byte[] out) {
        int inpos = 0;
        int outpos = 0;
        while (inpos < 4) {
            out[outpos++] = (byte)(in[inpos] & 0xFF);
            out[outpos++] = (byte)(in[inpos] >>> 8 & 0xFF);
            out[outpos++] = (byte)(in[inpos] >>> 16 & 0xFF);
            out[outpos++] = (byte)(in[inpos] >>> 24 & 0xFF);
            ++inpos;
        }
    }

    public static byte[] toBytes(long n) {
        byte[] b = new byte[]{(byte)n, (byte)(n >>>= 8), (byte)(n >>>= 8), (byte)(n >>>= 8), (byte)(n >>>= 8), (byte)(n >>>= 8), (byte)(n >>>= 8), (byte)(n >>>= 8)};
        return b;
    }

    private static int F(int x, int y, int z) {
        return z ^ x & (y ^ z);
    }

    private static int G(int x, int y, int z) {
        return y ^ z & (x ^ y);
    }

    private static int H(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private static int I(int x, int y, int z) {
        return y ^ (x | ~z);
    }

    private static int FF(int a, int b, int c, int d, int x, int s, int ac) {
        a += x + ac + MD5.F(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    private static int GG(int a, int b, int c, int d, int x, int s, int ac) {
        a += x + ac + MD5.G(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    private static int HH(int a, int b, int c, int d, int x, int s, int ac) {
        a += x + ac + MD5.H(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    private static int II(int a, int b, int c, int d, int x, int s, int ac) {
        a += x + ac + MD5.I(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    private void transform(byte[] buffer) {
        MD5.byte2int(buffer, this.x);
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        a = MD5.FF(a, b, c, d, this.x[0], 7, -680876936);
        d = MD5.FF(d, a, b, c, this.x[1], 12, -389564586);
        c = MD5.FF(c, d, a, b, this.x[2], 17, 606105819);
        b = MD5.FF(b, c, d, a, this.x[3], 22, -1044525330);
        a = MD5.FF(a, b, c, d, this.x[4], 7, -176418897);
        d = MD5.FF(d, a, b, c, this.x[5], 12, 1200080426);
        c = MD5.FF(c, d, a, b, this.x[6], 17, -1473231341);
        b = MD5.FF(b, c, d, a, this.x[7], 22, -45705983);
        a = MD5.FF(a, b, c, d, this.x[8], 7, 1770035416);
        d = MD5.FF(d, a, b, c, this.x[9], 12, -1958414417);
        c = MD5.FF(c, d, a, b, this.x[10], 17, -42063);
        b = MD5.FF(b, c, d, a, this.x[11], 22, -1990404162);
        a = MD5.FF(a, b, c, d, this.x[12], 7, 1804603682);
        d = MD5.FF(d, a, b, c, this.x[13], 12, -40341101);
        c = MD5.FF(c, d, a, b, this.x[14], 17, -1502002290);
        b = MD5.FF(b, c, d, a, this.x[15], 22, 1236535329);
        a = MD5.GG(a, b, c, d, this.x[1], 5, -165796510);
        d = MD5.GG(d, a, b, c, this.x[6], 9, -1069501632);
        c = MD5.GG(c, d, a, b, this.x[11], 14, 643717713);
        b = MD5.GG(b, c, d, a, this.x[0], 20, -373897302);
        a = MD5.GG(a, b, c, d, this.x[5], 5, -701558691);
        d = MD5.GG(d, a, b, c, this.x[10], 9, 38016083);
        c = MD5.GG(c, d, a, b, this.x[15], 14, -660478335);
        b = MD5.GG(b, c, d, a, this.x[4], 20, -405537848);
        a = MD5.GG(a, b, c, d, this.x[9], 5, 568446438);
        d = MD5.GG(d, a, b, c, this.x[14], 9, -1019803690);
        c = MD5.GG(c, d, a, b, this.x[3], 14, -187363961);
        b = MD5.GG(b, c, d, a, this.x[8], 20, 1163531501);
        a = MD5.GG(a, b, c, d, this.x[13], 5, -1444681467);
        d = MD5.GG(d, a, b, c, this.x[2], 9, -51403784);
        c = MD5.GG(c, d, a, b, this.x[7], 14, 1735328473);
        b = MD5.GG(b, c, d, a, this.x[12], 20, -1926607734);
        a = MD5.HH(a, b, c, d, this.x[5], 4, -378558);
        d = MD5.HH(d, a, b, c, this.x[8], 11, -2022574463);
        c = MD5.HH(c, d, a, b, this.x[11], 16, 1839030562);
        b = MD5.HH(b, c, d, a, this.x[14], 23, -35309556);
        a = MD5.HH(a, b, c, d, this.x[1], 4, -1530992060);
        d = MD5.HH(d, a, b, c, this.x[4], 11, 1272893353);
        c = MD5.HH(c, d, a, b, this.x[7], 16, -155497632);
        b = MD5.HH(b, c, d, a, this.x[10], 23, -1094730640);
        a = MD5.HH(a, b, c, d, this.x[13], 4, 681279174);
        d = MD5.HH(d, a, b, c, this.x[0], 11, -358537222);
        c = MD5.HH(c, d, a, b, this.x[3], 16, -722521979);
        b = MD5.HH(b, c, d, a, this.x[6], 23, 76029189);
        a = MD5.HH(a, b, c, d, this.x[9], 4, -640364487);
        d = MD5.HH(d, a, b, c, this.x[12], 11, -421815835);
        c = MD5.HH(c, d, a, b, this.x[15], 16, 530742520);
        b = MD5.HH(b, c, d, a, this.x[2], 23, -995338651);
        a = MD5.II(a, b, c, d, this.x[0], 6, -198630844);
        d = MD5.II(d, a, b, c, this.x[7], 10, 1126891415);
        c = MD5.II(c, d, a, b, this.x[14], 15, -1416354905);
        b = MD5.II(b, c, d, a, this.x[5], 21, -57434055);
        a = MD5.II(a, b, c, d, this.x[12], 6, 1700485571);
        d = MD5.II(d, a, b, c, this.x[3], 10, -1894986606);
        c = MD5.II(c, d, a, b, this.x[10], 15, -1051523);
        b = MD5.II(b, c, d, a, this.x[1], 21, -2054922799);
        a = MD5.II(a, b, c, d, this.x[8], 6, 1873313359);
        d = MD5.II(d, a, b, c, this.x[15], 10, -30611744);
        c = MD5.II(c, d, a, b, this.x[6], 15, -1560198380);
        b = MD5.II(b, c, d, a, this.x[13], 21, 1309151649);
        a = MD5.II(a, b, c, d, this.x[4], 6, -145523070);
        d = MD5.II(d, a, b, c, this.x[11], 10, -1120210379);
        c = MD5.II(c, d, a, b, this.x[2], 15, 718787259);
        b = MD5.II(b, c, d, a, this.x[9], 21, -343485551);
        this.state[0] = this.state[0] + a;
        this.state[1] = this.state[1] + b;
        this.state[2] = this.state[2] + c;
        this.state[3] = this.state[3] + d;
    }

    public static final void main(String[] ignored) {
        MD5 md5 = new MD5();
        String a = "35aefc1a14460a32c0a8a82c0588000500000000000000000100000b65254f96bbb7b888811e8dfc";
        String r = Bytes.toString(md5.digest(a.getBytes()));
        System.out.println(r);
        int i = 0;
        while (i < messages.length) {
            String digest = Bytes.toString(md5.digest(messages[i].getBytes()));
            System.out.println("Computed: " + digest);
            System.out.println("Correct: " + digests[i]);
            if (digest.equalsIgnoreCase(digests[i])) {
                System.out.println("Test " + i + " passed.");
            } else {
                System.out.println("Test " + i + " failed.");
            }
            ++i;
        }
    }
}

