/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.optimization;

import cn.org.gddsn.convert.DoubleFormat;
import cn.org.gddsn.coyote.stochastic.Stochastic;
import cn.org.gddsn.coyote.stochastic.StochasticLevel3;
import cn.org.gddsn.optimization.BinaryToDoubleFunction;
import cn.org.gddsn.optimization.BitSet;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.log4j.Logger;

public class GeneticMin {
    static Logger logger;
    private BinaryToDoubleFunction func;
    private int populationSize = 100;
    private double selectP = 0.75;
    private double crossP = 0.8;
    private double[] mutationP;
    private double updateP = 0.9;
    private int addNewGeneSize = 5;
    int bitsLength;
    BitSet[] inputModel;
    BitSet[] outputModel;
    private double[] funkVal;
    BitSet[] preInputModel;
    private double[] preFunkVal;
    private double[] outFunkVal;
    Stochastic rand = new StochasticLevel3();
    private final BitSet zero = new BitSet();
    private final double[] mutP = new double[]{0.4, 0.44, 0.41, 0.41, 0.21, 0.211, 0.211, 0.211};
    private double avgError = 1.0;
    private int iterateMax = 2000;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.optimization.GeneticMin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public void setFunk(BinaryToDoubleFunction newFunk) {
        this.func = newFunk;
    }

    public void setUpdateP(double newUpdateP) {
        this.updateP = newUpdateP;
    }

    public double getUpdateP() {
        return this.updateP;
    }

    public void setCrossP(double newCrossP) {
        this.crossP = newCrossP;
    }

    public double getCrossP() {
        return this.crossP;
    }

    public void setMutationP(double[] newMutationP) {
        this.mutationP = newMutationP;
    }

    public double[] getMutationP() {
        return this.mutationP;
    }

    public void setPopulationSize(int newPopulationSize) {
        this.populationSize = newPopulationSize;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setSelectP(double newSelectP) {
        this.selectP = newSelectP;
    }

    public double getSelectP() {
        return this.selectP;
    }

    public void setAddNewGeneSize(int newAddNewGeneSize) {
        this.addNewGeneSize = newAddNewGeneSize;
    }

    public int getAddNewGeneSize() {
        return this.addNewGeneSize;
    }

    public void setAvgError(double newAvgError) {
        this.avgError = newAvgError;
    }

    public double getAvgError() {
        return this.avgError;
    }

    public void setIterateMax(int newIterateMax) {
        this.iterateMax = newIterateMax;
    }

    public int getIterateMax() {
        return this.iterateMax;
    }

    private void initModel() {
        this.bitsLength = this.func.getTotalBitsLength();
        this.mutationP = new double[this.bitsLength];
        int i = 0;
        while (i < this.bitsLength) {
            this.mutationP[i] = i < this.mutP.length ? this.mutP[i] : 0.001;
            ++i;
        }
        this.inputModel = new BitSet[this.populationSize];
        this.funkVal = new double[this.populationSize];
        this.outputModel = new BitSet[this.populationSize];
        this.outFunkVal = new double[this.populationSize];
        this.preInputModel = new BitSet[this.populationSize];
        this.preFunkVal = new double[this.populationSize];
        int bit = 0;
        int i2 = 0;
        while (i2 < this.populationSize) {
            this.inputModel[i2] = new BitSet(this.bitsLength);
            this.outputModel[i2] = new BitSet(this.bitsLength);
            this.preInputModel[i2] = new BitSet(this.bitsLength);
            int j = 0;
            while (j < this.bitsLength) {
                bit = this.rand.nextValue(0, 2);
                if (bit == 1) {
                    this.inputModel[i2].set(j);
                } else {
                    this.inputModel[i2].clear(j);
                }
                ++j;
            }
            this.preFunkVal[i2] = Double.MAX_VALUE;
            ++i2;
        }
    }

    private void calcFunkVal() {
        int i = 0;
        while (i < this.populationSize) {
            this.funkVal[i] = this.func.getValue(this.inputModel[i]);
            ++i;
        }
    }

    private void tournamentSelect() {
        int n = 0;
        int min = 0;
        int max = 0;
        double r = 0.0;
        int i = 0;
        while (i < this.populationSize) {
            min = this.rand.nextValue(0, this.populationSize);
            max = this.rand.nextValue(0, this.populationSize);
            while (min == max) {
                max = this.rand.nextValue(0, this.populationSize);
            }
            if (this.funkVal[min] > this.funkVal[max]) {
                n = max;
                max = min;
                min = n;
            }
            if ((r = this.rand.nextDouble(0.0, 1.0)) < this.selectP) {
                this.outputModel[i].and(this.zero);
                this.outputModel[i].or(this.inputModel[min]);
                this.outFunkVal[i] = this.funkVal[min];
            } else {
                this.outputModel[i].and(this.zero);
                this.outputModel[i].or(this.inputModel[max]);
                this.outFunkVal[i] = this.funkVal[max];
            }
            n = this.rand.nextValue(0, this.populationSize);
            r = this.rand.nextDouble(0.0, 1.0);
            if (r < this.updateP && this.outFunkVal[i] > this.preFunkVal[n]) {
                this.outputModel[i].and(this.zero);
                this.outputModel[i].or(this.preInputModel[n]);
                this.outFunkVal[i] = this.preFunkVal[n];
            }
            ++i;
        }
        i = 0;
        while (i < this.populationSize) {
            this.preInputModel[i].and(this.zero);
            this.preInputModel[i].or(this.outputModel[i]);
            this.preFunkVal[i] = this.outFunkVal[i];
            ++i;
        }
        this.sendOutputToInput();
    }

    private void sendOutputToInput() {
        int i = 0;
        while (i < this.populationSize) {
            this.inputModel[i].and(this.zero);
            this.inputModel[i].or(this.outputModel[i]);
            ++i;
        }
    }

    private void crossOver() {
        int half = this.populationSize / 2;
        int[] dad = new int[half];
        int[] mom = new int[half];
        int tmp = 0;
        int n = 0;
        boolean bit = false;
        Vector<Integer> vec = new Vector<Integer>(this.populationSize);
        int i = 0;
        while (i < this.populationSize) {
            vec.addElement(new Integer(i));
            ++i;
        }
        i = 0;
        while (i < this.populationSize - 2) {
            tmp = this.rand.nextValue(0, this.populationSize - i);
            if (i % 2 == 0) {
                dad[i / 2] = (Integer)vec.elementAt(tmp);
            } else {
                mom[i / 2 + 1] = (Integer)vec.elementAt(tmp);
            }
            vec.removeElementAt(tmp);
            ++i;
        }
        dad[half - 1] = (Integer)vec.elementAt(0);
        mom[half - 1] = (Integer)vec.elementAt(1);
        i = 0;
        while (i < half) {
            if (this.rand.nextDouble(0.0, 1.0) < this.crossP) {
                int j = n = this.rand.nextValue(0, this.bitsLength);
                while (j < this.bitsLength) {
                    bit = this.inputModel[dad[i]].get(j);
                    if (this.inputModel[mom[i]].get(j)) {
                        this.inputModel[dad[i]].set(j);
                    } else {
                        this.inputModel[dad[i]].clear(j);
                    }
                    if (bit) {
                        this.inputModel[mom[i]].set(j);
                    } else {
                        this.inputModel[mom[i]].clear(j);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void mutation() {
        double r = 0.0;
        int n = 0;
        int i = 0;
        while (i < this.populationSize) {
            n = this.rand.nextValue(0, this.bitsLength);
            r = this.rand.nextDouble(0.0, 1.0);
            if (r < this.mutationP[this.func.getLocalOrder(n)]) {
                if (this.inputModel[i].get(n)) {
                    this.inputModel[i].clear(n);
                } else {
                    this.inputModel[i].set(n);
                }
            }
            int nn = 0;
            int j = 0;
            while (j < this.addNewGeneSize) {
                nn = this.rand.nextValue(0, this.populationSize);
                if (this.inputModel[i].equals(this.inputModel[nn])) {
                    n = this.rand.nextValue(0, this.bitsLength);
                    if (this.inputModel[i].get(n)) {
                        this.inputModel[i].clear(n);
                        break;
                    }
                    this.inputModel[i].set(n);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void addNewGene() {
        int s = this.rand.nextValue(0, this.populationSize);
        int n = 0;
        int bit = 0;
        int i = 0;
        while (i < this.addNewGeneSize) {
            n = this.rand.nextValue(0, this.populationSize);
            if (this.inputModel[s].equals(this.inputModel[n])) {
                int j = 0;
                while (j < this.bitsLength) {
                    bit = this.rand.nextValue(0, 2);
                    if (bit == 1) {
                        this.inputModel[s].set(j);
                    } else {
                        this.inputModel[s].clear(j);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    public double AvgError() {
        double retVal = 0.0;
        int i = 0;
        while (i < this.populationSize) {
            retVal += Math.abs(this.funkVal[i]);
            ++i;
        }
        return retVal /= (double)this.populationSize;
    }

    public double minError() {
        int min = 0;
        int i = 1;
        while (i < this.populationSize) {
            if (this.funkVal[i] < this.funkVal[min]) {
                min = i;
            }
            ++i;
        }
        return this.funkVal[min];
    }

    private void crossAndMutation() {
        int dad = 0;
        int mom = 0;
        double r = 0.0;
        int n = 0;
        boolean bit = false;
        int i = 0;
        while (i < this.populationSize) {
            dad = this.rand.nextValue(0, this.populationSize);
            mom = this.rand.nextValue(0, this.populationSize);
            this.outputModel[i].and(this.zero);
            this.outputModel[i].or(this.inputModel[dad]);
            this.outputModel[i + 1].and(this.zero);
            this.outputModel[i + 1].or(this.inputModel[mom]);
            r = this.rand.nextDouble(0.0, 1.0);
            if (r < this.crossP) {
                n = this.rand.nextValue(0, this.bitsLength);
                int j = 0;
                while (j < n) {
                    bit = this.outputModel[i].get(j);
                    if (this.outputModel[i + 1].get(j)) {
                        this.outputModel[i].set(j);
                    } else {
                        this.outputModel[i].clear(j);
                    }
                    if (bit) {
                        this.outputModel[i + 1].set(j);
                    } else {
                        this.outputModel[i + 1].clear(j);
                    }
                    ++j;
                }
            } else {
                n = this.rand.nextValue(0, this.bitsLength);
                r = this.rand.nextDouble(0.0, 1.0);
                if (r < this.mutationP[this.func.getLocalOrder(n)]) {
                    if (this.outputModel[i].get(n)) {
                        this.outputModel[i].clear(n);
                    } else {
                        this.outputModel[i].set(n);
                    }
                }
                n = this.rand.nextValue(0, this.bitsLength);
                r = this.rand.nextDouble(0.0, 1.0);
                if (r < this.mutationP[this.func.getLocalOrder(n)]) {
                    if (this.outputModel[i + 1].get(n)) {
                        this.outputModel[i + 1].clear(n);
                    } else {
                        this.outputModel[i + 1].set(n);
                    }
                }
            }
            i += 2;
        }
        this.sendOutputToInput();
    }

    public void SearchMin() {
        this.initModel();
        int count = 0;
        this.calcFunkVal();
        do {
            if (count > this.iterateMax) {
                logger.warn("iteratMax exceed in GeneticMin.SearchMin");
                return;
            }
            this.tournamentSelect();
            this.crossOver();
            this.mutation();
            this.calcFunkVal();
            this.writeResult("d:\\r.txt");
            if (count % 10 == 0) {
                this.printResult();
            }
            ++count;
        } while (this.minError() > this.avgError);
    }

    public void mixMutAndCrossSearchMin() {
        this.initModel();
        int count = 0;
        this.calcFunkVal();
        do {
            if (count > this.iterateMax) {
                logger.warn("iteratMax exceed in GeneticMin.SearchMin");
                return;
            }
            this.tournamentSelect();
            this.crossAndMutation();
            this.addNewGene();
            this.calcFunkVal();
            this.writeResult("d:\\r.txt");
            if (count % 10 == 0) {
                this.printResult();
            }
            ++count;
        } while (this.AvgError() > this.avgError);
    }

    public void addGene(double[] x) {
        int n = this.rand.nextValue(0, this.bitsLength);
        this.inputModel[n] = this.func.Convert(x);
    }

    public double getResidual() {
        int min = 0;
        int i = 1;
        while (i < this.populationSize) {
            if (this.funkVal[i] < this.funkVal[min]) {
                min = i;
            }
            ++i;
        }
        return this.funkVal[min];
    }

    public double[] getResult() {
        int min = 0;
        int i = 1;
        while (i < this.populationSize) {
            if (this.funkVal[i] < this.funkVal[min]) {
                min = i;
            }
            ++i;
        }
        return this.func.getBitSetValue(this.inputModel[min]);
    }

    public void writeResult(String fileName) {
        try {
            FileOutputStream Out = new FileOutputStream(fileName, true);
            BufferedOutputStream BufferedOut = new BufferedOutputStream(Out, 1024);
            PrintWriter p = new PrintWriter(Out);
            int i = 0;
            while (i < this.populationSize) {
                double[] x = this.func.getBitSetValue(this.inputModel[i]);
                int j = 0;
                while (j < x.length) {
                    p.print(String.valueOf(x[j]) + "  ");
                    ++j;
                }
                p.println(this.funkVal[i]);
                ++i;
            }
            p.flush();
            p.close();
            BufferedOut.close();
            Out.close();
        }
        catch (IOException e) {
            logger.warn(" Write ASCII FILE Error!");
        }
    }

    public void printResult() {
        int min = 0;
        int i = 1;
        while (i < this.populationSize) {
            if (this.funkVal[i] < this.funkVal[min]) {
                min = i;
            }
            ++i;
        }
        double[] x = this.func.getBitSetValue(this.inputModel[min]);
        int j = 0;
        while (j < x.length) {
            System.out.print(String.valueOf(DoubleFormat.toString(x[j], 4)) + "  ");
            ++j;
        }
        System.out.println(DoubleFormat.toString(this.funkVal[min], 4));
    }
}

