/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.optimization;

import cn.org.gddsn.optimization.BitSet;
import cn.org.gddsn.optimization.RealValueFunction;

public class BinaryToDoubleFunction {
    private static final int BITS_PER_UNIT = 6;
    private static final int MASK = 63;
    double[] paraMin;
    double[] paraStep;
    int[] bitsLength;
    int totalBitsLength;
    private RealValueFunction func;
    int[] Bits;
    double[] x;
    double[] BitsMax;

    public void setParaMin(double[] newParaMin) {
        this.paraMin = newParaMin;
    }

    public void setParaStep(double[] newParaStep) {
        this.paraStep = newParaStep;
    }

    public void setBitsLength(int[] newBitsLength) {
        this.bitsLength = newBitsLength;
        this.totalBitsLength = this.getTotalBitsLength();
        this.Bits = new int[this.bitsLength.length];
        this.x = new double[this.bitsLength.length];
        this.BitsMax = new double[this.bitsLength.length];
        int i = 0;
        while (i < this.bitsLength.length) {
            int n = 1;
            int j = 0;
            while (j < this.bitsLength[i]) {
                n *= 2;
                ++j;
            }
            this.BitsMax[i] = n;
            ++i;
        }
    }

    public int getTotalBitsLength() {
        int tmp = 0;
        int i = 0;
        while (i < this.bitsLength.length) {
            tmp += this.bitsLength[i];
            ++i;
        }
        return tmp;
    }

    public RealValueFunction getFunk() {
        return this.func;
    }

    public void setFunk(RealValueFunction newFunk) {
        this.func = newFunk;
    }

    public int getLocalOrder(int n) {
        if (n >= this.totalBitsLength) {
            throw new IllegalArgumentException("the argument is exceed in BinaryToDoubleFunction.getLocalOrder()");
        }
        int i = 0;
        while (n + 1 > this.bitsLength[i]) {
            n -= this.bitsLength[i++];
        }
        return this.bitsLength[i] - n;
    }

    public double getValue(BitSet bitSet) {
        int pos = 0;
        int gray = 0;
        boolean bit = false;
        int i = 0;
        while (i < this.bitsLength.length) {
            this.Bits[i] = 0;
            int n = 1 << this.bitsLength[i] - 1;
            gray = 0;
            if (bitSet.get(pos++)) {
                this.Bits[i] = n;
                gray = 1;
            }
            int j = 1;
            while (j < this.bitsLength[i]) {
                n >>= 1;
                if (bit = bitSet.get(pos++)) {
                    ++gray;
                }
                if (gray % 2 == 1) {
                    int n2 = i;
                    this.Bits[n2] = this.Bits[n2] + n;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.bitsLength.length) {
            this.x[i] = this.paraMin[i] + (double)this.Bits[i] * this.paraStep[i];
            ++i;
        }
        return this.func.funk(this.x);
    }

    public double[] getBitSetValue(BitSet bitSet) {
        double[] bits = new double[this.bitsLength.length];
        double[] X = new double[this.bitsLength.length];
        int pos = 0;
        int gray = 0;
        boolean bit = false;
        int i = 0;
        while (i < this.bitsLength.length) {
            bits[i] = 0.0;
            int n = 1 << this.bitsLength[i] - 1;
            gray = 0;
            if (bitSet.get(pos++)) {
                bits[i] = n;
                gray = 1;
            }
            int j = 1;
            while (j < this.bitsLength[i]) {
                n >>= 1;
                if (bit = bitSet.get(pos++)) {
                    ++gray;
                }
                if (gray % 2 == 1) {
                    int n2 = i;
                    bits[n2] = bits[n2] + (double)n;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.bitsLength.length) {
            X[i] = this.paraMin[i] + bits[i] * this.paraStep[i];
            ++i;
        }
        return X;
    }

    public BitSet Convert(double[] x) {
        BitSet bitset = new BitSet(this.totalBitsLength);
        int n = 0;
        int pos = 0;
        int gray = 0;
        int preGray = 0;
        boolean bit = false;
        int i = 0;
        while (i < this.bitsLength.length) {
            n = (int)((x[i] - this.paraMin[i]) / this.paraStep[i]);
            gray = (int)((long)n & 1L);
            boolean bl = bit = gray != 0;
            if (bit) {
                bitset.set(pos++);
            } else {
                bitset.clear(pos++);
            }
            int j = 1;
            while (j < this.bitsLength[i]) {
                preGray = gray;
                boolean bl2 = bit = (preGray + (gray = (int)((long)n & 1L << (j & 0x3F)))) % 2 != 0;
                if (bit) {
                    bitset.set(pos++);
                } else {
                    bitset.clear(pos++);
                }
                ++j;
            }
            ++i;
        }
        return bitset;
    }
}

