/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.util;

import cn.org.gddsn.liss.port.event.MiniSeedPortEvent;
import cn.org.gddsn.liss.port.event.MiniSeedPortEventListener;
import cn.org.gddsn.liss.port.sss.SSSPort;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SendUDP
implements MiniSeedPortEventListener {
    static Logger logger;
    private String host = null;
    private int port;
    private String user = null;
    private String password = null;
    private String[] stationCode = null;
    private SSSPort cPort = null;
    private String targetHost = null;
    private InetAddress targetAddress = null;
    private DatagramSocket udpSocket = null;
    private int udpPort = 5050;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.util.SendUDP");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public SendUDP() {
        try {
            this.loadCfg();
            this.connectServer();
        }
        catch (SocketException ex) {
            logger.error(ex.getMessage(), ex);
            System.exit(-2);
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            System.exit(-1);
        }
    }

    private void loadCfg() throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream("SendUDP.properties"));
        this.host = props.getProperty("SendUDP.source.host");
        this.port = Integer.parseInt(props.getProperty("SendUDP.source.port"));
        this.user = props.getProperty("SendUDP.source.user");
        this.password = props.getProperty("SendUDP.source.password");
        StringTokenizer st = new StringTokenizer(props.getProperty("SendUDP.cfg"), " ");
        this.stationCode = new String[st.countTokens()];
        int i = 0;
        while (i < this.stationCode.length) {
            this.stationCode[i] = st.nextToken();
            ++i;
        }
        this.targetHost = props.getProperty("SendUDP.target.host");
        this.targetAddress = InetAddress.getByName(this.targetHost);
        this.udpPort = Integer.parseInt(props.getProperty("SendUDP.target.port"));
    }

    private void connectServer() throws IOException {
        this.cPort = new SSSPort(this.host, this.port, this.user, this.password, this.stationCode);
        this.cPort.addMiniSeedPortEventListener(this);
        if (this.targetAddress.isMulticastAddress()) {
            MulticastSocket s = new MulticastSocket();
            s.joinGroup(this.targetAddress);
            s.setTimeToLive(255);
            this.udpSocket = s;
            logger.info("MultiCast:\t" + this.targetHost + ":" + this.udpPort);
        } else {
            this.udpSocket = new DatagramSocket();
        }
        this.udpSocket.setSoTimeout(180);
    }

    public void miniSeedEvent(MiniSeedPortEvent me) {
        GenericMiniSeedRecord gmsr = me.getGenericMiniSeedRecord();
        byte[] buf = gmsr.getBytes();
        DatagramPacket packet = new DatagramPacket(buf, buf.length, this.targetAddress, this.udpPort);
        try {
            this.udpSocket.send(packet);
            if (logger.isInfoEnabled()) {
                logger.debug("Sent a packet");
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public void quit() {
        this.cPort.removeMiniSeedPortEventListener(this);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.udpSocket.close();
    }

    public static void main(String[] args) {
        SendUDP sendUDP = new SendUDP();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

