/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.util;

import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.client.LissTransferType;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Date;
import org.apache.log4j.Logger;

public class LissClientReader
implements Runnable {
    static Logger logger;
    private String host = null;
    private String user = null;
    private String password = null;
    private String filename = null;
    private String headFile = null;
    private int second = 0;
    private String[] stnCodes = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.util.LissClientReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public LissClientReader(String host, String user, String password, String filename, int second, String[] stnCodes, String headFile) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.filename = filename;
        this.headFile = headFile;
        this.second = second;
        this.stnCodes = stnCodes;
    }

    public LissClientReader(String host, String user, String password, String filename, int second, String stnCode, String headFile) {
        this(host, user, password, filename, second, new String[]{stnCode}, headFile);
    }

    public void run() {
        try {
            LissClient lissClient = new LissClient(this.host, 5000);
            lissClient.login(this.user, this.password);
            logger.info("Logged into Server: " + this.host);
            lissClient.setType(LissTransferType.BINARY);
            lissClient.setRtServerPassiveMode(false);
            logger.info("Enter the passive transport mode");
            logger.info("Retrieving  MiniSeed data from " + this.host);
            logger.info("Data storing in " + this.filename);
            DataInputStream lissInputStream = new DataInputStream(lissClient.retrieveRealTimeStream(this.stnCodes));
            DataOutputStream hos = new DataOutputStream(new FileOutputStream(this.headFile));
            FileOutputStream fos = new FileOutputStream(this.filename);
            byte[] buf = new byte[512];
            boolean n = false;
            int nCurrent = 0;
            Date now = new Date();
            Date firstTime = new Date();
            while (this.second > nCurrent) {
                lissInputStream.readFully(buf);
                GenericMiniSeedRecord gmsr = GenericMiniSeedRecord.buildMiniSeedRecord(buf);
                hos.writeBytes(gmsr.toString());
                hos.writeByte(10);
                fos.write(buf);
                now = new Date();
                nCurrent = (int)(now.getTime() - firstTime.getTime()) / 1000;
            }
            lissClient.abortRealTimeStreamTransport();
            lissClient.quit();
            fos.close();
            hos.close();
            StringBuffer sbuf = new StringBuffer("OK, finish retrieve data from ");
            int i = 0;
            while (i < this.stnCodes.length) {
                sbuf.append(String.valueOf(this.stnCodes[i]) + " ");
                ++i;
            }
            logger.info(sbuf.substring(0));
        }
        catch (ConnectException cEx) {
            logger.warn("Caught ConnectionException : " + this.stnCodes[0] + "--" + cEx.getMessage());
        }
        catch (IOException ex) {
            logger.warn("Caught IOException: " + ex.getMessage());
        }
        catch (LissException ex) {
            logger.warn("Caught LissException: " + ex.getMessage());
        }
    }

    public static void main(String[] args) {
        int ind;
        int stnCount;
        int c;
        String host1 = null;
        String user1 = null;
        String password1 = null;
        String filename1 = null;
        String header1 = null;
        int second1 = 0;
        boolean bDiv1 = false;
        String[] stnCodes1 = null;
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 0), new LongOpt("host", 1, null, 1), new LongOpt("user", 1, null, 2), new LongOpt("password", 1, null, 3), new LongOpt("filename", 1, null, 4), new LongOpt("Summary", 1, null, 5), new LongOpt("second", 1, null, 6), new LongOpt("divide", 2, null, 7)};
        Getopt g = new Getopt("Reader", args, "?h:u:p:f:s:S:d", longopts);
        block14: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 0: 
                case 63: {
                    LissClientReader.usage();
                    System.exit(-1);
                    break;
                }
                case 1: 
                case 104: {
                    host1 = g.getOptarg();
                    break;
                }
                case 2: 
                case 117: {
                    user1 = g.getOptarg();
                    break;
                }
                case 3: 
                case 112: {
                    password1 = g.getOptarg();
                    break;
                }
                case 4: 
                case 102: {
                    filename1 = g.getOptarg();
                    break;
                }
                case 5: 
                case 83: {
                    header1 = g.getOptarg();
                    break;
                }
                case 6: 
                case 115: {
                    try {
                        second1 = Integer.parseInt(g.getOptarg());
                    }
                    catch (NumberFormatException nfEx) {
                        logger.warn("-s option should use Integer");
                        System.exit(0);
                    }
                    continue block14;
                }
                case 7: 
                case 100: {
                    bDiv1 = true;
                }
            }
        }
        if (host1 == null || user1 == null || password1 == null || filename1 == null || header1 == null || second1 == 0) {
            LissClientReader.usage();
            System.exit(-1);
        }
        if ((stnCount = args.length - (ind = g.getOptind())) == 0) {
            LissClientReader.usage();
            System.exit(-1);
        }
        stnCodes1 = new String[stnCount];
        int i = ind;
        while (i < args.length) {
            stnCodes1[i - ind] = args[i];
            ++i;
        }
        if (bDiv1) {
            i = 0;
            while (i < stnCodes1.length) {
                new Thread(new LissClientReader(host1, user1, password1, String.valueOf(filename1) + "." + stnCodes1[i], second1, stnCodes1[i], String.valueOf(header1) + "." + stnCodes1[i])).start();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        } else {
            new Thread(new LissClientReader(host1, user1, password1, filename1, second1, stnCodes1, header1)).start();
        }
    }

    public static void usage() {
        System.out.println("Usage: java -cp Reader.jar [options] stn1 stn2 stn3 stn4 ... stnN");
        System.out.println();
        System.out.println("  -h, --host host           Server Name");
        System.out.println("  -u, --user user           userName");
        System.out.println("  -p, --password password   password");
        System.out.println("  -f, --filename filename   output file name");
        System.out.println("  -S, --Summary filename    Summary file name");
        System.out.println("  -s, --second second       seconds");
        System.out.println("  -d, --divide              one file per station");
        System.out.println("Examples: ");
        System.out.println("  java -jar Reader.jar -h 192.168.4.200 -u user -p dummy -f c:\\temp\\test -S headFile -s 60 -d  BJT SSE");
    }
}

