/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.util;

import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.port.event.MiniSeedPortEvent;
import cn.org.gddsn.liss.port.event.MiniSeedPortEventListener;
import cn.org.gddsn.liss.port.sss.SSSPort;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.util.Date;
import org.apache.log4j.Logger;

public class DelayRecord
implements MiniSeedPortEventListener {
    static Logger logger;
    private String host = null;
    private String user = null;
    private String password = null;
    private PrintWriter pw = null;
    private String filename = null;
    private int second = 0;
    private String[] stnCodes = null;
    private LissClient lissClient = null;
    private SSSPort cPort = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.util.DelayRecord");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public DelayRecord(String host, String user, String password, String filename, int second, String[] stnCodes) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.filename = filename;
        this.second = second;
        this.stnCodes = stnCodes;
        this.init();
        this.connectServer();
        if (stnCodes[0].equals("*")) {
            this.stnCodes = this.getAllStationList();
        }
        try {
            this.lissClient.quit();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        this.cPort = new SSSPort(host, 5000, user, password, stnCodes);
        this.cPort.addMiniSeedPortEventListener(this);
    }

    public DelayRecord(String host, String user, String password, String filename, int second, String stnCode) {
        this(host, user, password, filename, second, new String[]{stnCode});
    }

    public void init() {
        try {
            this.pw = new PrintWriter(new FileOutputStream(this.filename));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Date getSTDtime() {
        return new Date();
    }

    public String[] getAllStationList() {
        String[] stns = null;
        try {
            stns = this.lissClient.getAllStationCode();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return stns;
    }

    public void miniSeedEvent(MiniSeedPortEvent me) {
        GenericMiniSeedRecord gmsr = me.getGenericMiniSeedRecord();
        this.pw.print(String.valueOf(gmsr.getSequenceNumber()) + " / " + gmsr.getNetwork() + "/" + gmsr.getStation() + "/" + gmsr.getLocID() + "/" + gmsr.getChannel() + "\t");
        this.pw.print(gmsr.getStartTime() + "\t" + gmsr.getNumSamples() + "\t");
        System.err.print(String.valueOf(gmsr.getSequenceNumber()) + " / " + gmsr.getNetwork() + "/" + gmsr.getStation() + "/" + gmsr.getLocID() + "/" + gmsr.getChannel() + "\t");
        System.err.print(gmsr.getStartTime() + "\t" + gmsr.getNumSamples() + "\t");
        long delay = (gmsr.getStartTime().getTime() - this.getSTDtime().getTime()) / 1000L + (long)((int)((double)gmsr.getNumSamples() / gmsr.getSampleRate()));
        this.pw.println(delay);
        System.err.println(delay);
    }

    public void quit() {
        this.cPort.removeMiniSeedPortEventListener(this);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.pw.close();
    }

    public void connectServer() {
        try {
            this.lissClient = new LissClient(this.host, 5000);
            logger.info("NetSeisIP version is: " + this.lissClient.getVersion());
            this.lissClient.login(this.user, this.password);
        }
        catch (ConnectException cEx) {
            logger.warn("Caught ConnectionException : " + this.stnCodes[0] + "--" + cEx.getMessage());
        }
        catch (IOException ex) {
            logger.warn("Caught IOException: " + ex.getMessage());
        }
        catch (LissException ex) {
            logger.warn("Caught LissException: " + ex.getMessage());
        }
    }

    public static void main(String[] args) {
        int ind;
        int stnCount;
        int c;
        String host1 = null;
        String user1 = null;
        String password1 = null;
        String filename1 = null;
        int second1 = 0;
        boolean bDiv1 = false;
        String[] stnCodes1 = null;
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 0), new LongOpt("host", 1, null, 1), new LongOpt("user", 1, null, 2), new LongOpt("password", 1, null, 3), new LongOpt("fileName", 1, null, 4), new LongOpt("second", 1, null, 5)};
        Getopt g = new Getopt("Reader", args, "?h:u:p:f:s:d", longopts);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 0: 
                case 63: {
                    DelayRecord.usage();
                    System.exit(-1);
                    break;
                }
                case 1: 
                case 104: {
                    host1 = g.getOptarg();
                    break;
                }
                case 2: 
                case 117: {
                    user1 = g.getOptarg();
                    break;
                }
                case 3: 
                case 112: {
                    password1 = g.getOptarg();
                    break;
                }
                case 4: 
                case 102: {
                    filename1 = g.getOptarg();
                    break;
                }
                case 5: 
                case 115: {
                    try {
                        second1 = Integer.parseInt(g.getOptarg());
                        break;
                    }
                    catch (NumberFormatException nfEx) {
                        logger.error("-s option should use Integer");
                        System.exit(0);
                    }
                }
            }
        }
        if (host1 == null || user1 == null || password1 == null || filename1 == null || second1 == 0) {
            DelayRecord.usage();
            System.exit(-1);
        }
        if ((stnCount = args.length - (ind = g.getOptind())) == 0) {
            DelayRecord.usage();
            System.exit(-1);
        }
        stnCodes1 = new String[stnCount];
        int i = ind;
        while (i < args.length) {
            stnCodes1[i - ind] = args[i];
            ++i;
        }
        DelayRecord delayRecord = new DelayRecord(host1, user1, password1, filename1, second1, stnCodes1);
        try {
            Thread.sleep(second1 * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        delayRecord.quit();
        System.exit(0);
    }

    public static void usage() {
        System.out.println("Usage: java -cp DelayRecord.jar [options] stn1 stn2 stn3 stn4 ... stnN");
        System.out.println();
        System.out.println("  -h, --host host           Server Name");
        System.out.println("  -u, --user user           userName");
        System.out.println("  -p, --password password   password");
        System.out.println("  -f, --filename filename   logger file name");
        System.out.println("  -s, --second second       seconds");
        System.out.println("  stn can be use *");
        System.out.println("Examples: ");
        System.out.println("  java -jar DelayRecord.jar -h 192.168.4.200 -u user -p dummy -f c:\\temp\\test -s 3600  BJT SSE");
    }
}

