/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.util;

import cn.org.gddsn.liss.client.BufferInfo;
import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.client.LissInputStream;
import cn.org.gddsn.liss.client.LissTransferType;
import cn.org.gddsn.liss.message.LocationSMS;
import cn.org.gddsn.liss.message.MessageParseException;
import cn.org.gddsn.liss.message.Result;
import cn.org.gddsn.liss.message.SystemLog;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Date;
import org.apache.log4j.Logger;

public class CmdTest {
    static Logger logger;
    private LissClient lissClient;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.util.CmdTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public void connectServer(String host, int port, String user, String passwd) throws IOException, LissException {
        this.lissClient = new LissClient(host, port);
        this.lissClient.login(user, passwd);
        this.lissClient.setType(LissTransferType.BINARY);
        this.lissClient.setServerPassiveMode(true);
        this.lissClient.setRtServerPassiveMode(true);
        logger.info("Set transfer   type");
    }

    public void quit() throws IOException, LissException {
        this.lissClient.quit();
    }

    public void test_slst() throws IOException, LissException {
        String[] stns = this.lissClient.getAllStationCode();
        int i = 0;
        while (i < stns.length) {
            logger.info(stns[i]);
            ++i;
        }
    }

    public void test_geti(String stnCode) throws IOException, LissException {
        BufferInfo bufferInfo = this.lissClient.getBufferInfo(stnCode);
        logger.info(bufferInfo);
    }

    public void test_getm(String stnCode) throws IOException, LissException {
        BufferInfo bufferInfo = this.lissClient.getBufferInfo(stnCode);
        String[] seqs = bufferInfo.getAllSeqNumber();
        FileOutputStream fos = new FileOutputStream("c:/temp/try.mseed1");
        String[] stns = new String[1];
        String[] ids = new String[]{"000064"};
        stns[0] = stnCode;
        byte[] bytes = this.lissClient.getOneMiniSeedRecord(stns, stns);
        fos.write(bytes);
        fos.flush();
        fos.close();
    }

    public void test_setm(String stnCode) throws IOException, LissException {
        FileInputStream fis = null;
        byte[] bytes = new byte[512];
        int[] index = new int[]{40, 5, 7, 3, 2, 10, 9, 13, 1};
        index = new int[50];
        int i = 41;
        while (i > 0) {
            index[i] = (int)(50.0 * Math.random());
            --i;
        }
        index[0] = 0;
        i = 0;
        while (i < 1) {
            fis = new FileInputStream("c:/temp/try.mseed");
            fis.skip(index[i] * 512);
            fis.read(bytes);
            fis.close();
            this.lissClient.setOneMiniSeedRecord(bytes);
            GenericMiniSeedRecord genericMiniSeedRecord = GenericMiniSeedRecord.buildMiniSeedRecord(bytes);
            ++i;
        }
        this.test_geti(stnCode);
    }

    public void test_sndr(String nID) throws IOException, LissException {
        LocationSMS.Location_Frame lf = new LocationSMS.Location_Frame();
        lf.year = 2004;
        lf.ML = 2.1f;
        lf.lat = 1.0f;
        lf.lon = 20.0f;
        byte[] buf = LocationSMS.buildLocationSMSData(lf);
        Result res = Result.buildResult(true, 5, 65576, nID, "192.168.162.234", 0, new Date(), buf);
        Result[] ress = new Result[2];
        int i = 0;
        while (i < ress.length) {
            ress[i] = res;
            ++i;
        }
        this.lissClient.sendResult("LOC", ress);
    }

    public void test_stat_active(String nID) throws IOException, LissException {
        logger.info("1----");
        logger.info(this.lissClient.stat_active());
        logger.info("2----");
    }

    public void test_stat_log(String nID) throws IOException, LissException {
        logger.info("1----");
        logger.info(this.lissClient.stat_log());
        logger.info("2----");
    }

    public void test_sndr_xml(String nID) throws IOException, LissException {
        FileInputStream is = new FileInputStream("/tmp/location.xml");
        ByteArrayOutputStream baOs = new ByteArrayOutputStream(8192);
        byte[] buf = new byte[512];
        int n = 0;
        while ((n = is.read(buf)) > 0) {
            baOs.write(buf, 0, n);
        }
        byte[] xmlBuf = baOs.toByteArray();
        Result res = Result.buildResult(true, 5, 65576, nID, "192.168.162.234", 0, new Date(), xmlBuf);
        Result[] ress = new Result[1];
        int i = 0;
        while (i < ress.length) {
            ress[i] = res;
            ++i;
        }
        this.lissClient.sendResult("LOC", ress);
    }

    public void test_rcvr() throws IOException, LissException {
        LissInputStream monitorInputStream = this.lissClient.retrieveResult("MONITOR");
        Result res = null;
        try {
            while (true) {
                res = null;
                res = Result.buildResult(monitorInputStream);
                if (res == null || res.getType() != 131328) continue;
                try {
                    SystemLog lsms = new SystemLog(res);
                    logger.info("1111" + lsms.getLog() + "2222");
                }
                catch (MessageParseException mpEx) {
                    logger.warn(mpEx.getMessage(), mpEx);
                }
            }
        }
        catch (InterruptedIOException iioEx) {
            logger.warn(iioEx.getMessage());
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public void test_GMSR() throws IOException {
        FileInputStream fis = null;
        byte[] bytes = new byte[512];
        int[] index = new int[]{40, 5, 7, 3, 2, 10, 9, 13, 1};
        fis = new FileInputStream("c:/temp/try.mseed");
        fis.skip(index[0] * 512);
        fis.read(bytes);
        fis.close();
        GenericMiniSeedRecord gmsr1 = GenericMiniSeedRecord.buildMiniSeedRecord(bytes);
        fis = new FileInputStream("c:/temp/try.mseed");
        fis.skip(index[1] * 512);
        fis.read(bytes);
        fis.close();
        GenericMiniSeedRecord gmsr2 = GenericMiniSeedRecord.buildMiniSeedRecord(bytes);
        String s1 = gmsr1.getSequenceNumber();
        String s2 = gmsr2.getSequenceNumber();
        logger.info(String.valueOf(s1) + "  " + s2);
    }

    public String test_GETB() throws IOException, LissException {
        return this.lissClient.gets("*");
    }

    public void Test_GETI(String stnCode) throws IOException, LissException {
        BufferInfo binfo = this.lissClient.getBufferInfo(stnCode);
        logger.info(binfo);
    }

    public void test_GETL(String stnCode) throws IOException, LissException {
        String[] ids = this.lissClient.getLostIDInfo(stnCode);
        int i = 0;
        while (i < ids.length) {
            logger.info(ids[i]);
            ++i;
        }
    }

    public void test_GETN(String[] stnCode) throws IOException, LissException {
        String[] ids = this.lissClient.getBufferInfo(stnCode, true);
        int i = 0;
        while (i < ids.length) {
            logger.info(ids[i]);
            ++i;
        }
    }

    public void test_GETO(String[] stnCode) throws IOException, LissException {
        String[] ids = this.lissClient.getBufferInfo(stnCode, false);
        int i = 0;
        while (i < ids.length) {
            logger.info(ids[i]);
            ++i;
        }
    }

    public static void usage() {
        System.out.println("Usage: ");
        System.out.println("cn.org.gddsn.liss.client.CmdTest cmd remotehost port user password stnCode ");
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 441->445)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

