/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.udp;

import cn.org.gddsn.liss.port.AbstractMiniSeedPort;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class UDPPort
extends AbstractMiniSeedPort {
    static Logger logger;
    private transient Vector miniSeedPortEventListeners;
    private DatagramSocket dgSocket = null;
    protected String host = "127.0.0.1";
    protected int port = 5050;
    private String[] stationCode = null;
    private boolean bConnectOK = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.udp.UDPPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public UDPPort(String newServerName, int newSeedPort, String[] stationCode) {
        this.host = newServerName;
        this.port = newSeedPort;
        this.stationCode = stationCode;
        this.openPort();
    }

    public UDPPort() {
    }

    public void setStationCode(String[] stationCode) {
        this.stationCode = stationCode;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String[] getStationCode() {
        return this.stationCode;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public boolean accept(GenericMiniSeedRecord gmsr) {
        return true;
    }

    public boolean connectServer() {
        logger.info("Connecting " + this.host + ":" + this.port + " UDP... In UDP Port");
        try {
            InetAddress group = InetAddress.getByName(this.host);
            if (group.isMulticastAddress()) {
                MulticastSocket s = new MulticastSocket(this.port);
                s.joinGroup(group);
                this.dgSocket = s;
                logger.info("MultiCast:\t" + this.host + ":" + this.port);
            } else {
                this.dgSocket = new DatagramSocket(this.port);
                this.dgSocket.setSoTimeout(120000);
            }
            this.bConnectOK = true;
        }
        catch (IOException ioEx) {
            logger.warn("Failed I/O to " + this.host + ":" + this.port + " : " + ioEx);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.bConnectOK = false;
            return false;
        }
        logger.info("Connected " + this.host + ":" + this.port);
        return true;
    }

    public void closePort() {
        super.closePort();
        if (this.dgSocket != null) {
            this.dgSocket.disconnect();
            this.dgSocket.close();
        }
    }

    public byte[] readMiniSeedFrame() throws IOException {
        GenericMiniSeedRecord gmsRec = null;
        try {
            gmsRec = this.getCurrentMiniSeedData();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        if (gmsRec == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(gmsRec);
        }
        return gmsRec.getBytes();
    }

    public boolean connectOK() {
        return this.bConnectOK;
    }

    private GenericMiniSeedRecord getCurrentMiniSeedData() {
        if (!this.bConnectOK) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.connectServer()) {
                return null;
            }
        }
        GenericMiniSeedRecord gmsr = null;
        try {
            int blkSize = 512;
            byte[] buf = new byte[blkSize];
            DatagramPacket dp = new DatagramPacket(buf, blkSize);
            this.dgSocket.receive(dp);
            gmsr = GenericMiniSeedRecord.buildMiniSeedRecord(buf);
        }
        catch (SocketException sEx) {
            logger.warn(sEx.getMessage(), sEx);
            this.closePort();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException buf) {
                // empty catch block
            }
            this.bConnectOK = false;
            return null;
        }
        catch (InterruptedIOException iioEx) {
            this.closePort();
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException buf) {
                // empty catch block
            }
            this.bConnectOK = false;
            return null;
        }
        catch (IOException ioEx) {
            this.closePort();
            logger.warn(ioEx.getMessage(), ioEx);
            this.bConnectOK = false;
            return null;
        }
        if (gmsr == null) {
            this.bConnectOK = false;
        }
        if (gmsr.getSampleRate() != 0.0) {
            try {
                gmsr.decompress();
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage(), ex);
                try {
                    FileOutputStream fos = new FileOutputStream("decompressErr.bin");
                    fos.write(gmsr.getBytes());
                    fos.flush();
                    fos.close();
                }
                catch (IOException ioex1) {
                    logger.warn(ioex1.getMessage(), ioex1);
                }
                return null;
            }
            return gmsr;
        }
        return null;
    }

    public static void main(String[] args) {
        UDPPort UDPPort1 = new UDPPort("127.0.0.1", 5050, new String[1]);
    }
}

