/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.seedlink;

import cn.org.gddsn.liss.port.AbstractMiniSeedPort;
import cn.org.gddsn.liss.port.seedlink.SeedlinkClient;
import cn.org.gddsn.util.Log4jConfig;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SeedlinkPort
extends AbstractMiniSeedPort {
    static Logger logger;
    private SeedlinkClient seedlinkClient = null;
    private SeedlinkClient.Stream[] streams = null;
    private String selector = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.seedlink.SeedlinkPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public boolean connectServer() {
        String host = this.seedlinkClient.getHost();
        int port = this.seedlinkClient.getPort();
        logger.info("Connecting " + host + ":" + port + " Seedlink Server");
        try {
            this.seedlinkClient.connect();
            this.seedlinkClient.requestData(this.selector, this.streams);
        }
        catch (UnknownHostException uhEx) {
            this.closeSeedLinkClient();
            logger.warn("Unknown host " + host + " : " + uhEx);
            return false;
        }
        catch (InterruptedIOException iEx) {
            this.closeSeedLinkClient();
            logger.warn(String.valueOf(host) + ":" + port + ": Socket Timeout");
            return false;
        }
        catch (IOException ioEx) {
            this.closeSeedLinkClient();
            logger.warn("Failed I/O to " + host + ":" + port + " : " + ioEx);
            return false;
        }
        logger.info("Connected " + host + ":" + port);
        return true;
    }

    public boolean connectOK() {
        return this.seedlinkClient.isConnectionOK();
    }

    public byte[] readMiniSeedFrame() throws IOException {
        SeedlinkClient.SLPacket packet = this.getCurrentPacket();
        if (packet == null) {
            return null;
        }
        GenericMiniSeedRecord gmsRec = null;
        try {
            gmsRec = packet.getMiniSeedRecord();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        if (gmsRec == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(gmsRec);
        }
        return gmsRec.getBytes();
    }

    private void loopConnect() {
        while (!this.connectOK()) {
            logger.info("connecting ...");
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.connectServer()) continue;
            logger.info("connected..");
            break;
        }
    }

    private SeedlinkClient.SLPacket getCurrentPacket() {
        this.loopConnect();
        SeedlinkClient.SLPacket packet = null;
        try {
            packet = this.seedlinkClient.getSLpacket();
        }
        catch (Exception ex) {
            this.closeSeedLinkClient();
            logger.warn(ex.getMessage(), ex);
            packet = null;
        }
        return packet;
    }

    private void closeSeedLinkClient() {
        try {
            if (this.seedlinkClient != null) {
                this.seedlinkClient.close();
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public void setStreams(String streamStr) {
        StringTokenizer st = new StringTokenizer(streamStr, ",");
        this.streams = new SeedlinkClient.Stream[st.countTokens()];
        StringTokenizer st0 = null;
        int i = 0;
        while (i < this.streams.length) {
            st0 = new StringTokenizer(st.nextToken(), ":");
            this.streams[i] = new SeedlinkClient.Stream();
            String net_sta = st0.nextToken();
            int idx = net_sta.indexOf(95);
            this.streams[i].net = net_sta.substring(0, idx);
            this.streams[i].station = net_sta.substring(idx + 1);
            if (st0.hasMoreTokens()) {
                this.streams[i].selector = st0.nextToken();
            }
            ++i;
        }
    }

    public void setStreams(SeedlinkClient.Stream[] streams) {
        this.streams = streams;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void setSeedlinkClient(SeedlinkClient seedlinkClient) {
        this.seedlinkClient = seedlinkClient;
    }

    public String getSelector() {
        return this.selector;
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain("SeedlinkPort.properties");
        SeedlinkClient client = new SeedlinkClient("172.19.1.81", 18000);
        SeedlinkPort liss1Port1 = new SeedlinkPort();
        liss1Port1.setSeedlinkClient(client);
        SeedlinkClient.Stream[] streams = new SeedlinkClient.Stream[2];
        streams[0] = new SeedlinkClient.Stream();
        streams[0].net = "IA";
        streams[0].station = "WSI";
        streams[0].selector = null;
        streams[1] = new SeedlinkClient.Stream();
        streams[1].net = "IA";
        streams[1].station = "YOGI";
        streams[1].selector = null;
        liss1Port1.setSelector("BHZ BHE BHN");
        liss1Port1.setStreams(streams);
        liss1Port1.sendMiniSeedData();
    }

    public SeedlinkClient getSeedlinkClient() {
        return this.seedlinkClient;
    }
}

