/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.q330;

import cn.org.gddsn.liss.port.q330.Q330CommInf;
import cn.org.gddsn.liss.port.q330.Q330IO;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class Q330IOUDP
implements Q330CommInf {
    private DatagramSocket ctlSocket = null;
    private DatagramSocket dataSocket = null;
    private byte[] cmdRcv = new byte[1024];
    private byte[] dataRcv = new byte[1024];
    private int basePort = 5330;
    private int dataPort = 0;
    String host = null;
    private int timeout = 50000;
    private int ctlUDPPort = this.basePort + 2;
    private int dataUDPPort = this.basePort + 3;

    public void send(Q330IO.QDP qdp) throws IOException {
        byte[] buf = qdp.toByteArray();
        if (qdp.header.command.get() < 16) {
            DatagramPacket sdp = new DatagramPacket(buf, buf.length, InetAddress.getByName(this.host), this.dataUDPPort);
            this.dataSocket.send(sdp);
        } else {
            DatagramPacket sdp = new DatagramPacket(buf, buf.length, InetAddress.getByName(this.host), this.ctlUDPPort);
            this.ctlSocket.send(sdp);
        }
    }

    public Q330IO.QDP commandReceive() throws IOException {
        DatagramPacket rdp = new DatagramPacket(this.cmdRcv, this.cmdRcv.length);
        this.ctlSocket.receive(rdp);
        return Q330IO.QDP.create(this.cmdRcv);
    }

    public Q330IO.QDP dataReceive() throws IOException {
        DatagramPacket rdp = new DatagramPacket(this.dataRcv, this.dataRcv.length);
        this.dataSocket.receive(rdp);
        return Q330IO.QDP.create(this.dataRcv);
    }

    public Q330IO.QDP command(Q330IO.QDP qdp) throws IOException {
        byte[] buf = qdp.toByteArray();
        if (qdp.header.command.get() < 16) {
            DatagramPacket sdp = new DatagramPacket(buf, buf.length, InetAddress.getByName(this.host), this.dataUDPPort);
            this.dataSocket.send(sdp);
            DatagramPacket rdp = new DatagramPacket(this.dataRcv, this.dataRcv.length);
            this.dataSocket.receive(rdp);
            return Q330IO.QDP.create(this.dataRcv);
        }
        DatagramPacket sdp = new DatagramPacket(buf, buf.length, InetAddress.getByName(this.host), this.ctlUDPPort);
        this.ctlSocket.send(sdp);
        DatagramPacket rdp = new DatagramPacket(this.cmdRcv, this.cmdRcv.length);
        this.ctlSocket.receive(rdp);
        return Q330IO.QDP.create(this.cmdRcv);
    }

    public void connect() throws IOException {
        this.ctlSocket = new DatagramSocket(this.ctlUDPPort);
        this.ctlSocket.setSoTimeout(this.timeout);
        this.dataSocket = new DatagramSocket(this.dataUDPPort);
        this.dataSocket.setSoTimeout(this.timeout);
    }

    public int getBasePort() {
        return this.basePort;
    }

    public void setBasePort(int basePort) {
        this.basePort = basePort;
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public void setDataPort(int dataPort) {
        this.dataPort = dataPort;
        this.ctlUDPPort = this.basePort + dataPort * 2 + 2;
        this.dataUDPPort = this.basePort + dataPort * 2 + 3;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

