/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.mr2002;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class MR2002IO {
    static Logger logger;
    private static final int[] frameHead;
    private int headLen = frameHead.length;
    private int[] head = new int[this.headLen];
    private final String ACK = "(SdACK++)";
    private int tempByte;
    private boolean newFrameFlag = false;
    private boolean reFindHead = true;
    private int[] dataX = new int[800];
    private int[] dataY = new int[800];
    private int[] dataZ = new int[800];
    public int sampRate = 0;
    public short startSample;
    public long time;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.mr2002.MR2002IO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        frameHead = new int[]{44, 13};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readMR2002Data(DataInputStream dIn) throws IOException {
        int[] tempData = new int[3];
        try {
            if (this.reFindHead) {
                logger.debug("find frame header flage!");
                if (!this.hasEnoughData(dIn)) {
                    return -1;
                }
                if (!this.findFrameHead(dIn)) {
                    return -1;
                }
                this.setReFindHead(false);
                logger.debug("find new data frame!");
            }
            this.time = this.readHeaderTime(dIn);
            if (logger.isDebugEnabled()) {
                String theTime = this.getStringDate(this.time);
                logger.debug(theTime);
            }
            if (this.time == -1L) {
                this.setReFindHead(true);
                return -1;
            }
            this.startSample = dIn.readShort();
            this.tempByte = dIn.readByte();
            logger.debug("Start Sample:" + this.startSample);
            if (this.tempByte != 44) {
                logger.warn("The byte after start sample is not 0x2C but is:" + Integer.toHexString(this.tempByte));
                this.setReFindHead(true);
                return -1;
            }
            MR2002IO.readMessage(dIn);
            MR2002IO.readMessage(dIn);
            int i = 0;
            while (true) {
                if (i >= this.dataX.length) {
                    return this.sampRate;
                }
                tempData = this.readOneSampleXYZ(dIn);
                if (this.newFrameFlag) {
                    this.sampRate = i;
                    this.setNewFrameFlag(false);
                    logger.debug("The sample rate is: " + i);
                    return this.sampRate;
                }
                if (tempData == null) {
                    logger.debug("read a bad Frame! find frame head again!");
                    this.setReFindHead(true);
                    return -1;
                }
                this.dataX[i] = tempData[0];
                this.dataY[i] = tempData[1];
                this.dataZ[i] = tempData[2];
                if (logger.isDebugEnabled()) {
                    logger.debug(String.valueOf(this.dataX[i]) + " " + this.dataY[i] + " " + this.dataZ[i] + " i=" + i);
                }
                ++i;
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx);
        }
        return this.sampRate;
    }

    public void sendACK(OutputStream outs) throws IOException {
        try {
            outs.write("(SdACK++)".getBytes());
            logger.debug("Send ACK Message:(SdACK++)");
        }
        catch (IOException ioex) {
            logger.warn(ioex);
        }
    }

    private long readHeaderTime(DataInputStream dIn) {
        int second;
        int minute;
        int hour;
        int year;
        int month;
        int day;
        block5: {
            block4: {
                try {
                    this.tempByte = dIn.read();
                    day = this.BCD2INT(this.tempByte);
                    this.tempByte = dIn.read();
                    month = this.BCD2INT(this.tempByte) - 1;
                    this.tempByte = dIn.read();
                    year = this.BCD2INT(this.tempByte) + 2000;
                    this.tempByte = dIn.read();
                    if (this.tempByte == 44) break block4;
                    logger.warn("the byte after year is not 0x2C but is:" + Integer.toHexString(this.tempByte));
                    return -1L;
                }
                catch (IOException ioEx) {
                    logger.warn(ioEx);
                    return -1L;
                }
            }
            this.tempByte = dIn.read();
            hour = this.BCD2INT(this.tempByte);
            this.tempByte = dIn.read();
            minute = this.BCD2INT(this.tempByte);
            this.tempByte = dIn.read();
            second = this.BCD2INT(this.tempByte);
            this.tempByte = dIn.read();
            if (this.tempByte == 44) break block5;
            logger.warn("the byte after second is not 0x2C but is:" + Integer.toHexString(this.tempByte));
            return -1L;
        }
        GregorianCalendar gcTime = new GregorianCalendar(year, month, day, hour, minute, second);
        gcTime.setTimeZone(TimeZone.getTimeZone("UTC"));
        return gcTime.getTime().getTime() / 1000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] readOneSampleXYZ(DataInputStream dIn) {
        int[] sample = new int[3];
        try {
            int i = 0;
            while (true) {
                if (i >= 3) {
                    int commaByte = dIn.read();
                    if (commaByte == 44) return sample;
                    logger.warn("the byte after three samples is not 0x2C but is:" + Integer.toHexString(this.tempByte));
                    return null;
                }
                int byte1 = dIn.read();
                if (byte1 == 13 && i == 0) {
                    this.setNewFrameFlag(true);
                    logger.debug("new frame begin!");
                    return null;
                }
                if (byte1 == 69 | byte1 == 42) {
                    byte1 = dIn.read();
                }
                if (byte1 == 40) {
                    while ((byte1 = dIn.read()) == 41) {
                    }
                    byte1 = dIn.read();
                }
                int byte2 = dIn.read();
                int byte3 = dIn.read();
                sample[i] = this.bytes2Sample(byte1, byte2, byte3);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sample;
    }

    private int bytes2Sample(int byte1, int byte2, int byte3) {
        int byte0 = 0;
        int sample = byte0 | byte1 << 16 | byte2 << 8 | byte3;
        return sample &= 0xFFFFF;
    }

    private boolean calculateCheckSum(int byte1, int byte2, int byte3) {
        int tempBytes = byte1 << 16 | byte2 << 8 | byte3;
        int sum = 0;
        int i = 0;
        while (i < 20) {
            if ((tempBytes & 1) == 1) {
                ++sum;
            }
            tempBytes >>>= 1;
            ++i;
        }
        return sum == byte1 >>> 4;
    }

    private void setNewFrameFlag(boolean flag) {
        this.newFrameFlag = flag;
    }

    private void setReFindHead(boolean flag) {
        this.reFindHead = flag;
    }

    private int BCD2INT(int sourceByte) {
        int[] temp = new int[]{sourceByte & 0xF, sourceByte >> 4 & 0xF};
        int result = temp[1] * 10 + temp[0];
        return result;
    }

    private static String readMessage(DataInputStream dIs) throws IOException {
        byte[] buf = new byte[1024];
        int i = 0;
        i = 0;
        while (i < 2048) {
            buf[i] = dIs.readByte();
            if (buf[i] == 44) break;
            ++i;
        }
        String recStr = new String(buf, 0, i);
        return recStr;
    }

    public String getStringDate(long theTime) {
        Date date = new Date(theTime * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(date);
    }

    public int getSampleRate() {
        return this.sampRate;
    }

    public int[] getDataX() {
        return this.dataX;
    }

    public int[] getDataY() {
        return this.dataY;
    }

    public int[] getDataZ() {
        return this.dataZ;
    }

    public long getTime() {
        return this.time;
    }

    private boolean findFrameHead(DataInputStream dIn) throws IOException {
        int ret;
        int i = 0;
        while (i < this.headLen) {
            this.head[i] = 0;
            ++i;
        }
        int firstIdx = 0;
        boolean found = false;
        while ((ret = this.forceRead(dIn)) != -1) {
            this.head[firstIdx % this.headLen] = ret;
            int i2 = firstIdx;
            while (i2 < firstIdx + this.headLen) {
                if (this.head[(i2 + 1) % this.headLen] != frameHead[i2 - firstIdx]) {
                    found = false;
                    break;
                }
                found = true;
                ++i2;
            }
            if (found) break;
            ++firstIdx;
            firstIdx %= this.headLen;
        }
        if (!found) {
            logger.warn("Has enough data to read, but I can't found Frame Header \"0x2C 0D\".");
        }
        return found;
    }

    private boolean hasEnoughData(DataInputStream dIn) throws IOException {
        int delay = 13000;
        int count = 0;
        while (delay != 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (dIn.available() >= 1) break;
            if (count++ > 12998 && dIn.available() == 0) {
                logger.warn("waite 13 seconds had not enough Data");
                return false;
            }
            --delay;
        }
        delay = 13000 - delay;
        return true;
    }

    private int forceRead(DataInputStream in) throws IOException {
        while (in.available() < 1) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return in.read();
    }
}

