/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.guralp;

import cn.org.gddsn.liss.port.guralp.GuralpPacket;
import cn.org.gddsn.util.Log4jConfig;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.log4j.Logger;

public class GuralpUDPTunnelClient {
    static Logger logger;
    private String host;
    private int port;
    private long count = 0L;
    private Socket socket;
    private DataOutputStream os;
    private DataInputStream is;
    private static String GCFPING;
    private static String GCFSEND;
    private static String GCFSENDB;
    private static String GCFSENDL;
    private static String GCFACKN;
    private static String GCFNOSV;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.guralp.GuralpUDPTunnelClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        GCFPING = "GCFPING\u0000";
        GCFSEND = "GCFSEND\u0000";
        GCFSENDB = "GCFSEND:B\u0000";
        GCFSENDL = "GCFSEND:L\u0000";
        GCFACKN = "GCFACKN\u0000";
        GCFNOSV = "GCFNOSV\u0000";
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void connect() throws IOException {
        this.socket = new Socket(this.host, this.port);
        this.socket.setSoTimeout(120000);
        this.os = new DataOutputStream(this.socket.getOutputStream());
        this.is = new DataInputStream(this.socket.getInputStream());
        this.count = 0L;
    }

    public byte[] toByteArray(String command) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        byte[] buf = command.getBytes();
        dos.writeShort(buf.length);
        dos.write(buf);
        dos.close();
        return baos.toByteArray();
    }

    public boolean ping() {
        boolean bret = false;
        try {
            this.os.write(this.toByteArray(GCFPING));
            this.os.flush();
            int length = this.is.readUnsignedShort();
            byte[] buf = new byte[length];
            this.is.readFully(buf);
            return GCFACKN.equals(new String(buf, 0, buf.length));
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
            return bret;
        }
    }

    public GuralpPacket getGuralpPacket() throws IOException {
        try {
            byte[] buf;
            int length;
            if (this.count++ % 50L == 0L) {
                this.os.write(this.toByteArray(GCFSEND));
                this.os.flush();
            }
            GuralpPacket gp = null;
            do {
                length = this.is.readUnsignedShort();
                buf = new byte[length];
                this.is.readFully(buf);
                if (length >= 1024) continue;
                logger.debug("Receive " + new String(buf, 0, buf.length));
            } while (length < 1024 || buf[14] == 0);
            gp = new GuralpPacket(buf, buf.length);
            return gp;
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
            throw ex;
        }
    }

    public void close() throws IOException {
        this.os.close();
        this.is.close();
        this.socket.close();
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("GuarlpUDPClient.properties");
        GuralpUDPTunnelClient client = new GuralpUDPTunnelClient();
        client.setHost("192.168.168.131");
        client.setPort(1234);
        client.connect();
        FileOutputStream fos = new FileOutputStream("/tmp/gcf.hex");
        int n = Integer.MAX_VALUE;
        GuralpPacket gp = null;
        while (n-- != 0) {
            try {
                gp = client.getGuralpPacket();
                if (gp == null) continue;
                System.out.println(gp);
                fos.write(gp.getBuf(), 0, gp.getLength());
            }
            catch (SocketTimeoutException ex) {
                ex.printStackTrace();
            }
        }
        fos.close();
        client.close();
    }
}

