/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.guralp;

import cn.org.gddsn.liss.port.guralp.GuralpCalibration;
import cn.org.gddsn.liss.port.guralp.GuralpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;

public class GuralpTCPClient {
    static Logger logger;
    public static final int CMD_TCP = 249;
    public static final int CMD_VERSION = 252;
    public static final int CMD_OLDEST = 254;
    public static final int CMD_BLOCK = 255;
    String host;
    int port;
    Socket socket;
    DataOutputStream dos;
    DataInputStream dis;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.guralp.GuralpTCPClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public GuralpTCPClient(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
    }

    public void connect() throws IOException {
        this.socket = new Socket(this.host, this.port);
        this.socket.setSoTimeout(120000);
        this.dos = new DataOutputStream(this.socket.getOutputStream());
        this.dis = new DataInputStream(this.socket.getInputStream());
    }

    public int getOldestSerailNumber() throws IOException {
        this.dos.write(254);
        return this.dis.readShort() & 0xFFFF;
    }

    public GuralpPacket getBlock(int serial) throws IOException {
        this.dos.writeByte(255);
        this.dos.writeShort(serial);
        byte[] buf = new byte[2048];
        int size = this.dis.read(buf);
        GuralpPacket gp = new GuralpPacket(buf, size);
        return gp;
    }

    public void Caliration(int calType, int unitType, short[] minute, short[] amplitude, short[] unitValue) throws IOException {
        int i = 0;
        while (i < minute.length) {
            this.connect();
            GuralpCalibration cali = new GuralpCalibration(this.dis, this.dos);
            cali.setCaliType(calType);
            cali.setUnitType(unitType);
            cali.setAmplitude(amplitude[i]);
            cali.setMinute(minute[i]);
            cali.setHz(unitValue[i]);
            short status = cali.calibration();
            cali.bfr.close();
            cali.bfw.close();
            this.dos.close();
            this.socket.close();
            if (status == 1) {
                logger.info(cali + " complete.");
            } else if (status == 2) {
                logger.warn("equipment system has calibration in progress,it wil be terminated");
            } else {
                if (status == -1) {
                    logger.warn("Exception:Send CMD_FLAG,but the respond unkonw");
                    break;
                }
                if (status == -2) {
                    logger.warn("Exception:Send calibration command,but the command underfind");
                    break;
                }
            }
            try {
                Thread.sleep(minute[i] * 60000 + 10000);
                if (status == 1 | status == 2) {
                    logger.warn(String.valueOf(cali.getParString()) + "completed!");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.info("sleep done");
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        GuralpTCPClient client = new GuralpTCPClient("192.168.168.155", 12345);
        short[] minute = new short[]{3, 4, 3, 2, 1};
        short[] amplitude = new short[]{20, 30, 40, 50, 60};
        short[] unitValue = new short[]{50, 40, 30, 20, 10};
        client.Caliration(0, 1, minute, amplitude, unitValue);
        logger.info("Calibration all completed!");
        System.out.println("Calibration all completed!");
    }

    public static void main0(String[] args) throws Exception {
        FileOutputStream fos = new FileOutputStream("/tmp/gcf.hex");
        int n = Integer.MAX_VALUE;
        GuralpTCPClient client = new GuralpTCPClient("192.168.168.140", 12345);
        client.connect();
        while (n-- != 0) {
            int sn = client.getOldestSerailNumber();
            GuralpPacket gp = client.getBlock(sn);
            fos.write(gp.getBuf(), 0, gp.getLength());
            System.out.println(gp);
            Thread.sleep(500L);
        }
        fos.close();
    }
}

