/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.guralp;

import cn.org.gddsn.liss.port.ComServPortInf;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.MiniSeedStreamEncoder;
import cn.org.gddsn.liss.port.SiteInfo;
import cn.org.gddsn.liss.port.guralp.GuralpPacket;
import cn.org.gddsn.liss.port.guralp.GuralpUDPClient;
import cn.org.gddsn.util.Log4jConfig;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.IOException;
import org.apache.log4j.Logger;

public class GuralpPort
implements ComServPortInf,
DataFrameInput {
    static Logger logger;
    GuralpUDPClient guarlpUDPClient = null;
    private static final String[] compCode;
    private SiteInfo siteInfo = null;
    private String[] chanDis;
    private int data_type = 6;
    private long caliTime = -1L;
    private int caliFlag = 0;
    private MiniSeedStreamEncoder msis;
    private LogLostManager logLostManager = new LogLostManager();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.guralp.GuralpPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        compCode = new String[]{"Z", "E", "N", "X", "C"};
    }

    public void open() {
    }

    public boolean prepareProcess() {
        return true;
    }

    public boolean connect() throws IOException {
        this.openComServPort();
        return true;
    }

    public void openComServPort() throws IOException {
        logger.info("close GuralpClient.");
        this.close();
        logger.info("Opening GuralpClient.");
        this.guarlpUDPClient.connect();
        this.msis = new MiniSeedStreamEncoder(this);
        logger.info("Opened GuralpPort.");
    }

    public byte[] readMiniSeedFrame() throws IOException {
        byte[] buf = this.msis.readMiniSeedRecord();
        return buf;
    }

    public void setDataType(int data_type) {
        this.data_type = data_type;
    }

    public void setChannelDiscription(String[] chanDis) {
        this.chanDis = chanDis;
        this.siteInfo = new SiteInfo(chanDis, compCode);
    }

    public void setMaxCompressSamples(int maxSamples) {
        this.msis.setMaxSamplesInMiniSeed(maxSamples);
    }

    public void close() {
        if (this.guarlpUDPClient != null) {
            this.guarlpUDPClient.close();
        }
    }

    public DataFrame[] readDataFrame() throws IOException {
        GuralpPacket gp = this.guarlpUDPClient.getGuralpPacket();
        if (gp == null) {
            return null;
        }
        if (gp.getSampleRate() < 10) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(gp);
        }
        String streamId = gp.getStreamId();
        String comp = streamId.substring(4, 5).toUpperCase();
        int tap = Integer.parseInt(streamId.substring(5));
        DataFrame[] dfs = new DataFrame[]{new DataFrame()};
        dfs[0].time = gp.getStartTime().getTime() / 1000L;
        dfs[0].ns = 0L;
        dfs[0].siteID = tap % 2;
        dfs[0].setChannelLocator(this.siteInfo.getChannelLocator(dfs[0].siteID, comp));
        if (comp.equals(compCode[4])) {
            this.caliFlag = 3;
            this.caliTime = dfs[0].time;
            logger.info("Station " + dfs[0].getChannelLocator() + " detect calibration.");
        } else if (Math.abs(this.caliTime - dfs[0].time) > 60L) {
            this.caliFlag = 0;
            this.caliTime = -1L;
        }
        dfs[0].flag = this.caliFlag;
        dfs[0].sampRate = gp.getSampleRate();
        dfs[0].data = gp.getData();
        if (logger.isDebugEnabled()) {
            logger.debug(dfs[0]);
        }
        if (this.logLostManager != null && dfs != null) {
            int i = 0;
            while (i < dfs.length) {
                LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
                timeInfo.date = dfs[i].time * 1000L + dfs[i].ns / 1000000L;
                timeInfo.length = dfs[i].data.length * 1000 / dfs[i].sampRate;
                this.logLostManager.log(dfs[i].getChannelLocator(), timeInfo);
                ++i;
            }
        }
        if (comp.equals(compCode[4]) || comp.equals(compCode[3])) {
            return null;
        }
        return dfs;
    }

    public int getDataTpe() {
        return this.data_type;
    }

    public String[] getChannelDiscription() {
        return this.chanDis;
    }

    public void setGuarlpUDPClient(GuralpUDPClient guarlpUDPClient) {
        this.guarlpUDPClient = guarlpUDPClient;
    }

    public String getHost() {
        return this.guarlpUDPClient.getHost();
    }

    public int getPort() {
        return this.guarlpUDPClient.getPort();
    }

    public void setLogLostManager(LogLostManager logLostManager) {
        this.logLostManager = logLostManager;
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain("GuralpPort.properties");
        GuralpPort csPort = null;
        String[] cDis = new String[]{"GD/TST/00/BHZ:BHE:BHN"};
        if (args.length < 3) {
            logger.debug("Usage:\n java cn.org.gddsn.liss.port.GuralpPort host port chanDisc");
            System.exit(-1);
        } else {
            GuralpUDPClient client = new GuralpUDPClient();
            client.setHost(args[0]);
            client.setPort(Integer.parseInt(args[1]));
            csPort = new GuralpPort();
            csPort.setGuarlpUDPClient(client);
            cDis = new String[args.length - 2];
            int i = 2;
            while (i < args.length) {
                cDis[i - 2] = args[i];
                ++i;
            }
            csPort.setChannelDiscription(cDis);
        }
        try {
            csPort.openComServPort();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        DataFrame[] dfs = null;
        byte[] buf = null;
        while (true) {
            if ((buf = csPort.readMiniSeedFrame()) != null) {
                GenericMiniSeedRecord gmsr = GenericMiniSeedRecord.buildMiniSeedRecord(buf);
                logger.info(gmsr);
                continue;
            }
            logger.error("Could not read one miniseed packet");
        }
    }
}

