/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.guralp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class GuralpComPacket {
    static Logger logger;
    private byte[] buf;
    private int length;
    private String systemId;
    private String streamId;
    private Date startTime;
    private int sampleRate;
    private int sampleNumber;
    private int[] data;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.guralp.GuralpComPacket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public GuralpComPacket(byte[] buf, int length) {
        this.buf = buf;
        this.length = length;
        this.decode();
    }

    public int getSampleNumber() {
        return this.sampleRate;
    }

    public int[] getData() {
        return this.data;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    private int decode() {
        DataInputStream di;
        int i;
        int checkSample;
        block14: {
            checkSample = 0;
            i = 1;
            di = new DataInputStream(new ByteArrayInputStream(this.buf, 0, this.buf.length));
            this.systemId = Long.toString((long)di.readInt() & 0xFFFFFFFFL, 36);
            this.streamId = Long.toString((long)di.readInt() & 0xFFFFFFFFL, 36);
            int date_code = di.readInt();
            long gcf_seconds = date_code & 0x1FFFF;
            long gcf_days = date_code >> 17 & Short.MAX_VALUE;
            GregorianCalendar cal = new GregorianCalendar(1989, 10, 17, 0, 0, 0);
            cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.startTime = new Date(cal.getTime().getTime() / 1000L * 1000L + gcf_days * 3600L * 24L * 1000L + gcf_seconds * 1000L);
            di.skipBytes(1);
            this.sampleRate = di.readByte() & 0xFF;
            if (this.sampleRate >= 10) break block14;
            return -1;
        }
        try {
            int compressCode = di.readByte() & 0xFF;
            if (logger.isDebugEnabled()) {
                logger.debug("compress code:" + compressCode);
            }
            int num_records = di.readByte() & 0xFF;
            this.sampleNumber = compressCode * num_records;
            this.data = new int[this.sampleNumber];
            this.data[0] = di.readInt();
            switch (compressCode) {
                case 1: {
                    int difference = di.readInt();
                    int k = 1;
                    while (k < num_records) {
                        difference = di.readInt();
                        this.data[i] = this.data[i - 1] + difference;
                        ++i;
                        ++k;
                    }
                    break;
                }
                case 2: {
                    short difference = di.readShort();
                    int k = 1;
                    while (k < num_records * 2) {
                        difference = di.readShort();
                        this.data[i] = this.data[i - 1] + difference;
                        ++i;
                        ++k;
                    }
                    break;
                }
                case 4: {
                    byte difference = di.readByte();
                    int k = 1;
                    while (k < num_records * 4) {
                        difference = di.readByte();
                        this.data[i] = this.data[i - 1] + difference;
                        ++i;
                        ++k;
                    }
                    break;
                }
            }
            checkSample = di.readInt();
            di.close();
            if (logger.isDebugEnabled()) {
                logger.debug("checkSample: " + checkSample);
                logger.debug("data[i-1]:" + this.data[i - 1]);
            }
        }
        catch (IOException ex) {
            logger.warn("IOException:" + ex);
        }
        if (checkSample == this.data[i - 1]) {
            this.sampleNumber = i;
            return this.sampleNumber;
        }
        this.sampleNumber = -1;
        logger.warn("check sample not equal data[i-1],maybe decode error!");
        return -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("systemId=" + this.systemId + "/");
        sb.append("streamId=" + this.streamId + "/");
        sb.append("startTime=" + this.startTime + "/");
        sb.append("sampleRate=" + this.sampleRate + "/");
        sb.append("sampleNumber=" + this.sampleNumber + "/");
        return sb.toString();
    }
}

