/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.geotech;

import cn.org.gddsn.util.Log4jConfig;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;

public class Smart24IO {
    static Logger logger;
    public static final int FRAME_TYPE_CONNECTION_REQUEST = 1;
    public static final int FRAME_TYPE_CONNECTION_RESPONSE = 2;
    public static final int FRAME_TYPE_OPTION_REQUEST = 3;
    public static final int FRAME_TYPE_OPTION_RESPONSE = 4;
    public static final int FRAME_TYPE_DATA = 5;
    public static final int FRAME_TYPE_ACKNACK = 6;
    public static final int FRAME_TYPE_ALERT = 7;
    public static final int FRAME_TYPE_COMMAND_REQUEST = 8;
    public static final int FRAME_TYPE_COMMAND_RESPONSE = 9;
    public static final int FRAME_TYPE_ENCAPSULATION_FRAME = 13;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.geotech.Smart24IO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public CDFrameCommandResponse cmd(DataInputStream is, DataOutputStream os, String user, String password, String cmd) throws IOException {
        CDFrameCommandRequest req = new CDFrameCommandRequest();
        String rcmd = cmd;
        if (cmd.indexOf(63) == -1) {
            rcmd = "USR " + user + "\r\nPSW " + password + "\r\n" + cmd;
        }
        byte[] buf = rcmd.getBytes();
        req.commandSize = buf.length;
        req.command = buf;
        return this.cmd(is, os, req);
    }

    public CDFrameCommandResponse cmd(DataInputStream is, DataOutputStream os, CDFrameCommandRequest req) throws IOException {
        CDFrameHeader header = new CDFrameHeader();
        header.type = 8;
        header.trailerOffset = header.getFrameLength() + req.getFrameLength();
        CDFrameTrailer trailer = new CDFrameTrailer();
        trailer.authValue = new byte[0];
        if (logger.isDebugEnabled()) {
            logger.debug("Sendt Request: " + req);
        }
        header.write(os);
        req.write(os);
        trailer.write(os);
        os.flush();
        CDFrameHeader rspHeader = CDFrameHeader.read(is);
        CDFrameCommandResponse response = CDFrameCommandResponse.read(is);
        CDFrameTrailer rspTrailer = CDFrameTrailer.read(is);
        if (logger.isDebugEnabled()) {
            logger.debug("Received Response: " + response);
        }
        return response;
    }

    public CDFrame readCDFrame(DataInputStream is) throws IOException {
        CDFrame cdframe = new CDFrame();
        CDFrameHeader header = CDFrameHeader.read(is);
        cdframe.setCDFrameHeader(header);
        CDPart cdPart = null;
        switch (header.type) {
            case 1: 
            case 2: {
                cdPart = CDFrameConnection.read(is);
                break;
            }
            case 3: 
            case 4: {
                cdPart = CDFrameOption.read(is);
                break;
            }
            case 5: {
                cdPart = CDFrameData.read(is);
                break;
            }
            case 6: {
                cdPart = CDFrameAnknack.read(is);
                break;
            }
            case 7: {
                cdPart = CDFrameAlert.read(is);
                break;
            }
            case 8: {
                cdPart = CDFrameCommandRequest.read(is);
                break;
            }
            case 9: {
                cdPart = CDFrameCommandResponse.read(is);
                break;
            }
            case 13: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Frame Type In Header Unknown!");
            }
        }
        cdframe.setCDFrameBody(cdPart);
        cdframe.setCDFrameTrailer(CDFrameTrailer.read(is));
        if (logger.isDebugEnabled()) {
            logger.debug("Read CD Frame: " + cdframe);
        }
        return cdframe;
    }

    public void writeCDFrame(DataOutputStream os, CDFrame cdframe) throws IOException {
        cdframe.getCDFrameHeader().write(os);
        CDPart cdPart = cdframe.getCDFrameBody();
        switch (cdframe.getCDFrameHeader().type) {
            case 1: 
            case 2: {
                ((CDFrameConnection)cdPart).write(os);
                break;
            }
            case 3: 
            case 4: {
                ((CDFrameOption)cdPart).write(os);
                break;
            }
            case 5: {
                ((CDFrameData)cdPart).write(os);
                break;
            }
            case 6: {
                ((CDFrameAnknack)cdPart).write(os);
                break;
            }
            case 7: {
                ((CDFrameAlert)cdPart).write(os);
                break;
            }
            case 8: {
                ((CDFrameCommandRequest)cdPart).write(os);
                break;
            }
            case 9: {
                ((CDFrameCommandResponse)cdPart).write(os);
                break;
            }
            case 13: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Frame Type In Header Unknown!");
            }
        }
        cdframe.getCDFrameTrailer().write(os);
        if (logger.isDebugEnabled()) {
            logger.debug("write CD Frame: " + cdframe);
        }
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("Smart24IO.properties");
        String host = "192.168.168.151";
        int port = 8000;
        Socket socket = new Socket(host, port);
        socket.setSoTimeout(60000);
        DataInputStream ais = new DataInputStream(socket.getInputStream());
        DataOutputStream aos = new DataOutputStream(socket.getOutputStream());
        Smart24IO smart24 = new Smart24IO();
        String user = "smart24";
        String password = "changeme";
        CDFrameCommandResponse rsp = smart24.cmd(ais, aos, user, password, "CDE 1,?\r\n");
        rsp = smart24.cmd(ais, aos, user, password, "CDE 1,1\r\n");
        System.out.println(rsp);
        ais.close();
        aos.close();
        socket.close();
    }

    public static class CDFrame {
        public CDFrameHeader header;
        public CDPart frameBody;
        public CDFrameTrailer trailer;

        public CDFrameHeader getCDFrameHeader() {
            return this.header;
        }

        public void setCDFrameHeader(CDFrameHeader aheader) {
            this.header = aheader;
        }

        public CDFrameTrailer getCDFrameTrailer() {
            return this.trailer;
        }

        public void setCDFrameTrailer(CDFrameTrailer atrailer) {
            this.trailer = atrailer;
        }

        public CDPart getCDFrameBody() {
            return this.frameBody;
        }

        public void setCDFrameBody(CDPart aframeBody) {
            this.frameBody = aframeBody;
        }

        public String toString() {
            return String.valueOf(this.header.toString()) + this.frameBody.toString() + this.trailer.toString();
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            this.header.write(dos);
            this.frameBody.write(dos);
            this.trailer.write(dos);
            dos.flush();
            dos.close();
            return bos.toByteArray();
        }
    }

    public static class CDFrameAlert
    extends CDPart {
        public int msgSize;
        public byte[] message;

        public String toString() {
            return new String(this.message).trim();
        }

        public void write(DataOutputStream os) throws IOException {
            os.writeInt(this.msgSize);
            os.write(this.message);
            CDPart.writePad(os, this.msgSize);
        }

        public static CDFrameAlert read(DataInputStream is) throws IOException {
            CDFrameAlert alert = new CDFrameAlert();
            alert.msgSize = is.readInt();
            alert.message = new byte[alert.msgSize];
            is.readFully(alert.message);
            CDPart.readPad(is, alert.msgSize);
            return alert;
        }
    }

    public static class CDFrameAnknack
    extends CDPart {
        public byte[] setAcked = new byte[20];
        public long lowestSeq;
        public long highestSeq;
        public int gapCount;
        public Gap[] gaps;

        public void write(DataOutputStream os) throws IOException {
            os.write(this.setAcked);
            os.writeLong(this.lowestSeq);
            os.writeLong(this.highestSeq);
            os.writeInt(this.gapCount);
            int i = 0;
            while (i < this.gapCount) {
                os.writeLong(this.gaps[i].begin);
                os.writeLong(this.gaps[i].end);
                ++i;
            }
        }

        public static CDFrameAnknack read(DataInputStream is) throws IOException {
            CDFrameAnknack anknack = new CDFrameAnknack();
            is.readFully(anknack.setAcked);
            anknack.lowestSeq = is.readLong();
            anknack.highestSeq = is.readLong();
            anknack.gapCount = is.readInt();
            int i = 0;
            while (i < anknack.gapCount) {
                anknack.gaps[i].begin = is.readLong();
                anknack.gaps[i].end = is.readLong();
                ++i;
            }
            return anknack;
        }
    }

    public static class CDFrameCommandRequest
    extends CDPart {
        public byte[] stationName = new byte[8];
        public byte[] location = new byte[12];
        public byte[] timestamp = new byte[20];
        public int commandSize;
        public byte[] command;

        public int getFrameLength() {
            return 44 + CDPart.getPadLength(this.command.length);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Request Station: " + new String(this.stationName).trim() + "\n");
            buf.append("Responder location: " + new String(this.location).trim() + "\n");
            buf.append("Timestamp: " + new String(this.timestamp) + "\n");
            buf.append("Command: " + new String(this.command) + "\n");
            return buf.substring(0);
        }

        public void write(DataOutputStream os) throws IOException {
            os.write(this.stationName);
            os.write(this.location);
            os.write(this.timestamp);
            os.writeInt(this.commandSize);
            os.write(this.command);
            CDPart.writePad(os, this.commandSize);
        }

        public static CDFrameCommandRequest read(DataInputStream is) throws IOException {
            CDFrameCommandRequest request = new CDFrameCommandRequest();
            is.readFully(request.stationName);
            is.readFully(request.location);
            is.readFully(request.timestamp);
            request.commandSize = is.readInt();
            request.command = new byte[request.commandSize];
            is.readFully(request.command);
            CDPart.readPad(is, request.commandSize);
            return request;
        }
    }

    public static class CDFrameCommandResponse
    extends CDPart {
        public byte[] stationName = new byte[8];
        public byte[] location = new byte[12];
        public byte[] timestamp = new byte[20];
        public int commandSize;
        public byte[] command;
        public int responseSize;
        public byte[] response;

        public int getFrameLength() {
            return 44 + CDPart.getPadLength(this.command.length) + 4 + CDPart.getPadLength(this.response.length);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Responder Station: " + new String(this.stationName) + "\n");
            buf.append("Responder location: " + new String(this.location) + "\n");
            buf.append("Timestamp: " + new String(this.timestamp) + "\n");
            buf.append("Command: " + new String(this.command) + "\n");
            buf.append("Response: " + new String(this.response) + "\n");
            return buf.substring(0);
        }

        public void write(DataOutputStream os) throws IOException {
            os.write(this.stationName);
            os.write(this.location);
            os.write(this.timestamp);
            os.writeInt(this.commandSize);
            os.write(this.command);
            CDPart.writePad(os, this.commandSize);
            os.writeInt(this.responseSize);
            os.write(this.response);
            CDPart.writePad(os, this.responseSize);
        }

        public static CDFrameCommandResponse read(DataInputStream is) throws IOException {
            CDFrameCommandResponse response = new CDFrameCommandResponse();
            is.readFully(response.stationName);
            is.readFully(response.location);
            is.readFully(response.timestamp);
            response.commandSize = is.readInt();
            response.command = new byte[response.commandSize];
            is.readFully(response.command);
            CDPart.readPad(is, response.commandSize);
            response.responseSize = is.readInt();
            response.response = new byte[response.responseSize];
            is.readFully(response.response);
            CDPart.readPad(is, response.responseSize);
            return response;
        }
    }

    public static class CDFrameConnection
    extends CDPart {
        public int frameType = 1;
        public short majorVersion = 1;
        public short minorVersion = 1;
        public byte[] stationName = new byte[8];
        public byte[] stationType = new byte[4];
        public byte[] serviceType = new byte[]{84, 67, 80, 32};
        public int ipAddress;
        public short port;
        public int ipAddress2;
        public short port2;

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Major Version: " + this.majorVersion + "\n");
            buf.append("Minor Version: " + this.minorVersion + "\n");
            buf.append("Station: " + new String(this.stationName).trim() + "\n");
            buf.append("Station Type: " + new String(this.stationType).trim() + "\n");
            buf.append("Service Type: " + new String(this.serviceType).trim() + "\n");
            buf.append("IP address: " + Integer.toHexString(this.ipAddress) + "\n");
            buf.append("port: " + Integer.toHexString(this.port) + "\n");
            buf.append("Second IP address: " + Integer.toHexString(this.ipAddress2) + "\n");
            buf.append("Second port: " + this.port2 + "\n");
            return buf.substring(0);
        }

        static int swap(int val) {
            int ch1 = val & 0xFF;
            int ch2 = val >>> 8 & 0xFF;
            int ch3 = val >>> 16 & 0xFF;
            int ch4 = val >>> 24 & 0xFF;
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }

        public void write(DataOutputStream os) throws IOException {
            os.writeShort(this.majorVersion);
            os.writeShort(this.minorVersion);
            os.write(this.stationName);
            os.write(this.stationType);
            os.write(this.serviceType);
            if (this.frameType == 1) {
                os.writeInt(this.ipAddress);
            } else {
                os.writeInt(this.ipAddress);
            }
            os.writeShort(this.port);
            os.writeInt(this.ipAddress2);
            os.writeShort(this.port2);
        }

        public static CDFrameConnection read(DataInputStream is) throws IOException {
            CDFrameConnection con = new CDFrameConnection();
            con.majorVersion = is.readShort();
            con.minorVersion = is.readShort();
            is.readFully(con.stationName);
            is.readFully(con.stationType);
            is.readFully(con.serviceType);
            con.ipAddress = is.readInt();
            con.port = is.readShort();
            con.ipAddress2 = is.readInt();
            con.port2 = is.readShort();
            return con;
        }
    }

    public static class CDFrameData
    extends CDPart {
        public int numChannel;
        public int frameTimeLength;
        public byte[] timeUTC = new byte[20];
        public int channelStringCount;
        public byte[] channelString;
        public ChannelSubframe[] subframe;

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Channel Number: " + this.numChannel + "\n");
            buf.append("Frame Time Length in ms: " + this.frameTimeLength + "\n");
            buf.append("UTC time: " + new String(this.timeUTC).trim() + "\n");
            buf.append("Channel String: " + new String(this.channelString).trim() + "\n");
            int i = 0;
            while (i < this.numChannel) {
                buf.append(this.subframe[i].toString());
                ++i;
            }
            return buf.substring(0);
        }

        public void write(DataOutputStream os) throws IOException {
            os.writeInt(this.numChannel);
            os.writeInt(this.frameTimeLength);
            os.write(this.timeUTC);
            os.writeInt(this.channelStringCount);
            os.write(this.channelString);
            CDPart.writePad(os, this.channelStringCount);
            int i = 0;
            while (i < this.numChannel) {
                this.subframe[i].write(os);
                ++i;
            }
        }

        public static CDFrameData read(DataInputStream is) throws IOException {
            CDFrameData fd = new CDFrameData();
            fd.numChannel = is.readInt();
            fd.frameTimeLength = is.readInt();
            is.readFully(fd.timeUTC);
            fd.channelStringCount = is.readInt();
            fd.channelString = new byte[fd.channelStringCount];
            is.readFully(fd.channelString);
            CDPart.readPad(is, fd.channelStringCount);
            fd.subframe = new ChannelSubframe[fd.numChannel];
            int i = 0;
            while (i < fd.numChannel) {
                fd.subframe[i] = ChannelSubframe.read(is);
                ++i;
            }
            return fd;
        }
    }

    public static class CDFrameHeader
    extends CDPart {
        public int type;
        public int trailerOffset;
        public byte[] creator = new byte[8];
        public byte[] destination = new byte[8];
        public long sequence;
        public int series;

        public int getFrameLength() {
            return 36;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Type: " + Integer.toHexString(this.type) + "\n");
            buf.append("TrailerOffset: " + Integer.toHexString(this.trailerOffset) + "\n");
            buf.append("Creator: " + new String(this.creator) + "\n");
            buf.append("Destination: " + new String(this.destination) + "\n");
            buf.append("sequence: " + this.sequence + "\n");
            buf.append("series: " + this.series + "\n");
            return buf.substring(0);
        }

        public void write(DataOutputStream os) throws IOException {
            os.writeInt(this.type);
            os.writeInt(this.trailerOffset);
            os.write(this.creator);
            os.write(this.destination);
            os.writeLong(this.sequence);
            os.writeInt(this.series);
        }

        public static CDFrameHeader read(DataInputStream is) throws IOException {
            CDFrameHeader header = new CDFrameHeader();
            header.type = is.readInt();
            header.trailerOffset = is.readInt();
            is.readFully(header.creator);
            is.readFully(header.destination);
            header.sequence = is.readLong();
            header.series = is.readInt();
            return header;
        }
    }

    public static class CDFrameOption
    extends CDPart {
        public int count;
        public Option[] options;

        public void write(DataOutputStream os) throws IOException {
            os.writeInt(this.count);
            int i = 0;
            while (i < this.count) {
                os.writeInt(this.options[i].type);
                os.writeInt(this.options[i].size);
                os.write(this.options[i].value);
                CDPart.writePad(os, this.options[i].size);
                ++i;
            }
        }

        public static CDFrameOption read(DataInputStream is) throws IOException {
            CDFrameOption op = new CDFrameOption();
            op.count = is.readInt();
            int i = 0;
            while (i < op.count) {
                op.options[i].type = is.readInt();
                op.options[i].size = is.readInt();
                op.options[i].value = new byte[op.options[i].size];
                is.readFully(op.options[i].value);
                CDPart.readPad(is, op.options[i].size);
                ++i;
            }
            return op;
        }
    }

    public static class CDFrameTrailer
    extends CDPart {
        public int authKey;
        public int authSize;
        public byte[] authValue;
        public long CRC64;

        public int getFrameLength() {
            return 8 + CDPart.getPadLength(this.authValue.length) + 8;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Auth Key: " + this.authKey + "\n");
            buf.append("auth Size: " + this.authSize + "\n");
            buf.append("CRC64: " + Long.toHexString(this.CRC64) + "\n");
            return buf.substring(0);
        }

        public void write(DataOutputStream os) throws IOException {
            os.writeInt(this.authKey);
            os.writeInt(this.authSize);
            os.write(this.authValue);
            CDPart.writePad(os, this.authSize);
            os.writeLong(this.CRC64);
        }

        public static CDFrameTrailer read(DataInputStream is) throws IOException {
            CDFrameTrailer trailer = new CDFrameTrailer();
            trailer.authKey = is.readInt();
            trailer.authSize = is.readInt();
            trailer.authValue = new byte[trailer.authSize];
            is.readFully(trailer.authValue);
            CDPart.readPad(is, trailer.authSize);
            trailer.CRC64 = is.readLong();
            return trailer;
        }
    }

    public static abstract class CDPart {
        static int getPadLength(int length) {
            int j = length % 4;
            int k = j != 0 ? 4 - j : 0;
            return length + k;
        }

        static void writePad(DataOutputStream out, int length) throws IOException {
            byte[] pad = new byte[CDPart.getPadLength(length) - length];
            out.write(pad);
        }

        static void readPad(DataInputStream in, int length) throws IOException {
            byte[] pad = new byte[CDPart.getPadLength(length) - length];
            in.readFully(pad);
        }

        public abstract void write(DataOutputStream var1) throws IOException;

        public String toString() {
            return "";
        }
    }

    public static class ChannelSubframe
    extends CDPart {
        public int channelLength;
        public int authOffset;
        public byte[] channelDiscription = new byte[24];
        public byte[] timestamp = new byte[20];
        public int frameTimeLength;
        public int samples;
        public int channelStatusSize;
        public byte[] channelStatus;
        public int dataSize;
        public byte[] data;
        public int subframeCount;
        public int authKeyId;
        public int authSize;
        public byte[] authVale;

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Channel Length: " + this.channelLength + "\n");
            buf.append("AuthOffset: " + this.authOffset + "\n");
            buf.append("Channel Discription: " + new String(this.channelDiscription) + "\n");
            buf.append("UTC time: " + new String(this.timestamp).trim() + "\n");
            buf.append("Frame Time Length in ms: " + this.frameTimeLength + "\n");
            buf.append("Samples: " + this.samples + "\n");
            buf.append("Channel Status Size: " + this.channelStatusSize + "\n");
            buf.append("Channel Status: " + new String(this.channelStatus) + "\n");
            buf.append("Data Size: " + this.dataSize + "\n");
            buf.append("subframeCount: " + this.subframeCount + "\n");
            buf.append("AuthKeyId: " + this.authKeyId + "\n");
            buf.append("AuthSize: " + this.authSize + "\n");
            return buf.substring(0);
        }

        public void write(DataOutputStream os) throws IOException {
            os.writeInt(this.channelLength);
            os.writeInt(this.authOffset);
            os.write(this.channelDiscription);
            os.write(this.timestamp);
            os.writeInt(this.frameTimeLength);
            os.writeInt(this.samples);
            os.writeInt(this.channelStatusSize);
            os.write(this.channelStatus);
            CDPart.writePad(os, this.channelStatusSize);
            os.writeInt(this.dataSize);
            os.write(this.data);
            CDPart.writePad(os, this.dataSize);
            os.writeInt(this.subframeCount);
            os.writeInt(this.authKeyId);
            os.writeInt(this.authSize);
            os.write(this.authVale);
            CDPart.writePad(os, this.authSize);
        }

        public static ChannelSubframe read(DataInputStream is) throws IOException {
            ChannelSubframe sf = new ChannelSubframe();
            sf.channelLength = is.readInt();
            sf.authOffset = is.readInt();
            is.readFully(sf.channelDiscription);
            is.readFully(sf.timestamp);
            sf.frameTimeLength = is.readInt();
            sf.samples = is.readInt();
            sf.channelStatusSize = is.readInt();
            sf.channelStatus = new byte[sf.channelStatusSize];
            is.readFully(sf.channelStatus);
            CDPart.readPad(is, sf.channelStatusSize);
            sf.dataSize = is.readInt();
            sf.data = new byte[sf.dataSize];
            is.readFully(sf.data);
            CDPart.readPad(is, sf.dataSize);
            sf.subframeCount = is.readInt();
            sf.authKeyId = is.readInt();
            sf.authSize = is.readInt();
            sf.authVale = new byte[sf.authSize];
            is.readFully(sf.authVale);
            CDPart.readPad(is, sf.authSize);
            return sf;
        }
    }

    public static class Gap {
        public long begin;
        public long end;
    }

    public static class Option {
        public int type;
        public int size;
        public byte[] value;
    }
}

