/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.geotech;

class CRCTable {
    private static CRCTable instance;
    private long[] array = new long[256];
    private static long poly;
    private static long bitExtract;

    static {
        poly = 27L;
        bitExtract = 0L;
    }

    public static CRCTable getInstance() {
        if (instance == null) {
            instance = new CRCTable();
        }
        return instance;
    }

    private CRCTable() {
        this.init();
    }

    private void init() {
        long crc = 0L;
        int ii = 0;
        while (ii < 256) {
            crc = ii << 8;
            int kk = 0;
            while (kk < 8) {
                crc = crc << 1 ^ ((crc & bitExtract) <= 0L ? 0L : poly);
                ++kk;
            }
            this.array[ii] = crc & 0xFFFFFFFFFFFFFFFFL;
            ++ii;
        }
    }

    public long get(int index) {
        if (index < 0 || index > 255) {
            return -1L;
        }
        return this.array[index];
    }

    public long getPoly() {
        return poly;
    }

    public static void main(String[] args) {
        CRCTable table = CRCTable.getInstance();
        int ii = 0;
        while (ii < 256) {
            System.out.println(" ii=" + ii + " value = " + table.get(ii) + " hex = " + Long.toHexString(table.get(ii)));
            ++ii;
        }
    }
}

