/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.geotech;

import cn.org.gddsn.liss.port.geotech.AbstractCRCVerifier;
import java.io.ByteArrayOutputStream;
import org.apache.log4j.Logger;

class CRC64BitVerifier
extends AbstractCRCVerifier {
    static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.geotech.CRC64BitVerifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public CRC64BitVerifier() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public boolean verifyData(byte[] data, long checksum) {
        long register = 0L;
        long ourCheckSum = this.getCheckSum(data);
        logger.debug(" verifyData:: our check sum=" + ourCheckSum + " passed in =" + checksum);
        return ourCheckSum == checksum;
    }

    public long getCheckSum(byte[] actualData) {
        int mask = -1;
        long register = 0L;
        byte[] data = this.getAugumentedData(actualData);
        int ii = 0;
        while (ii < data.length) {
            byte topByte = (byte)(register >> 56 & (long)mask);
            register = register << 8 | (long)data[ii];
            register ^= AbstractCRCVerifier.table.get(topByte);
            ++ii;
        }
        logger.debug(" get Check sum returning =" + register);
        return register & 0xFFFFFFFFFFFFFFFFL;
    }

    private byte[] getAugumentedData(byte[] actualData) {
        byte[] data = new byte[actualData.length + 8];
        System.arraycopy(actualData, 0, data, 0, actualData.length);
        int ii = actualData.length;
        while (ii < data.length) {
            data[ii] = 0;
            ++ii;
        }
        return data;
    }

    public static void main(String[] args) {
        CRC64BitVerifier verifier = new CRC64BitVerifier();
        byte[] data = new byte[]{101, 100, 97, 95, 90, 67, 65, 11};
        long checksum = verifier.getCheckSum(data);
        verifier.verifyChecksumGot(data, checksum);
    }

    private boolean verifyChecksumGot(byte[] actualData, long checksum) {
        byte[] finalBytes = this.getFinalBytes(actualData, checksum);
        long finalChecksum = this.getCheckSum(finalBytes);
        logger.debug(" finally after passing through with checksum = " + checksum);
        logger.debug(" and final checksum should be 0 is " + finalChecksum);
        return true;
    }

    private byte[] getFinalBytes(byte[] actualData, long checksum) {
        byte[] finalBytes;
        byte[] checksumBytes = this.getBytesFromLong(checksum);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(actualData);
            out.write(checksumBytes);
            out.flush();
            finalBytes = out.toByteArray();
            out.close();
            logger.debug(" return final bytes size = " + finalBytes.length);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            finalBytes = new byte[]{};
        }
        return finalBytes;
    }

    private byte[] getBytesFromLong(long checksum) {
        byte[] bytes = new byte[8];
        int ii = 0;
        while (ii < bytes.length) {
            bytes[bytes.length - (ii + 1)] = (byte)(checksum & 0xFFL);
            checksum >>>= 8;
            ++ii;
        }
        return bytes;
    }
}

