/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edsp;

import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.util.StructUtil;
import cn.org.gddsn.security.Bytes;
import cn.org.gddsn.util.EdasSteim2;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javolution.io.Struct;
import org.apache.log4j.Logger;

public class EdspIO {
    static Logger logger;
    private DataInputStream in;
    private DataOutputStream out;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.edsp.EdspIO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public void setIO(InputStream in, OutputStream out) {
        this.in = new DataInputStream(in);
        this.out = new DataOutputStream(out);
    }

    public void writeFrame(Frame frame) throws Edas24IPIOException, IOException {
        this.out.write(frame.toByteArray());
        this.out.flush();
        if (logger.isDebugEnabled()) {
            logger.debug("Send Frame: " + (Object)((Object)frame));
        }
    }

    public Frame readFrame() throws Edas24IPIOException, IOException {
        Frame frame = new Frame();
        frame.header.readFully(this.in);
        int type = frame.header.type.get();
        switch (type & 0xFFFF) {
            case 21966: {
                EDAS_STEIM2 edas_steim2 = new EDAS_STEIM2();
                edas_steim2.alloc(frame.header.length.get());
                frame.body = edas_steim2;
                frame.body.readFully(this.in);
                this.in.readFully(edas_steim2.zdata);
                break;
            }
            default: {
                logger.warn("Got unknow Frame type: " + (Object)((Object)frame.header));
                frame.unknown = new byte[frame.header.length.get() - 4];
                this.in.readFully(frame.unknown);
            }
        }
        frame.tailer.readFully(this.in);
        if (logger.isDebugEnabled()) {
            logger.debug("Got Frame: " + (Object)((Object)frame));
        }
        return frame;
    }

    public static class ACK
    extends Body {
        public final Struct.Unsigned32 second = new Struct.Unsigned32((Struct)this);

        public String toString() {
            return "second=" + Long.toHexString(this.second.get());
        }
    }

    public static class Body
    extends Struct {
        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public boolean isPacked() {
            return true;
        }

        public byte[] toByteArray() throws IOException {
            ByteBuffer bb = this.getByteBuffer();
            byte[] buf = new byte[this.size()];
            int i = 0;
            while (i < buf.length) {
                buf[i] = bb.get(i);
                ++i;
            }
            return buf;
        }

        public String toString() {
            return StructUtil.struct2String(this);
        }
    }

    public static class DATA_REQUEST
    extends Body {
        public final Struct.Unsigned32 second = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned16 length = new Struct.Unsigned16((Struct)this);

        public String toString() {
            return "second=" + Long.toHexString(this.second.get()) + "length=" + Long.toHexString(this.length.get());
        }
    }

    public static class EDAS_STEIM2
    extends Body {
        public final Struct.Unsigned32 second = new Struct.Unsigned32((Struct)this);
        public final Struct.Unsigned8 flag1 = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 flag2 = new Struct.Unsigned8((Struct)this);
        public static final int OFFSET = 8;
        public byte[] zdata;
        public int sampRate;
        public int samps;
        public int flag;
        public int chns = 3;
        public int compressFlag;

        public void alloc(int length) {
            this.zdata = new byte[length - 8];
        }

        public byte[] toByteArray() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(super.toByteArray(), 0, this.size());
            baos.write(this.zdata);
            return baos.toByteArray();
        }

        public DataFrame[] decode() {
            switch (this.flag1.get() >>> 4) {
                case 0: {
                    this.sampRate = 1;
                    break;
                }
                case 1: {
                    this.sampRate = 10;
                    break;
                }
                case 2: {
                    this.sampRate = 20;
                    break;
                }
                case 3: {
                    this.sampRate = 50;
                    break;
                }
                case 4: {
                    this.sampRate = 100;
                    break;
                }
                case 5: {
                    this.sampRate = 125;
                    break;
                }
                case 6: {
                    this.sampRate = 200;
                    break;
                }
                case 7: {
                    this.sampRate = 500;
                }
            }
            this.samps = this.sampRate;
            this.flag = (byte)(this.flag1.get() & 0xF);
            this.chns = 3;
            this.compressFlag = this.flag2.get() >>> 4;
            int[] data = new int[this.chns * this.sampRate];
            EdasSteim2.decodeSteim2(this.zdata, 0, this.zdata.length, data);
            DataFrame[] dFrame = new DataFrame[this.chns];
            int i = 0;
            while (i < this.chns) {
                dFrame[i] = new DataFrame();
                dFrame[i].data = new int[this.samps];
                System.arraycopy(data, i * this.sampRate, dFrame[i].data, 0, this.sampRate);
                dFrame[i].flag = this.flag;
                dFrame[i].siteID = 0;
                dFrame[i].time = this.second.get();
                dFrame[i].sampRate = this.sampRate;
                ++i;
            }
            return dFrame;
        }

        public String toString() {
            return "second=" + Long.toHexString(this.second.get()) + "/flag1=" + Integer.toHexString(this.flag1.get());
        }
    }

    public static class Edas24IPIOException
    extends Exception {
        public Edas24IPIOException() {
        }

        public Edas24IPIOException(String s) {
            super(s);
        }
    }

    public static class Frame
    extends Struct {
        public final Header header = (Header)this.inner(new Header());
        public Body body = null;
        public byte[] unknown;
        public final Tailer tailer = (Tailer)this.inner(new Tailer());

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public Frame() {
            this.header.sync.set(1956058047);
        }

        public boolean isPacked() {
            return true;
        }

        public byte[] toByteArray() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.header.write(baos);
            if (this.body != null) {
                baos.write(this.body.toByteArray());
            } else {
                baos.write(this.unknown);
            }
            this.tailer.write(baos);
            return baos.toByteArray();
        }

        public String toString() {
            String buf = "\n\tHeader: " + (Object)((Object)this.header) + "\n";
            if (this.body != null) {
                try {
                    buf = String.valueOf(buf) + "\tBody: " + Bytes.toString(this.body.toByteArray()) + "\n";
                }
                catch (IOException iOException) {}
            } else {
                buf = String.valueOf(buf) + "\tBody: " + Bytes.toString(this.unknown) + "\n";
            }
            buf = String.valueOf(buf) + "\tTailer: " + (Object)((Object)this.tailer);
            return buf;
        }

        int calculateCheckSum() {
            int checksum = 0;
            ByteBuffer sbuf = this.header.getByteBuffer();
            ((Buffer)sbuf).position(8);
            int p = 8;
            while (p < this.header.size()) {
                checksum += sbuf.getShort(p) & 0xFFFF;
                p += 2;
            }
            byte[] buf = null;
            if (this.body != null) {
                try {
                    buf = this.body.toByteArray();
                    sbuf = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                int p2 = 0;
                while (p2 < buf.length) {
                    checksum += sbuf.getShort(p2) & 0xFFFF;
                    p2 += 2;
                }
            } else {
                sbuf = ByteBuffer.wrap(this.unknown).order(ByteOrder.LITTLE_ENDIAN);
                int p3 = 0;
                while (p3 < this.unknown.length) {
                    checksum += sbuf.getShort(p3) & 0xFFFF;
                    p3 += 2;
                }
            }
            return 0 - checksum & 0xFFFF;
        }

        public void fillCheckSum() {
            this.tailer.checksum.set(this.calculateCheckSum());
        }
    }

    public static class Header
    extends Struct {
        public static final int SYNC = 1956058047;
        public static final int CMD_WAVEFORM = 21966;
        public static final int CMD_TRIG = 32769;
        public static final int CMD_RESULT_LOC = 32770;
        public static final int CMD_PHASE = 32771;
        public static final int CMD_SOH = 32772;
        public static final int CMD_DISK = 32773;
        public static final int CMD_CPU = 32774;
        public static final int CMD_SET = 32775;
        public static final int CMD_LD = 32776;
        public final Struct.Signed32 sync = new Struct.Signed32((Struct)this);
        public final Struct.Unsigned16 nodeId = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 siteId = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 sensId = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 type = new Struct.Unsigned16((Struct)this);
        public final Struct.Unsigned16 length = new Struct.Unsigned16((Struct)this);

        public Header() {
            this.sync.set(1956058047);
        }

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public boolean isPacked() {
            return true;
        }

        public String toString() {
            return StructUtil.struct2String(this);
        }
    }

    public static class Tailer
    extends Struct {
        public final Struct.Unsigned16 checksum = new Struct.Unsigned16((Struct)this);

        public ByteOrder byteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        public boolean isPacked() {
            return true;
        }

        public String toString() {
            return "checksum=" + Integer.toHexString(this.checksum.get());
        }
    }
}

