/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edsp;

import cn.org.gddsn.liss.port.edsp.BufferedReader0;
import cn.org.gddsn.liss.port.edsp.EdspControlResponse;
import cn.org.gddsn.liss.port.edsp.EdspException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import org.apache.log4j.Logger;

public class EdspControlSocket {
    static Logger logger;
    static final String EOL = "\r\n";
    private static final int CONTROL_PORT = 5000;
    private Socket controlSock = null;
    private Writer writer = null;
    private BufferedReader0 reader = null;
    private String connectionInfo = "";
    private int timeOut = 160000;
    private String remoteHostAddress = null;
    private int remotePort = -1;
    private String localHostAddress = null;
    private int localPort = -1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.edsp.EdspControlSocket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public EdspControlSocket(String remoteHost, int port) throws IOException, EdspException {
        this.controlSock = new Socket(remoteHost, port);
        this.controlSock.setSoTimeout(this.timeOut);
        this.connectionInfo = String.valueOf(this.controlSock.getLocalAddress().getHostName()) + ":" + this.controlSock.getLocalPort() + "->" + this.controlSock.getInetAddress().getHostName() + ":" + this.controlSock.getPort();
        this.connectionInfo = "Established " + this.connectionInfo + " at " + new Date();
        this.initStreams();
        this.validateConnection();
    }

    public EdspControlSocket(String remoteHost) throws IOException, EdspException {
        this(remoteHost, 5000);
    }

    public EdspControlSocket(InetAddress remoteAddr, int port) throws IOException, EdspException {
        this.controlSock = new Socket(remoteAddr, port);
        this.controlSock.setSoTimeout(this.timeOut);
        this.initStreams();
        this.validateConnection();
    }

    public EdspControlSocket(InetAddress remoteAddr) throws IOException, EdspException {
        this(remoteAddr, 5000);
    }

    public void setTimeOut(int ms) {
        this.timeOut = ms;
        try {
            this.controlSock.setSoTimeout(this.timeOut);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getSocketConnectionInfo() {
        return this.connectionInfo;
    }

    private void validateConnection() throws IOException, EdspException {
        EdspControlResponse reply = this.readReply();
        this.validateReply(reply, "100");
    }

    private void initStreams() throws IOException {
        InputStream is = this.controlSock.getInputStream();
        this.reader = new BufferedReader0(new InputStreamReader(is));
        OutputStream os = this.controlSock.getOutputStream();
        this.writer = new OutputStreamWriter(os);
    }

    String getRemoteHostName() {
        InetAddress addr = this.controlSock.getInetAddress();
        return addr.getHostName();
    }

    public void logout() throws IOException {
        this.writer.close();
        this.reader.close();
        this.controlSock.close();
    }

    public EdspControlResponse sendCommand(String command) throws IOException {
        this.writer.write(String.valueOf(command) + EOL);
        this.writer.flush();
        if (logger.isDebugEnabled()) {
            logger.debug("command: " + command);
        }
        return this.readReply();
    }

    EdspControlResponse readReply() throws IOException {
        return new EdspControlResponse(this.reader);
    }

    public void validateReply(EdspControlResponse reply, String expectedReplyCode) throws IOException, EdspException {
        String replyCode = reply.getReturnCode();
        if (!replyCode.equals(expectedReplyCode)) {
            String emsg = "Expeted code " + expectedReplyCode + ", but got: " + reply.getMessage();
            throw new EdspException(emsg);
        }
    }

    public void validateReply(EdspControlResponse reply, String[] expectedReplyCodes) throws IOException, EdspException {
        String replyCode = reply.getReturnCode();
        int i = 0;
        while (i < expectedReplyCodes.length) {
            if (replyCode.equals(expectedReplyCodes[i])) {
                return;
            }
            ++i;
        }
        StringBuffer buf = new StringBuffer("Expeted code ");
        int i2 = 0;
        while (i2 < expectedReplyCodes.length) {
            buf.append(String.valueOf(expectedReplyCodes[i2]) + "/");
            ++i2;
        }
        String emsg = String.valueOf(buf.toString()) + ", but got: " + reply.getMessage();
        throw new EdspException(emsg);
    }

    public String getLocalHostAddress() {
        if (this.localHostAddress == null) {
            this.localHostAddress = this.controlSock.getLocalAddress().getHostAddress();
        }
        return this.localHostAddress;
    }

    public int getLocalHostPort() {
        if (this.localPort == -1) {
            this.localPort = this.controlSock.getLocalPort();
        }
        return this.localPort;
    }

    String getRemoteHostAddress() {
        if (this.remoteHostAddress == null) {
            this.remoteHostAddress = this.controlSock.getInetAddress().getHostAddress();
        }
        return this.remoteHostAddress;
    }

    int getRemoteHostPort() {
        if (this.remotePort == -1) {
            this.remotePort = this.controlSock.getPort();
        }
        return this.remotePort;
    }

    public String getDetailHeader() {
        String strUsr = "";
        return String.valueOf(this.getLocalHostAddress()) + ":" + this.getLocalHostPort() + "/" + this.getRemoteHostName() + ":" + this.getRemoteHostPort();
    }
}

