/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edsp;

import cn.org.gddsn.liss.port.edsp.EdspControlResponse;
import cn.org.gddsn.liss.port.edsp.EdspControlSocket;
import cn.org.gddsn.liss.port.edsp.EdspException;
import cn.org.gddsn.liss.port.edsp.EdspIO;
import cn.org.gddsn.util.Log4jConfig;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;

public class EdspClient {
    static Logger logger;
    private EdspControlSocket control = null;
    int dataPort = 8001;
    private Socket data = null;
    private EdspIO edspIO;
    private int timeOut = 120000;
    private int sendBufferSize = -1;
    private String remoteHost;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.edsp.EdspClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public EdspClient(String remoteHost, int port) throws IOException, EdspException {
        this.control = new EdspControlSocket(remoteHost, port);
        logger.info("Connected " + remoteHost + ":" + port);
        this.remoteHost = remoteHost;
    }

    public EdspClient(String remoteHost) throws IOException, EdspException {
        this.control = new EdspControlSocket(remoteHost);
        this.remoteHost = remoteHost;
    }

    EdspControlSocket getEdas24ControlSocket() {
        return this.control;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void setTimeOut(int ms) {
        this.timeOut = ms;
        this.control.setTimeOut(this.timeOut);
        try {
            if (this.data != null) {
                this.data.setSoTimeout(this.timeOut);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getSocketConnectionInfo() {
        return this.control.getSocketConnectionInfo();
    }

    private void skipLine(EdspControlResponse reply) throws IOException, EdspException {
        reply = this.control.readReply();
        this.control.validateReply(reply, "109");
    }

    public synchronized EdspIO login(String user, String password) throws IOException, EdspException {
        EdspControlResponse reply = this.control.sendCommand(user);
        this.control.validateReply(reply, "102");
        reply = this.control.sendCommand(password);
        this.control.validateReply(reply, "107");
        reply = this.control.readReply();
        this.control.validateReply(reply, "108");
        String msg = reply.getMessage().substring(4);
        int idx = msg.indexOf(32);
        this.dataPort = Integer.parseInt(msg.substring(0, idx));
        this.data = new Socket(this.remoteHost, this.dataPort);
        if (this.sendBufferSize != -1) {
            this.data.setSendBufferSize(this.sendBufferSize);
        }
        this.data.setSoTimeout(this.timeOut);
        this.edspIO = new EdspIO();
        this.edspIO.setIO(this.data.getInputStream(), this.data.getOutputStream());
        reply = this.control.readReply();
        this.control.validateReply(reply, "104");
        logger.info("User " + user + " loggin on " + this.remoteHost);
        return this.edspIO;
    }

    public synchronized void logout() throws IOException, EdspException {
        EdspControlResponse reply = this.control.sendCommand("QUIT");
        logger.info("logout " + this.remoteHost);
    }

    public synchronized EdspIO requestData(String stnList) throws IOException, EdspException {
        EdspControlResponse reply = this.control.sendCommand("RETR DATA " + stnList);
        String[] validCodes1 = new String[]{"110"};
        this.control.validateReply(reply, validCodes1);
        logger.info("Open DATA Stream.");
        return this.edspIO;
    }

    public synchronized EdspIO.Frame getRtsFrame() throws IOException, EdspIO.Edas24IPIOException {
        EdspIO.Frame frame = this.edspIO.readFrame();
        if (logger.isDebugEnabled()) {
            logger.debug("calc checksum: " + Integer.toHexString(frame.calculateCheckSum()));
        }
        if (frame.header.type.get() == 21966) {
            EdspIO.EDAS_STEIM2 data = (EdspIO.EDAS_STEIM2)frame.body;
            if (frame.calculateCheckSum() != frame.tailer.checksum.get()) {
                logger.warn("checksum error for got STEIM2 packet");
            }
        }
        return frame;
    }

    public String getDetailHeader() {
        return this.control.getDetailHeader();
    }

    public String getLocalHostAddress() {
        return this.control.getLocalHostAddress();
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    void checkResponse(String[] validCodes) throws IOException, EdspException {
        EdspControlResponse reply = this.control.readReply();
        this.control.validateReply(reply, validCodes);
    }

    protected void closeTransferSocket() throws IOException {
        if (this.data != null) {
            this.data.close();
            this.data = null;
        }
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("Edas24Client.properties");
        EdspClient edspclient = new EdspClient("222.82.248.99", 9000);
        edspclient.setTimeOut(5000);
        edspclient.login("xj", "xj");
        edspclient.requestData("*.*.*");
        int n = 1000;
        while (n-- != 0) {
            edspclient.getRtsFrame();
        }
        edspclient.logout();
    }

    public EdspIO getEdas24IPIO() {
        return this.edspIO;
    }
}

