/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edas;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.liss.port.edas.FrameParseException;
import cn.org.gddsn.liss.port.edas.GenericFrame;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class Rsp_2072_Frame
extends GenericFrame {
    int nchan = 0;
    int siteID = 0;
    int siteMask = 0;
    String siteName;

    public Rsp_2072_Frame(GenericFrame gframe) throws FrameParseException {
        super(gframe);
        this.parse();
    }

    private void parse() throws FrameParseException {
        LittleEndianInputStream di = null;
        if (this.cmd != 8306) {
            throw new FrameParseException("parse Error in Rsp_2072_Frame");
        }
        try {
            di = new LittleEndianInputStream(new ByteArrayInputStream(this.getData()));
            this.nchan = di.readShort();
            this.siteID = di.readShort();
            this.siteMask = di.readShort();
            byte[] buf = new byte[20];
            di.readFully(buf);
            this.siteName = new String(buf);
        }
        catch (IOException ioEx) {
            throw new FrameParseException("parse Error in Rsp_2072_Frame, throw IOException");
        }
    }

    public int getNChan() {
        return this.nchan;
    }

    public int getSiteID() {
        return this.siteID;
    }

    public int getSiteMask() {
        return this.siteMask;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String toString() {
        String header = super.toString();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(header);
        sbuf.append(" ( NCHAN: \t" + this.nchan + "\n");
        sbuf.append("   Site ID:\t" + this.siteID + "\n");
        sbuf.append("   Site Mask:\t" + this.siteMask + "\n");
        sbuf.append("   Site Name:\t" + this.siteName + " )\n");
        return sbuf.substring(0);
    }
}

