/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edas;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.liss.port.edas.FrameParseException;
import cn.org.gddsn.liss.port.edas.GenericFrame;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class Rsp_2018_Frame
extends GenericFrame {
    int evtCount;
    int tmsec;

    public Rsp_2018_Frame(GenericFrame gframe) throws FrameParseException {
        super(gframe);
        this.parse();
    }

    private void parse() throws FrameParseException {
        LittleEndianInputStream di = null;
        if (this.cmd != 8216) {
            throw new FrameParseException("parse Error in Rsp_2018_Frame");
        }
        try {
            di = new LittleEndianInputStream(new ByteArrayInputStream(this.getData()));
            this.evtCount = di.readShort();
            this.tmsec = di.readInt();
        }
        catch (IOException ioEx) {
            throw new FrameParseException("parse Error in Rsp_2018_Frame, throw IOException");
        }
    }

    public int getEvtCount() {
        return this.evtCount;
    }

    public int getTmsec() {
        return this.tmsec;
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer(4096);
        strBuffer.append(super.toString());
        strBuffer.append("evtCount :\t" + this.evtCount + "\n");
        strBuffer.append("tm_sec :\t" + this.tmsec + "\n");
        return strBuffer.toString();
    }
}

