/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edas;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class GenericFrame {
    public static final int CMD_SET_SAMPLE_RATE_RSP = 8196;
    public static final int CMD_SET_HIGH_FILTER_RSP = 8288;
    public static final int CMD_SET_SITE_ID_RSP = 8200;
    public static final int CMD_SET_PULSE_CAL_RSP = 8199;
    public static final int CMD_SET_BINARY_CAL_RSP = 8199;
    public static final int CMD_SET_SINE_CAL_RSP = 8199;
    public static final int CMD_SET_STRONG_CAL_RSP = 8199;
    public static final int CMD_GET_ENV_RSP = 8289;
    public static final int CMD_GET_GPS_RSP = 8290;
    public static final int CMD_GET_PARAM_RSP = 8291;
    public static final int CMD_SET_CAL_WAIT_TIME_RSP = 8292;
    public static final int CMD_SET_GAIN_RSP = 8294;
    public static final int CMD_SET_MGR_INFO_RSP = 8295;
    public static final int CMD_SET_TRIGGER_PARAM1_RSP = 8212;
    public static final int CMD_SET_TRIGGER_PARAM2_RSP = 8212;
    public static final int CMD_SET_TRIGGER_PARAM3_RSP = 8212;
    public static final int CMD_SET_RECORD_PARAM_RSP = 8272;
    public static final int CMD_RECORD_LIST_RSP = 8213;
    public static final int CMD_RECORD_NOTIFY_RSP = 8216;
    public static final int CMD_RECORD_FIN_RSP = 8214;
    public static final int CMD_RECORD_DELETE_RSP = 8215;
    public static final int CMD_GET_STRONG_PARAM_RSP = 8304;
    public static final int CMD_2072_RSP = 8306;
    public static final int CMD_SET_SAMPLE_RATE = 4100;
    public static final int CMD_SET_HIGH_FILTER = 4192;
    public static final int CMD_SET_SITE_ID = 4104;
    public static final int CMD_SET_COM_PORT = 4106;
    public static final int CMD_SET_PULSE_CAL = 4103;
    public static final int CMD_SET_BINARY_CAL = 4103;
    public static final int CMD_SET_SINE_CAL = 4103;
    public static final int CMD_SET_STRONG_CAL = 4103;
    public static final int CMD_GET_ENV = 4193;
    public static final int CMD_GET_GPS = 4194;
    public static final int CMD_GET_PARAM = 4195;
    public static final int CMD_START_CAL = 4102;
    public static final int CMD_SET_CAL_WAIT_TIME = 4196;
    public static final int CMD_SET_GAIN = 4198;
    public static final int CMD_SET_MISC = 4197;
    public static final int CMD_SET_MGR_INFO = 4199;
    public static final int CMD_SET_TRIGGER_PARAM1 = 4116;
    public static final int CMD_SET_TRIGGER_PARAM2 = 4116;
    public static final int CMD_SET_TRIGGER_PARAM3 = 4116;
    public static final int CMD_SET_RECORD_PARAM = 4176;
    public static final int CMD_RECORD_LIST = 4117;
    public static final int CMD_RECORD_SEND = 4118;
    public static final int CMD_RECORD_ACK = 4127;
    public static final int CMD_RECORD_DELETE = 4119;
    public static final int CMD_GET_STRONG_PARAM = 4208;
    public static final int CMD_DATA_FLAG_24_COMPRESS = 21964;
    public static final int CMD_DATA_FLAG_24_3_SR_01 = 21947;
    public static final int CMD_DATA_FLAG_24_3_SR_50 = 21930;
    public static final int CMD_DATA_FLAG_16_3_SR_50 = 21845;
    private static int commonHeaderLength = 10;
    protected byte[] bytes;
    private static byte[] FRAME_HEADER = new byte[]{-65, 19, -105, 116};
    protected short siteID;
    protected short cmd;
    protected short frameLength;

    private GenericFrame() {
    }

    public GenericFrame(GenericFrame gframe) {
        this.bytes = new byte[gframe.bytes.length];
        System.arraycopy(gframe.bytes, 0, this.bytes, 0, this.bytes.length);
        this.siteID = gframe.siteID;
        this.cmd = gframe.cmd;
        this.frameLength = gframe.frameLength;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getData() {
        byte[] data = new byte[this.frameLength - 2];
        System.arraycopy(this.bytes, commonHeaderLength, data, 0, data.length);
        return data;
    }

    public int getSiteID() {
        return this.siteID;
    }

    public int getCmd() {
        return this.cmd;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[Site ID: \t" + this.siteID + "\n");
        sbuf.append(" CMD:\t" + Integer.toHexString(this.cmd) + "\n");
        sbuf.append(" Frame Length: \t" + this.frameLength + "]\n");
        return sbuf.substring(0);
    }

    public static GenericFrame buildGenericFrame(byte[] buf, int off) throws IOException {
        GenericFrame gframe = new GenericFrame();
        LittleEndianInputStream lin = new LittleEndianInputStream(new ByteArrayInputStream(buf, off, buf.length - off));
        if (buf.length - off <= 6) {
            return null;
        }
        gframe.siteID = lin.readShort();
        gframe.cmd = lin.readShort();
        gframe.frameLength = lin.readShort();
        if (buf.length - off < 6 + gframe.frameLength) {
            return null;
        }
        gframe.bytes = new byte[FRAME_HEADER.length + 6 + gframe.frameLength];
        System.arraycopy(FRAME_HEADER, 0, gframe.bytes, 0, FRAME_HEADER.length);
        System.arraycopy(buf, 0, gframe.bytes, FRAME_HEADER.length, 6 + gframe.frameLength);
        return gframe;
    }

    private static byte[] addChecksum(byte[] buf) throws IOException {
        LittleEndianInputStream lin = new LittleEndianInputStream(new ByteArrayInputStream(buf));
        lin.skip(FRAME_HEADER.length);
        int size = (buf.length - FRAME_HEADER.length) / 2;
        int sum = 0;
        int i = 0;
        while (i < size) {
            sum += lin.readUnsignedShort();
            ++i;
        }
        lin.close();
        sum = 0 - sum & 0xFFFF;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length + 2);
        LittleEndianOutputStream leo = new LittleEndianOutputStream(baos);
        leo.write(buf);
        leo.writeShort(sum);
        leo.close();
        return baos.toByteArray();
    }

    public static byte[] build_1016_Frame(int siteID, int CTL, int TM_SEC) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(18);
        LittleEndianOutputStream leo = new LittleEndianOutputStream(baos);
        leo.write(FRAME_HEADER);
        leo.writeShort(siteID);
        leo.writeShort(4118);
        leo.writeShort(8);
        leo.writeShort(CTL);
        leo.writeInt(TM_SEC);
        leo.close();
        byte[] buf = baos.toByteArray();
        return GenericFrame.addChecksum(buf);
    }

    public static byte[] build_101F_Frame(int siteID, int Type2, int TM_SEC) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(18);
        LittleEndianOutputStream leo = new LittleEndianOutputStream(baos);
        leo.write(FRAME_HEADER);
        leo.writeShort(siteID);
        leo.writeShort(4127);
        leo.writeShort(8);
        leo.write(0);
        leo.writeByte(Type2);
        leo.writeInt(TM_SEC);
        leo.close();
        return GenericFrame.addChecksum(baos.toByteArray());
    }

    public static byte[] build_1012_Frame(int siteID, int second, int ID) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(18);
        LittleEndianOutputStream leo = new LittleEndianOutputStream(baos);
        leo.write(FRAME_HEADER);
        leo.writeShort(siteID);
        leo.writeShort(4114);
        leo.writeShort(8);
        leo.writeInt(second);
        leo.writeShort(ID);
        leo.close();
        return GenericFrame.addChecksum(baos.toByteArray());
    }

    public static byte[] build_1015_Frame(int siteID) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(14);
        LittleEndianOutputStream leo = new LittleEndianOutputStream(baos);
        leo.write(FRAME_HEADER);
        leo.writeShort(siteID);
        leo.writeShort(4117);
        leo.writeShort(4);
        leo.writeShort(0);
        leo.close();
        return GenericFrame.addChecksum(baos.toByteArray());
    }

    public static byte[] build_1017_Frame(int siteID, int CTL, int TM_SEC) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(18);
        LittleEndianOutputStream leo = new LittleEndianOutputStream(baos);
        leo.write(FRAME_HEADER);
        leo.writeShort(siteID);
        leo.writeShort(4119);
        leo.writeShort(8);
        leo.writeShort(CTL);
        leo.writeInt(TM_SEC);
        leo.close();
        return GenericFrame.addChecksum(baos.toByteArray());
    }

    public static byte[] build_2018_Frame(int siteID) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(18);
        LittleEndianOutputStream leo = new LittleEndianOutputStream(baos);
        leo.write(FRAME_HEADER);
        leo.writeShort(siteID);
        leo.writeShort(8216);
        leo.writeShort(8);
        leo.writeShort(1);
        leo.writeInt(0);
        leo.close();
        return GenericFrame.addChecksum(baos.toByteArray());
    }

    public static byte[] build_1012_3C_Frame(int siteID, int sec) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16);
        LittleEndianOutputStream leo = new LittleEndianOutputStream(baos);
        leo.write(FRAME_HEADER);
        leo.writeShort(siteID);
        leo.writeShort(4114);
        leo.writeShort(6);
        leo.writeInt(sec);
        leo.close();
        return GenericFrame.addChecksum(baos.toByteArray());
    }

    public static byte[] build_1072_Frame() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(12);
        LittleEndianOutputStream leo = new LittleEndianOutputStream(baos);
        leo.write(FRAME_HEADER);
        leo.writeShort(0);
        leo.writeShort(4210);
        leo.writeShort(2);
        leo.close();
        return GenericFrame.addChecksum(baos.toByteArray());
    }
}

