/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edas;

import cn.org.gddsn.liss.port.CmdResponseManager;
import cn.org.gddsn.liss.port.ComServPortInf;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.MiniSeedStreamEncoder;
import cn.org.gddsn.liss.port.SiteInfo;
import cn.org.gddsn.liss.port.edas.Edas24Client;
import cn.org.gddsn.liss.port.edas.Edas24Exception;
import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.liss.port.edas.FrameParseException;
import cn.org.gddsn.liss.port.edas.Rsp_2072_Frame;
import cn.org.gddsn.util.Log4jConfig;
import cn.org.gddsn.util.QueueAddElementEvent;
import cn.org.gddsn.util.QueueAddElementEventListener;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;

public class EdasServPort
implements ComServPortInf,
DataFrameInput,
QueueAddElementEventListener {
    static Logger logger;
    String host;
    int port;
    String user;
    String passwd;
    Edas24Client client = null;
    private static final String[] compCode;
    private SiteInfo siteInfo = null;
    private String[] chanDis;
    private int data_type = 5;
    private MiniSeedStreamEncoder msis;
    private LogLostManager logLostManager = new LogLostManager();
    private boolean retransmit = false;
    private long lastSecond = -1L;
    private int no;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.edas.EdasServPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        compCode = new String[]{"Z", "E", "N"};
    }

    public EdasServPort(String edasServName, int edasServPort, String user, String passwd) {
        this.host = edasServName;
        this.port = edasServPort;
        this.user = user;
        this.passwd = passwd;
        CmdResponseManager.addQueueAddElementEventListener(this);
    }

    public void QueueAddElementHandler(QueueAddElementEvent e) {
        CmdResponseManager.Node node = (CmdResponseManager.Node)e.getValue();
        if (node.gframe.getCmd() == 8306) {
            try {
                Rsp_2072_Frame dFrame = new Rsp_2072_Frame(node.gframe);
                dFrame.getClass();
            }
            catch (FrameParseException frameParseException) {
                // empty catch block
            }
        }
    }

    public boolean prepareProcess() throws IOException {
        return true;
    }

    public boolean connect() throws IOException {
        boolean bvalue = false;
        logger.info("Opening EdasServPort.");
        try {
            if (this.client != null) {
                this.client.logout();
            }
        }
        catch (Edas24Exception ex) {
            logger.error("Edas24Exception: " + ex.getMessage());
        }
        catch (IOException ioEx) {
            logger.error("IOException: " + ioEx.getMessage());
        }
        try {
            this.client = null;
            this.msis = null;
            this.client = new Edas24Client(this.host, this.port);
            this.client.login(this.user, this.passwd);
            this.client.rtsOn();
        }
        catch (Edas24Exception ex) {
            logger.error("Exception: " + ex.getMessage());
            throw new IOException(ex.getMessage());
        }
        this.msis = new MiniSeedStreamEncoder(this);
        logger.info("Opened EdasServPort.");
        bvalue = true;
        return bvalue;
    }

    public void openComServPort() throws IOException {
        logger.info("Opening EdasServPort.");
        try {
            if (this.client != null) {
                this.client.logout();
            }
        }
        catch (Edas24Exception ex) {
            logger.error("Edas24Exception: " + ex.getMessage());
        }
        catch (IOException ioEx) {
            logger.error("IOException: " + ioEx.getMessage());
        }
        try {
            this.client = null;
            this.msis = null;
            this.client = new Edas24Client(this.host, this.port);
            this.client.login(this.user, this.passwd);
            this.client.rtsOn();
            if (this.retransmit && this.lastSecond != -1L) {
                logger.info("Try to retransmit data from: " + Long.toHexString(this.lastSecond) + ", " + new Date(this.lastSecond * 1000L));
                Edas24IPIO.Frame frame = null;
                DataFrame[] dfs = null;
                try {
                    do {
                        frame = this.client.getRtsFrame();
                    } while (frame.header.type.get() != 21981 && frame.header.type.get() != 21930);
                    if (frame.header.type.get() == 21981) {
                        Edas24IPIO.EDAS_STEIM2 steim2 = (Edas24IPIO.EDAS_STEIM2)frame.body;
                        dfs = steim2.decode();
                    } else if (frame.header.type.get() == 21930) {
                        Edas24IPIO.EDAS_55AA edas = (Edas24IPIO.EDAS_55AA)frame.body;
                        dfs = edas.decode();
                    }
                    this.client.requestData(this.no, (int)(this.lastSecond + 1L), (int)(dfs[0].time - this.lastSecond));
                }
                catch (Edas24IPIO.Edas24IPIOException ex) {
                    logger.warn(ex.getMessage(), ex);
                }
            }
        }
        catch (Edas24Exception ex) {
            logger.error("Exception: " + ex.getMessage());
            throw new IOException(ex.getMessage());
        }
        this.msis = new MiniSeedStreamEncoder(this);
        logger.info("Opened EdasServPort.");
    }

    public void closeComServPort() throws IOException {
        try {
            if (this.client != null) {
                this.client.logout();
            }
        }
        catch (Edas24Exception ex) {
            logger.error("Edas24Exception: " + ex.getMessage());
        }
        catch (IOException ioEx) {
            logger.error("IOException: " + ioEx.getMessage());
        }
    }

    public byte[] readMiniSeedFrame() throws IOException {
        byte[] buf = this.msis.readMiniSeedRecord();
        return buf;
    }

    public void setDataType(int data_type) {
        this.data_type = data_type;
    }

    public void setChannelDiscription(String[] chanDis) {
        this.chanDis = chanDis;
        this.siteInfo = new SiteInfo(chanDis, compCode);
    }

    public void setMaxCompressSamples(int maxSamples) {
        this.msis.setMaxSamplesInMiniSeed(maxSamples);
    }

    public void setSteimLevel(int level) {
        this.msis.setSteimInfo((short)level, (short)7);
    }

    public void close() {
        try {
            this.closeComServPort();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public DataFrame[] readDataFrame() throws IOException {
        DataFrame[] dfs;
        block13: {
            dfs = null;
            try {
                Edas24IPIO.Frame frame = null;
                do {
                    frame = this.client.getRtsFrame();
                    this.no = frame.header.no.get();
                } while (frame.header.type.get() != 21981 && frame.header.type.get() != 21930);
                if (frame.header.type.get() == 21981) {
                    Edas24IPIO.EDAS_STEIM2 steim2 = (Edas24IPIO.EDAS_STEIM2)frame.body;
                    dfs = steim2.decode();
                } else if (frame.header.type.get() == 21930) {
                    Edas24IPIO.EDAS_55AA edas = (Edas24IPIO.EDAS_55AA)frame.body;
                    dfs = edas.decode();
                }
                this.lastSecond = dfs[0].time;
                int i = 0;
                while (i < dfs.length) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Site ID: " + frame.header.no.get());
                    }
                    dfs[i].siteID = frame.header.no.get();
                    dfs[i].setChannelLocator(this.siteInfo.getChannelLocator(dfs[i].siteID, compCode[i]));
                    if (dfs[i].getChannelLocator().getStationCode().equals("")) {
                        logger.warn(String.valueOf(this.host) + ":" + this.port + " got unknown ChannelLocator, may be need to config chanDisc.");
                    }
                    ++i;
                }
                if (dfs != null) break block13;
                logger.warn("From " + this.host + ":" + this.port + " Get It NULL");
                return null;
            }
            catch (Edas24IPIO.Edas24IPIOException ex) {
                logger.error("Exception: " + ex.getMessage());
                logger.warn(ex.getMessage(), ex);
                throw new IOException(ex.getMessage());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("From " + this.host + ":" + this.port + " Get It: " + dfs.length + " : " + dfs[0]);
        }
        if (this.logLostManager != null && dfs != null) {
            int i = 0;
            while (i < dfs.length) {
                LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
                timeInfo.date = dfs[i].time * 1000L + dfs[i].ns / 1000000L;
                timeInfo.length = dfs[i].data.length * 1000 / dfs[i].sampRate;
                this.logLostManager.log(dfs[i].getChannelLocator(), timeInfo);
                ++i;
            }
        }
        return dfs;
    }

    public void setLogLostManager(LogLostManager logLostManager) {
        this.logLostManager = logLostManager;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getDataTpe() {
        return this.data_type;
    }

    public String[] getChannelDiscription() {
        return this.chanDis;
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain("EdasServPort.properties");
        EdasServPort csPort = null;
        String[] cDis = new String[]{"GD/TST/00/BHZ:BHE:BHN"};
        if (args.length < 5) {
            logger.debug("Usage:\n java cn.org.gddsn.liss.port.EdasServPort edasServ edasPort user password data_type");
            System.exit(-1);
        } else {
            csPort = new EdasServPort(args[0], Integer.parseInt(args[1]), args[2], args[3]);
            if (args[4].equalsIgnoreCase("EDAS_STEIM2")) {
                csPort.setDataType(5);
                logger.info(String.valueOf(args[0]) + " data type is: EDAS_STEIM2");
            }
            cDis = new String[args.length - 5];
            int i = 5;
            while (i < args.length) {
                cDis[i - 5] = args[i];
                ++i;
            }
            csPort.setChannelDiscription(cDis);
        }
        try {
            csPort.openComServPort();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        byte[] buf = null;
        while (true) {
            if ((buf = csPort.readMiniSeedFrame()) != null) {
                GenericMiniSeedRecord gmsr = GenericMiniSeedRecord.buildMiniSeedRecord(buf);
                logger.info(gmsr);
                continue;
            }
            logger.error("Could not read one miniseed packet");
        }
    }

    public String getPasswd() {
        return this.passwd;
    }

    public String getUser() {
        return this.user;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isRetransmit() {
        return this.retransmit;
    }

    public void setRetransmit(boolean retransmit) {
        this.retransmit = retransmit;
    }
}

