/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.edas;

import cn.org.gddsn.liss.port.edas.BufferedReader0;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class Edas24ControlResponse {
    static Logger logger;
    public static final char REPLY_POSITIVE = '1';
    public static final char REPLY_NEGATIVE = '2';
    public static final char REPLY_CLOSE = '3';
    public static final char REGARDING_POSITIVE_CONNECTION = '0';
    public static final char REGARDING_NEGATIVE_CONNECTION = '0';
    public static final char REGARDING_POSITIVE_STREAM = '1';
    public static final char REGARDING_NEGATIVE_STREAM = '1';
    public static final char REGARDING_POSITIVE_PACKET = '2';
    public static final char REGARDING_NEGATIVE_PACKET = '2';
    public static final char REGARDING_POSITIVE_EVENT_INFO = '3';
    public static final char REGARDING_NEGATIVE_EVENT_INFO = '5';
    public static final char REGARDING_POSITIVE_EVENT_WAVEFORM = '4';
    public static final char REGARDING_NEGATIVE_EVENT_WAVEFORM = '6';
    public static final char REGARDING_NEGATIVE_SYNTAX = '8';
    public static final char REGARDING_NEGATIVE_DATA_LINK = '9';
    private String message;
    private String returnCode;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.edas.Edas24ControlResponse");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    protected Edas24ControlResponse(BufferedReader0 in) throws IOException {
        this.setMessage2(in);
    }

    public String getMessage() {
        return this.message;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public String toString() {
        return this.message;
    }

    public boolean isPositiveReply() {
        return this.returnCode.charAt(0) == '1';
    }

    public boolean isNegativeReply() {
        return this.returnCode.charAt(0) == '2';
    }

    public boolean isCloseReply() {
        return this.returnCode.charAt(0) == '3';
    }

    public boolean isRegardingPositiveConnection() {
        return this.returnCode.charAt(1) == '0';
    }

    public boolean isRegardingNegativeConnection() {
        return this.returnCode.charAt(1) == '0';
    }

    public boolean isRegardingPositiveStream() {
        return this.returnCode.charAt(1) == '1';
    }

    public boolean isRegardingNegativeStream() {
        return this.returnCode.charAt(1) == '1';
    }

    public boolean isRegardingPositivePacket() {
        return this.returnCode.charAt(1) == '2';
    }

    public boolean isRegardingNegativePacket() {
        return this.returnCode.charAt(1) == '2';
    }

    public boolean isRegardingPositiveEventInfo() {
        return this.returnCode.charAt(1) == '3';
    }

    public boolean isRegardingNegativeEventInfo() {
        return this.returnCode.charAt(1) == '5';
    }

    public boolean isRegardingPositiveEventWaveform() {
        return this.returnCode.charAt(1) == '4';
    }

    public boolean isRegardingNegativeEventWaveform() {
        return this.returnCode.charAt(1) == '6';
    }

    public boolean isRegardingNegativeSyntax() {
        return this.returnCode.charAt(1) == '8';
    }

    public boolean isRegardingNegativeDataLink() {
        return this.returnCode.charAt(1) == '9';
    }

    private static String readLine(BufferedReader0 in) throws IOException {
        StringBuffer buf = new StringBuffer();
        String line = null;
        do {
            if ((line = in.readLine()) == null) {
                return null;
            }
            buf.append(line);
        } while (in.getTermintor() == '\n');
        return buf.toString();
    }

    private void setMessage2(BufferedReader0 reader) throws IOException {
        String line = Edas24ControlResponse.readLine(reader);
        if (line == null) {
            logger.warn("Read null string, server side closed");
            throw new EOFException("Read null string, server side closed");
        }
        StringBuffer reply = new StringBuffer(line);
        if (reply.length() < 3) {
            logger.warn("Read a string less than 3 char, server side closed");
            throw new EOFException("Read a string less than 3 char, server side closed");
        }
        this.returnCode = reply.toString().substring(0, 3);
        this.message = reply.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("reply: " + this.message);
        }
    }

    private void setMessage1(BufferedReader in) throws IOException {
        StringBuffer buffer = new StringBuffer();
        while (true) {
            if (!in.ready()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            String line = in.readLine();
            if (this.returnCode == null) {
                this.returnCode = line.substring(0, 3);
            }
            buffer.append(line);
            buffer.append('\n');
            if (line.charAt(3) == ' ' && this.returnCode.equals(line.substring(0, 3))) break;
        }
        this.message = buffer.toString();
    }

    private void setMessage(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            logger.warn("Read null string, server side closed");
            throw new EOFException("Read null string, server side closed");
        }
        StringBuffer reply = new StringBuffer(line);
        if (reply.length() < 3) {
            logger.warn("Read a string less than 3 char, server side closed");
            throw new EOFException("Read a string less than 3 char, server side closed");
        }
        this.returnCode = reply.toString().substring(0, 3);
        reply.append("\r\n");
        if (reply.charAt(3) == '-') {
            boolean complete = false;
            while (!complete) {
                line = reader.readLine();
                if (line == null) {
                    logger.warn("Read null string, server side closed");
                    throw new EOFException("Read null string, server side closed");
                }
                if (line.substring(0, 3).equals(this.returnCode) && line.charAt(3) == ' ') {
                    reply.append(line);
                    complete = true;
                    continue;
                }
                reply.append(String.valueOf(line) + "\r\n");
            }
        }
        this.message = reply.toString();
    }
}

