/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port.altus;

import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.LogLostManager;
import cn.org.gddsn.liss.port.SiteInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class AltusInputStream
implements DataFrameInput {
    static Logger logger;
    private static final String[] compCode;
    InputStream in;
    String comPort;
    private int samps;
    private int sampRate;
    private int chns;
    private static final int[] frameHead;
    private int headLen = frameHead.length;
    private int totalFrameLength;
    private int commonHeaderLength = 8;
    private int headChecksumOffset = 9;
    private int[] head = new int[this.headLen];
    private int siteID;
    private int cmd;
    private int packetSER;
    private int sourceID;
    private int destID;
    private int length;
    private int headChecksum;
    private int SN;
    private int chan;
    private int dStatus;
    private int dataSER;
    private int sec80;
    private int ns;
    private short _unsed;
    private int[] data;
    private int CRC;
    private int packetChecksum;
    private byte[] buffer;
    private SiteInfo siteInfo = null;
    private static int dsec_70_80;
    private LogLostManager logLostManager = new LogLostManager();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.altus.AltusInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        compCode = new String[]{"E", "N", "Z"};
        frameHead = new int[]{192};
    }

    public AltusInputStream(InputStream in, String comPort, String[] chanDiscription) {
        this.in = in;
        this.comPort = comPort;
        this.samps = 100;
        this.sampRate = 100;
        this.data = new int[this.samps];
        this.chns = 3;
        this.totalFrameLength = 300;
        this.buffer = new byte[4096];
        this.siteInfo = new SiteInfo(chanDiscription, compCode);
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(1980, 0, 1, 0, 0, 0);
        dsec_70_80 = (int)(cal.getTime().getTime() / 1000L);
    }

    public int getTotalChannels() {
        return this.siteInfo.getChannalSize();
    }

    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final DataFrame[] readDataFrame() throws IOException {
        if (!this.hasEnoughData()) {
            return null;
        }
        if (!this.findFrameHead()) {
            return null;
        }
        int n = this.readOnePacket();
        if (n == -1) {
            return null;
        }
        int nn = this.removeEsc(n);
        if (!(this.checksum(this.buffer, 0, 8, 1) && this.checksum(this.buffer, 9, nn - 2 - 9, 2) && this.checkCRC(this.buffer, 25, nn - 2 - 9 - 16))) {
            return null;
        }
        this.parse(nn);
        if (this.cmd != 138) {
            return null;
        }
        DataFrame[] dfs = new DataFrame[]{new DataFrame()};
        dfs[0].data = new int[this.data.length];
        System.arraycopy(this.data, 0, dfs[0].data, 0, this.data.length);
        dfs[0].flag = 0;
        dfs[0].siteID = this.SN;
        dfs[0].time = this.sec80 + dsec_70_80;
        dfs[0].ns = this.ns;
        dfs[0].sampRate = this.sampRate;
        dfs[0].setChannelLocator(this.siteInfo.getChannelLocator(this.siteID, compCode[this.chan]));
        if (this.logLostManager != null && dfs != null) {
            int i = 0;
            while (i < dfs.length) {
                LogLostManager.TimeInfo timeInfo = new LogLostManager.TimeInfo();
                timeInfo.date = dfs[i].time * 1000L + dfs[i].ns / 1000000L;
                timeInfo.length = dfs[i].data.length * 1000 / dfs[i].sampRate;
                this.logLostManager.log(dfs[i].getChannelLocator(), timeInfo);
                ++i;
            }
        }
        return dfs;
    }

    private boolean findFrameHead() throws IOException {
        int ret;
        int i = 0;
        while (i < this.headLen) {
            this.head[i] = 0;
            ++i;
        }
        int firstIdx = 0;
        boolean found = false;
        while ((ret = this.forceRead(this.in)) != -1) {
            this.head[firstIdx % this.headLen] = ret;
            int i2 = firstIdx;
            while (i2 < firstIdx + this.headLen) {
                if (this.head[(i2 + 1) % this.headLen] != frameHead[i2 - firstIdx]) {
                    found = false;
                    break;
                }
                found = true;
                ++i2;
            }
            if (found) break;
            ++firstIdx;
            firstIdx %= this.headLen;
        }
        if (!found) {
            logger.warn(String.valueOf(this.siteInfo.getChannelLocator(this.siteID, "Z").getStationCode()) + " has enough data to read, but I can't found Frame Header \"0xC0\".");
        }
        return found;
    }

    private boolean hasEnoughData() throws IOException {
        int delay = 3000;
        int count = 0;
        while (delay != 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.in.available() >= 512) break;
            if (count++ > 998 && this.in.available() == 0) {
                return false;
            }
            --delay;
        }
        delay = 3000 - delay;
        return true;
    }

    private int readOnePacket() throws IOException {
        int i = 0;
        int c = this.forceRead(this.in);
        if (c != 192) {
            this.buffer[i++] = (byte)c;
        }
        if ((c = this.forceRead(this.in)) != 192) {
            this.buffer[i++] = (byte)c;
        }
        while ((this.buffer[i++] = (byte)this.forceRead(this.in)) != -64 && i < this.buffer.length) {
        }
        if (i >= this.buffer.length) {
            return -1;
        }
        if (this.forceRead(this.in) != 192) {
            return -1;
        }
        return i - 1;
    }

    private int forceRead(InputStream IN) throws IOException {
        int c = -1;
        while ((c = IN.available()) < 1) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return IN.read();
    }

    private int removeEsc(int Offset) {
        int n = Offset;
        int i = 0;
        while (i < n - 1) {
            if (this.buffer[i] == 92 && this.buffer[i + 1] == -35 || this.buffer[i] == 92 && this.buffer[i + 1] == -36) {
                this.buffer[i] = this.buffer[i + 1] == -35 ? -64 : 92;
                int j = i + 2;
                while (j < n) {
                    this.buffer[j - 1] = this.buffer[j];
                    ++j;
                }
                --n;
            }
            ++i;
        }
        return n;
    }

    private void parse(int len) throws IOException {
        DataInputStream dIn = new DataInputStream(new ByteArrayInputStream(this.buffer, 0, len));
        this.cmd = dIn.read();
        this.packetSER = dIn.read();
        this.sourceID = dIn.readUnsignedShort();
        this.destID = dIn.readUnsignedShort();
        this.length = dIn.readUnsignedShort();
        this.headChecksum = dIn.read();
        this.SN = dIn.readUnsignedShort();
        this.chan = dIn.readUnsignedByte();
        this.dStatus = dIn.readUnsignedByte();
        this.dataSER = dIn.readInt();
        this.sec80 = dIn.readInt();
        this.ns = dIn.readUnsignedShort() * 1000;
        dIn.readUnsignedShort();
        int i = 0;
        while (i < 100) {
            int b;
            int b2;
            int b1 = dIn.read();
            if ((b1 & 0x80) == 128) {
                int b3;
                b2 = dIn.read();
                b = ((b1 & 0x7F) << 16) + (b2 << 8) + (b3 = dIn.read());
                if ((b & 0x400000) == 0x400000) {
                    b -= 0x800000;
                }
                this.data[i] = b;
            } else {
                b2 = dIn.read();
                b = ((b1 & 0x7F) << 8) + b2;
                if ((b & 0x4000) == 16384) {
                    b -= 32768;
                }
                this.data[i] = this.data[i - 1] + b;
            }
            ++i;
        }
        dIn.close();
    }

    private boolean checkCRC(byte[] buf, int off, int dlen) throws IOException {
        return true;
    }

    private boolean checksum(byte[] buf, int off, int dlen, int clen) throws IOException {
        boolean retValue = false;
        DataInputStream dIn = new DataInputStream(new ByteArrayInputStream(this.buffer, off, dlen + clen));
        int c_checksum = 0;
        int i = 0;
        while (i < dlen) {
            c_checksum += dIn.read();
            ++i;
        }
        if (clen == 2) {
            try {
                if ((c_checksum & 0xFFFF) == dIn.readUnsignedShort()) {
                    retValue = true;
                }
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage(), ex);
            }
        } else if ((c_checksum & 0xFF) == dIn.readUnsignedByte()) {
            retValue = true;
        }
        dIn.close();
        return retValue;
    }
}

