/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port;

import cn.org.gddsn.liss.port.Buffer;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.seis.ChannelLocator;
import edu.iris.miniseedutils.steim.GenericCompressMiniSeedRecord;
import edu.iris.timeutils.TimeStamp;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MiniSeedStreamEncoder {
    static Logger logger;
    private static DecimalFormat fmt;
    private int seq = 0;
    private static int maxSamplesInMiniSeed;
    private short steimLevel = (short)2;
    private short dframes = (short)7;
    private GenericCompressMiniSeedRecord cmsr = new GenericCompressMiniSeedRecord(this.steimLevel, this.dframes);
    private DataFrameInput dataFrameInput;
    private Hashtable bufferTable = new Hashtable();
    private Vector outVec = new Vector();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.MiniSeedStreamEncoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
        fmt = new DecimalFormat("000000");
        maxSamplesInMiniSeed = 1500;
    }

    public MiniSeedStreamEncoder() {
    }

    public void setDataFrameInput(DataFrameInput in) {
        this.dataFrameInput = in;
    }

    public MiniSeedStreamEncoder(DataFrameInput in) {
        this.dataFrameInput = in;
    }

    public void setMaxSamplesInMiniSeed(int maxSamples) {
        maxSamplesInMiniSeed = maxSamples;
    }

    public void setSteimLevel(short steimLevel) {
        this.steimLevel = steimLevel;
    }

    public void setSteimInfo(short steimLevel, short dframes) {
        this.steimLevel = steimLevel;
        this.dframes = dframes;
        this.cmsr = new GenericCompressMiniSeedRecord(steimLevel, dframes);
    }

    public void close() throws IOException {
        this.dataFrameInput.close();
    }

    public final byte[] readMiniSeedRecord() throws IOException {
        DataFrame[] dfs = null;
        Buffer buffer = null;
        boolean bGaps = false;
        boolean bExceed = false;
        this.outVec.removeAllElements();
        while (true) {
            if ((dfs = this.dataFrameInput.readDataFrame()) == null) {
                logger.warn("In MiniSeedInputStream, readDataFram return NULL");
                continue;
            }
            if (dfs[0].flag != 0) {
                logger.info(dfs[0]);
            }
            bExceed = false;
            int j = 0;
            while (j < dfs.length) {
                if (logger.isDebugEnabled() && j == 0 && dfs[j].getChannelLocator().getChanCode().equals("BHE")) {
                    logger.info(dfs[j].toString());
                }
                buffer = this.getBuffer(dfs[j].getChannelLocator());
                if (!buffer.calibrateFlag && dfs[j].flag != 0) {
                    buffer.calibrateFlag = true;
                    buffer.caliVal = dfs[j].flag;
                }
                if (dfs[j].flag == 0) {
                    buffer.calibrateFlag = false;
                    buffer.caliVal = 0;
                }
                if (buffer.bufLen == 0) {
                    buffer.startTime.setTime(dfs[j].time * 1000L);
                    buffer.startTime.setNanos((int)dfs[j].ns);
                }
                if (buffer.startTime.getTime() + (long)(buffer.bufLen * 1000 / dfs[j].sampRate) == dfs[j].time * 1000L + dfs[j].ns / 1000000L) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("buffer.bufLen= " + buffer.bufLen + "\tdata.length=" + dfs[j].data.length);
                    }
                    System.arraycopy(dfs[j].data, 0, buffer.buf, buffer.bufLen, dfs[j].data.length);
                    buffer.bufLen += dfs[j].data.length;
                    while (buffer.bufLen > buffer.nextMaxSamplesInMiniSeed) {
                        bExceed = true;
                        this.addExceedDataOut(dfs[j], buffer);
                    }
                } else if (buffer.startTime.getTime() + (long)(buffer.bufLen * 1000 / dfs[j].sampRate) < dfs[j].time * 1000L + dfs[j].ns / 1000000L) {
                    bGaps = true;
                    this.addGapsDataOut(dfs[j], buffer);
                } else {
                    bGaps = true;
                    this.addGapsDataOut(dfs[j], buffer);
                }
                ++j;
            }
            if (bExceed || bGaps) break;
        }
        if (logger.isDebugEnabled()) {
            logger.info("Size of Buffer " + buffer.bufLen + ", bExceed=" + bExceed + ", bGaps=" + bGaps);
        }
        if (dfs == null) {
            return null;
        }
        dfs = null;
        buffer = null;
        return this.fixSeq(this.getTotalBytes());
    }

    private void addExceedDataOut(DataFrame df, Buffer buffer) throws IOException {
        this.cmsr.setStartTime(new TimeStamp(buffer.startTime.getTime()));
        this.cmsr.setSampleRate(df.sampRate);
        ChannelLocator cl = df.getChannelLocator();
        this.cmsr.setStationInfo(cl.getNetCode(), cl.getStationCode(), cl.getLocID(), cl.getChanCode());
        if (buffer.calibrateFlag) {
            this.cmsr.setActivityFlag(1);
            this.cmsr.setCaliFlag(buffer.caliVal);
        } else {
            this.cmsr.setActivityFlag(0);
        }
        int nSamps = this.cmsr.encodeOneMiniSeedRecord(buffer.buf, buffer.bufLen);
        System.arraycopy(buffer.buf, nSamps, buffer.buf, 0, buffer.bufLen - nSamps);
        buffer.bufLen -= nSamps;
        buffer.startTime.setTime(buffer.startTime.getTime() + (long)(nSamps * 1000 / df.sampRate));
        this.outVec.add(this.cmsr.getBytes());
        buffer.nextMaxSamplesInMiniSeed = nSamps + 50;
        if (buffer.nextMaxSamplesInMiniSeed > maxSamplesInMiniSeed) {
            buffer.nextMaxSamplesInMiniSeed = maxSamplesInMiniSeed;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("buffer.nextMaxSamplesInMiniSeed: " + buffer.nextMaxSamplesInMiniSeed);
        }
    }

    private void addGapsDataOut(DataFrame df, Buffer buffer) throws IOException {
        this.cmsr.setStartTime(new TimeStamp(buffer.startTime.getTime()));
        this.cmsr.setSampleRate(df.sampRate);
        ChannelLocator cl = df.getChannelLocator();
        this.cmsr.setStationInfo(cl.getNetCode(), cl.getStationCode(), cl.getLocID(), cl.getChanCode());
        if (buffer.calibrateFlag) {
            this.cmsr.setActivityFlag(1);
            this.cmsr.setCaliFlag(buffer.caliVal);
        } else {
            this.cmsr.setActivityFlag(0);
        }
        int nSamps = this.cmsr.encodeMiniSeedRecord(buffer.buf, buffer.bufLen);
        if (nSamps != buffer.bufLen) {
            logger.error(new Date() + ":\tError in handle gaps data in addGapsDataOut()");
        }
        this.outVec.add(this.cmsr.getTotalBytes());
        System.arraycopy(df.data, 0, buffer.buf, 0, df.data.length);
        buffer.bufLen = df.data.length;
        buffer.startTime.setTime(df.time * 1000L);
        buffer.startTime.setNanos((int)df.ns);
    }

    private byte[] getTotalBytes() {
        Enumeration Enum2 = this.outVec.elements();
        int nTotal = 0;
        while (Enum2.hasMoreElements()) {
            byte[] msBytes = (byte[])Enum2.nextElement();
            nTotal += msBytes.length;
        }
        if (nTotal == 0) {
            return null;
        }
        byte[] totalBytes = new byte[nTotal];
        int count = 0;
        Enum2 = this.outVec.elements();
        while (Enum2.hasMoreElements()) {
            byte[] msBytes = (byte[])Enum2.nextElement();
            System.arraycopy(msBytes, 0, totalBytes, count, msBytes.length);
            count += msBytes.length;
        }
        this.outVec.removeAllElements();
        Enum2 = null;
        return totalBytes;
    }

    private byte[] fixSeq(byte[] miniSeedFrame) {
        if (miniSeedFrame == null || miniSeedFrame.length == 0) {
            return null;
        }
        int indx = 0;
        while (indx < miniSeedFrame.length) {
            System.arraycopy(fmt.format(this.seq).getBytes(), 0, miniSeedFrame, indx, 6);
            this.incSeq();
            indx += 512;
        }
        return miniSeedFrame;
    }

    private void incSeq() {
        this.seq = (this.seq + 1) % 1000000;
    }

    private Buffer getBuffer(ChannelLocator chanLocator) {
        Buffer buffer = (Buffer)this.bufferTable.get(chanLocator);
        if (buffer == null) {
            buffer = new Buffer();
            this.bufferTable.put(chanLocator, buffer);
        }
        return buffer;
    }

    private Date getStdDate() {
        return new Date();
    }

    public short getSteimLevel() {
        return this.steimLevel;
    }
}

