/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port;

import cn.org.gddsn.seis.ChannelLocator;
import java.util.Date;

public class DataFrame {
    public static final int CALI_FLAG_NORMAL = 0;
    public static final int CALI_FLAG_PULSE = 1;
    public static final int CALI_FLAG_SINE = 2;
    public static final int CALI_FLAG_UNKNOWN = 3;
    public long time;
    public long ns;
    public int siteID;
    public int flag;
    public int[] data;
    public int sampRate = 50;
    private ChannelLocator channelLocator = new ChannelLocator();

    public DataFrame copy() {
        DataFrame df = new DataFrame();
        df.siteID = this.siteID;
        df.time = this.time;
        df.flag = this.flag;
        df.data = new int[this.data.length];
        System.arraycopy(this.data, 0, df.data, 0, this.data.length);
        df.sampRate = this.sampRate;
        df.channelLocator = this.channelLocator.copy();
        return df;
    }

    public String toString(boolean dispData) {
        StringBuffer buffer = new StringBuffer(4096);
        if (dispData) {
            int i = 0;
            while (i < this.data.length) {
                buffer.append(this.data[i]);
                buffer.append("\n");
                ++i;
            }
        }
        buffer.append("Time:  ");
        buffer.append(new Date(this.time * 1000L).toString());
        buffer.append("; ");
        buffer.append("ns:  ");
        buffer.append(this.ns);
        buffer.append("; ");
        buffer.append("site id:  ");
        buffer.append(this.siteID);
        buffer.append("; ");
        buffer.append("Flag:  ");
        buffer.append(this.flag);
        buffer.append("; ");
        buffer.append("SampRate:  ");
        buffer.append(this.sampRate);
        buffer.append("; ");
        buffer.append(this.channelLocator.toString());
        return buffer.substring(0);
    }

    public String toString() {
        return this.toString(false);
    }

    public ChannelLocator getChannelLocator() {
        return this.channelLocator;
    }

    public void setChannelLocator(ChannelLocator chanLocator) {
        this.channelLocator = chanLocator;
    }
}

