/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port;

import cn.org.gddsn.liss.port.ComServPortInf;
import cn.org.gddsn.liss.port.DataFrame;
import cn.org.gddsn.liss.port.DataFrameInput;
import cn.org.gddsn.liss.port.MiniSeedStreamEncoder;
import cn.org.gddsn.liss.port.altus.AltusInputStream;
import cn.org.gddsn.liss.port.edas.DataFrameInputStream;
import cn.org.gddsn.liss.port.edas.GenericFrame;
import cn.org.gddsn.liss.port.geotech.GeoTechInputStream;
import cn.org.gddsn.liss.port.guralp.GuralpInputStream;
import cn.org.gddsn.liss.port.mr2002.MR2002InputStream;
import cn.org.gddsn.liss.port.tde.TdeInputStream;
import cn.org.gddsn.liss.port.tyt.TytInputStream;
import cn.org.gddsn.util.Log4jConfig;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;

public class ComServPort
implements ComServPortInf {
    static Logger logger;
    String comServName;
    int comServPort;
    Socket comSocket = null;
    private String[] chanDis;
    private int data_type = 0;
    private DataFrameInput dFrameIn;
    private MiniSeedStreamEncoder msis;
    private String[] stationCode;
    private int original_site_id = 1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.ComServPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public ComServPort(String comServName, int comServPort) {
        this.comServName = comServName;
        this.comServPort = comServPort;
    }

    public void close() {
        try {
            if (this.comSocket != null) {
                this.comSocket.close();
            }
            this.comSocket = null;
            this.dFrameIn = null;
            this.msis = null;
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public boolean accept(GenericMiniSeedRecord gmsr) {
        return true;
    }

    public String[] getStationCode() {
        return this.stationCode;
    }

    public void setStationCode(String[] stationCode) {
        this.stationCode = stationCode;
    }

    public void open() {
        try {
            this.openComServPort();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public void openComServPort() throws IOException {
        logger.info("Opening ComServPort.");
        if (this.comSocket != null) {
            this.comSocket.close();
        }
        this.comSocket = null;
        this.dFrameIn = null;
        this.msis = null;
        this.comSocket = new Socket(this.comServName, this.comServPort);
        this.comSocket.setSoTimeout(120000);
        if (this.data_type == 0) {
            this.dFrameIn = new DataFrameInputStream(this.comSocket.getInputStream(), String.valueOf(this.comServName) + ":" + this.comServPort, this.chanDis);
        } else if (this.data_type == 3) {
            DataFrameInputStream dFrameIn1 = new DataFrameInputStream(this.comSocket.getInputStream(), String.valueOf(this.comServName) + ":" + this.comServPort, this.chanDis);
            dFrameIn1.setRequest(this.comSocket.getOutputStream());
            this.dFrameIn = dFrameIn1;
        } else if (this.data_type == 1) {
            this.dFrameIn = new AltusInputStream(this.comSocket.getInputStream(), String.valueOf(this.comServName) + ":" + this.comServPort, this.chanDis);
        } else if (this.data_type == 2) {
            this.dFrameIn = new GeoTechInputStream(this.comSocket.getInputStream(), this.comSocket.getOutputStream(), String.valueOf(this.comServName) + ":" + this.comServPort, this.chanDis);
        } else if (this.data_type == 4) {
            this.dFrameIn = new TytInputStream(this.comSocket.getInputStream(), String.valueOf(this.comServName) + ":" + this.comServPort, this.chanDis);
        } else if (this.data_type == 11) {
            this.dFrameIn = new TdeInputStream(this.comSocket.getInputStream(), String.valueOf(this.comServName) + ":" + this.comServPort, this.chanDis);
        } else if (this.data_type == 12) {
            this.dFrameIn = new GuralpInputStream(this.comSocket.getInputStream(), this.comSocket.getOutputStream(), String.valueOf(this.comServName) + ":" + this.comServPort, this.chanDis);
        } else if (this.data_type == 13) {
            this.dFrameIn = new MR2002InputStream(this.comSocket.getInputStream(), this.comSocket.getOutputStream(), String.valueOf(this.comServName) + ":" + this.comServPort, this.chanDis);
        }
        this.msis = new MiniSeedStreamEncoder(this.dFrameIn);
        logger.info("Opened ComServPort.");
    }

    public void requestNewDataFrame(byte[] buf) throws IOException {
        this.comSocket.getOutputStream().write(buf);
        this.comSocket.getOutputStream().flush();
    }

    public void requestNewDataFrame() throws IOException {
        this.comSocket.getOutputStream().write(GenericFrame.build_1012_3C_Frame(this.original_site_id, 0));
        this.comSocket.getOutputStream().flush();
    }

    public DataFrame[] readDataFrame() throws IOException {
        DataFrame[] adFrame;
        block5: {
            adFrame = null;
            try {
                adFrame = this.dFrameIn.readDataFrame();
                if (adFrame != null) break block5;
                logger.warn("From " + this.comServName + ":" + this.comServPort + " Get It NULL");
                return null;
            }
            catch (IOException ex) {
                logger.warn(ex.getMessage(), ex);
                return null;
            }
        }
        if (this.data_type == 3) {
            DataFrameInputStream dFrameIn1 = (DataFrameInputStream)this.dFrameIn;
            this.original_site_id = dFrameIn1.get_original_site_id();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("From " + this.comServName + ":" + this.comServPort + " Get It!");
        }
        return adFrame;
    }

    public byte[] readMiniSeedFrame() throws IOException {
        byte[] buf = this.msis.readMiniSeedRecord();
        return buf;
    }

    public void setDataType(int data_type) {
        this.data_type = data_type;
    }

    public void setChannelDiscription(String[] chanDis) {
        this.chanDis = chanDis;
    }

    public void setMaxCompressSamples(int maxSamples) {
        this.msis.setMaxSamplesInMiniSeed(maxSamples);
    }

    public int getDataType() {
        return this.data_type;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.comSocket.getOutputStream();
    }

    public String[] getChannelDiscription() {
        return this.chanDis;
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain("ComServPort.properties");
        ComServPort csPort = null;
        String[] cDis = new String[]{"GD/TST/00/BHZ:BHE:BHN"};
        if (args.length < 2) {
            logger.error("Usage:\n java cn.org.gddsn.liss.port.ComServPort comServ comPort data_type");
            System.exit(-1);
        } else {
            csPort = new ComServPort(args[0], Integer.parseInt(args[1]));
            if (args[2].equalsIgnoreCase("EDAS")) {
                csPort.setDataType(0);
                logger.info(String.valueOf(args[0]) + " data type is: EDAS");
            } else if (args[2].equalsIgnoreCase("EDAS_REQ")) {
                csPort.setDataType(3);
                logger.info(String.valueOf(args[0]) + " data type is: EDAS_REQ");
            } else if (args[2].equalsIgnoreCase("ALTUS")) {
                csPort.setDataType(1);
                logger.info(String.valueOf(args[0]) + " data type is: ALTUS");
            } else if (args[2].equalsIgnoreCase("DR24")) {
                csPort.setDataType(2);
                logger.info(String.valueOf(args[0]) + " data type is: DR24");
            } else if (args[2].equalsIgnoreCase("TYT")) {
                csPort.setDataType(4);
                logger.info(String.valueOf(args[0]) + " data type is: TYT");
            }
            cDis = new String[args.length - 3];
            int i = 3;
            while (i < args.length) {
                cDis[i - 3] = args[i];
                ++i;
            }
            csPort.setChannelDiscription(cDis);
        }
        try {
            csPort.openComServPort();
        }
        catch (IOException e2) {
            logger.error(e2.getMessage(), e2);
        }
        csPort.requestNewDataFrame(GenericFrame.build_1072_Frame());
        DataFrame[] dfs = null;
        while (true) {
            if ((dfs = csPort.readDataFrame()) != null) {
                logger.info(dfs[0]);
                continue;
            }
            logger.info("Lost at least one second packet");
        }
    }
}

