/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.port;

import cn.org.gddsn.liss.port.MiniSeedHeaderFilter;
import cn.org.gddsn.liss.port.MiniSeedStreamInf;
import cn.org.gddsn.liss.port.event.MiniSeedPortEvent;
import cn.org.gddsn.liss.port.event.MiniSeedPortEventListener;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class AbstractMiniSeedPort
implements MiniSeedStreamInf {
    static Logger logger;
    private transient Vector miniSeedPortEventListeners;
    private Thread sendMiniSeedDataThread = null;
    private MiniSeedHeaderFilter miniSeedHeaderFilter = null;
    private boolean quit = false;
    private String[] stationCode;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.port.AbstractMiniSeedPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public void closePort() {
        this.quit = true;
    }

    public String[] getStationCode() {
        return this.stationCode;
    }

    public void setStationCode(String[] stationCode) {
        this.stationCode = stationCode;
    }

    public void openPort() {
        this.quit = false;
        this.sendMiniSeedData();
    }

    public boolean accept(GenericMiniSeedRecord gmsr) {
        return true;
    }

    public void sendMiniSeedData() {
        this.sendMiniSeedDataThread = new Thread(){

            public void run() {
                logger.info("sendMiniSeedDataThread start");
                AbstractMiniSeedPort.this.connectServer();
                GenericMiniSeedRecord gmsRec = null;
                byte[] buf = null;
                byte[] mbuf = new byte[512];
                while (!AbstractMiniSeedPort.this.quit) {
                    try {
                        buf = AbstractMiniSeedPort.this.readMiniSeedFrame();
                    }
                    catch (IOException ioEx) {
                        logger.warn(ioEx.getMessage(), ioEx);
                        continue;
                    }
                    if (buf == null || buf.length == 0) continue;
                    try {
                        int i = 0;
                        while (i < buf.length) {
                            System.arraycopy(buf, i, mbuf, 0, mbuf.length);
                            gmsRec = GenericMiniSeedRecord.buildMiniSeedRecord(mbuf);
                            if (gmsRec != null) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug(gmsRec);
                                }
                                if (AbstractMiniSeedPort.this.miniSeedHeaderFilter != null) {
                                    AbstractMiniSeedPort.this.miniSeedHeaderFilter.filter(gmsRec);
                                }
                                if (AbstractMiniSeedPort.this.accept(gmsRec)) {
                                    MiniSeedPortEvent e = new MiniSeedPortEvent(this, gmsRec);
                                    AbstractMiniSeedPort.this.fireMiniSeedEvent(e);
                                }
                            }
                            i += 512;
                        }
                    }
                    catch (Exception ex) {
                        logger.warn(ex.getMessage(), ex);
                    }
                }
                logger.info("sendMiniSeedDataThread end");
            }
        };
        this.sendMiniSeedDataThread.setName("sendMiniSeedDataThread");
        this.sendMiniSeedDataThread.start();
    }

    public synchronized void addMiniSeedPortEventListener(MiniSeedPortEventListener l) {
        Vector v;
        Vector vector = v = this.miniSeedPortEventListeners == null ? new Vector(2) : (Vector)this.miniSeedPortEventListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.miniSeedPortEventListeners = v;
        }
    }

    public synchronized void removeMiniSeedPortEventListener(MiniSeedPortEventListener l) {
        if (this.miniSeedPortEventListeners != null && this.miniSeedPortEventListeners.contains(l)) {
            Vector v = (Vector)this.miniSeedPortEventListeners.clone();
            v.removeElement(l);
            this.miniSeedPortEventListeners = v;
        }
    }

    protected void fireMiniSeedEvent(MiniSeedPortEvent e) {
        if (this.miniSeedPortEventListeners != null) {
            Vector listeners = this.miniSeedPortEventListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((MiniSeedPortEventListener)listeners.elementAt(i)).miniSeedEvent(e);
                ++i;
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closePort();
    }

    public abstract /* synthetic */ byte[] readMiniSeedFrame() throws IOException;

    public abstract /* synthetic */ boolean connectServer();

    public abstract /* synthetic */ boolean connectOK();
}

