/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.message;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import cn.org.gddsn.liss.message.MessageParseException;
import cn.org.gddsn.liss.message.Result;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class WaveformStreamStatus
extends Result {
    static Logger logger;
    private int stnCount;
    private String[] stnCodes;
    private short[] status;
    private Hashtable tbl = new Hashtable();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.message.WaveformStreamStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public WaveformStreamStatus(Result res) throws MessageParseException {
        super(res);
        this.parse();
    }

    private void parse() throws MessageParseException {
        FilterInputStream di = null;
        if (this.subType != 131074) {
            throw new MessageParseException("parse Error in WaveformStreamStatus");
        }
        try {
            di = this.wordOrder == 0 ? new LittleEndianInputStream(new ByteArrayInputStream(this.getData())) : new DataInputStream(new ByteArrayInputStream(this.getData()));
            this.stnCount = di.readShort();
            this.stnCodes = new String[this.stnCount];
            this.status = new short[this.stnCount];
            int i = 0;
            while (i < this.stnCount) {
                byte[] stnByte = new byte[8];
                di.readFully(stnByte);
                this.stnCodes[i] = new String(stnByte).trim();
                this.status[i] = di.readShort();
                this.tbl.put(this.stnCodes[i], new Short(this.status[i]));
                ++i;
            }
        }
        catch (IOException ioEx) {
            throw new MessageParseException("parse Error in WaveformStreamStatus, throw IOException");
        }
    }

    public static byte[] buildWaveformStreamStatusData(int stnCount, String[] stnCodes, boolean[] status) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(stnCount * 12);
        LittleEndianOutputStream los = new LittleEndianOutputStream(bos);
        try {
            los.writeShort(stnCount);
            int i = 0;
            while (i < stnCount) {
                los.writeBytes(stnCodes[i].getBytes(), 8);
                los.writeShort(status[i] ? 1 : 0);
                ++i;
            }
            los.close();
            bos.close();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
        return bos.toByteArray();
    }

    public int getStnCount() {
        return this.stnCount;
    }

    public String[] getStnCodes() {
        return (String[])this.stnCodes.clone();
    }

    public short[] getStatus() {
        return (short[])this.status.clone();
    }

    public short getStatus(String stn) {
        Object obj = this.tbl.get(stn);
        if (obj == null) {
            return -1;
        }
        return (Short)obj;
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer(4096);
        strBuffer.append(super.toString());
        int i = 0;
        while (i < this.stnCount) {
            String str = String.valueOf(this.stnCodes[i]) + ":\t" + (this.status[i] == 0 ? "Inactive" : "Active") + "\n";
            strBuffer.append(str);
            ++i;
        }
        return strBuffer.toString();
    }
}

