/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.client;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class LissResponse {
    public static final char REPLY_POSITIVE_PRELIMINARY = '1';
    public static final char REPLY_POSITIVE_COMPLETION = '2';
    public static final char REPLY_POSITIVE_INTERMEDIARY = '3';
    public static final char REPLY_TRANSIENT_NEGATIVE_COMPLETION = '4';
    public static final char REPLY_PERMANENT_NEGATIVE_COMPLETION = '5';
    public static final char REGARDING_SYNTAX = '0';
    public static final char REGARDING_INFORMATION = '1';
    public static final char REGARDING_CONNECTION = '2';
    public static final char REGARDING_AUTHENTICATION = '3';
    public static final char REGARDING_UNSPECIFIED = '4';
    public static final char REGARDING_FILE_SYSTEM = '5';
    private String message;
    private String returnCode;

    protected LissResponse(BufferedReader in) throws IOException {
        this.setMessage(in);
    }

    protected LissResponse(InputStream istr) throws IOException {
        this.setMessage(istr);
    }

    public String getMessage() {
        return this.message;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public String toString() {
        return this.message;
    }

    public boolean isPositivePreliminary() {
        return this.returnCode.charAt(0) == '1';
    }

    public boolean isPositiveCompletion() {
        return this.returnCode.charAt(0) == '2';
    }

    public boolean isPositiveIntermediary() {
        return this.returnCode.charAt(0) == '3';
    }

    public boolean isTransientNegativeCompletion() {
        return this.returnCode.charAt(0) == '4';
    }

    public boolean isPermanentNegativeCompletion() {
        return this.returnCode.charAt(0) == '5';
    }

    public boolean isRegardingSyntax() {
        return this.returnCode.charAt(1) == '0';
    }

    public boolean isRegardingInformation() {
        return this.returnCode.charAt(1) == '1';
    }

    public boolean isRegardingConnection() {
        return this.returnCode.charAt(1) == '2';
    }

    public boolean isRegardingAuthentication() {
        return this.returnCode.charAt(1) == '3';
    }

    public boolean isRegardingFileSystem() {
        return this.returnCode.charAt(1) == '5';
    }

    public void setMessage1(BufferedReader in) throws IOException {
        StringBuffer buffer = new StringBuffer();
        while (true) {
            if (!in.ready()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            String line = in.readLine();
            if (this.returnCode == null) {
                this.returnCode = line.substring(0, 3);
            }
            buffer.append(line);
            buffer.append('\n');
            if (line.charAt(3) == ' ' && this.returnCode.equals(line.substring(0, 3))) break;
        }
        this.message = buffer.toString();
    }

    private void setMessage(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            throw new EOFException("Server side close");
        }
        StringBuffer reply = new StringBuffer(line);
        if (reply.length() < 3) {
            throw new EOFException("Server side close 1");
        }
        this.returnCode = reply.toString().substring(0, 3);
        reply.append("\r\n");
        if (reply.charAt(3) == '-') {
            boolean complete = false;
            while (!complete) {
                line = reader.readLine();
                if (line == null) {
                    throw new EOFException("Server side close");
                }
                if (line.length() >= 3 && line.substring(0, 3).equals(this.returnCode) && line.charAt(3) == ' ') {
                    reply.append(line);
                    complete = true;
                    continue;
                }
                reply.append(String.valueOf(line) + "\r\n");
            }
        }
        this.message = reply.toString();
    }

    private void setMessage(InputStream istr) throws IOException {
        int read;
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = istr.read(buffer)) != -1) {
            ostr.write(buffer, 0, read);
        }
        ostr.close();
        this.message = ostr.toString();
    }
}

