/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.liss.client;

import cn.org.gddsn.liss.client.BufferInfo;
import cn.org.gddsn.liss.client.LissControlSocket;
import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.client.LissInputStream;
import cn.org.gddsn.liss.client.LissOutputStream;
import cn.org.gddsn.liss.client.LissResponse;
import cn.org.gddsn.liss.client.LissTransferType;
import cn.org.gddsn.liss.message.Result;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class LissClient {
    static Logger logger;
    private String host;
    private int port;
    private String user;
    private String password;
    private LissControlSocket control = null;
    private Socket data = null;
    private Socket rtData = null;
    private LissTransferType transferType = null;
    private ServerSocket rtDataServerSocket = null;
    private ServerSocket dataServerSocket = null;
    private boolean rtServerPassiveMode = true;
    private boolean serverPassiveMode = true;
    private int timeOut = 120000;
    private int sendBufferSize = 43008;
    private int receiveBufferSize = 71680;
    private boolean throughFirewall = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.liss.client.LissClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public LissClient() {
    }

    public LissClient(String host, int port) throws IOException, LissException {
        this.host = host;
        this.port = port;
        this.control = new LissControlSocket(host, port);
    }

    public LissClient(String remoteHost) throws IOException, LissException {
        this.host = remoteHost;
        this.control = new LissControlSocket(remoteHost);
    }

    public void init() throws IOException, LissException {
        this.control = new LissControlSocket(this.host, this.port);
        this.control.setThroughFirewall(this.throughFirewall);
        this.login();
    }

    public void connect() throws IOException, LissException {
        this.init();
    }

    LissControlSocket getLissControlSocket() {
        return this.control;
    }

    public synchronized void setTimeOut(int ms) {
        this.timeOut = ms;
        this.control.setTimeOut(this.timeOut);
    }

    public synchronized void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public synchronized void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public synchronized float getVersion() {
        return this.control.version;
    }

    public synchronized String getSocketConnectionInfo() {
        return this.control.getSocketConnectionInfo();
    }

    public synchronized void login(String user1, String password1) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("USER " + user1);
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "331");
        reply = this.control.sendCommand("PASS " + password1);
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "230");
    }

    public synchronized void login() throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("USER " + this.user);
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "331");
        reply = this.control.sendCommand("PASS " + this.password);
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "230");
    }

    public synchronized void user(String user) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("USER " + user);
        logger.debug(reply.getMessage());
        String[] validCodes = new String[]{"230", "331"};
        this.control.validateReply(reply, validCodes);
    }

    public synchronized void password(String password) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("PASS " + password);
        logger.debug(reply.getMessage());
        String[] validCodes = new String[]{"230", "202"};
        this.control.validateReply(reply, validCodes);
    }

    public synchronized void noop() throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("NOOP");
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "200");
    }

    public synchronized void addStation(String[] stns) throws IOException, LissException {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < stns.length) {
            buf.append(' ');
            buf.append(stns[i]);
            ++i;
        }
        LissResponse reply = this.control.sendCommand("ADDB " + buf);
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "257");
    }

    public synchronized void deleteStation(String[] stns) throws IOException, LissException {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < stns.length) {
            buf.append(' ');
            buf.append(stns[i]);
            ++i;
        }
        LissResponse reply = this.control.sendCommand("DELB " + buf);
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "200");
    }

    public synchronized void chpass(String newPass) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("CPAS " + newPass);
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "200");
    }

    public synchronized String stat_monitor() throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("STAT MONITOR");
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "211");
        return reply.getMessage();
    }

    public synchronized boolean isExist(String net_stn, String sn) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("STAT PACKET " + net_stn + " " + sn);
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "200");
        StringTokenizer st = new StringTokenizer(reply.getMessage(), " \r\n");
        st.nextToken();
        st.nextToken();
        return st.nextToken().equals("1");
    }

    public synchronized String stat_active() throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("STAT ACTIVE");
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "211");
        return reply.getMessage();
    }

    public synchronized String stat_log() throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("STAT LOG");
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "211");
        return reply.getMessage();
    }

    public synchronized void port(String dataType, String host, int port) throws IOException, LissException {
        StringBuffer command = new StringBuffer("PORT " + dataType + " ");
        command.append(host.replace('.', ','));
        command.append(',');
        command.append(port / 256);
        command.append(',');
        command.append(port % 256);
        LissResponse reply = this.control.sendCommand(command.toString());
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "200");
    }

    public synchronized String pasv(String dataType) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("PASV " + dataType + " ");
        logger.debug(reply.getMessage());
        String[] validCode1 = new String[]{"227", "228"};
        this.control.validateReply(reply, validCode1);
        String message = reply.getMessage();
        int bracket1 = message.indexOf(40);
        int bracket2 = message.indexOf(41);
        if (this.isThroughFirewall()) {
            String ipData = message.substring(bracket1 + 1, bracket2);
            int[] parts = new int[6];
            int len = ipData.length();
            int partCount = 0;
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < len && partCount <= 6) {
                char ch = ipData.charAt(i);
                if (Character.isDigit(ch)) {
                    buf.append(ch);
                } else if (ch != ',') {
                    throw new LissException("Malformed PASV reply: " + reply);
                }
                if (ch == ',' || i + 1 == len) {
                    try {
                        parts[partCount++] = Integer.parseInt(buf.toString());
                        buf.setLength(0);
                    }
                    catch (NumberFormatException ex) {
                        throw new LissException("Malformed PASV reply: " + reply);
                    }
                }
                ++i;
            }
            StringBuffer host_port = new StringBuffer();
            String host = this.control.getRemoteHostAddress();
            host_port.append(host.replace('.', ','));
            host_port.append(',');
            host_port.append("" + parts[4]);
            host_port.append(',');
            host_port.append("" + parts[5]);
            if (logger.isDebugEnabled()) {
                logger.debug("PASV return: " + host_port);
            }
            return host_port.toString();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("PASV return: " + message.substring(bracket1 + 1, bracket2));
        }
        return message.substring(bracket1 + 1, bracket2);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public synchronized void setServerPassiveMode(boolean serverPassiveMode) {
        this.serverPassiveMode = serverPassiveMode;
    }

    public synchronized void setRtServerPassiveMode(boolean rtServerPassiveMode) {
        this.rtServerPassiveMode = rtServerPassiveMode;
    }

    public synchronized void setThroughFirewall(boolean throughFirewall) {
        this.throughFirewall = throughFirewall;
        if (this.control != null) {
            this.control.setThroughFirewall(throughFirewall);
        }
    }

    public synchronized String shellCommand(String[] args) throws IOException, LissException {
        StringBuffer cmd = new StringBuffer();
        cmd.append("SCMD ");
        int i = 0;
        while (i < args.length) {
            cmd.append(args[i]);
            cmd.append(" ");
            ++i;
        }
        LissResponse reply = this.control.sendCommand(cmd.substring(0));
        if (logger.isDebugEnabled()) {
            logger.debug(reply.getMessage());
        }
        this.control.validateReply(reply, "200");
        return reply.getMessage();
    }

    public synchronized String addUser(String netUser, String plainPassword) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("ADDU " + netUser + " " + plainPassword);
        if (logger.isDebugEnabled()) {
            logger.debug(reply.getMessage());
        }
        this.control.validateReply(reply, "200");
        return reply.getMessage();
    }

    public synchronized String deleteUser(String netUser) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("DELU " + netUser);
        if (logger.isDebugEnabled()) {
            logger.debug(reply.getMessage());
        }
        this.control.validateReply(reply, "200");
        return reply.getMessage();
    }

    public synchronized String getUser(String netUser) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("GETU " + netUser);
        if (logger.isDebugEnabled()) {
            logger.debug(reply.getMessage());
        }
        this.control.validateReply(reply, "200");
        return reply.getMessage();
    }

    public synchronized String modifyUser(String netUser, String args) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("SETU " + netUser + args);
        if (logger.isDebugEnabled()) {
            logger.debug(reply.getMessage());
        }
        this.control.validateReply(reply, "200");
        return reply.getMessage();
    }

    public synchronized String setServer(String args) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("SSRV " + args);
        if (logger.isDebugEnabled()) {
            logger.debug(reply.getMessage());
        }
        this.control.validateReply(reply, "200");
        return reply.getMessage();
    }

    public synchronized String setServer2Server(String args) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("SRV2SRV " + args);
        if (logger.isDebugEnabled()) {
            logger.debug(reply.getMessage());
        }
        this.control.validateReply(reply, "200");
        return reply.getMessage();
    }

    public synchronized String setComServ2Server(String args) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("COMSRV " + args);
        if (logger.isDebugEnabled()) {
            logger.debug(reply.getMessage());
        }
        this.control.validateReply(reply, "200");
        return reply.getMessage();
    }

    public synchronized String setSerial2Server(String args) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("SERIAL " + args);
        if (logger.isDebugEnabled()) {
            logger.debug(reply.getMessage());
        }
        this.control.validateReply(reply, "200");
        return reply.getMessage();
    }

    public synchronized void getXmlConfig(OutputStream os) throws IOException, LissException {
        this.nrtClean();
        if (this.serverPassiveMode) {
            this.data = this.control.createPassiveDataSocket("NRT");
            this.data.setSoTimeout(this.timeOut);
        } else {
            this.dataServerSocket = this.control.createDataServerSocket("NRT");
        }
        LissResponse reply = this.control.sendCommand("GETC");
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.dataServerSocket != null) {
            this.data = this.dataServerSocket.accept();
            this.data.setSoTimeout(this.timeOut);
        }
        BufferedInputStream in = new BufferedInputStream(this.data.getInputStream());
        IOUtils.copy((InputStream)in, os);
        IOUtils.closeQuietly(in);
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        this.data.close();
    }

    public synchronized void setXmlConfig(InputStream in) throws IOException, LissException {
        this.nrtClean();
        if (this.serverPassiveMode) {
            this.data = this.control.createPassiveDataSocket("NRT");
            this.data.setSoTimeout(this.timeOut);
        } else {
            this.dataServerSocket = this.control.createDataServerSocket("NRT");
        }
        LissResponse reply = this.control.sendCommand("SETC");
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.dataServerSocket != null) {
            this.data = this.dataServerSocket.accept();
            this.data.setSoTimeout(this.timeOut);
        }
        OutputStream out = this.data.getOutputStream();
        IOUtils.copy(in, out);
        IOUtils.closeQuietly(out);
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        this.data.close();
    }

    public synchronized String[] getAllStationCode() throws IOException, LissException {
        this.nrtClean();
        if (this.serverPassiveMode) {
            this.data = this.control.createPassiveDataSocket("NRT");
            this.data.setSoTimeout(this.timeOut);
        } else {
            this.dataServerSocket = this.control.createDataServerSocket("NRT");
        }
        LissResponse reply = this.control.sendCommand("SLST");
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.dataServerSocket != null) {
            this.data = this.dataServerSocket.accept();
            this.data.setSoTimeout(this.timeOut);
        }
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(this.data.getInputStream()));
        Vector<String> vec = new Vector<String>();
        String line = null;
        while ((line = bufReader.readLine()) != null) {
            vec.addElement(line);
        }
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        String[] stns = new String[vec.size()];
        int i = 0;
        Enumeration enu = vec.elements();
        while (enu.hasMoreElements()) {
            stns[i++] = (String)enu.nextElement();
        }
        bufReader.close();
        this.data.close();
        enu = null;
        vec = null;
        return stns;
    }

    public synchronized String[] getBufferInfo(String[] stnCode, boolean bNew) throws IOException, LissException {
        this.nrtClean();
        if (this.serverPassiveMode) {
            this.data = this.control.createPassiveDataSocket("NRT");
            this.data.setSoTimeout(this.timeOut);
        } else {
            this.dataServerSocket = this.control.createDataServerSocket("NRT");
        }
        StringBuffer cmd = new StringBuffer();
        if (bNew) {
            cmd.append("GETN ");
        } else {
            cmd.append("GETO ");
        }
        int i = 0;
        while (i < stnCode.length) {
            cmd.append(stnCode[i]);
            cmd.append(" ");
            ++i;
        }
        LissResponse reply = this.control.sendCommand(cmd.toString());
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.dataServerSocket != null) {
            this.data = this.dataServerSocket.accept();
            this.data.setSoTimeout(this.timeOut);
        }
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(this.data.getInputStream()));
        Vector<String> vec = new Vector<String>();
        String line = null;
        while ((line = bufReader.readLine()) != null) {
            vec.addElement(line);
        }
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        String[] infos = new String[vec.size()];
        int i2 = 0;
        Enumeration enu = vec.elements();
        while (enu.hasMoreElements()) {
            infos[i2++] = (String)enu.nextElement();
        }
        bufReader.close();
        this.data.close();
        enu = null;
        vec = null;
        return infos;
    }

    public synchronized String[] getLostIDInfo(String stnCode) throws IOException, LissException {
        this.nrtClean();
        if (this.serverPassiveMode) {
            this.data = this.control.createPassiveDataSocket("NRT");
            this.data.setSoTimeout(this.timeOut);
        } else {
            this.dataServerSocket = this.control.createDataServerSocket("NRT");
        }
        LissResponse reply = this.control.sendCommand("GETL " + stnCode);
        logger.debug(reply.getMessage());
        if (reply.getReturnCode().equals("455")) {
            return new String[0];
        }
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.dataServerSocket != null) {
            this.data = this.dataServerSocket.accept();
            this.data.setSoTimeout(this.timeOut);
        }
        BufferedInputStream bIn = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
        ByteBuffer buf = this.readAllBytes(bIn);
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        bIn.close();
        this.data.close();
        String IDstr = new String(buf.resultBuf, 0, buf.bufsize);
        StringTokenizer st = new StringTokenizer(IDstr, " \r\n");
        String[] IDs = new String[st.countTokens()];
        int n = 0;
        while (st.hasMoreTokens()) {
            IDs[n++] = st.nextToken();
        }
        return IDs;
    }

    public synchronized BufferInfo getBufferInfo(String stnCode) throws IOException, LissException {
        this.nrtClean();
        if (this.serverPassiveMode) {
            this.data = this.control.createPassiveDataSocket("NRT");
            this.data.setSoTimeout(this.timeOut);
        } else {
            this.dataServerSocket = this.control.createDataServerSocket("NRT");
        }
        LissResponse reply = this.control.sendCommand("GETI " + stnCode);
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.dataServerSocket != null) {
            this.data = this.dataServerSocket.accept();
            this.data.setSoTimeout(this.timeOut);
        }
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(this.data.getInputStream()));
        BufferInfo bufferInfo = new BufferInfo();
        String line = null;
        while ((line = bufReader.readLine()) != null) {
            bufferInfo.addElement(line);
        }
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        bufReader.close();
        this.data.close();
        return bufferInfo;
    }

    public synchronized byte[] getOneMiniSeedRecord(String[] stnCode, String[] seqNumber) throws IOException, LissException {
        this.nrtClean();
        if (this.serverPassiveMode) {
            this.data = this.control.createPassiveDataSocket("NRT");
            this.data.setSoTimeout(this.timeOut);
        } else {
            this.dataServerSocket = this.control.createDataServerSocket("NRT");
        }
        StringBuffer cmd = new StringBuffer();
        cmd.append("GETM ");
        if (stnCode.length > seqNumber.length) {
            logger.debug("In LissClient.getOneMiniSeedRecord, stnCode.length NEQ seqNumber");
            return null;
        }
        int i = 0;
        while (i < stnCode.length) {
            cmd.append(stnCode[i]);
            cmd.append(" ");
            cmd.append(seqNumber[i]);
            cmd.append(" ");
            ++i;
        }
        LissResponse reply = this.control.sendCommand(cmd.toString());
        logger.debug(reply.getMessage());
        if (reply.getReturnCode().equals("551")) {
            return null;
        }
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.dataServerSocket != null) {
            this.data = this.dataServerSocket.accept();
            this.data.setSoTimeout(this.timeOut);
        }
        this.data.setSendBufferSize(this.sendBufferSize);
        this.data.setReceiveBufferSize(this.receiveBufferSize);
        BufferedInputStream bIn = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
        ByteBuffer buf = this.readAllBytes(bIn);
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        bIn.close();
        this.data.close();
        byte[] ret = buf.resultBuf;
        buf = null;
        return ret;
    }

    public synchronized void setOneMiniSeedRecord(byte[] bytes) throws IOException, LissException {
        this.nrtClean();
        if (this.serverPassiveMode) {
            this.data = this.control.createPassiveDataSocket("NRT");
            this.data.setSoTimeout(this.timeOut);
        } else {
            this.dataServerSocket = this.control.createDataServerSocket("NRT");
        }
        LissResponse reply = this.control.sendCommand("SETM");
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.dataServerSocket != null) {
            this.data = this.dataServerSocket.accept();
            this.data.setSoTimeout(this.timeOut);
        }
        this.data.setSendBufferSize(this.sendBufferSize);
        this.data.setReceiveBufferSize(this.receiveBufferSize);
        DataOutputStream out = new DataOutputStream(this.data.getOutputStream());
        out.write(bytes, 0, bytes.length);
        out.flush();
        out.close();
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        try {
            this.data.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public synchronized void sendResult(String infoType, Result[] results) throws IOException, LissException {
        this.nrtClean();
        if (this.serverPassiveMode) {
            this.data = this.control.createPassiveDataSocket("NRT");
            this.data.setSoTimeout(this.timeOut);
        } else {
            this.dataServerSocket = this.control.createDataServerSocket("NRT");
        }
        LissResponse reply = this.control.sendCommand("SNDR " + infoType);
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.dataServerSocket != null) {
            this.data = this.dataServerSocket.accept();
            this.data.setSoTimeout(this.timeOut);
        }
        this.data.setSendBufferSize(this.sendBufferSize);
        this.data.setReceiveBufferSize(this.receiveBufferSize);
        DataOutputStream out = new DataOutputStream(this.data.getOutputStream());
        int i = 0;
        while (i < results.length) {
            out.write(results[i].getBytes());
            ++i;
        }
        out.flush();
        out.close();
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        try {
            this.data.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized String sendResult(String infoType, byte[] bytes) throws IOException, LissException {
        this.nrtClean();
        if (this.serverPassiveMode) {
            this.data = this.control.createPassiveDataSocket("NRT");
            this.data.setSoTimeout(this.timeOut);
        } else {
            this.dataServerSocket = this.control.createDataServerSocket("NRT");
        }
        LissResponse reply = this.control.sendCommand("SNDR " + infoType);
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.dataServerSocket != null) {
            this.data = this.dataServerSocket.accept();
            this.data.setSoTimeout(this.timeOut);
        }
        this.data.setSendBufferSize(this.sendBufferSize);
        this.data.setReceiveBufferSize(this.receiveBufferSize);
        DataOutputStream out = new DataOutputStream(this.data.getOutputStream());
        out.write(bytes, 0, bytes.length);
        out.flush();
        out.close();
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        try {
            this.data.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return reply.getMessage();
    }

    public synchronized LissInputStream retrieveResult(String infoType) throws IOException, LissException {
        this.nrtClean();
        if (this.serverPassiveMode) {
            this.data = this.control.createPassiveDataSocket("NRT");
            this.data.setSoTimeout(this.timeOut);
        } else {
            this.dataServerSocket = this.control.createDataServerSocket("NRT");
        }
        LissResponse reply = this.control.sendCommand("RCVR " + infoType);
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.dataServerSocket != null) {
            this.data = this.dataServerSocket.accept();
            this.data.setSoTimeout(this.timeOut);
        }
        this.data.setSendBufferSize(this.sendBufferSize);
        this.data.setReceiveBufferSize(this.receiveBufferSize);
        return new LissInputStream(this.data.getInputStream(), this);
    }

    public synchronized void getMiniSeedBufferRT(String[] stns, String startTimeSqlStr, int seconds) throws IOException, LissException {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < stns.length) {
            buf.append(' ');
            buf.append(stns[i]);
            ++i;
        }
        LissResponse reply = this.control.sendCommand("GETB " + buf + " " + startTimeSqlStr + " " + seconds + " RT");
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "200");
    }

    public synchronized LissInputStream getMiniSeedBuffer(String[] stns, String startTimeSqlStr, int seconds) throws IOException, LissException {
        this.nrtClean();
        if (this.serverPassiveMode) {
            this.data = this.control.createPassiveDataSocket("NRT");
            this.data.setSoTimeout(this.timeOut);
        } else {
            this.dataServerSocket = this.control.createDataServerSocket("NRT");
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < stns.length) {
            buf.append(' ');
            buf.append(stns[i]);
            ++i;
        }
        LissResponse reply = this.control.sendCommand("GETB " + buf + " " + startTimeSqlStr + " " + seconds + " NRT");
        logger.debug(reply.getMessage());
        if (reply.getReturnCode().equals("551")) {
            return null;
        }
        if (reply.getReturnCode().equals("455")) {
            return null;
        }
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.dataServerSocket != null) {
            this.data = this.dataServerSocket.accept();
            this.data.setSoTimeout(this.timeOut);
        }
        this.data.setSendBufferSize(this.sendBufferSize);
        this.data.setReceiveBufferSize(this.receiveBufferSize);
        return new LissInputStream(this.data.getInputStream(), this);
    }

    public synchronized LissInputStream retrieveRealTimeStream(String type, String[] stnCodes) throws IOException, LissException {
        this.rtClean();
        StringBuffer stns = new StringBuffer();
        int i = 0;
        while (i < stnCodes.length) {
            stns.append(' ');
            stns.append(stnCodes[i]);
            ++i;
        }
        if (this.rtServerPassiveMode) {
            this.rtData = this.control.createPassiveDataSocket("RT");
            this.rtData.setSoTimeout(this.timeOut);
        } else {
            this.rtDataServerSocket = this.control.createDataServerSocket("RT");
        }
        LissResponse reply = this.control.sendCommand("RETR " + type + stns.toString());
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.rtDataServerSocket != null) {
            this.rtData = this.rtDataServerSocket.accept();
            this.rtData.setSoTimeout(this.timeOut);
        }
        this.rtData.setSendBufferSize(this.sendBufferSize);
        this.rtData.setReceiveBufferSize(this.receiveBufferSize);
        return new LissInputStream(this.rtData.getInputStream(), this);
    }

    public LissInputStream retrieveRealTimeStream(String[] stnCodes) throws IOException, LissException {
        return this.retrieveRealTimeStream("", stnCodes);
    }

    public synchronized LissOutputStream storeRealTimeStream(String[] stnCodes) throws IOException, LissException {
        this.rtClean();
        StringBuffer stns = new StringBuffer();
        int i = 0;
        while (i < stnCodes.length) {
            stns.append(' ');
            stns.append(stnCodes[i]);
            ++i;
        }
        if (this.rtServerPassiveMode) {
            this.rtData = this.control.createPassiveDataSocket("RT");
            this.rtData.setSoTimeout(this.timeOut);
        } else {
            this.rtDataServerSocket = this.control.createDataServerSocket("RT");
        }
        LissResponse reply = this.control.sendCommand("STOR" + stns.toString());
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        if (this.rtDataServerSocket != null) {
            this.rtData = this.rtDataServerSocket.accept();
            this.rtData.setSoTimeout(this.timeOut);
        }
        this.rtData.setSendBufferSize(this.sendBufferSize);
        this.rtData.setReceiveBufferSize(this.receiveBufferSize);
        return new LissOutputStream(this.rtData.getOutputStream(), this);
    }

    public synchronized String gets(String stnCode) throws IOException, LissException {
        int count;
        this.data = this.control.createPassiveDataSocket("NRT");
        this.data.setSoTimeout(this.timeOut);
        DataInputStream in = new DataInputStream(this.data.getInputStream());
        BufferedInputStream bIn = new BufferedInputStream(in);
        LissResponse reply = this.control.sendCommand("GETS " + stnCode);
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        int chunksize = 4096;
        byte[] chunk = new byte[chunksize];
        ByteArrayOutputStream bos = new ByteArrayOutputStream(10240);
        while ((count = bIn.read(chunk, 0, chunksize)) >= 0) {
            bos.write(chunk, 0, count);
        }
        bos.close();
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        try {
            bIn.close();
            this.data.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return bos.toString();
    }

    public synchronized void sets(File localStnInfo, String stnCode) throws IOException, LissException {
        this.data = this.control.createPassiveDataSocket("NRT");
        this.data.setSoTimeout(this.timeOut);
        DataOutputStream out = new DataOutputStream(this.data.getOutputStream());
        LissResponse reply = this.control.sendCommand("SETS " + stnCode);
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        FileInputStream input = new FileInputStream(localStnInfo);
        byte[] buf = new byte[512];
        int count = 0;
        while ((count = input.read(buf)) > 0) {
            out.write(buf, 0, count);
        }
        input.close();
        out.flush();
        out.close();
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        try {
            this.data.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public synchronized void put(String localPath, String remoteFile) throws IOException, LissException {
        this.data = this.control.createPassiveDataSocket("NRT");
        this.data.setSoTimeout(this.timeOut);
        DataOutputStream out = new DataOutputStream(this.data.getOutputStream());
        LissResponse reply = this.control.sendCommand("STOR " + remoteFile);
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        FileInputStream input = new FileInputStream(localPath);
        byte[] buf = new byte[512];
        int count = 0;
        while ((count = input.read(buf)) > 0) {
            out.write(buf, 0, count);
        }
        input.close();
        out.flush();
        out.close();
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        try {
            this.data.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public synchronized void put(byte[] bytes, String remoteFile) throws IOException, LissException {
        this.data = this.control.createPassiveDataSocket("NRT");
        this.data.setSoTimeout(this.timeOut);
        DataOutputStream out = new DataOutputStream(this.data.getOutputStream());
        LissResponse reply = this.control.sendCommand("STOR " + remoteFile);
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        out.write(bytes, 0, bytes.length);
        out.flush();
        out.close();
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        try {
            this.data.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public synchronized void get(String localPath, String remoteFile) throws IOException, LissException {
        int count;
        this.data = this.control.createPassiveDataSocket("NRT");
        this.data.setSoTimeout(this.timeOut);
        DataInputStream in = new DataInputStream(this.data.getInputStream());
        BufferedInputStream bIn = new BufferedInputStream(in);
        LissResponse reply = this.control.sendCommand("RETR " + remoteFile);
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        int chunksize = 4096;
        byte[] chunk = new byte[chunksize];
        BufferedOutputStream out = null;
        out = new BufferedOutputStream(new FileOutputStream(localPath, false));
        while ((count = bIn.read(chunk, 0, chunksize)) >= 0) {
            out.write(chunk, 0, count);
        }
        out.close();
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        try {
            bIn.close();
            this.data.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public synchronized byte[] get(String remoteFile) throws IOException, LissException {
        int count;
        this.data = this.control.createPassiveDataSocket("NRT");
        this.data.setSoTimeout(this.timeOut);
        DataInputStream in = new DataInputStream(this.data.getInputStream());
        BufferedInputStream bIn = new BufferedInputStream(in);
        LissResponse reply = this.control.sendCommand("RETR " + remoteFile);
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        int chunksize = 4096;
        byte[] chunk = new byte[chunksize];
        byte[] resultBuf = new byte[chunksize];
        byte[] temp = null;
        int bufsize = 0;
        while ((count = bIn.read(chunk, 0, chunksize)) >= 0) {
            temp = new byte[bufsize + count];
            System.arraycopy(resultBuf, 0, temp, 0, bufsize);
            System.arraycopy(chunk, 0, temp, bufsize, count);
            resultBuf = temp;
            bufsize += count;
        }
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        this.control.validateReply(reply, validCodes2);
        try {
            bIn.close();
            this.data.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return resultBuf;
    }

    public synchronized String list(String mask) throws IOException, LissException {
        int count;
        this.data = this.control.createPassiveDataSocket("NRT");
        this.data.setSoTimeout(this.timeOut);
        InputStreamReader in = new InputStreamReader(this.data.getInputStream());
        BufferedReader bIn = new BufferedReader(in);
        LissResponse reply = this.control.sendCommand("NLST " + mask);
        logger.debug(reply.getMessage());
        String[] validCodes1 = new String[]{"125", "150"};
        this.control.validateReply(reply, validCodes1);
        int chunksize = 4096;
        char[] chunk = new char[chunksize];
        char[] resultBuf = new char[chunksize];
        char[] temp = null;
        int bufsize = 0;
        while ((count = bIn.read(chunk, 0, chunksize)) >= 0) {
            temp = new char[bufsize + count];
            System.arraycopy(resultBuf, 0, temp, 0, bufsize);
            System.arraycopy(chunk, 0, temp, bufsize, count);
            resultBuf = temp;
            bufsize += count;
        }
        String[] validCodes2 = new String[]{"226", "250"};
        reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes2);
        try {
            bIn.close();
            this.data.close();
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return new String(resultBuf);
    }

    public synchronized LissTransferType getType() {
        return this.transferType;
    }

    public synchronized void setType(LissTransferType type) throws IOException, LissException {
        String typeStr = LissTransferType.ASCII_CHAR;
        if (type.equals(LissTransferType.BINARY)) {
            typeStr = LissTransferType.BINARY_CHAR;
        }
        LissResponse reply = this.control.sendCommand("TYPE " + typeStr);
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "200");
        this.transferType = type;
    }

    public synchronized void delete(String remoteFile) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("DELE " + remoteFile);
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "250");
    }

    public synchronized void rmdir(String dir) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("RMD " + dir);
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "250");
    }

    public synchronized void mkdir(String dir) throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("MKD " + dir);
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "257");
    }

    public synchronized void abortRealTimeStreamTransport() throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("ABOR");
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "226");
        this.rtClean();
    }

    public synchronized void quit() throws IOException, LissException {
        if (this.control == null) {
            return;
        }
        LissResponse reply = this.control.sendCommand("QUIT\r\n");
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "221");
        this.rtClean();
        this.nrtClean();
        this.control.logout();
        this.control = null;
    }

    public synchronized void shutdown() throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("SHUT\r\n");
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "221");
        this.rtClean();
        this.nrtClean();
        this.control.logout();
        this.control = null;
    }

    public synchronized void reboot() throws IOException, LissException {
        LissResponse reply = this.control.sendCommand("REBT\r\n");
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, "221");
        this.rtClean();
        this.nrtClean();
        this.control.logout();
        this.control = null;
    }

    public synchronized void sendRETR(StringBuffer stns) throws IOException, LissException {
        String[] validCodes1 = new String[]{"125", "150"};
        LissResponse reply = this.control.sendCommand("RETR" + stns.toString());
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes1);
    }

    public synchronized void sendSTOR(StringBuffer stns) throws IOException, LissException {
        String[] validCodes1 = new String[]{"125", "150"};
        LissResponse reply = this.control.sendCommand("STOR" + stns.toString());
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes1);
    }

    public synchronized String getDetailHeader() {
        return this.control.getDetailHeader();
    }

    public synchronized String getLocalHostAddress() {
        return this.control.getLocalHostAddress();
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    private void checkResponse(String[] validCodes) throws IOException, LissException {
        LissResponse reply = this.control.readReply();
        logger.debug(reply.getMessage());
        this.control.validateReply(reply, validCodes);
    }

    public synchronized void closeDataSocketResponse() throws IOException, LissException {
        String[] validCodes2 = new String[]{"226", "250"};
        this.checkResponse(validCodes2);
    }

    protected void closeTransferSocket() throws IOException {
        if (this.data != null) {
            this.data.close();
        }
        if (this.rtData != null) {
            this.rtData.close();
        }
    }

    private void rtClean() {
        try {
            if (this.rtData != null) {
                this.rtData.close();
                this.rtData = null;
            }
            if (this.rtDataServerSocket != null) {
                this.rtDataServerSocket.close();
                this.rtDataServerSocket = null;
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    private void nrtClean() {
        try {
            if (this.data != null) {
                this.data.close();
                this.data = null;
            }
            if (this.dataServerSocket != null) {
                this.dataServerSocket.close();
                this.dataServerSocket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ByteBuffer readAllBytes(BufferedInputStream bIn) throws IOException {
        int count;
        ByteBuffer buf = new ByteBuffer();
        byte[] chunk = new byte[buf.chunksize];
        byte[] temp = null;
        while ((count = bIn.read(chunk, 0, buf.chunksize)) >= 0) {
            temp = new byte[buf.bufsize + count];
            System.arraycopy(buf.resultBuf, 0, temp, 0, buf.bufsize);
            System.arraycopy(chunk, 0, temp, buf.bufsize, count);
            buf.resultBuf = temp;
            temp = null;
            buf.bufsize += count;
        }
        return buf;
    }

    public synchronized int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public synchronized int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public synchronized int getTimeOut() {
        return this.timeOut;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isRtServerPassiveMode() {
        return this.rtServerPassiveMode;
    }

    public synchronized boolean isServerPassiveMode() {
        return this.serverPassiveMode;
    }

    public synchronized boolean isThroughFirewall() {
        if (this.control != null) {
            return this.control.isThroughFirewall();
        }
        return this.throughFirewall;
    }

    class ByteBuffer {
        public int chunksize = 256;
        public byte[] resultBuf = new byte[0];
        public int bufsize = 0;

        ByteBuffer() {
        }
    }
}

