/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.linalg;

import cn.org.gddsn.linalg.DimensionNotMatchException;
import cn.org.gddsn.linalg.Matrix;
import org.apache.log4j.Logger;

public class SVD {
    static Logger logger;
    Matrix OrgX;
    double[][] x;
    int n;
    int p;
    double[][] u;
    double[][] v;
    double[] svalues;
    Matrix GInverse;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.linalg.SVD");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public SVD(double[][] XX, int nn, int pp) {
        this.n = nn;
        this.p = pp;
        this.OrgX = new Matrix(XX, this.n, this.p);
        this.svalues = new double[Math.min(this.n + 1, this.p)];
        this.u = new double[this.n][this.n];
        this.v = new double[this.p][this.p];
        this.Svd();
    }

    public double[][] getLeftVector() {
        return this.u;
    }

    public double[][] getRightVector() {
        return this.v;
    }

    public double[] getSingular() {
        return this.svalues;
    }

    public Matrix getGInverse() {
        return this.GInverse;
    }

    public void CalGInverse() {
        double[][] InvS = new double[this.p][this.n];
        int i = 0;
        while (i < this.p) {
            int j = 0;
            while (j < this.n) {
                if (i == j) {
                    InvS[i][j] = this.svalues[i] > 1.0E-9 ? 1.0 / this.svalues[i] : 0.0;
                }
                ++j;
            }
            ++i;
        }
        Matrix InvSM = new Matrix(InvS, this.p, this.n);
        Matrix V = new Matrix(this.v, this.p, this.p);
        Matrix U = new Matrix(this.u, this.n, this.n);
        try {
            Matrix temp = Matrix.Multiply(V, InvSM);
            this.GInverse = Matrix.Multiply(temp, U.Transport());
        }
        catch (DimensionNotMatchException e) {
            logger.warn(e.toString());
        }
    }

    public double[] Solve(double[] b) {
        double[] r = new double[this.p];
        int i = 0;
        while (i < this.p) {
            r[i] = 0.0;
            int j = 0;
            while (j < this.n) {
                int n = i;
                r[n] = r[n] + this.GInverse.Mat[i][j] * b[j];
                ++j;
            }
            ++i;
        }
        return r;
    }

    public Matrix Resolution() {
        Matrix Ret = this.GInverse;
        try {
            Ret = Matrix.Multiply(this.GInverse, this.OrgX);
        }
        catch (DimensionNotMatchException e) {
            logger.warn("error in Resolution()");
            logger.warn(e.toString());
        }
        return Ret;
    }

    public Matrix Density() {
        Matrix Ret = this.GInverse;
        try {
            Ret = Matrix.Multiply(this.OrgX, this.GInverse);
        }
        catch (DimensionNotMatchException e) {
            logger.warn("error in Density()");
            logger.warn(e.toString());
        }
        return Ret;
    }

    public void printResult() {
        int j;
        logger.info("Singular Values are:");
        int i = 0;
        while (i < Math.min(this.n, this.p)) {
            System.out.print(this.svalues[i]);
            if (i != Math.min(this.n, this.p) - 1) {
                System.out.print(",");
            }
            ++i;
        }
        logger.info("Left singular Vectors are:");
        i = 0;
        while (i < this.n) {
            j = 0;
            while (j < this.n) {
                System.out.print(this.u[i][j]);
                if (j != this.n - 1) {
                    System.out.print(",");
                }
                ++j;
            }
            logger.info("");
            ++i;
        }
        logger.info("Right singular Vectors are:");
        i = 0;
        while (i < this.p) {
            j = 0;
            while (j < this.p) {
                System.out.print(this.v[i][j]);
                if (j != this.p - 1) {
                    System.out.print(",");
                }
                ++j;
            }
            logger.info("");
            ++i;
        }
    }

    public static void main(String[] args) {
        double[][] x = new double[][]{{1.0, 2.0, 3.0, 4.0}, {5.0, 6.0, 7.0, 8.0}};
        SVD svd = new SVD(x, 2, 4);
        svd.printResult();
    }

    public void Svd() {
        int j;
        double[][] XX = this.OrgX.getMat();
        double[][] _x = new double[this.n + 1][this.p + 1];
        double[][] _u = new double[this.n + 1][this.n + 1];
        double[][] _v = new double[this.p + 1][this.p + 1];
        int i = 1;
        while (i <= this.n) {
            int j2 = 1;
            while (j2 <= this.p) {
                _x[i][j2] = XX[i - 1][j2 - 1];
                ++j2;
            }
            ++i;
        }
        int k = Math.min(this.n + 1, this.p);
        double[] s = new double[k + 1];
        double[] work = new double[this.n + 1];
        double[] e = new double[this.p + 1];
        SVD.svd(11, 11, e, s, work, _x, this.n, this.p, _u, _v);
        int i2 = 1;
        while (i2 <= k) {
            this.svalues[i2 - 1] = s[i2];
            ++i2;
        }
        i2 = 1;
        while (i2 <= this.n) {
            j = 1;
            while (j <= this.n) {
                this.u[i2 - 1][j - 1] = _u[i2][j];
                ++j;
            }
            ++i2;
        }
        i2 = 1;
        while (i2 <= this.p) {
            j = 1;
            while (j <= this.p) {
                this.v[i2 - 1][j - 1] = _v[i2][j];
                ++j;
            }
            ++i2;
        }
    }

    public static void svd(int want, int job, double[] e, double[] s, double[] work, double[][] x, int n, int p, double[][] u, double[][] v) {
        boolean br1 = false;
        boolean br2 = false;
        boolean br3 = false;
        boolean br4 = false;
        int i = 0;
        int ii = 0;
        int iter = 0;
        int j = 0;
        int k = 0;
        int kase = 0;
        int tl = 0;
        int L = 0;
        int lm1 = 0;
        int lp1 = 0;
        int ls = 0;
        int lu = 0;
        int m = 0;
        int maxit = 0;
        int mm = 0;
        int mm1 = 0;
        int nct = 0;
        int nctp1 = 0;
        int ncu = 0;
        int nrt = 0;
        int nrtp1 = 0;
        double b = 0.0;
        double c = 0.0;
        double cs = 0.0;
        double el = 0.0;
        double emm1 = 0.0;
        double f = 0.0;
        double g = 0.0;
        double scale = 0.0;
        double shift = 0.0;
        double sl = 0.0;
        double sm = 0.0;
        double smm1 = 0.0;
        double sn = 0.0;
        double r = 0.0;
        double roe = 0.0;
        double z = 0.0;
        double summ = 0.0;
        double t = 0.0;
        double t1 = 0.0;
        double test = 0.0;
        double tt = 0.0;
        double ttmp = 0.0;
        double ztest = 0.0;
        maxit = 30;
        int jobu = (int)(0.1 * (double)job - 10.0 * (double)((int)(0.01 * (double)job)));
        ncu = n;
        if (1 < jobu) {
            ncu = Math.min(n, p);
        }
        if (1 <= (lu = Math.max(nct = Math.min(n - 1, p), nrt = Math.max(0, Math.min(p - 2, n))))) {
            L = 1;
            while (L <= lu) {
                lp1 = L + 1;
                if (L <= nct) {
                    summ = 0.0;
                    ii = L;
                    while (ii <= n) {
                        summ += x[ii][L] * x[ii][L];
                        ++ii;
                    }
                    s[L] = summ = Math.sqrt(summ);
                    if (s[L] != 0.0) {
                        if (x[L][L] != 0.0) {
                            s[L] = 0.0 < x[L][L] ? Math.abs(s[L]) : -Math.abs(s[L]);
                        }
                        ii = L;
                        while (ii <= n) {
                            x[ii][L] = x[ii][L] / s[L];
                            ++ii;
                        }
                        x[L][L] = 1.0 + x[L][L];
                    }
                    s[L] = -s[L];
                }
                if (lp1 <= p) {
                    j = lp1;
                    while (j <= p) {
                        if (L <= nct && s[L] != 0.0) {
                            summ = 0.0;
                            ii = L;
                            while (ii <= n) {
                                summ += x[ii][j] * x[ii][L];
                                ++ii;
                            }
                            t = -summ / x[L][L];
                            ii = L;
                            while (ii <= n) {
                                x[ii][j] = x[ii][j] + t * x[ii][L];
                                ++ii;
                            }
                        }
                        e[j] = x[L][j];
                        ++j;
                    }
                }
                if ((want == 11 || want == 12) && L <= nct) {
                    i = L;
                    while (i <= n) {
                        u[i][L] = x[i][L];
                        ++i;
                    }
                }
                if (L <= nrt) {
                    summ = 0.0;
                    ii = lp1;
                    while (ii <= p) {
                        summ += e[ii] * e[ii];
                        ++ii;
                    }
                    e[L] = summ = Math.sqrt(summ);
                    if (e[L] != 0.0) {
                        if (e[lp1] != 0.0) {
                            e[L] = 0.0 < e[lp1] ? Math.abs(e[L]) : -Math.abs(e[L]);
                        }
                        ii = lp1;
                        while (ii <= p) {
                            e[ii] = e[ii] / e[L];
                            ++ii;
                        }
                        e[lp1] = 1.0 + e[lp1];
                    }
                    e[L] = -e[L];
                    if (lp1 <= n && e[L] != 0.0) {
                        i = lp1;
                        while (i <= n) {
                            work[i] = 0.0;
                            ++i;
                        }
                        j = lp1;
                        while (j <= p) {
                            ii = lp1;
                            while (ii <= n) {
                                work[ii] = work[ii] + e[j] * x[ii][j];
                                ++ii;
                            }
                            ++j;
                        }
                        j = lp1;
                        while (j <= p) {
                            tt = -e[j] / e[lp1];
                            ii = lp1;
                            while (ii <= n) {
                                x[ii][j] = x[ii][j] + tt * work[ii];
                                ++ii;
                            }
                            ++j;
                        }
                    }
                    if (want == 11 || want == 21) {
                        i = lp1;
                        while (i <= p) {
                            v[i][L] = e[i];
                            ++i;
                        }
                    }
                }
                ++L;
            }
        }
        m = Math.min(p, n + 1);
        nctp1 = nct + 1;
        nrtp1 = nrt + 1;
        if (nct < p) {
            s[nctp1] = x[nctp1][nctp1];
        }
        if (n < m) {
            s[m] = 0.0;
        }
        if (nrtp1 < m) {
            e[nrtp1] = x[nrtp1][m];
        }
        e[m] = 0.0;
        if (want == 11 || want == 12) {
            if (nctp1 <= ncu) {
                j = nctp1;
                while (j <= ncu) {
                    i = 1;
                    while (i <= n) {
                        u[i][j] = 0.0;
                        ++i;
                    }
                    u[j][j] = 1.0;
                    ++j;
                }
            }
            if (1 <= nct) {
                L = nct;
                while (L >= 1) {
                    if (s[L] == 0.0) {
                        i = 1;
                        while (i <= n) {
                            u[i][L] = 0.0;
                            ++i;
                        }
                        u[L][L] = 1.0;
                    } else {
                        lp1 = L + 1;
                        if (lp1 <= ncu) {
                            j = lp1;
                            while (j <= ncu) {
                                summ = 0.0;
                                ii = L;
                                while (ii <= n) {
                                    summ += u[ii][L] * u[ii][j];
                                    ++ii;
                                }
                                t = -summ / u[L][L];
                                ii = L;
                                while (ii <= n) {
                                    u[ii][j] = u[ii][j] + t * u[ii][L];
                                    ++ii;
                                }
                                ++j;
                            }
                        }
                        ii = L;
                        while (ii <= n) {
                            u[ii][L] = -u[ii][L];
                            ++ii;
                        }
                        u[L][L] = 1.0 + u[L][L];
                        lm1 = L - 1;
                        if (1 <= lm1) {
                            i = 1;
                            while (i <= lm1) {
                                u[i][L] = 0.0;
                                ++i;
                            }
                        }
                    }
                    --L;
                }
            }
        }
        if (want == 11 || want == 21) {
            L = p;
            while (L >= 1) {
                lp1 = L + 1;
                if (L <= nrt && e[L] != 0.0) {
                    j = lp1;
                    while (j <= p) {
                        summ = 0.0;
                        ii = lp1;
                        while (ii <= p) {
                            summ += v[ii][L] * v[ii][j];
                            ++ii;
                        }
                        t = -summ / v[lp1][L];
                        ii = lp1;
                        while (ii <= p) {
                            v[ii][j] = v[ii][j] + t * v[ii][L];
                            ++ii;
                        }
                        ++j;
                    }
                }
                i = 1;
                while (i <= p) {
                    v[i][L] = 0.0;
                    ++i;
                }
                v[L][L] = 1.0;
                --L;
            }
        }
        mm = m;
        iter = 0;
        br1 = true;
        while (br1) {
            if (m == 0) {
                return;
            }
            if (maxit <= iter) {
                br1 = false;
                continue;
            }
            br2 = true;
            L = m - 1;
            while (L >= 0 && br2) {
                if (L == 0) {
                    br2 = false;
                    tl = L;
                } else {
                    test = Math.abs(s[L]) + Math.abs(s[L + 1]);
                    ztest = test + Math.abs(e[L]);
                    if (ztest == test) {
                        e[L] = 0.0;
                        br2 = false;
                        tl = L;
                    }
                }
                --L;
            }
            L = tl;
            if (L == m - 1) {
                kase = 4;
            } else {
                br3 = true;
                tl = 0;
                ls = m;
                while (ls >= L && br3) {
                    if (ls == L) {
                        br3 = false;
                        tl = ls;
                    } else {
                        test = 0.0;
                        if (ls != m) {
                            test += Math.abs(e[ls]);
                        }
                        if (ls != L + 1) {
                            test += Math.abs(e[ls - 1]);
                        }
                        if ((ztest = test + Math.abs(s[ls])) == test) {
                            s[ls] = 0.0;
                            br3 = false;
                            tl = ls;
                        }
                    }
                    --ls;
                }
                ls = tl;
                if (ls == L) {
                    kase = 3;
                } else if (ls == m) {
                    kase = 1;
                } else {
                    kase = 2;
                    L = ls;
                }
            }
            ++L;
            if (kase == 1) {
                f = e[m - 1];
                e[m - 1] = 0.0;
                k = m - L;
                while (k >= L) {
                    t1 = s[k];
                    roe = f;
                    if (Math.abs(f) < Math.abs(t1)) {
                        roe = t1;
                    }
                    if ((scale = Math.abs(t1) + Math.abs(f)) == 0.0) {
                        cs = 1.0;
                        sn = 0.0;
                        r = 0.0;
                    } else {
                        r = scale * Math.sqrt(t1 * t1 / (scale * scale) + f * f / (scale * scale));
                        if (!(0.0 <= roe)) {
                            r = -r;
                        }
                        cs = t1 / r;
                        sn = f / r;
                    }
                    z = 1.0;
                    if (Math.abs(f) < Math.abs(t1)) {
                        z = sn;
                    }
                    if (Math.abs(t1) <= Math.abs(f) && cs != 0.0) {
                        z = 1.0 / cs;
                    }
                    t1 = r;
                    f = z;
                    s[k] = t1;
                    if (k != L) {
                        f = -sn * e[k - 1];
                        e[k - 1] = cs * e[k - 1];
                    }
                    if (want == 11 || want == 21) {
                        ii = 1;
                        while (ii <= p) {
                            ttmp = cs * v[ii][k] + sn * v[ii][m];
                            v[ii][m] = cs * v[ii][m] - sn * v[ii][k];
                            v[ii][k] = ttmp;
                            ++ii;
                        }
                    }
                    --k;
                }
                continue;
            }
            if (kase == 2) {
                f = e[L - 1];
                e[L - 1] = 0.0;
                k = L;
                while (k <= m) {
                    t1 = s[k];
                    roe = f;
                    if (Math.abs(f) < Math.abs(t1)) {
                        roe = t1;
                    }
                    if ((scale = Math.abs(t1) + Math.abs(f)) == 0.0) {
                        cs = 1.0;
                        sn = 0.0;
                        r = 0.0;
                    } else {
                        r = scale * Math.sqrt(t1 * t1 / (scale * scale) + f * f / (scale * scale));
                        if (!(0.0 <= roe)) {
                            r = -r;
                        }
                        cs = t1 / r;
                        sn = f / r;
                    }
                    z = 1.0;
                    if (Math.abs(f) < Math.abs(t1)) {
                        z = sn;
                    }
                    if (Math.abs(t1) <= Math.abs(f) && cs != 0.0) {
                        z = 1.0 / cs;
                    }
                    t1 = r;
                    f = z;
                    s[k] = t1;
                    f = -sn * e[k];
                    e[k] = cs * e[k];
                    if (want == 11 || want == 12) {
                        ii = 1;
                        while (ii <= n) {
                            ttmp = cs * u[ii][k] + sn * u[ii][L - 1];
                            u[ii][L - 1] = cs * u[ii][L - 1] - sn * u[ii][k];
                            u[ii][k] = ttmp;
                            ++ii;
                        }
                    }
                    ++k;
                }
                continue;
            }
            if (kase == 3) {
                scale = Math.max(Math.abs(s[m]), Math.abs(s[m - 1]));
                double scaltemp1 = Math.max(Math.abs(e[m - 1]), Math.abs(s[L]));
                scaltemp1 = Math.max(scaltemp1, Math.abs(e[L]));
                scale = Math.max(scale, scaltemp1);
                sm = s[m] / scale;
                smm1 = s[m - 1] / scale;
                emm1 = e[m - 1] / scale;
                sl = s[L] / scale;
                el = e[L] / scale;
                b = 0.5 * (smm1 + sm) * (smm1 - sm) + 0.5 * (emm1 * emm1);
                c = sm * sm * (emm1 * emm1);
                shift = 0.0;
                if (b != 0.0 || c != 0.0) {
                    shift = Math.sqrt(b * b + c);
                    if (b < 0.0) {
                        shift = -shift;
                    }
                    shift = c / (b + shift);
                }
                f = (sl + sm) * (sl - sm) + shift;
                g = sl * el;
                mm1 = m - 1;
                k = L;
                while (k <= mm1) {
                    roe = g;
                    if (Math.abs(g) < Math.abs(f)) {
                        roe = f;
                    }
                    if ((scale = Math.abs(f) + Math.abs(g)) == 0.0) {
                        cs = 1.0;
                        sn = 0.0;
                        r = 0.0;
                    } else {
                        r = scale * Math.sqrt(f * f / (scale * scale) + g * g / (scale * scale));
                        if (!(0.0 <= roe)) {
                            r = -r;
                        }
                        cs = f / r;
                        sn = g / r;
                    }
                    z = 1.0;
                    if (Math.abs(g) < Math.abs(f)) {
                        z = sn;
                    }
                    if (Math.abs(f) <= Math.abs(g) && cs != 0.0) {
                        z = 1.0 / cs;
                    }
                    f = r;
                    g = z;
                    if (k != L) {
                        e[k - 1] = f;
                    }
                    f = cs * s[k] + sn * e[k];
                    e[k] = cs * e[k] - sn * s[k];
                    g = sn * s[k + 1];
                    s[k + 1] = cs * s[k + 1];
                    if (want == 11 || want == 21) {
                        ii = 1;
                        while (ii <= p) {
                            ttmp = cs * v[ii][k] + sn * v[ii][k + 1];
                            v[ii][k + 1] = cs * v[ii][k + 1] - sn * v[ii][k];
                            v[ii][k] = ttmp;
                            ++ii;
                        }
                    }
                    roe = g;
                    if (Math.abs(g) < Math.abs(f)) {
                        roe = f;
                    }
                    if ((scale = Math.abs(f) + Math.abs(g)) == 0.0) {
                        cs = 1.0;
                        sn = 0.0;
                        r = 0.0;
                    } else {
                        r = scale * Math.sqrt(f * f / (scale * scale) + g * g / (scale * scale));
                        if (!(0.0 <= roe)) {
                            r = -r;
                        }
                        cs = f / r;
                        sn = g / r;
                    }
                    z = 1.0;
                    if (Math.abs(g) < Math.abs(f)) {
                        z = sn;
                    }
                    if (Math.abs(f) <= Math.abs(g) && cs != 0.0) {
                        z = 1.0 / cs;
                    }
                    f = r;
                    g = z;
                    s[k] = f;
                    f = cs * e[k] + sn * s[k + 1];
                    s[k + 1] = -sn * e[k] + cs * s[k + 1];
                    g = sn * e[k + 1];
                    e[k + 1] = cs * e[k + 1];
                    if ((want == 11 || want == 12) && k < n) {
                        ii = 1;
                        while (ii <= n) {
                            ttmp = cs * u[ii][k] + sn * u[ii][k + 1];
                            u[ii][k + 1] = cs * u[ii][k + 1] - sn * u[ii][k];
                            u[ii][k] = ttmp;
                            ++ii;
                        }
                    }
                    ++k;
                }
                e[m - 1] = f;
                ++iter;
                continue;
            }
            if (s[L] < 0.0) {
                s[L] = -s[L];
                if (want == 11 || want == 21) {
                    ii = 1;
                    while (ii <= p) {
                        v[ii][L] = -v[ii][L];
                        ++ii;
                    }
                }
            }
            br4 = true;
            while (br4 && L != mm) {
                if (s[L + 1] <= s[L]) {
                    br4 = false;
                    continue;
                }
                t = s[L];
                s[L] = s[L + 1];
                s[L + 1] = t;
                if ((want == 11 || want == 21) && L < p) {
                    ii = 1;
                    while (ii <= p) {
                        ttmp = v[ii][L];
                        v[ii][L] = v[ii][L + 1];
                        v[ii][L + 1] = ttmp;
                        ++ii;
                    }
                }
                if ((want == 11 || want == 12) && L < n) {
                    ii = 1;
                    while (ii <= n) {
                        ttmp = u[ii][L];
                        u[ii][L] = u[ii][L + 1];
                        u[ii][L + 1] = ttmp;
                        ++ii;
                    }
                }
                ++L;
            }
            iter = 0;
            --m;
        }
    }
}

