/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.linalg;

import cn.org.gddsn.linalg.Matrix;
import cn.org.gddsn.linalg.SVD;

public class Pcacov {
    double[][] pc;
    double[] latent;
    double[] explained;

    public Pcacov(Matrix mat) {
        SVD svd = new SVD(mat.getMat(), mat.getRow(), mat.getCol());
        this.pc = svd.getRightVector();
        this.latent = svd.getSingular();
        double sum = 0.0;
        int i = 0;
        while (i < this.latent.length) {
            sum += this.latent[i];
            ++i;
        }
        this.explained = new double[this.latent.length];
        i = 0;
        while (i < this.latent.length) {
            this.explained[i] = 100.0 * this.latent[i] / sum;
            ++i;
        }
    }

    public double[][] getPC() {
        return this.pc;
    }

    public double[] getLatent() {
        return this.latent;
    }

    public double[] getExplained() {
        return this.explained;
    }

    public static void main(String[] args) {
        double[][] x = new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0}, {1.0, 3.0, 1.0, 7.0, 6.0}};
        Matrix mat = Matrix.Cov(new Matrix(x, 2, 5).Transport().getMat(), 5, 2);
        Pcacov pca = new Pcacov(mat);
        double[][] pc = pca.getPC();
        double[] eig = pca.getLatent();
        double[] score = pca.getExplained();
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                System.err.print(String.valueOf(pc[i][j]) + ",");
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < 2) {
            System.out.println(String.valueOf(eig[i]) + "\t" + score[i]);
            ++i;
        }
    }
}

