/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.test;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.CatalogI;
import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.MagI;
import cn.org.gddsn.jopens.entity.MagType;
import cn.org.gddsn.jopens.entity.Phase;
import cn.org.gddsn.jopens.entity.PhaseI;
import cn.org.gddsn.jopens.entity.UniEventId;
import cn.org.gddsn.jopens.entity.util.EntityXmlUtils;
import cn.org.gddsn.jopens.service.EventManagerService;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;

public class TestEventManagerService {
    static Logger logger = Logger.getLogger(TestEventManagerService.class);
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private EventManagerService eventManagerService;

    public void addMagType() {
        MagType type1 = new MagType();
        type1.setId("M");
        type1.setDescription("M");
        this.eventManagerService.updateMagType(type1);
        MagType m = this.eventManagerService.findMagTypeById("M");
        logger.info(m.getDescription());
        MagType type2 = new MagType();
        type2.setId("Ms");
        type2.setDescription("Ms");
        this.eventManagerService.updateMagType(type2);
    }

    private Catalog buildCatalog1() throws Exception {
        CatalogI cata1 = new CatalogI();
        cata1.setCataName("GD.20070112205011.11628.3889.51");
        cata1.setDepfixFlag(1);
        cata1.setDmin(-10.0f);
        cata1.setEpicId("30");
        cata1.setDepth(33.0f);
        cata1.setLat(38.89f);
        cata1.setLon(116.28f);
        cata1.setEqType("1");
        cata1.setEqName("1");
        cata1.setErh(10.0f);
        cata1.setErz(10.0f);
        cata1.setFeNum(1);
        cata1.setFeSname("North of China");
        cata1.setGapAzi(99.0f);
        cata1.setLocationSname("He Bei China");
        cata1.setLocPha(31);
        cata1.setLocProgram("Hypo2000");
        cata1.setLocStn(10);
        cata1.setM(5.0f);
        cata1.setModelName("ASPI91");
        cata1.setMSource("M");
        cata1.setNetCode("GD");
        cata1.setOperator("HWH");
        cata1.setOriginTime(sdf.parse("2007-01-12 21:20:34"));
        cata1.setOriginTimeFrac(9000);
        cata1.setQcom("AAA");
        cata1.setQloc("BBB");
        cata1.setQnet("CCC");
        cata1.setRemark("dfetwfds");
        cata1.setRms(0.3f);
        cata1.setSaveTime(sdf.parse("2007-01-20 21:20:34"));
        cata1.setSequenName("2");
        cata1.setSourceId("fe");
        cata1.setSpmin(2.0f);
        cata1.setSumPha(40);
        cata1.setSumStn(21);
        return cata1;
    }

    private Catalog buildCatalog2() throws Exception {
        CatalogI cata2 = new CatalogI();
        cata2.setCataName("HB.20070112205011.11628.3889.51");
        cata2.setDepfixFlag(1);
        cata2.setDmin(-10.0f);
        cata2.setEpicId("30");
        cata2.setDepth(33.0f);
        cata2.setLat(38.89f);
        cata2.setLon(116.28f);
        cata2.setEqType("1");
        cata2.setEqName("1");
        cata2.setErh(10.0f);
        cata2.setErz(10.0f);
        cata2.setFeNum(1);
        cata2.setFeSname("North of China");
        cata2.setGapAzi(99.0f);
        cata2.setLocationSname("He Bei China");
        cata2.setLocPha(31);
        cata2.setLocProgram("Hypo2000");
        cata2.setLocStn(10);
        cata2.setM(5.0f);
        cata2.setModelName("ASPI91");
        cata2.setMSource("M");
        cata2.setNetCode("HB");
        cata2.setOperator("HWH");
        cata2.setOriginTime(new Date(sdf.parse("2007-01-12 21:20:34").getTime()));
        cata2.setOriginTimeFrac(9000);
        cata2.setQcom("AAA");
        cata2.setQloc("BBB");
        cata2.setQnet("CCC");
        cata2.setRemark("dfetwfds");
        cata2.setRms(0.3f);
        cata2.setSaveTime(new Date(sdf.parse("2007-01-20 21:20:34").getTime()));
        cata2.setSequenName("1");
        cata2.setSourceId("fe");
        cata2.setSpmin(2.0f);
        cata2.setSumPha(40);
        cata2.setSumStn(21);
        return cata2;
    }

    public Mag buildMag1() {
        MagI mag1 = new MagI();
        mag1.setMagGap(20.0f);
        mag1.setMagStn(5);
        mag1.setMagVal(5.1f);
        MagType magtypeDic1 = this.eventManagerService.findMagTypeById("M");
        mag1.setMagType(magtypeDic1);
        mag1.setRemark("hehe");
        return mag1;
    }

    public Mag buildMag2() {
        MagI mag2 = new MagI();
        mag2.setMagGap(20.0f);
        mag2.setMagStn(5);
        mag2.setMagVal(5.1f);
        MagType magtypeDic2 = this.eventManagerService.findMagTypeById("Ms");
        mag2.setMagType(magtypeDic2);
        mag2.setRemark("hehe");
        return mag2;
    }

    public Phase buildPhase1(String stn) throws Exception {
        PhaseI phase1 = new PhaseI();
        phase1.setChannelLocator(new ChannelLocator("GD", stn, "00", "BHZ"));
        phase1.setAmp(3453.0f);
        phase1.setAmpType("full");
        phase1.setAzimuth(91.0f);
        phase1.setClarity("I");
        phase1.setDistance(245.0f);
        phase1.setMagtypeDic(this.eventManagerService.findMagTypeById("Ms"));
        phase1.setMagVal(5.1f);
        phase1.setPeriod(0.5f);
        phase1.setPhaseName("LMZ");
        phase1.setPhaseTime(new Date(sdf.parse("2007-01-12 21:20:34").getTime()));
        phase1.setPhaseTimeFrac(20000);
        phase1.setRecType("V");
        phase1.setResi(0.5f);
        phase1.setSp(300.0f);
        phase1.setWeight(1);
        phase1.setWsign("C");
        return phase1;
    }

    public Phase buildPhase2(String stn) throws Exception {
        PhaseI phase2 = new PhaseI();
        phase2.setChannelLocator(new ChannelLocator("GD", stn, "00", "BHZ"));
        phase2.setAmp(3453.0f);
        phase2.setAmpType("full");
        phase2.setAzimuth(91.0f);
        phase2.setClarity("I");
        phase2.setDistance(245.0f);
        phase2.setMagtypeDic(this.eventManagerService.findMagTypeById("Ms"));
        phase2.setMagVal(5.1f);
        phase2.setPeriod(0.5f);
        phase2.setPhaseName("LMZ");
        phase2.setPhaseTime(new Date(sdf.parse("2007-01-12 21:20:34").getTime()));
        phase2.setPhaseTimeFrac(20000);
        phase2.setRecType("V");
        phase2.setResi(0.5f);
        phase2.setSp(300.0f);
        phase2.setWeight(1);
        phase2.setWsign("C");
        return phase2;
    }

    public EventManagerService getEventManagerService() {
        return this.eventManagerService;
    }

    public void setEventManagerService(EventManagerService eventManagerService) {
        this.eventManagerService = eventManagerService;
    }

    public void testFindMagById() {
        MagI mag = this.eventManagerService.findMagIById(1L);
        logger.info("mag= " + mag.getMagVal());
        logger.info("cata_id: " + mag.getCatalog().getCataName());
        logger.info("cata_id: " + mag.getCatalog().getEventInfo().getUniEventId().getNationEventId());
    }

    public void testRegister() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<EventInfo> events = new ArrayList<EventInfo>();
        UniEventId uniEventId = new UniEventId();
        uniEventId.setNationEventId("CC.200701122050.0001");
        EventInfo event1 = new EventInfo();
        event1.setUniEventId(uniEventId);
        event1.setEventId("GD.200701122050.0001");
        event1.setStartTime(new Date(sdf.parse("2007-01-12 20:50:34").getTime()));
        event1.setStartTimeFrac(9000);
        event1.setEndTime(new Date(sdf.parse("2007-01-12 21:20:34").getTime()));
        event1.setStartTimeFrac(0);
        Catalog cata1 = this.buildCatalog1();
        cata1.setEventInfo(event1);
        Mag mag1 = this.buildMag1();
        mag1.setCatalog(cata1);
        Mag mag2 = this.buildMag2();
        mag2.setCatalog(cata1);
        HashSet<Mag> mags = new HashSet<Mag>();
        mags.add(mag1);
        mags.add(mag2);
        cata1.setMags(mags);
        Phase phase1 = this.buildPhase1("SHT");
        phase1.setCatalog(cata1);
        Phase phase2 = this.buildPhase2("SHG");
        phase2.setCatalog(cata1);
        ArrayList<Phase> phs = new ArrayList<Phase>();
        phs.add(phase1);
        phs.add(phase2);
        cata1.setPhases(phs);
        ArrayList<Catalog> catas1 = new ArrayList<Catalog>();
        catas1.add(cata1);
        event1.setCatalogs(catas1);
        events.add(event1);
        uniEventId.setEventInfos(events);
        EventInfo event2 = new EventInfo();
        event2.setUniEventId(uniEventId);
        event2.setEventId("HB.200701122051.0001");
        event2.setStartTime(new Date(sdf.parse("2007-01-12 20:50:34").getTime()));
        event2.setStartTimeFrac(8500);
        event2.setEndTime(new Date(sdf.parse("2007-01-12 21:21:34").getTime()));
        event2.setStartTimeFrac(0);
        Catalog cata2 = this.buildCatalog2();
        cata2.setEventInfo(event2);
        Mag mag3 = this.buildMag1();
        mag3.setCatalog(cata2);
        Mag mag4 = this.buildMag2();
        mag4.setCatalog(cata2);
        HashSet<Mag> mags2 = new HashSet<Mag>();
        mags2.add(mag3);
        mags2.add(mag4);
        cata2.setMags(mags2);
        Phase phase3 = this.buildPhase1("SHT");
        phase3.setCatalog(cata2);
        Phase phase4 = this.buildPhase2("SHG");
        phase4.setCatalog(cata2);
        ArrayList<Phase> phs2 = new ArrayList<Phase>();
        phs2.add(phase3);
        phs2.add(phase4);
        cata2.setPhases(phs2);
        ArrayList<Catalog> catas2 = new ArrayList<Catalog>();
        catas2.add(cata2);
        event2.setCatalogs(catas2);
        events.add(event2);
        uniEventId.setEventInfos(events);
        this.eventManagerService.addUniEventId(uniEventId);
    }

    public void testRegisterAgain() throws Exception {
        String uniId = "CC.200701122050.0001";
        UniEventId uniEventId = this.eventManagerService.findUniEventIdById(uniId);
        EventInfo event1 = new EventInfo();
        event1.setUniEventId(uniEventId);
        event1.setEventId("GX.200701122050.0001");
        event1.setStartTime(new Date(sdf.parse("2007-01-12 20:50:34").getTime()));
        event1.setStartTimeFrac(9000);
        event1.setEndTime(new Date(sdf.parse("2007-01-12 21:20:34").getTime()));
        event1.setStartTimeFrac(0);
        Catalog cata1 = this.buildCatalog1();
        cata1.setEventInfo(event1);
        Mag mag1 = this.buildMag1();
        mag1.setCatalog(cata1);
        Mag mag2 = this.buildMag2();
        mag2.setCatalog(cata1);
        HashSet<Mag> mags = new HashSet<Mag>();
        mags.add(mag1);
        mags.add(mag2);
        cata1.setMags(mags);
        Phase phase1 = this.buildPhase1("XXX");
        phase1.setCatalog(cata1);
        Phase phase2 = this.buildPhase2("YYY");
        phase2.setCatalog(cata1);
        ArrayList<Phase> phs = new ArrayList<Phase>();
        phs.add(phase1);
        phs.add(phase2);
        cata1.setPhases(phs);
        ArrayList<Catalog> catas1 = new ArrayList<Catalog>();
        catas1.add(cata1);
        event1.setCatalogs(catas1);
        uniEventId.getEventInfos().add(event1);
        this.eventManagerService.updateUniEventId(uniEventId);
    }

    public void testRemoveMag() {
        this.eventManagerService.findMagIById(1L);
        this.eventManagerService.removeMag(1L);
    }

    public void testRemoveUniEventId() {
        MagI mag = this.eventManagerService.findMagIById(1L);
        logger.info("mag= " + mag.getMagVal());
        UniEventId uniEventId = mag.getCatalog().getEventInfo().getUniEventId();
        logger.info("uniEventId: " + uniEventId.getNationEventId());
        this.eventManagerService.removeUniEventId(uniEventId.getNationEventId());
    }

    public void testUpdateMag() {
        MagI mag = this.eventManagerService.findMagIById(1L);
        mag.setRemark("hello");
        this.eventManagerService.updateMag(mag);
    }

    public void testUniEventId() throws Exception {
        UniEventId uniEventId = this.eventManagerService.findUniEventIdById("1");
        FileOutputStream fos = new FileOutputStream("/tmp/uniEventId.xml");
        EntityXmlUtils.write(fos, uniEventId, UniEventId.class);
        fos.close();
        FileInputStream fis = new FileInputStream("/tmp/uniEventId.xml");
        uniEventId = (UniEventId)EntityXmlUtils.read(fis, UniEventId.class);
        fis.close();
        fos = new FileOutputStream("/tmp/uniEventId1.xml");
        EntityXmlUtils.write(fos, uniEventId, UniEventId.class);
        fos.close();
    }

    public static void main(String[] args) throws Exception {
        FileSystemResource res = new FileSystemResource("JOPENS-service-test.xml");
        XmlBeanFactory factory = new XmlBeanFactory(res);
        EventManagerService service = (EventManagerService)factory.getBean("eventManagerService");
        TestEventManagerService test = new TestEventManagerService();
        test.setEventManagerService(service);
        test.addMagType();
        test.testRegister();
        test.testRegisterAgain();
        test.testUniEventId();
    }
}

