/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.Timer;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TemporalType;
import org.jboss.annotation.ejb.ResourceAdapter;
import org.jboss.logging.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="cronTrigger", propertyValue="0 0/5 * * * ?")})
@ResourceAdapter(value="quartz-ra.rar")
public class WaveformScavengerBean
implements Job {
    static final Logger logger = Logger.getLogger(WaveformScavengerBean.class);
    @PersistenceContext
    private EntityManager manager;
    @Resource(name="WaveformBean/maxWaveformStoreTime", type=Integer.class)
    private int maxWaveformStoreTime = 720000;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
    }

    @PostConstruct
    public void postConstruct() {
        logger.info((Object)("maxWaveformStoreTime = " + this.maxWaveformStoreTime));
    }

    public void scavenger(Timer timer) {
        try {
            logger.info((Object)"waveformCon scavenger...");
            long ms = new Date().getTime() - (long)(this.maxWaveformStoreTime * 3600) * 1000L;
            int ndelete = this.manager.createQuery("delete from WaveformCon w where w.startTime > :startTime and w.startTime < :endTime").setParameter("startTime", new Date(ms), TemporalType.TIMESTAMP).setParameter("endTime", new Date(ms - 720000L), TemporalType.TIMESTAMP).executeUpdate();
            logger.info((Object)("delete old waveformCon: " + ndelete));
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

