/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.LogCenter;
import cn.org.gddsn.jopens.entity.LogStation;
import cn.org.gddsn.jopens.entity.SyncLogCenter;
import cn.org.gddsn.jopens.entity.SyncLogStation;
import cn.org.gddsn.jopens.service.SyncLogService;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

@Stateless
@Local(value={SyncLogService.class})
@Remote(value={SyncLogService.class})
public class SyncLogServiceBean
implements SyncLogService {
    static Logger logger = Logger.getLogger(SyncLogServiceBean.class);
    @PersistenceContext
    private EntityManager em;

    public void removeLogCenter(String net, long id) {
        String nid = String.valueOf(net) + "." + id;
        SyncLogCenter syncLog = this.em.find(SyncLogCenter.class, nid);
        if (syncLog != null) {
            this.em.remove(syncLog);
        }
    }

    public void syncLogCenter(LogCenter log) {
        String id = String.valueOf(log.getNetCode()) + "." + log.getId();
        SyncLogCenter syncLog = this.em.find(SyncLogCenter.class, id);
        if (syncLog == null) {
            syncLog = new SyncLogCenter();
            syncLog.setId(id);
            log.setId(0L);
            syncLog.setLogCenter(log);
            this.em.persist(syncLog);
        } else {
            LogCenter logn = syncLog.getLogCenter();
            long newid = logn.getId();
            try {
                BeanUtils.copyProperties((Object)logn, (Object)log);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
            }
            logn.setId(newid);
            this.em.merge(syncLog);
        }
    }

    public void removeLogStation(String net, long id) {
        String nid = String.valueOf(net) + "." + id;
        SyncLogStation syncLog = this.em.find(SyncLogStation.class, nid);
        if (syncLog != null) {
            this.em.remove(syncLog);
        }
    }

    public void syncLogStation(LogStation log) {
        String id = String.valueOf(log.getNetStation().getNetCode()) + "." + log.getId();
        SyncLogStation syncLog = this.em.find(SyncLogStation.class, id);
        if (syncLog == null) {
            syncLog = new SyncLogStation();
            syncLog.setId(id);
            log.setId(0L);
            syncLog.setLogStation(log);
            this.em.persist(syncLog);
        } else {
            LogStation logn = syncLog.getLogStation();
            long newid = logn.getId();
            try {
                BeanUtils.copyProperties((Object)logn, (Object)log);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
            }
            logn.setId(newid);
            this.em.merge(syncLog);
        }
    }
}

