/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.ChannelInfo;
import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.InstrDic;
import cn.org.gddsn.jopens.entity.InstruManage;
import cn.org.gddsn.jopens.entity.NetStation;
import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.SeedConfig;
import cn.org.gddsn.jopens.entity.StationCorr;
import cn.org.gddsn.jopens.entity.StationInfo;
import cn.org.gddsn.jopens.entity.StationSite;
import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette030;
import cn.org.gddsn.jopens.entity.seed.Blockette031;
import cn.org.gddsn.jopens.entity.seed.Blockette032;
import cn.org.gddsn.jopens.entity.seed.Blockette033;
import cn.org.gddsn.jopens.entity.seed.Blockette034;
import cn.org.gddsn.jopens.entity.seed.Blockette050;
import cn.org.gddsn.jopens.entity.seed.Blockette052;
import cn.org.gddsn.jopens.entity.seed.Blockette053;
import cn.org.gddsn.jopens.entity.seed.Blockette054;
import cn.org.gddsn.jopens.entity.seed.Blockette057;
import cn.org.gddsn.jopens.entity.seed.Blockette058;
import cn.org.gddsn.jopens.entity.seed.Blockette059;
import cn.org.gddsn.jopens.entity.seed.Blockette061;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.CoeffBlob;
import cn.org.gddsn.jopens.entity.seed.ComplexErrorBlob;
import cn.org.gddsn.jopens.entity.seed.Corner;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Response;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.entity.util.EntityXmlUtils;
import cn.org.gddsn.jopens.entity.util.ResponseXML;
import cn.org.gddsn.jopens.service.StationManagerService;
import java.io.ByteArrayOutputStream;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Local(value={StationManagerService.class})
@Remote(value={StationManagerService.class})
public class StationManagerServiceBean
implements StationManagerService {
    static Logger logger = Logger.getLogger(StationManagerServiceBean.class);
    @PersistenceContext
    private EntityManager em;

    @Override
    public SeedConfig findSeedConifgById(long id) {
        return this.em.find(SeedConfig.class, id);
    }

    public SeedConfig findNewestSeedConifg() {
        return (SeedConfig)this.em.createQuery("select e from SeedConfig e where e.endTime=null").getSingleResult();
    }

    @Override
    public void updateSeedConfig(SeedConfig sc) {
        sc.setSaveTime(new Timestamp(new Date().getTime()));
        this.em.merge(sc);
    }

    @Override
    public void initStationInfo() {
        if (this.em.createQuery("select e from SeedConfig e").getResultList().size() == 0) {
            SeedConfig sc = new SeedConfig();
            Abbreviation abbreviation = new Abbreviation();
            sc.setAbbreviation(abbreviation);
            this.em.persist(sc);
        }
    }

    @Override
    public Station findStationById(long id) {
        Station sta = this.em.find(Station.class, id);
        if (sta != null) {
            sta.getChannel().size();
        }
        return sta;
    }

    @Override
    public Station findStationByEId(String eid) {
        List lst = this.em.createQuery("select s from Station s where s.exchangeId = :eid").setParameter("eid", (Object)eid).getResultList();
        if (lst.size() == 0) {
            return null;
        }
        return (Station)lst.get(0);
    }

    @Override
    public Collection<Station> findAllStation() {
        NetworkInfo ni = this.findNetworkInfoSelf();
        List<Station> stns = this.em.find(Dataless.class, ni.getUniCode()).getSeedConfig().getStation();
        stns.size();
        return stns;
    }

    @Override
    public void addStation(Station sta) {
        NetworkInfo ni = this.findNetworkInfoSelf();
        SeedConfig sc = this.em.find(Dataless.class, ni.getUniCode()).getSeedConfig();
        sc.getStation().add(sta);
        this.em.persist(sta);
    }

    @Override
    public void removeStation(long id) {
        NetworkInfo ni = this.findNetworkInfoSelf();
        SeedConfig sc = this.em.find(Dataless.class, ni.getUniCode()).getSeedConfig();
        Station sta = this.findStationById(id);
        sc.getStation().remove(sta);
        this.em.remove(sta);
        this.em.merge(sc);
    }

    @Override
    public void updateStation(Station sta) {
        for (Channel c : sta.getChannel()) {
            c.getBlockette052().setLatitude(sta.getBlockette050().getLatitude());
            c.getBlockette052().setLongitude(sta.getBlockette050().getLongitude());
            c.getBlockette052().setElevation(sta.getBlockette050().getElevation());
        }
        this.em.merge(sta);
    }

    @Override
    public StationInfo findStationInfoById(long id) {
        return this.em.find(StationInfo.class, id);
    }

    @Override
    public Channel findChannelById(long id) {
        Channel chn = this.em.find(Channel.class, id);
        if (chn != null && chn.getResponse() != null) {
            chn.getResponse().size();
            chn.getChannelInfo();
        }
        return chn;
    }

    @Override
    public void addChannel(Channel chan) {
        this.em.persist(chan);
    }

    @Override
    public void removeChannel(long id) {
        Channel chn = this.em.find(Channel.class, id);
        Station Station2 = chn.getStation();
        Station2.getChannel().remove(chn);
        this.em.merge(Station2);
        this.em.remove(chn);
    }

    @Override
    public void updateChannel(Channel chan) {
        this.em.merge(chan);
    }

    @Override
    public InstruManage findInstruManageById(long id) {
        return this.em.find(InstruManage.class, id);
    }

    @Override
    public void addInstruManage(InstruManage instru) {
        this.em.persist(instru);
    }

    @Override
    public void removeInstruManage(long id) {
        InstruManage instru = this.em.find(InstruManage.class, id);
        this.em.remove(instru);
    }

    @Override
    public void updateInstruManage(InstruManage instru) {
        this.em.merge(instru);
    }

    @Override
    public InstrDic findInstrDicByName(String name) {
        List lst = this.em.createQuery("select e from InstrDic e where e.instrModel = :instrModel").setParameter("instrModel", (Object)name).getResultList();
        if (lst.size() != 0) {
            return (InstrDic)lst.get(0);
        }
        return null;
    }

    @Override
    public InstrDic findInstrDicById(long id) {
        InstrDic inst = this.em.find(InstrDic.class, id);
        if (inst != null) {
            inst.getChannel().size();
            for (Channel chan : inst.getChannel()) {
                chan.getResponse().size();
            }
        }
        return inst;
    }

    @Override
    public Collection<InstrDic> findAllInstrDic() {
        return this.em.createQuery("select e from InstrDic e").getResultList();
    }

    @Override
    public void addInstrDic(InstrDic instrDic) {
        this.em.persist(instrDic);
    }

    @Override
    public void removeInstrumentChannel(long instrumentId, long channelId) {
        InstrDic inst = this.em.find(InstrDic.class, instrumentId);
        Channel chn = this.em.find(Channel.class, channelId);
        inst.getChannel().remove(chn);
        this.em.merge(inst);
        this.em.remove(chn);
    }

    @Override
    public void removeInstrDic(long id) {
        this.em.remove(this.findInstrDicById(id));
    }

    @Override
    public void updateInstrDic(InstrDic instrDic) {
        this.em.merge(instrDic);
    }

    @Override
    public StationCorr findStationCorrById(long id) {
        return this.em.find(StationCorr.class, id);
    }

    @Override
    public void addStationCorr(StationCorr corr) {
        this.em.persist(corr);
    }

    @Override
    public void removeStationCorr(long id) {
        this.em.remove(this.findStationCorrById(id));
    }

    @Override
    public void updateStationCorr(StationCorr corr) {
        this.em.merge(corr);
    }

    @Override
    public StationSite findStationSiteById(long id) {
        return this.em.find(StationSite.class, id);
    }

    @Override
    public void addStationSite(StationSite site) {
        this.em.persist(site);
    }

    @Override
    public void removeStationSite(long id) {
        this.em.remove(this.findStationSiteById(id));
    }

    @Override
    public void updateStationSite(StationSite site) {
        this.em.merge(site);
    }

    @Override
    public Blockette030 findBlockette030ById(long id) {
        Blockette030 b030 = this.em.find(Blockette030.class, id);
        return b030;
    }

    @Override
    public Blockette030 findBlockette030ByLookupCode(int id) {
        Blockette030 b = null;
        try {
            b = (Blockette030)this.em.createQuery("select e from Blockette030 e where e.dataFormat = :lookupCode").setParameter("lookupCode", (Object)id).getSingleResult();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return b;
    }

    @Override
    public Collection<Blockette030> findAllBlockette030() {
        return this.em.createQuery("select e from Blockette030 e").getResultList();
    }

    @Override
    public void addBlockette030(Blockette030 b) {
        this.em.persist(b);
    }

    @Override
    public void removeBlockette030(long id) {
        this.em.remove(this.findBlockette030ById(id));
    }

    @Override
    public void updateBlockette030(Blockette030 b) {
        this.em.merge(b);
    }

    @Override
    public Blockette031 findBlockette031ById(long id) {
        return this.em.find(Blockette031.class, id);
    }

    @Override
    public Blockette031 findBlockette031ByLookupCode(int id) {
        Blockette031 b = null;
        try {
            b = (Blockette031)this.em.createQuery("select e from Blockette031 e where e.codeKey= :lookupCode").setParameter("lookupCode", (Object)id).getSingleResult();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return b;
    }

    @Override
    public Collection<Blockette031> findAllBlockette031() {
        return this.em.createQuery("select e from Blockette031 e").getResultList();
    }

    @Override
    public void addBlockette031(Blockette031 b) {
        this.em.persist(b);
    }

    @Override
    public void removeBlockette031(long id) {
        this.em.remove(this.findBlockette031ById(id));
    }

    @Override
    public void updateBlockette031(Blockette031 b) {
        this.em.merge(b);
    }

    @Override
    public Blockette032 findBlockette032ById(long id) {
        return this.em.find(Blockette032.class, id);
    }

    @Override
    public Blockette032 findBlockette032ByLookupCode(int id) {
        Blockette032 b = null;
        try {
            b = (Blockette032)this.em.createQuery("select e from Blockette032 e where e.lookupCode= :lookupCode").setParameter("lookupCode", (Object)id).getSingleResult();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return b;
    }

    @Override
    public Collection<Blockette032> findAllBlockette032() {
        return this.em.createQuery("select e from Blockette032 e").getResultList();
    }

    @Override
    public void addBlockette032(Blockette032 b) {
        this.em.persist(b);
    }

    @Override
    public void removeBlockette032(long id) {
        this.em.remove(this.findBlockette032ById(id));
    }

    @Override
    public void updateBlockette032(Blockette032 b) {
        this.em.merge(b);
    }

    @Override
    public Blockette033 findBlockette033ById(long id) {
        return this.em.find(Blockette033.class, id);
    }

    @Override
    public Blockette033 findBlockette033ByLookupCode(int id) {
        Blockette033 b = null;
        try {
            b = (Blockette033)this.em.createQuery("select e from Blockette033 e where e.lookupCode= :lookupCode").setParameter("lookupCode", (Object)id).getSingleResult();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return b;
    }

    @Override
    public Collection<Blockette033> findAllBlockette033() {
        return this.em.createQuery("select e from Blockette033 e").getResultList();
    }

    @Override
    public void addBlockette033(Blockette033 b) {
        this.em.persist(b);
    }

    @Override
    public void removeBlockette033(long id) {
        this.em.remove(this.findBlockette033ById(id));
    }

    @Override
    public void updateBlockette033(Blockette033 b) {
        this.em.merge(b);
    }

    @Override
    public Blockette034 findBlockette034ById(long id) {
        return this.em.find(Blockette034.class, id);
    }

    @Override
    public Blockette034 findBlockette034ByLookupCode(int id) {
        Blockette034 b034 = null;
        try {
            b034 = (Blockette034)this.em.createQuery("select e from Blockette034 e where e.lookupCode= :lookupCode").setParameter("lookupCode", (Object)id).getSingleResult();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return b034;
    }

    @Override
    public Blockette034 findBlockette034ByName(String id) {
        Blockette034 b034 = null;
        try {
            b034 = (Blockette034)this.em.createQuery("select e from Blockette034 e where e.unitName= :uniName").setParameter("uniName", (Object)id).getSingleResult();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return b034;
    }

    @Override
    public Collection<Blockette034> findAllBlockette034() {
        return this.em.createQuery("select e from Blockette034 e").getResultList();
    }

    @Override
    public void addBlockette034(Blockette034 b034) {
        this.em.persist(b034);
    }

    @Override
    public void removeBlockette034(long id) {
        this.em.remove(this.findBlockette034ById(id));
    }

    @Override
    public void updateBlockette034(Blockette034 units) {
        this.em.merge(units);
    }

    @Override
    public Collection<NetworkInfo> findAllNetworkInfo() {
        return this.em.createQuery("select e from NetworkInfo e").getResultList();
    }

    public NetworkInfo findNetworkInfoSelf() {
        List niList = this.em.createQuery("select e from NetworkInfo e where e.self = :self").setParameter("self", (Object)"Y").getResultList();
        if (niList.size() == 0) {
            return null;
        }
        return (NetworkInfo)niList.get(0);
    }

    @Override
    public NetworkInfo findNetworkInfoById(String id) {
        return this.em.find(NetworkInfo.class, id);
    }

    @Override
    public void addNetworkInfo(NetworkInfo networkInfo) {
        this.em.persist(networkInfo);
    }

    @Override
    public void removeNetworkInfo(String id) {
        this.em.remove(this.findNetworkInfoById(id));
    }

    @Override
    public void updateNetworkInfo(NetworkInfo networkInfo) {
        this.em.merge(networkInfo);
    }

    @Override
    public void addResponse(long chanId, Response rsp) {
        this.findChannelById(chanId).getResponse().add(rsp);
    }

    @Override
    public void removeResponse(long chanId, long rspId) {
        Channel chan = this.findChannelById(chanId);
        Response rsp = this.em.find(Response.class, rspId);
        chan.getResponse().remove(rsp);
        this.em.remove(rsp);
        this.em.merge(chan);
    }

    @Override
    public Response findResponseById(long rspId) {
        Response rsp = this.em.find(Response.class, rspId);
        if (rsp != null) {
            rsp.getChannel().getChannelInfo();
        }
        return rsp;
    }

    @Override
    public void updateAllStation() {
        Collection<Station> stns = this.findAllStation();
        for (Station s : stns) {
            int nc = s.getChannel().size();
            Blockette050 b050 = s.getBlockette050();
            b050.setNumberOfChannels(nc);
            StationInfo si = s.getStationInfo();
            if (si == null) {
                si = new StationInfo();
                s.setStationInfo(si);
            }
            si.setNetStation(new NetStation(b050.getNetworkCode(), b050.getStation()));
            si.setStaSname(b050.getStation());
            si.setChanNum(nc);
            si.setStaLat((float)b050.getLatitude());
            si.setStaLon((float)b050.getLongitude());
            si.setStaElev((float)b050.getElevation());
            if (s.getDatarecord() != null) {
                si.setDatarecordId((int)s.getDatarecord().getId());
                logger.info("DatarecordId= " + si.getDatarecordId());
            } else {
                logger.warn("DatarecordId= 0");
            }
            if (s.getInstrument() != null) {
                si.setInstrumentId((int)s.getInstrument().getId());
            } else {
                logger.warn("setInstrumentId= 0");
            }
            s.setStationInfo(si);
            logger.info("checking " + b050.getNetworkCode() + "/" + b050.getStation());
            for (Channel c : s.getChannel()) {
                this.writeChannelInfo(c);
            }
            this.updateStation(s);
        }
    }

    @Override
    public void updateResponse(Response rsp) {
        if (rsp.getBlockette053() != null) {
            rsp.getBlockette053().setStageSequence(rsp.getStage());
        }
        if (rsp.getBlockette054() != null) {
            rsp.getBlockette054().setStageSequence(rsp.getStage());
        }
        if (rsp.getBlockette055() != null) {
            rsp.getBlockette055().setStageSequence(rsp.getStage());
        }
        if (rsp.getBlockette056() != null) {
            rsp.getBlockette056().setStageSequence(rsp.getStage());
        }
        if (rsp.getBlockette057() != null) {
            rsp.getBlockette057().setStageSequence(rsp.getStage());
        }
        if (rsp.getBlockette058() != null) {
            rsp.getBlockette058().setStageSequence(rsp.getStage());
        }
        if (rsp.getBlockette061() != null) {
            rsp.getBlockette061().setStageSequence(rsp.getStage());
        }
        this.em.merge(rsp);
        Channel chn = rsp.getChannel();
        this.writeChannelInfo(chn);
    }

    private void writeChannelInfo(Channel chn) {
        chn = this.findChannelById(chn.getId());
        Blockette052 b052 = chn.getBlockette052();
        Station s = chn.getStation();
        if (s == null) {
            return;
        }
        ChannelInfo ci = chn.getChannelInfo();
        if (ci == null) {
            ci = new ChannelInfo();
            chn.setChannelInfo(ci);
        }
        ci.setChannelLocator(new ChannelLocator(s.getBlockette050().getNetworkCode(), s.getBlockette050().getStation(), chn.getBlockette052().getLocation(), chn.getBlockette052().getChannel()));
        ci.setInstrumentId(b052.getInstrument().getLookupCode());
        ci.setUnitOfCaliInput(b052.getUnitOfCalibrationInput().getUnitName());
        ci.setUnitOfSignalRes(b052.getUnitOfSignalResponse().getUnitName());
        ci.setAzimuth(b052.getAzimuth());
        ci.setDip(b052.getDip());
        ci.setSampRate(b052.getSampleRate());
        ci.setOndate(b052.getStartTime());
        ci.setOffdate(b052.getEndTime());
        InstrDic instr = this.findInstrDicByName(b052.getInstrument().getDescription());
        if (instr != null) {
            ci.setInstrumentId((int)instr.getId());
            logger.info("setInstrumentId= " + ci.getInstrumentId());
        } else {
            logger.warn("Could find InstrDic for : " + b052.getInstrument().getDescription());
        }
        ci.setResponse(this.toResponseXML(chn));
        this.em.merge(chn);
    }

    private String toResponseXML(Channel c) {
        Station s = c.getStation();
        ResponseXML rxml = new ResponseXML();
        rxml.setNetCode(s.getBlockette050().getNetworkCode());
        rxml.setStationCode(s.getBlockette050().getStation());
        rxml.setLocId(c.getBlockette052().getLocation());
        rxml.setChanCode(c.getBlockette052().getChannel());
        rxml.setRsp(c.getResponse());
        ByteArrayOutputStream os = new ByteArrayOutputStream(8192);
        try {
            EntityXmlUtils.write(os, rxml, ResponseXML.class);
            os.close();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            return null;
        }
        return new String(os.toByteArray());
    }

    @Override
    public Blockette053 findBlockette053ById(long id) {
        Blockette053 b053 = this.em.find(Blockette053.class, id);
        return b053;
    }

    @Override
    public void updateBlockette053(Blockette053 b053) {
        this.em.merge(b053);
    }

    @Override
    public Blockette054 findBlockette054ById(long id) {
        Blockette054 blk = this.em.find(Blockette054.class, id);
        return blk;
    }

    @Override
    public void updateBlockette054(Blockette054 b054) {
        this.em.merge(b054);
    }

    @Override
    public Blockette061 findBlockette061ById(long id) {
        Blockette061 blk = this.em.find(Blockette061.class, id);
        return blk;
    }

    @Override
    public void updateBlockette061(Blockette061 b061) {
        this.em.merge(b061);
    }

    @Override
    public Blockette057 findBlockette057ById(long id) {
        return this.em.find(Blockette057.class, id);
    }

    @Override
    public void updateBlockette057(Blockette057 b057) {
        this.em.merge(b057);
    }

    @Override
    public Blockette058 findBlockette058ById(long id) {
        Blockette058 b058 = this.em.find(Blockette058.class, id);
        b058.getHistoryValues().size();
        return b058;
    }

    @Override
    public void updateBlockette058(Blockette058 b058) {
        this.em.merge(b058);
    }

    @Override
    public Blockette059 findBlockette059ById(long id) {
        return this.em.find(Blockette059.class, id);
    }

    @Override
    public void updateBlockette059(Blockette059 b059) {
        this.em.merge(b059);
    }

    @Override
    public void removeComplexError(long id) {
        this.em.remove(this.em.find(ComplexErrorBlob.class, id));
    }

    @Override
    public void removeCoeff(long id) {
        this.em.remove(this.em.find(CoeffBlob.class, id));
    }

    @Override
    public void removeCorner(long id) {
        this.em.remove(this.em.find(Corner.class, id));
    }

    Blockette034 _getBlockette034(String unitName) {
        List b034s = this.em.createQuery("select c from Blockette034 c where c.unitName = :unitName").setParameter("unitName", (Object)unitName).getResultList();
        if (b034s.size() == 0) {
            Blockette034 b034 = new Blockette034();
            b034.setUnitName(unitName);
            NetworkInfo ni = this.findNetworkInfoSelf();
            Dataless dl = this.em.find(Dataless.class, ni.getUniCode());
            dl.getSeedConfig().getAbbreviation().getBlockette034().add(b034);
            b034.setAbbreviation(dl.getSeedConfig().getAbbreviation());
            return (Blockette034)this.em.createQuery("select c from Blockette034 c where c.unitName = :unitName").setParameter("unitName", (Object)unitName).getSingleResult();
        }
        return (Blockette034)b034s.get(0);
    }

    @Override
    public void modifyResponseBlockette(long rspId, String mode, String block) {
        Response rsp = this.em.find(Response.class, rspId);
        if (mode.equalsIgnoreCase("add")) {
            if (block.equalsIgnoreCase("b053")) {
                Blockette053 b053 = rsp.getBlockette053();
                if (b053 != null) {
                    this.em.remove(b053);
                }
                b053 = new Blockette053();
                Blockette034 u1 = this._getBlockette034("M/S");
                b053.setSignalInputUnit(u1);
                b053.setSignalOutputUnit(this._getBlockette034("V"));
                b053.setStageSequence(rsp.getStage());
                rsp.setBlockette053(b053);
                this.em.merge(rsp);
            } else if (block.equalsIgnoreCase("b054")) {
                Blockette054 b054 = rsp.getBlockette054();
                if (b054 != null) {
                    this.em.remove(b054);
                }
                b054 = new Blockette054();
                b054.setSignalInputUnit(this._getBlockette034("V"));
                b054.setSignalOutputUnit(this._getBlockette034("COUNTS"));
                b054.setStageSequence(rsp.getStage());
                rsp.setBlockette054(b054);
                this.em.merge(rsp);
            } else if (block.equalsIgnoreCase("b061")) {
                Blockette061 b061 = rsp.getBlockette061();
                if (b061 != null) {
                    this.em.remove(b061);
                }
                b061 = new Blockette061();
                b061.setSignalInputUnit(this._getBlockette034("V"));
                b061.setSignalOutputUnit(this._getBlockette034("COUNTS"));
                b061.setStageSequence(rsp.getStage());
                rsp.setBlockette061(b061);
                this.em.merge(rsp);
            } else if (!block.equalsIgnoreCase("b055") && !block.equalsIgnoreCase("b056")) {
                if (block.equalsIgnoreCase("b057")) {
                    Blockette057 b057 = rsp.getBlockette057();
                    if (b057 != null) {
                        this.em.remove(b057);
                    }
                    b057 = new Blockette057();
                    b057.setStageSequence(rsp.getStage());
                    rsp.setBlockette057(b057);
                    this.em.merge(rsp);
                } else if (block.equalsIgnoreCase("b058")) {
                    Blockette058 b058 = rsp.getBlockette058();
                    if (b058 != null) {
                        this.em.remove(b058);
                    }
                    b058 = new Blockette058();
                    b058.setStageSequence(rsp.getStage());
                    rsp.setBlockette058(b058);
                    this.em.merge(rsp);
                } else if (block.equalsIgnoreCase("b059")) {
                    Blockette059 b059 = rsp.getBlockette059();
                    if (b059 != null) {
                        this.em.remove(b059);
                    }
                    b059 = new Blockette059();
                    rsp.setBlockette059(b059);
                    this.em.merge(rsp);
                }
            }
        } else if (mode.equalsIgnoreCase("delete")) {
            if (block.equalsIgnoreCase("b053")) {
                Blockette053 b053 = rsp.getBlockette053();
                rsp.setBlockette053(null);
                if (b053 != null) {
                    this.em.remove(b053);
                }
                this.em.merge(rsp);
            } else if (block.equalsIgnoreCase("b054")) {
                Blockette054 b054 = rsp.getBlockette054();
                rsp.setBlockette054(null);
                if (b054 != null) {
                    this.em.remove(b054);
                }
                this.em.merge(rsp);
            } else if (block.equalsIgnoreCase("b061")) {
                Blockette061 b061 = rsp.getBlockette061();
                rsp.setBlockette061(null);
                if (b061 != null) {
                    this.em.remove(b061);
                }
                this.em.merge(rsp);
            } else if (!block.equalsIgnoreCase("b055") && !block.equalsIgnoreCase("b056")) {
                if (block.equalsIgnoreCase("b057")) {
                    Blockette057 b057 = rsp.getBlockette057();
                    rsp.setBlockette057(null);
                    if (b057 != null) {
                        this.em.remove(b057);
                    }
                    this.em.merge(rsp);
                } else if (block.equalsIgnoreCase("b058")) {
                    Blockette058 b058 = rsp.getBlockette058();
                    rsp.setBlockette058(null);
                    if (b058 != null) {
                        this.em.remove(b058);
                    }
                    this.em.merge(rsp);
                } else if (block.equalsIgnoreCase("b059")) {
                    Blockette059 b059 = rsp.getBlockette059();
                    rsp.setBlockette059(null);
                    if (b059 != null) {
                        this.em.remove(b059);
                    }
                    this.em.merge(rsp);
                }
            }
        }
    }
}

